/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class DonutPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -739606033637947985L;
    protected static final double START_ANGLE = 135.0;
    protected static final double CIRCLE = 360.0;
    protected static final double PIE = 180.0;
    protected static final double MARGIN_GAP = 3.0;
    protected static final double HALF = 2.0;
    protected double arcWidth = 0.0;
    protected double innerRadius = 0.0;
    protected double radius = 0.0;
    protected Point2D centerPoint = new Point2D.Double();
    protected double innerRadiusPercent;
    protected double outerArcRadius = 0.0;
    private static double OUTER_PERCENT = 1.1;
    protected ArrayList<Rectangle2D> labelBounds = new ArrayList();
    protected double seriesGap;
    protected double categoryGap;

    protected double getPercent(int n2, int n3) {
        double d2 = this.getTotalValue(n3);
        if (d2 <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n2);
        return Math.abs(dataSeries.getDataPoint(n3).getValue()) / d2;
    }

    protected double getTotalValue(int n2) {
        double d2 = 0.0;
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            d2 += Math.abs(dataSeries.getDataPoint(n2).getValue());
        }
        return d2;
    }

    protected double getArcInnerRadius(int n2) {
        double d2 = this.arcWidth * this.categoryGap / 2.0;
        return this.innerRadius + this.arcWidth * (double)n2 + d2;
    }

    protected double getActOuterRadius(int n2) {
        double d2 = this.arcWidth * this.categoryGap / 2.0;
        return this.innerRadius + this.arcWidth * (double)(n2 + 1) - d2;
    }

    public void setCategoryGap(double d2) {
        this.categoryGap = d2;
    }

    public double getSeriesGap() {
        return this.seriesGap;
    }

    public void setSeriesGap(double d2) {
        this.seriesGap = d2;
    }

    public double getCategoryGap() {
        return this.categoryGap;
    }

    public double getInnerRadiusPercent() {
        return this.innerRadiusPercent;
    }

    public void setInnerRadiusPercent(double d2) {
        this.innerRadiusPercent = d2;
    }

    public void layoutAxisGlyph(int n2) {
    }

    public boolean equals(Object object) {
        return object instanceof DonutPlotGlyph && super.equals(object) && ((DonutPlotGlyph)object).getInnerRadiusPercent() == this.innerRadiusPercent && ((DonutPlotGlyph)object).getSeriesGap() == this.seriesGap && ((DonutPlotGlyph)object).getCategoryGap() == this.categoryGap;
    }

    protected void initArcValues() {
        Rectangle2D rectangle2D = this.getBounds();
        this.radius = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0 - 3.0;
        if (this.plotStyle == 2) {
            this.outerArcRadius = this.radius;
            this.radius = this.outerArcRadius / OUTER_PERCENT;
        }
        double d2 = (1.0 - this.getInnerRadiusPercent()) * this.radius;
        this.arcWidth = d2 / (double)this.getCategoryCount();
        this.innerRadius = this.radius * this.getInnerRadiusPercent();
        this.centerPoint.setLocation(rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("innerRadiusPercent", this.innerRadiusPercent);
        jSONObject.put("seriesGap", this.seriesGap);
        jSONObject.put("categoryGap", this.categoryGap);
        return jSONObject;
    }
}

