/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseUtils;
import com.fr.base.CoreDecimalFormat;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Utils;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.data.TableDataSource;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.js.JavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Tag;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionIDInfor;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;

public class DataPoint
extends SpecialGlyph
implements Result {
    private static final long serialVersionUID = -970056669601457244L;
    private static final int COODNUM = 6;
    private int categoryIndex;
    private int seriesIndex;
    private double value;
    private double percentValue;
    private boolean valueIsNull = false;
    private String categoryName;
    private String seriesName;
    private String secondCate;
    private String thirdCate;
    private String categoryOriginalName;
    private String seriesOriginalName;
    private Glyph drawImpl;
    private String tooltip = null;
    private String hyperlink = null;
    private TextGlyph dataLabel;
    private ChartStyle dataPointStyle;

    public DataPoint() {
    }

    public DataPoint(int n2, int n3, String string, String string2, double d2) {
        this.seriesIndex = n2;
        this.categoryIndex = n3;
        this.categoryName = string;
        this.seriesName = string2;
        this.value = d2;
    }

    public void setCategoryIndex(int n2) {
        this.categoryIndex = n2;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setSeriesIndex(int n2) {
        this.seriesIndex = n2;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSecondCate(String string) {
        this.secondCate = string;
    }

    public void setThirdCate(String string) {
        this.thirdCate = string;
    }

    public void setValue(double d2) {
        this.value = d2;
    }

    public double getValue() {
        return this.value;
    }

    public void setPercentValue(double d2) {
        this.percentValue = d2;
    }

    public double getPercentValue() {
        return this.percentValue;
    }

    public void setValueIsNull(boolean bl) {
        this.valueIsNull = bl;
    }

    public boolean isValueIsNull() {
        return this.valueIsNull;
    }

    public void setCategoryName(String string) {
        this.categoryName = string;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getCategoryOriginalName() {
        return this.categoryOriginalName;
    }

    public void setCategoryOriginalName(String string) {
        this.categoryOriginalName = string;
    }

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public String getSeriesOriginalName() {
        return this.seriesOriginalName;
    }

    public void setSeriesOriginalName(String string) {
        this.seriesOriginalName = string;
    }

    public void setHyperlink(String string) {
        this.hyperlink = string;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getType() {
        return "DataPoint";
    }

    public boolean evalWithCondition(Condition condition, Calculator calculator) {
        return condition == null ? false : condition.eval(this, calculator);
    }

    public Object toResult(CommonCondition commonCondition) {
        String string = commonCondition.getColumnName();
        if (ComparatorUtils.equals(string, ChartConstants.CATEGORY_INDEX) || ArrayUtils.contains(ChartConstants.CAGORY_INDEX_KEYS, string)) {
            return new Integer(this.categoryIndex + 1);
        }
        if (ComparatorUtils.equals(string, ChartConstants.SERIES_INDEX) || ArrayUtils.contains(ChartConstants.SERIES_INDEX_KEYS, string)) {
            return new Integer(this.seriesIndex + 1);
        }
        if (this.isUseValue(string)) {
            return new Double(this.value);
        }
        if (this.isUseCateName(string)) {
            return this.categoryName;
        }
        if (ComparatorUtils.equals(string, ChartConstants.SERIES_NAME) || ArrayUtils.contains(ChartConstants.SERIES_NAME_KEYS, string)) {
            return this.seriesName;
        }
        if (ComparatorUtils.equals(string, ChartConstants.PROJECT_ID) || ArrayUtils.contains(ChartConstants.PROJECT_ID_KEYS, string)) {
            return this.seriesName;
        }
        if (ComparatorUtils.equals(string, ChartConstants.STEP_INDEX) || ArrayUtils.contains(ChartConstants.STEP_INDEX_KYES, string)) {
            return new Integer(this.categoryIndex);
        }
        return this;
    }

    private boolean isUseValue(String string) {
        return ComparatorUtils.equals(string, ChartConstants.VALUE) || ComparatorUtils.equals(string, ChartConstants.AREA_VALUE) || ArrayUtils.contains(ChartConstants.VALUE_KEYS, string) || ArrayUtils.contains(ChartConstants.AREA_VALUE_KEYS, string);
    }

    private boolean isUseCateName(String string) {
        return ComparatorUtils.equals(string, ChartConstants.CATEGORY_NAME) || ComparatorUtils.equals(string, ChartConstants.AREA_NAME) || ComparatorUtils.equals(string, ChartConstants.STEP_NAME) || ArrayUtils.contains(ChartConstants.STEP_NAME_KEYS, string) || ArrayUtils.contains(ChartConstants.CATEGORY_NAME_KEYS, string) || ArrayUtils.contains(ChartConstants.AREA_NAMES_KEYS, string);
    }

    public ParameterProvider[] getParameters4Labels(AttrContents attrContents) {
        ParameterProvider[] parameterProviderArray = new Parameter[]{new Parameter("Category", this.getCategoryName()), new Parameter("Series", this.getSeriesName()), new Parameter("BR", AttrContents.RelineSeparation), new Parameter("PERCENT", this.getPercentParaString(attrContents)), new Parameter("Value", this.getValueParaString(this.getValue(), attrContents))};
        return parameterProviderArray;
    }

    protected String getValueParaString(double d2, AttrContents attrContents) {
        String string;
        if (attrContents != null && attrContents.getFormat() != null) {
            string = attrContents.getFormat().format(new Double(d2));
        } else {
            CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat("#.##"), "#.##");
            string = coreDecimalFormat.format(d2);
        }
        return Utils.objectToString(string);
    }

    public String createHotTooltip(AttrContents attrContents) {
        String string = "";
        if (attrContents != null && StringUtils.isNotEmpty(attrContents.getSeriesLabel())) {
            String string2 = attrContents.getSeriesLabel();
            String string3 = this.categoryName;
            if (StringUtils.isNotEmpty(this.secondCate)) {
                string3 = this.secondCate + " " + string3;
            }
            if (StringUtils.isNotEmpty(this.thirdCate)) {
                string3 = this.thirdCate + " " + string3;
            }
            if (StringUtils.isNotEmpty(this.seriesName)) {
                string = string + this.seriesName + AttrContents.RelineSeparation;
            }
            if (this.containsPara(string2, "${VALUE}")) {
                if (this.containsPara(string2, "${PERCENT}")) {
                    if (StringUtils.isNotEmpty(string3)) {
                        string = string + string3 + AttrContents.RelineSeparation;
                    }
                    string = string + this.getValueParaString(this.getValue(), attrContents) + ", " + this.getPercentParaString(attrContents);
                } else {
                    if (StringUtils.isNotEmpty(string3)) {
                        string = string + string3 + AttrContents.RelineSeparation;
                    }
                    string = string + this.getValueParaString(this.getValue(), attrContents);
                }
            } else if (this.containsPara(string2, "${PERCENT}")) {
                if (StringUtils.isNotEmpty(string3)) {
                    string = string + string3 + AttrContents.RelineSeparation;
                }
                string = string + this.getPercentParaString(attrContents);
            }
            this.setTooltip(string);
        }
        return string;
    }

    public String createDataPointHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup, Repository repository) {
        if (nameJavaScriptGroup != null) {
            int n2 = nameJavaScriptGroup.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JavaScript javaScript = nameJavaScriptGroup.getNameHyperlink(i2).getJavaScript();
                if (javaScript == null) continue;
                this.dealParameter4Hyperlink(javaScript.getParameters(), repository);
            }
            String string = null;
            try {
                string = BaseUtils.writeJSLinkContent(nameJavaScriptGroup, repository);
                this.setHyperlink(string);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error("Error in HyperLink", jSONException);
            }
            return string;
        }
        return null;
    }

    private void dealParameter4Hyperlink(ParameterProvider[] parameterProviderArray, Repository repository) {
        if (parameterProviderArray == null) {
            return;
        }
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            ParameterProvider parameterProvider = parameterProviderArray[i2];
            Object object = parameterProvider.getValue();
            if (!(object instanceof Formula)) continue;
            NameSpace nameSpace = this.getParas4Hyperlink();
            SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(repository);
            Calculator calculator = Calculator.createCalculator();
            calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
            calculator.pushNameSpace(nameSpace);
            calculator.setAttribute(TableDataSource.class, sessionIDInfor.getTableDataSource());
            String string = null;
            try {
                string = ((Formula)object).getContent();
                if (string.startsWith("=")) {
                    string = string.substring(1);
                }
                ((Formula)object).setResult(Utils.objectToString(calculator.evalValue(string)));
                continue;
            }
            catch (Exception exception) {
                String string2 = "error happens at calculating hyperlink formula";
                throw new RuntimeException(string2, exception);
            }
            finally {
                calculator.removeNameSpace(nameSpace);
            }
        }
    }

    protected boolean containsPara(String string, String string2) {
        return string != null && string2 != null && string.indexOf(string2) != -1;
    }

    protected String getPercentParaString(AttrContents attrContents) {
        Format format = attrContents.getPercentFormat();
        if (format == null) {
            format = new CoreDecimalFormat(new DecimalFormat("#.##%"), "#.##%");
            attrContents.setPercentFormat(format);
        }
        return format.format(Double.valueOf(Utils.doubleToString(this.getPercentValue())));
    }

    public NameSpace getParas4Hyperlink() {
        return ParameterMapNameSpace.create(new ParameterProvider[]{new Parameter("CATEGORY", this.getCategoryOriginalName()), new Parameter("SERIES", this.getSeriesOriginalName()), new Parameter("BR", AttrContents.RelineSeparation), new Parameter("VALUE", new Double(this.value))});
    }

    public void setDrawImpl(Glyph glyph) {
        this.drawImpl = glyph;
    }

    public Glyph getDrawImpl() {
        return this.drawImpl;
    }

    public void setDataLabel(TextGlyph textGlyph) {
        this.dataLabel = textGlyph;
    }

    public TextGlyph getDataLabel() {
        return this.dataLabel;
    }

    public void setShape(Shape shape) {
        this.drawImpl = new ShapeGlyph(shape);
    }

    public Shape getShape() {
        return this.drawImpl == null ? null : this.drawImpl.getShape();
    }

    public void draw(Graphics graphics, int n2) {
        if (!(this.dataPointStyle != null && this.dataPointStyle.isAvoidOriginDraw() || this.drawImpl == null)) {
            this.drawImpl.draw(graphics, n2);
        }
        if (this.dataPointStyle != null) {
            this.dataPointStyle.paintStyle(graphics);
        }
    }

    public ChartStyle getDataPointStyle() {
        return this.dataPointStyle;
    }

    public void setDataPointStyle(ChartStyle chartStyle) {
        this.dataPointStyle = chartStyle;
    }

    public void drawLabel(Graphics graphics, int n2) {
        if (this.valueIsNull) {
            return;
        }
        if (this.dataLabel != null) {
            this.dataLabel.draw(graphics, n2);
        }
    }

    public Tag getImageMapAreaTag(ChartGlyph chartGlyph) {
        if (chartGlyph == null || chartGlyph.getPlotGlyph() == null || chartGlyph.getPlotGlyph().getBounds() == null || this.isValueIsNull() || this.getDrawImpl() == null) {
            return new Tag();
        }
        int n2 = (int)chartGlyph.getPlotGlyph().getBounds().getX();
        int n3 = (int)chartGlyph.getPlotGlyph().getBounds().getY();
        Tag tag = new Tag("area");
        tag.attr("shape", this.getShapeType());
        tag.attr("coords", this.getShapeCoords(n2, n3));
        tag.attr("alt", "");
        return tag;
    }

    private String getShapeType() {
        if (this.getShape() instanceof Rectangle2D) {
            return "rect";
        }
        return "poly";
    }

    private String getShapeCoords(int n2, int n3) {
        if (this.getShape() instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.getShape(), n2, n3);
        }
        return this.getPolyCoords(this.getShape(), n2, n3);
    }

    private String getRectCoords(Rectangle2D rectangle2D, int n2, int n3) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'rectangle' argument.");
        }
        int n4 = (int)rectangle2D.getX() + n2 - 2;
        int n5 = (int)rectangle2D.getY() + n3 - 2;
        int n6 = n4 + (int)rectangle2D.getWidth() + 2;
        int n7 = n5 + (int)rectangle2D.getHeight() + 2;
        if (n6 == n4) {
            n6 += 2;
        }
        if (n7 == n5) {
            n7 += 2;
        }
        return n4 + "," + n5 + "," + n6 + "," + n7;
    }

    private String getPolyCoords(Shape shape, int n2, int n3) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                stringBuffer.append((int)fArray[0] + n2);
                stringBuffer.append(',').append((int)fArray[1] + n3);
            } else {
                stringBuffer.append(',');
                stringBuffer.append((int)fArray[0] + n2);
                stringBuffer.append(',');
                stringBuffer.append((int)fArray[1] + n3);
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return object instanceof DataPoint && ComparatorUtils.equals(((DataPoint)object).categoryName, this.categoryName) && ComparatorUtils.equals(((DataPoint)object).dataLabel, this.dataLabel) && ComparatorUtils.equals(((DataPoint)object).drawImpl, this.drawImpl) && ComparatorUtils.equals(((DataPoint)object).seriesName, this.seriesName) && ComparatorUtils.equals(((DataPoint)object).secondCate, this.secondCate) && ComparatorUtils.equals(((DataPoint)object).thirdCate, this.thirdCate) && ((DataPoint)object).seriesIndex == this.seriesIndex && ((DataPoint)object).categoryIndex == this.categoryIndex && ((DataPoint)object).percentValue == this.percentValue && ((DataPoint)object).valueIsNull == this.valueIsNull;
    }

    public Object clone() throws CloneNotSupportedException {
        DataPoint dataPoint = (DataPoint)super.clone();
        if (this.dataLabel != null) {
            dataPoint.dataLabel = (TextGlyph)this.dataLabel.clone();
        }
        if (this.drawImpl != null) {
            dataPoint.drawImpl = (Glyph)this.drawImpl.clone();
        }
        return dataPoint;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("categoryIndex", this.categoryIndex);
        jSONObject.put("categoryName", this.categoryName);
        jSONObject.put("value", this.value);
        jSONObject.put("percentValue", this.percentValue);
        jSONObject.put("valueIsNull", this.valueIsNull);
        jSONObject.put("seriesIndex", this.seriesIndex);
        jSONObject.put("seriesName", this.seriesName);
        jSONObject.put("categoryOriginalName", this.categoryOriginalName);
        jSONObject.put("secondCate", this.secondCate);
        jSONObject.put("thirdCate", this.thirdCate);
        if (this.dataLabel != null) {
            jSONObject.put("dataLabel", this.dataLabel.toJSONObject());
        }
        if (this.hyperlink != null) {
            jSONObject.put("hyperlink", this.hyperlink);
        }
        if (this.tooltip != null) {
            jSONObject.put("tooltip", this.tooltip);
        }
        if (this.drawImpl != null && this.drawImpl instanceof ShapeGlyph) {
            ShapeGlyph shapeGlyph = (ShapeGlyph)this.drawImpl;
        }
        return jSONObject;
    }
}

