/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cylinder
implements Object3D {
    private static final long serialVersionUID = 5570356712828640455L;
    private static final double PIE_ANGLE = 180.0;
    private static final double ROUND_ANGLE = 360.0;
    private static final double LE = 0.01;
    private static final double FI = 0.05;
    private static final double HALF = 0.5;
    private double start_y = 0.0;
    private double x;
    private double y;
    private double start = 0.0;
    private double extent = 360.0;
    private double depth = 60.0;
    private float R = 60.0f;
    private boolean startEnable = true;
    private boolean endEnable = true;
    private Projection projection = new Projection();
    private ColorInfo colorInfo = new ColorInfo();

    public Cylinder() {
    }

    public Cylinder(double d2, double d3, double d4) {
        this.start_y = d2;
        this.depth = d3;
        this.R = (float)d4;
    }

    public void setAttrbute(double d2, double d3, double d4, double d5, Projection projection) {
        this.x = d2;
        this.y = d3;
        this.start = d4;
        this.extent = d5;
        this.projection = projection;
    }

    public boolean isStartEnable() {
        return this.startEnable;
    }

    public boolean isEndEnable() {
        return this.endEnable;
    }

    public Arc2D bottom() {
        return this.getArc2D((int)this.depth);
    }

    private Ellipse2D getEllipseTop() {
        Arc2D arc2D = this.projection.projecteeArc(this.start_y, this.R, 0.0, 360.0);
        Rectangle rectangle = arc2D.getBounds();
        rectangle.x = (int)((double)rectangle.x + this.x);
        rectangle.y = (int)((double)rectangle.y + this.y);
        return new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    private Ellipse2D getEllipseBottom() {
        Arc2D arc2D = this.projection.projecteeArc(this.start_y + (double)((int)this.depth), this.R, 0.0, 360.0);
        Rectangle rectangle = arc2D.getBounds();
        rectangle.x = (int)((double)rectangle.x + this.x);
        rectangle.y = (int)((double)rectangle.y + this.y);
        return new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    private Area getBackInBottom(Ellipse2D ellipse2D, Ellipse2D ellipse2D2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)ellipse2D.getX(), (float)ellipse2D.getCenterY());
        generalPath.lineTo((float)ellipse2D.getMaxX(), (float)ellipse2D.getCenterY());
        generalPath.lineTo((float)ellipse2D2.getMaxX(), (float)ellipse2D2.getCenterY());
        generalPath.lineTo((float)ellipse2D2.getX(), (float)ellipse2D2.getCenterY());
        generalPath.closePath();
        Area area = new Area(ellipse2D);
        area.add(new Area(generalPath));
        area.add(new Area(ellipse2D2));
        Area area2 = new Area(area);
        area2.subtract(new Area(ellipse2D2));
        return area2;
    }

    private double getTheta() {
        return Math.toDegrees(Math.asin(-this.get_sin_theta()));
    }

    private Area initBackSideWhenExtentLessThanZero(Arc2D arc2D, Arc2D arc2D2, Ellipse2D ellipse2D, Ellipse2D ellipse2D2, Area area) {
        Area area2 = null;
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        double d5 = this.getTheta();
        Point2D.Double double_ = new Point2D.Double(ellipse2D.getX(), ellipse2D.getY());
        Point2D.Double double_2 = new Point2D.Double(ellipse2D.getMaxX(), ellipse2D.getY());
        Point2D.Double double_3 = new Point2D.Double(ellipse2D2.getX(), ellipse2D2.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(ellipse2D2.getMaxX(), ellipse2D2.getMaxY());
        if (this.isAngleAtFront(d2)) {
            if (!this.isAngleAtBack(d4)) {
                if (!(d3 > -(180.0 + 2.0 * d5))) {
                    area2 = area;
                }
            } else {
                area2 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d5, d4, double_, double_2, double_3, double_4);
            }
        } else if (!this.isAngleAtFront(d4)) {
            if (d3 > -(180.0 - 2.0 * d5)) {
                area2 = Cylinder.getSideArea(arc2D, arc2D2, d2, d4, double_, double_2, double_3, double_4);
            } else {
                Area area3 = Cylinder.getSideArea(arc2D, arc2D2, d5, d2, double_, double_2, double_3, double_4);
                Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d4, 180.0 - d5, double_, double_2, double_3, double_4);
                area2 = new Area(area3);
                area2.add(area4);
            }
        } else {
            area2 = Cylinder.getSideArea(arc2D, arc2D2, d2, d5, double_, double_2, double_3, double_4);
        }
        return area2;
    }

    private Area initBackSideWhenExtentMoreThanZero(Arc2D arc2D, Arc2D arc2D2, Ellipse2D ellipse2D, Ellipse2D ellipse2D2, Area area) {
        Area area2 = null;
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        double d5 = this.getTheta();
        Point2D.Double double_ = new Point2D.Double(ellipse2D.getX(), ellipse2D.getY());
        Point2D.Double double_2 = new Point2D.Double(ellipse2D.getMaxX(), ellipse2D.getY());
        Point2D.Double double_3 = new Point2D.Double(ellipse2D2.getX(), ellipse2D2.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(ellipse2D2.getMaxX(), ellipse2D2.getMaxY());
        if (this.isAngleAtFront(d2)) {
            if (!this.isAngleAtBack(d4)) {
                if (!(d3 < 180.0 + 2.0 * d5)) {
                    area2 = area;
                }
            } else {
                area2 = Cylinder.getSideArea(arc2D, arc2D2, d5, d4, double_, double_2, double_3, double_4);
            }
        } else if (!this.isAngleAtFront(d4)) {
            if (d3 < 180.0 - 2.0 * d5) {
                area2 = Cylinder.getSideArea(arc2D, arc2D2, d4, d2, double_, double_2, double_3, double_4);
            } else {
                Area area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d5, d2, double_, double_2, double_3, double_4);
                Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d5, d4, double_, double_2, double_3, double_4);
                area2 = new Area(area3);
                area2.add(area4);
            }
        } else {
            area2 = Cylinder.getSideArea(arc2D, arc2D2, 180.0, d2, double_, double_2, double_3, double_4);
        }
        return area2;
    }

    private void frontPieFront(ArrayList<Cylinder> arrayList) {
        double d2;
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        double d3 = arc2D.getAngleStart();
        double d4 = arc2D.getAngleExtent();
        double d5 = d3 + d4;
        double d6 = this.getTheta();
        double d7 = d2 = d6 < 0.0 ? d6 + 360.0 : d6;
        if (!this.isAngleAtBack(d5)) {
            if (this.extent < 180.0 + 2.0 * d6) {
                Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                cylinder.x = this.x;
                cylinder.y = this.y;
                cylinder.start = this.start;
                cylinder.extent = this.extent;
                cylinder.projection = this.projection;
                cylinder.colorInfo = this.colorInfo;
                arrayList.add(cylinder);
            } else {
                Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                cylinder.x = this.x;
                cylinder.y = this.y;
                cylinder.start = this.start;
                cylinder.extent = (360.0 - this.start) % 360.0;
                cylinder.projection = this.projection;
                cylinder.colorInfo = this.colorInfo;
                cylinder.startEnable = false;
                Cylinder cylinder2 = new Cylinder(this.start_y, this.depth, this.R);
                cylinder2.x = this.x;
                cylinder2.y = this.y;
                cylinder2.start = 180.0;
                cylinder2.extent = (this.start + this.extent) % 360.0 - 180.0;
                cylinder2.projection = this.projection;
                cylinder2.colorInfo = this.colorInfo;
                cylinder2.endEnable = false;
                arrayList.add(cylinder);
                arrayList.add(cylinder2);
            }
        } else {
            Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
            cylinder.x = this.x;
            cylinder.y = this.y;
            cylinder.start = this.start;
            cylinder.extent = 360.0 - this.start % 360.0;
            cylinder.projection = this.projection;
            cylinder.colorInfo = this.colorInfo;
            arrayList.add(cylinder);
        }
    }

    public Cylinder[] getFrontPie3d() {
        double d2;
        ArrayList<Cylinder> arrayList = new ArrayList<Cylinder>();
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        double d3 = arc2D.getAngleStart();
        double d4 = arc2D.getAngleExtent();
        double d5 = d3 + d4;
        double d6 = this.getTheta();
        double d7 = d2 = d6 < 0.0 ? d6 + 360.0 : d6;
        if (this.isAngleAtFront(d3)) {
            this.frontPieFront(arrayList);
        } else if (!this.isAngleAtFront(d5)) {
            if (!(this.extent < 180.0 - 2.0 * d6)) {
                Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                cylinder.x = this.x;
                cylinder.y = this.y;
                cylinder.start = 180.0;
                cylinder.extent = 180.0;
                cylinder.projection = this.projection;
                cylinder.colorInfo = this.colorInfo;
                arrayList.add(cylinder);
            }
        } else {
            Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
            cylinder.x = this.x;
            cylinder.y = this.y;
            cylinder.start = 180.0;
            cylinder.extent = (this.start + this.extent) % 360.0 - 180.0;
            cylinder.projection = this.projection;
            cylinder.colorInfo = this.colorInfo;
            arrayList.add(cylinder);
        }
        return arrayList.toArray(new Cylinder[0]);
    }

    private void backPieBack(ArrayList<Cylinder> arrayList) {
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        double d2 = arc2D.getAngleStart() + arc2D.getAngleExtent();
        double d3 = this.getTheta();
        if (!this.isAngleAtFront(d2)) {
            if (this.extent < 180.0 - 2.0 * d3) {
                Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                cylinder.x = this.x;
                cylinder.y = this.y;
                cylinder.start = this.start;
                cylinder.extent = this.extent;
                cylinder.projection = this.projection;
                cylinder.colorInfo = this.colorInfo;
                arrayList.add(cylinder);
            } else {
                Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                cylinder.x = this.x;
                cylinder.y = this.y;
                cylinder.start = 0.0;
                cylinder.extent = (this.start + this.extent) % 360.0;
                cylinder.projection = this.projection;
                cylinder.colorInfo = this.colorInfo;
                cylinder.startEnable = false;
                Cylinder cylinder2 = new Cylinder(this.start_y, this.depth, this.R);
                cylinder2.x = this.x;
                cylinder2.y = this.y;
                cylinder2.start = this.start;
                cylinder2.extent = (180.0 - this.start) % 360.0;
                cylinder2.projection = this.projection;
                cylinder2.colorInfo = this.colorInfo;
                cylinder2.endEnable = false;
                arrayList.add(cylinder);
                arrayList.add(cylinder2);
            }
        } else {
            Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
            cylinder.x = this.x;
            cylinder.y = this.y;
            cylinder.start = this.start;
            cylinder.extent = (180.0 - this.start) % 360.0;
            cylinder.projection = this.projection;
            cylinder.colorInfo = this.colorInfo;
            cylinder.endEnable = false;
            arrayList.add(cylinder);
        }
    }

    public Cylinder[] getBackPie3d() {
        ArrayList<Cylinder> arrayList = new ArrayList<Cylinder>();
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        double d5 = this.getTheta();
        if (this.isAngleAtFront(d2)) {
            if (!this.isAngleAtBack(d4)) {
                if (!(this.extent < 180.0 + 2.0 * d5)) {
                    Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                    cylinder.x = this.x;
                    cylinder.y = this.y;
                    cylinder.start = 0.0;
                    cylinder.extent = 180.0;
                    cylinder.projection = this.projection;
                    cylinder.colorInfo = this.colorInfo;
                    cylinder.startEnable = false;
                    cylinder.endEnable = false;
                    arrayList.add(cylinder);
                }
            } else {
                Cylinder cylinder = new Cylinder(this.start_y, this.depth, this.R);
                cylinder.x = this.x;
                cylinder.y = this.y;
                cylinder.start = 0.0;
                cylinder.extent = this.extent - (360.0 - this.start % 360.0);
                cylinder.projection = this.projection;
                cylinder.colorInfo = this.colorInfo;
                cylinder.startEnable = false;
                arrayList.add(cylinder);
            }
        } else {
            this.backPieBack(arrayList);
        }
        return arrayList.toArray(new Cylinder[0]);
    }

    public Area getBack() {
        double d2;
        Area area = new Area();
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        Arc2D arc2D2 = this.bottom();
        arc2D2.setArcType(0);
        Ellipse2D ellipse2D = this.getEllipseTop();
        Ellipse2D ellipse2D2 = this.getEllipseBottom();
        Area area2 = this.getFrontIntTop(ellipse2D, ellipse2D2);
        double d3 = arc2D.getAngleStart();
        double d4 = arc2D.getAngleExtent();
        double d5 = d3 + d4;
        Point2D.Double double_ = new Point2D.Double(ellipse2D.getX(), ellipse2D.getY());
        Point2D.Double double_2 = new Point2D.Double(ellipse2D.getMaxX(), ellipse2D.getY());
        Point2D.Double double_3 = new Point2D.Double(ellipse2D2.getX(), ellipse2D2.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(ellipse2D2.getMaxX(), ellipse2D2.getMaxY());
        double d6 = this.getTheta();
        double d7 = d2 = d6 < 0.0 ? d6 + 360.0 : d6;
        if (this.isAngleAtFront(d3)) {
            if (!this.isAngleAtBack(d5)) {
                if (this.extent < 180.0 + 2.0 * d6) {
                    area = Cylinder.getSideArea(arc2D, arc2D2, d3, d5, double_, double_2, double_3, double_4);
                } else {
                    Area area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d6, d5, double_, double_2, double_3, double_4);
                    Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d3, d2, double_, double_2, double_3, double_4);
                    area.add(area3);
                    area.add(area4);
                }
            } else {
                area = Cylinder.getSideArea(arc2D, arc2D2, d3, d2, double_, double_2, double_3, double_4);
            }
        } else if (!this.isAngleAtFront(d5)) {
            if (!(this.extent < 180.0 - 2.0 * d6)) {
                area = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d6, d2, double_, double_2, double_3, double_4);
            }
        } else {
            area = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d6, d5, double_, double_2, double_3, double_4);
        }
        area.intersect(area2);
        return area;
    }

    public Area getNegtiveBack() {
        Area area = new Area();
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        Arc2D arc2D2 = this.bottom();
        arc2D2.setArcType(0);
        Ellipse2D ellipse2D = this.getEllipseTop();
        Ellipse2D ellipse2D2 = this.getEllipseBottom();
        Area area2 = this.getBackInBottom(ellipse2D, ellipse2D2);
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        Point2D.Double double_ = new Point2D.Double(ellipse2D.getX(), ellipse2D.getY());
        Point2D.Double double_2 = new Point2D.Double(ellipse2D.getMaxX(), ellipse2D.getY());
        Point2D.Double double_3 = new Point2D.Double(ellipse2D2.getX(), ellipse2D2.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(ellipse2D2.getMaxX(), ellipse2D2.getMaxY());
        double d5 = this.getTheta();
        if (this.isAngleAtFront(d2)) {
            if (!this.isAngleAtBack(d4)) {
                if (!(this.extent < 180.0 + 2.0 * d5)) {
                    area = area2;
                }
            } else {
                area = Cylinder.getSideArea(arc2D, arc2D2, d5, d4, double_, double_2, double_3, double_4);
            }
        } else if (!this.isAngleAtFront(d4)) {
            if (this.extent < 180.0 - 2.0 * d5) {
                area = Cylinder.getSideArea(arc2D, arc2D2, d2, d4, double_, double_2, double_3, double_4);
            } else {
                Area area3 = Cylinder.getSideArea(arc2D, arc2D2, d5, d4, double_, double_2, double_3, double_4);
                Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d2, 180.0 - d5, double_, double_2, double_3, double_4);
                area.add(area3);
                area.add(area4);
            }
        } else {
            area = Cylinder.getSideArea(arc2D, arc2D2, d2, 180.0 - d5, double_, double_2, double_3, double_4);
        }
        area.intersect(area2);
        return area;
    }

    public Area back() {
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        Arc2D arc2D2 = this.bottom();
        arc2D2.setArcType(0);
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        if (this.isInner()) {
            return this.whenInnerBack(arc2D, arc2D2, d4);
        }
        Ellipse2D ellipse2D = this.getEllipseTop();
        Ellipse2D ellipse2D2 = this.getEllipseBottom();
        Area area = this.getBackInBottom(ellipse2D, ellipse2D2);
        Area area2 = null;
        if (d3 < 0.0) {
            area2 = this.initBackSideWhenExtentLessThanZero(arc2D, arc2D2, ellipse2D, ellipse2D2, area);
        } else if (d3 > 0.0) {
            area2 = this.initBackSideWhenExtentMoreThanZero(arc2D, arc2D2, ellipse2D, ellipse2D2, area);
        }
        if (area2 == null) {
            area2 = new Area();
        } else {
            area2.intersect(area);
        }
        return area2;
    }

    private Area whenInnerBack(Arc2D arc2D, Arc2D arc2D2, double d2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(arc2D.getPathIterator(null), true);
        generalPath.lineTo((float)arc2D2.getEndPoint().getX(), (float)arc2D2.getEndPoint().getY());
        arc2D2.setAngleStart(d2);
        arc2D2.setAngleExtent(-this.extent);
        generalPath.append(arc2D2.getPathIterator(null), true);
        return new Area(generalPath);
    }

    private Area getFrontIntTop(Ellipse2D ellipse2D, Ellipse2D ellipse2D2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)ellipse2D.getX(), (float)ellipse2D.getCenterY());
        generalPath.lineTo((float)ellipse2D.getMaxX(), (float)ellipse2D.getCenterY());
        generalPath.lineTo((float)ellipse2D2.getMaxX(), (float)ellipse2D2.getCenterY());
        generalPath.lineTo((float)ellipse2D2.getX(), (float)ellipse2D2.getCenterY());
        generalPath.closePath();
        Area area = new Area(ellipse2D);
        area.add(new Area(generalPath));
        area.add(new Area(ellipse2D2));
        Area area2 = new Area(area);
        area2.subtract(new Area(ellipse2D));
        return area2;
    }

    private Area initFrontSizeWhenExtentMoreThanZero(Arc2D arc2D, Arc2D arc2D2, Ellipse2D ellipse2D, Ellipse2D ellipse2D2, Area area) {
        Area area2 = null;
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        double d5 = this.getTheta();
        Point2D.Double double_ = new Point2D.Double(ellipse2D.getX(), ellipse2D.getY());
        Point2D.Double double_2 = new Point2D.Double(ellipse2D.getMaxX(), ellipse2D.getY());
        Point2D.Double double_3 = new Point2D.Double(ellipse2D2.getX(), ellipse2D2.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(ellipse2D2.getMaxX(), ellipse2D2.getMaxY());
        if (this.isAngleAtFront(d2)) {
            if (!this.isAngleAtBack(d4)) {
                if (d3 < 180.0 + 2.0 * d5) {
                    area2 = Cylinder.getSideArea(arc2D, arc2D2, d4, d2, double_, double_2, double_3, double_4);
                } else {
                    Area area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d5, d4, double_, double_2, double_3, double_4);
                    Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d2, d5, double_, double_2, double_3, double_4);
                    area2 = new Area(area3);
                    area2.add(area4);
                }
            } else {
                area2 = Cylinder.getSideArea(arc2D, arc2D2, d2, d5, double_, double_2, double_3, double_4);
            }
        } else if (!this.isAngleAtFront(d4)) {
            if (!(d3 < 180.0 - 2.0 * d5)) {
                area2 = area;
            }
        } else {
            area2 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d5, d4, double_, double_2, double_3, double_4);
        }
        return area2;
    }

    private Area initFrontSizeWhenExtentLessThanZero(Arc2D arc2D, Arc2D arc2D2, Ellipse2D ellipse2D, Ellipse2D ellipse2D2, Area area) {
        Area area2 = null;
        double d2 = arc2D.getAngleStart();
        double d3 = arc2D.getAngleExtent();
        double d4 = d2 + d3;
        double d5 = this.getTheta();
        Point2D.Double double_ = new Point2D.Double(ellipse2D.getX(), ellipse2D.getY());
        Point2D.Double double_2 = new Point2D.Double(ellipse2D.getMaxX(), ellipse2D.getY());
        Point2D.Double double_3 = new Point2D.Double(ellipse2D2.getX(), ellipse2D2.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(ellipse2D2.getMaxX(), ellipse2D2.getMaxY());
        if (this.isAngleAtFront(d2)) {
            if (!this.isAngleAtBack(d4)) {
                if (d3 > -(180.0 + 2.0 * d5)) {
                    area2 = Cylinder.getSideArea(arc2D, arc2D2, d4, d2, double_, double_2, double_3, double_4);
                } else {
                    Area area3 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d5, d2, double_, double_2, double_3, double_4);
                    Area area4 = Cylinder.getSideArea(arc2D, arc2D2, d4, d5, double_, double_2, double_3, double_4);
                    area2 = new Area(area3);
                    area2.add(area4);
                }
            } else {
                area2 = Cylinder.getSideArea(arc2D, arc2D2, 180.0 - d5, d2, double_, double_2, double_3, double_4);
            }
        } else if (!this.isAngleAtFront(d4)) {
            if (!(d3 > -(180.0 - 2.0 * d5))) {
                area2 = area;
            }
        } else {
            area2 = Cylinder.getSideArea(arc2D, arc2D2, d4, d5, double_, double_2, double_3, double_4);
        }
        return area2;
    }

    public Area front() {
        if (this.isInner()) {
            return new Area();
        }
        Arc2D arc2D = this.top();
        arc2D.setArcType(0);
        Arc2D arc2D2 = this.bottom();
        arc2D2.setArcType(0);
        double d2 = arc2D.getAngleExtent();
        Ellipse2D ellipse2D = this.getEllipseTop();
        Ellipse2D ellipse2D2 = this.getEllipseBottom();
        Area area = this.getFrontIntTop(ellipse2D, ellipse2D2);
        Area area2 = null;
        if (d2 < 0.0) {
            area2 = this.initFrontSizeWhenExtentLessThanZero(arc2D, arc2D2, ellipse2D, ellipse2D2, area);
        } else if (d2 > 0.0) {
            area2 = this.initFrontSizeWhenExtentMoreThanZero(arc2D, arc2D2, ellipse2D, ellipse2D2, area);
        }
        if (area2 == null) {
            area2 = new Area();
        } else {
            area2.intersect(area);
        }
        return area2;
    }

    public Arc2D top() {
        return this.getArc2D(0);
    }

    public GeneralPath getStartSide() {
        Arc2D arc2D = this.top();
        Arc2D arc2D2 = this.bottom();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)arc2D2.getCenterX(), (float)arc2D2.getCenterY());
        generalPath.lineTo((float)arc2D2.getStartPoint().getX(), (float)arc2D2.getStartPoint().getY());
        generalPath.lineTo((float)arc2D.getStartPoint().getX(), (float)arc2D.getStartPoint().getY());
        generalPath.lineTo((float)arc2D.getCenterX(), (float)arc2D.getCenterY());
        generalPath.closePath();
        return generalPath;
    }

    public GeneralPath getEndSide() {
        Arc2D arc2D = this.top();
        Arc2D arc2D2 = this.bottom();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)arc2D2.getCenterX(), (float)arc2D2.getCenterY());
        generalPath.lineTo((float)arc2D2.getEndPoint().getX(), (float)arc2D2.getEndPoint().getY());
        generalPath.lineTo((float)arc2D.getEndPoint().getX(), (float)arc2D.getEndPoint().getY());
        generalPath.lineTo((float)arc2D.getCenterX(), (float)arc2D.getCenterY());
        generalPath.closePath();
        return generalPath;
    }

    private Arc2D getArc2D(int n2) {
        Arc2D arc2D = this.projection.projecteeArc(this.start_y + (double)n2, this.R, this.start, this.extent);
        Rectangle rectangle = arc2D.getBounds();
        rectangle.x = (int)((double)rectangle.x + this.x);
        rectangle.y = (int)((double)rectangle.y + this.y);
        arc2D.setArc(rectangle, arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
        return arc2D;
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        Arc2D arc2D = this.top();
        generalPath2.append(arc2D, false);
        Point2D point2D = generalPath2.getCurrentPoint();
        Area area = this.front();
        if (area != null) {
            generalPath.append(area, false);
        }
        generalPath.append(arc2D, false);
        if (point2D != null) {
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        }
        return generalPath;
    }

    @Override
    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    @Override
    public Projection getProjection() {
        return this.projection;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.colorInfo = colorInfo;
    }

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public void setX(double d2) {
        this.x = d2;
    }

    public void setY(double d2) {
        this.y = d2;
    }

    public void setStart(double d2) {
        this.start = d2;
    }

    public void setExtent(double d2) {
        this.extent = d2;
    }

    public double getExtent() {
        return this.extent;
    }

    public static Point2D getArcPoint(Arc2D arc2D, double d2) {
        double d3 = arc2D.getX() + (Math.cos(Math.toRadians(-d2)) / 2.0 + 0.5) * arc2D.getWidth();
        double d4 = arc2D.getY() + (Math.sin(Math.toRadians(-d2)) / 2.0 + 0.5) * arc2D.getHeight();
        return new Point2D.Double(d3, d4);
    }

    private static Area getSideArea(Arc2D arc2D, Arc2D arc2D2, double d2, double d3, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Point2D point2D5 = Cylinder.intersectsPoint(Cylinder.getArcPoint(arc2D, d2), Cylinder.getArcPoint(arc2D2, d2), point2D, point2D2);
        Point2D point2D6 = Cylinder.intersectsPoint(Cylinder.getArcPoint(arc2D, d2), Cylinder.getArcPoint(arc2D2, d2), point2D3, point2D4);
        Point2D point2D7 = Cylinder.intersectsPoint(Cylinder.getArcPoint(arc2D, d3), Cylinder.getArcPoint(arc2D2, d3), point2D, point2D2);
        Point2D point2D8 = Cylinder.intersectsPoint(Cylinder.getArcPoint(arc2D, d3), Cylinder.getArcPoint(arc2D2, d3), point2D3, point2D4);
        if (point2D5 == null || point2D6 == null || point2D7 == null || point2D8 == null) {
            return new Area();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D5.getX(), (float)point2D5.getY());
        generalPath.lineTo((float)point2D6.getX(), (float)point2D6.getY());
        generalPath.lineTo((float)point2D8.getX(), (float)point2D8.getY());
        generalPath.lineTo((float)point2D7.getX(), (float)point2D7.getY());
        generalPath.closePath();
        return new Area(generalPath);
    }

    private static Point2D intersectsPoint(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d2 = (point2D4.getY() - point2D3.getY()) * (point2D2.getX() - point2D.getX()) - (point2D2.getY() - point2D.getY()) * (point2D4.getX() - point2D3.getX());
        if (Math.abs(d2) < 0.01) {
            return null;
        }
        double d3 = (point2D4.getY() - point2D3.getY()) * point2D3.getX() - (point2D4.getX() - point2D3.getX()) * point2D3.getY();
        double d4 = (point2D2.getY() - point2D.getY()) * point2D.getX() - (point2D2.getX() - point2D.getX()) * point2D.getY();
        double d5 = ((point2D2.getX() - point2D.getX()) * d3 - (point2D4.getX() - point2D3.getX()) * d4) / d2;
        double d6 = ((point2D2.getY() - point2D.getY()) * d3 - (point2D4.getY() - point2D3.getY()) * d4) / d2;
        return new Point2D.Double(d5, d6);
    }

    private boolean isInner() {
        int n2 = this.projection.getElevation();
        int n3 = this.projection.getFocus();
        double d2 = (float)n3 / (2.0f * this.R);
        double d3 = Math.sqrt(1.0 + d2 * d2) - d2;
        return Math.cos(Math.toRadians(n2)) <= d3;
    }

    private boolean isAngleAtFront(double d2) {
        return Math.sin(Math.toRadians(d2)) < -this.get_sin_theta();
    }

    private boolean isAngleAtBack(double d2) {
        return !this.isAngleAtFront(d2);
    }

    private double get_sin_theta() {
        double d2 = Math.toRadians(this.projection.getElevation());
        int n2 = this.projection.getFocus();
        return (double)this.R * Math.pow(Math.sin(d2), 2.0) / (Math.cos(d2) * (double)n2);
    }

    public Point2D topMiddleEdgePoint() {
        Arc2D arc2D = this.top();
        double d2 = Math.toRadians(-arc2D.getAngleStart() - arc2D.getAngleExtent() / 2.0);
        double d3 = arc2D.getX() + (Math.cos(d2) * 0.5 + 0.5) * arc2D.getWidth();
        double d4 = arc2D.getY() + (Math.sin(d2) * 0.5 + 0.5) * arc2D.getHeight();
        return new Point2D.Double(d3, d4);
    }

    public Point2D topCenterPoint(Point2D point2D) {
        Arc2D arc2D = this.top();
        double d2 = Math.toRadians(-arc2D.getAngleStart() - arc2D.getAngleExtent() / 2.0);
        double d3 = arc2D.getX() + (Math.cos(d2) * 0.5 + 0.5) * arc2D.getWidth();
        double d4 = arc2D.getY() + (Math.sin(d2) * 0.5 + 0.5) * arc2D.getHeight();
        return new Point2D.Double((d3 + point2D.getX()) / 2.0, (d4 + point2D.getY()) / 2.0);
    }

    public boolean equals(Object object) {
        return object instanceof Cylinder && ((Cylinder)object).R == this.R && ((Cylinder)object).start_y == this.start_y && ((Cylinder)object).x == this.x && ((Cylinder)object).y == this.y && ((Cylinder)object).start == this.start && ((Cylinder)object).extent == this.extent && ((Cylinder)object).depth == this.depth && ComparatorUtils.equals(((Cylinder)object).getProjection(), this.getProjection());
    }

    public static class CylinderSide
    implements Comparable {
        Cylinder cylinder;
        boolean isStart;

        public CylinderSide(Cylinder cylinder, boolean bl) {
            this.cylinder = cylinder;
            this.isStart = bl;
        }

        public int compareTo(Object object) {
            CylinderSide cylinderSide = (CylinderSide)object;
            double d2 = this.isStart ? this.cylinder.start : this.cylinder.start + this.cylinder.extent;
            double d3 = cylinderSide.isStart ? cylinderSide.cylinder.start : cylinderSide.cylinder.start + cylinderSide.cylinder.extent;
            double d4 = Math.abs(d2 - 90.0) % 360.0;
            double d5 = Math.abs(d3 - 90.0) % 360.0;
            d4 = d4 > 180.0 ? 360.0 - d4 : d4;
            double d6 = d5 = d5 > 180.0 ? 360.0 - d5 : d5;
            if (Math.abs(d4 - d5) < 0.05) {
                if (this.cylinder.getExtent() != 0.0) {
                    d2 = this.isStart ? this.cylinder.start + this.cylinder.getExtent() / Math.abs(this.cylinder.getExtent()) : this.cylinder.start + this.cylinder.getExtent() - this.cylinder.getExtent() / Math.abs(this.cylinder.getExtent());
                }
                if (cylinderSide.cylinder.getExtent() != 0.0) {
                    d3 = cylinderSide.isStart ? cylinderSide.cylinder.start + cylinderSide.cylinder.getExtent() / Math.abs(cylinderSide.cylinder.getExtent()) : cylinderSide.cylinder.start + cylinderSide.cylinder.getExtent() - cylinderSide.cylinder.getExtent() / Math.abs(cylinderSide.cylinder.getExtent());
                }
                d4 = Math.abs(d2 - 90.0) % 360.0;
                d5 = Math.abs(d3 - 90.0) % 360.0;
                d4 = d4 > 180.0 ? 360.0 - d4 : d4;
                double d7 = d5 = d5 > 180.0 ? 360.0 - d5 : d5;
            }
            if (d4 < d5) {
                return -1;
            }
            if (d4 > d5) {
                return 1;
            }
            return 0;
        }
    }
}

