/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrPosition;
import com.fr.chart.base.AttrStyle;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConditionAttr
implements XMLable {
    private static final long serialVersionUID = -3118030222189423100L;
    public static final String XML_TAG = "ConditionAttr";
    private List attributeList2Change = new ArrayList();
    private AbstractCondition condition = null;
    private String name = "";

    public DataSeriesCondition getDataSeriesCondition(int n2) {
        return (DataSeriesCondition)this.attributeList2Change.get(n2);
    }

    public void addDataSeriesCondition(DataSeriesCondition dataSeriesCondition) {
        this.attributeList2Change.add(dataSeriesCondition);
    }

    public int getDataSeriesConditionCount() {
        return this.attributeList2Change == null ? 0 : this.attributeList2Change.size();
    }

    public void removeAll() {
        this.attributeList2Change.clear();
    }

    public void remove(DataSeriesCondition dataSeriesCondition) {
        this.attributeList2Change.remove(dataSeriesCondition);
    }

    public void remove(Class clazz) {
        Iterator iterator = this.attributeList2Change.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next().getClass();
            if (!ComparatorUtils.equals(clazz2.getName(), clazz.getName())) continue;
            iterator.remove();
        }
    }

    public DataSeriesCondition getExisted(Class clazz) {
        for (DataSeriesCondition dataSeriesCondition : this.attributeList2Change) {
            if (dataSeriesCondition == null || !ComparatorUtils.equals(dataSeriesCondition.getClass().getName(), clazz.getName())) continue;
            return dataSeriesCondition;
        }
        return null;
    }

    public void dealFormula(Calculator calculator) {
        if (this.condition != null) {
            this.condition.formula2Value(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.condition != null) {
            this.condition.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.condition != null) {
            this.condition.modColumnRow(mOD_COLUMN_ROW);
        }
    }

    public String getConditionAttrType() {
        return XML_TAG;
    }

    public void setCondition(AbstractCondition abstractCondition) {
        this.condition = abstractCondition;
    }

    public Iterator getConditionIterator() {
        return this.attributeList2Change.iterator();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean eval(Result result, Calculator calculator) {
        return result.evalWithCondition(this.condition, calculator);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("name", this.name);
        if (this.attributeList2Change != null && this.getDataSeriesConditionCount() > 0) {
            xMLPrintWriter.startTAG("AttrList");
            for (int i2 = 0; i2 < this.getDataSeriesConditionCount(); ++i2) {
                GeneralXMLTools.writeXMLable(xMLPrintWriter, this.getDataSeriesCondition(i2), "Attr");
            }
            xMLPrintWriter.end();
        }
        if (this.condition != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.condition, "Condition");
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("ConditionList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (!xMLableReader.isChildNode() || xMLableReader.getTagName().equals("Condition")) {
                            // empty if block
                        }
                    }
                });
            }
            if (string.equals(XML_TAG)) {
                String string2 = xMLableReader.getAttrAsString("name", null);
                if (string2 != null) {
                    this.name = string2;
                }
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            String string = xMLableReader.getTagName();
                            if (string.equals("AttrList")) {
                                xMLableReader.readXMLObject(new XMLReadable(){

                                    public void readXML(XMLableReader xMLableReader) {
                                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Attr")) {
                                            DataSeriesCondition dataSeriesCondition = (DataSeriesCondition)GeneralXMLTools.readXMLable(xMLableReader);
                                            ConditionAttr.this.addDataSeriesCondition(ConditionAttr.this.checkCondition(dataSeriesCondition));
                                        }
                                    }
                                });
                            }
                            if (string.equals("Condition")) {
                                if (xMLableReader.getAttrAsString("class", null).endsWith("ChartCondition")) {
                                    ConditionAttr.this.condition = (AbstractCondition)xMLableReader.readXMLObject(new ListCondition());
                                } else {
                                    ConditionAttr.this.condition = (AbstractCondition)GeneralXMLTools.readXMLable(xMLableReader);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private DataSeriesCondition checkCondition(DataSeriesCondition dataSeriesCondition) {
        if (dataSeriesCondition instanceof AttrPosition) {
            AttrContents attrContents = (AttrContents)this.getConditionInType("AttrContents");
            if (attrContents == null) {
                attrContents = new AttrContents("${VALUE}");
            } else {
                this.remove(attrContents);
            }
            attrContents.setPosition(((AttrPosition)dataSeriesCondition).getPosition());
            return attrContents;
        }
        if (dataSeriesCondition instanceof AttrStyle) {
            AttrContents attrContents = (AttrContents)this.getConditionInType("AttrContents");
            if (attrContents == null) {
                attrContents = new AttrContents("${VALUE}");
            } else {
                this.remove(attrContents);
            }
            AttrStyle attrStyle = (AttrStyle)dataSeriesCondition;
            attrContents.setTextAttr(attrStyle.getTextAttr());
            attrContents.setFormat(attrStyle.getFormat());
            attrContents.setPercentFormat(attrStyle.getPercentFormat());
            return attrContents;
        }
        if (dataSeriesCondition instanceof AttrContents) {
            AttrContents attrContents = (AttrContents)this.getConditionInType("AttrContents");
            if (attrContents != null) {
                AttrContents attrContents2 = (AttrContents)dataSeriesCondition;
                this.remove(attrContents);
                attrContents.setSeriesLabel(attrContents2.getSeriesLabel());
                attrContents.setFormat(attrContents2.getFormat());
                attrContents.setPercentFormat(attrContents2.getFormat());
                attrContents.setPosition(attrContents2.getPosition());
                attrContents.setShowGuidLine(attrContents2.isShowGuidLine());
                attrContents.setTextAttr(attrContents2.getTextAttr());
                return attrContents;
            }
            AttrContents attrContents3 = (AttrContents)dataSeriesCondition;
            return attrContents3;
        }
        if (dataSeriesCondition instanceof AttrLine) {
            return this.comAttrLineToColor((AttrLine)dataSeriesCondition);
        }
        return dataSeriesCondition;
    }

    private AttrColor comAttrLineToColor(AttrLine attrLine) {
        this.remove(attrLine);
        AttrLineStyle attrLineStyle = new AttrLineStyle(attrLine.getSeriesLineStyle());
        this.addDataSeriesCondition(attrLineStyle);
        AttrColor attrColor = new AttrColor();
        attrColor.setSeriesColor(attrLine.getSeriesLineColor());
        this.remove(AttrColor.class);
        return attrColor;
    }

    public DataSeriesCondition getConditionInType(String string) {
        if (this.attributeList2Change != null && this.getDataSeriesConditionCount() > 0) {
            for (int i2 = 0; i2 < this.getDataSeriesConditionCount(); ++i2) {
                DataSeriesCondition dataSeriesCondition = this.getDataSeriesCondition(i2);
                if (!ComparatorUtils.equals(dataSeriesCondition.getConditionType(), string)) continue;
                return dataSeriesCondition;
            }
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        ConditionAttr conditionAttr = (ConditionAttr)super.clone();
        if (this.attributeList2Change != null) {
            conditionAttr.attributeList2Change = new ArrayList();
            for (int i2 = 0; i2 < this.getDataSeriesConditionCount(); ++i2) {
                if (this.getDataSeriesCondition(i2) == null) continue;
                conditionAttr.addDataSeriesCondition((DataSeriesCondition)this.getDataSeriesCondition(i2).clone());
            }
        }
        if (this.condition != null) {
            conditionAttr.condition = (AbstractCondition)this.condition.clone();
        }
        return conditionAttr;
    }

    public boolean equals(Object object) {
        return object instanceof ConditionAttr && ComparatorUtils.equals(((ConditionAttr)object).attributeList2Change, this.attributeList2Change) && ComparatorUtils.equals(((ConditionAttr)object).condition, this.condition) && ComparatorUtils.equals(((ConditionAttr)object).name, this.name);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("conditionAttrType", this.getConditionAttrType());
        if (this.getDataSeriesConditionCount() > 0) {
            jSONObject.put("attrList", this.attrs2JSON());
        }
        if (StringUtils.isNotEmpty(this.name)) {
            jSONObject.put("name", this.name);
        }
        return jSONObject;
    }

    public JSONObject toJSONObject(DataSeries[] dataSeriesArray) throws JSONException {
        JSONObject jSONObject = this.toJSONObject();
        if (this.condition != null && !ArrayUtils.isEmpty(dataSeriesArray)) {
            JSONArray jSONArray = new JSONArray();
            JSONArray jSONArray2 = new JSONArray();
            Calculator calculator = Calculator.createCalculator();
            for (int i2 = 0; i2 < dataSeriesArray.length; ++i2) {
                DataSeries dataSeries = dataSeriesArray[i2];
                if (dataSeries.evalWithCondition(this.condition, calculator)) {
                    jSONArray.put(dataSeries.getSeriesIndex());
                }
                int n2 = dataSeries.getDataPointCount();
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (!dataSeries.getDataPoint(i3).evalWithCondition(this.condition, calculator)) continue;
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("series", dataSeries.getSeriesIndex());
                    jSONObject2.put("category", dataSeries.getDataPoint(i3).getCategoryIndex());
                    jSONArray2.put(jSONObject2);
                }
            }
            jSONObject.put("ConditionDataSeries", jSONArray);
            jSONObject.put("ConditionDataPoint", jSONArray2);
        }
        return jSONObject;
    }

    private JSONArray attrs2JSON() throws JSONException {
        DataSeriesCondition[] dataSeriesConditionArray = this.attributeList2Change.toArray(new DataSeriesCondition[this.attributeList2Change.size()]);
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < dataSeriesConditionArray.length; ++i2) {
            JSONObject jSONObject = new JSONObject();
            DataSeriesCondition dataSeriesCondition = dataSeriesConditionArray[i2];
            jSONObject.put("attrType", dataSeriesCondition.getConditionType());
            jSONObject.put("attr", dataSeriesCondition.toJSONObject());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }
}

