/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class CompositePiePlotGlyph
extends PiePlotGlyph {
    private static final long serialVersionUID = 8976370546122236609L;
    private static final double CIR_ANGLE = 360.0;
    private static final double PIE_ANGLE = 180.0;
    private static final double RIGHT_PO = 0.3;
    public static final double SMALLPERCENT_LABEL_RADIUS_COEFFICIENT = 0.7;
    public static final double SUB_CENTER_COEFFICIENT = 0.8;
    private List list = new ArrayList();
    private int subType = 1;
    protected double smallPercent = 0.05;

    public void setSubType(int n2) {
        this.subType = n2;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSmallPercent(double d2) {
        this.smallPercent = d2;
    }

    public void draw(Graphics graphics, int n2) {
        super.draw(graphics, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics.getColor();
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        graphics2D.setColor(new Color(125, 125, 125));
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            GeneralPath generalPath = (GeneralPath)this.list.get(i2);
            GraphHelper.draw(graphics2D, generalPath, 1);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        graphics2D.setColor(color);
    }

    public void layoutDataSeriesGlyph(int n2) {
        this.list.clear();
        for (int i2 = 0; i2 < this.getCategoryCount(); ++i2) {
            this.initLabelData(i2, n2);
            this.dealWithDataSeries(i2, n2);
            GeneralPath generalPath = this.getLinePath(i2);
            if (generalPath == null) continue;
            this.list.add(generalPath);
        }
        this.dealLabelBoundsInOrder();
        this.dealLeadLineSeries();
    }

    protected double deal4BestRad(double d2, int n2) {
        return super.deal4BestRad(d2, n2) * 0.8;
    }

    protected double getSeriesStartAngle(int n2, int n3) {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(n3).getDataPoint(n2);
        boolean bl = dataPoint4Pie.getPercentValue() >= this.smallPercent || n3 == this.getSeriesSize() - 1;
        double d2 = this.getStartAngle(n3, n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            DataPoint4Pie dataPoint4Pie2 = (DataPoint4Pie)this.getSeries(i2).getDataPoint(n2);
            if (bl) {
                if (!(dataPoint4Pie2.getPercentValue() >= this.smallPercent) && i2 != this.getSeriesSize() - 1) continue;
                d2 += this.getPercent(i2, n2) * 360.0;
                continue;
            }
            if (!(dataPoint4Pie2.getPercentValue() < this.smallPercent) || i2 == this.getSeriesSize() - 1) continue;
            d2 += this.getPercent(i2, n2) * 360.0;
        }
        return d2;
    }

    protected double getStartAngle(int n2, int n3) {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(n2).getDataPoint(n3);
        if (dataPoint4Pie.getPercentValue() >= this.smallPercent || n2 == this.getSeriesSize() - 1) {
            return this.getPercent(this.getSeriesSize() - 1, n3) * 180.0;
        }
        return 90.0;
    }

    protected double getPercent(int n2, int n3) {
        boolean bl = this.isMainPie(n2, n3);
        double d2 = this.getTotalValue(n3, bl);
        if (d2 <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n2);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
        return Math.abs(dataPoint4Pie.getValue()) / d2;
    }

    protected double getTotalValue(int n2, boolean bl) {
        double d2 = 0.0;
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
            double d3 = dataPoint4Pie.getPercentValue();
            if (bl) {
                if (!(d3 >= this.smallPercent) && i2 != this.getSeriesSize() - 1) continue;
                d2 += Math.abs(dataPoint4Pie.getValue());
                continue;
            }
            if (!(d3 < this.smallPercent) || i2 == this.getSeriesSize() - 1) continue;
            d2 += Math.abs(dataPoint4Pie.getValue());
        }
        return d2;
    }

    protected double changeRadius(int n2, int n3) {
        boolean bl = this.isMainPie(n3, n2);
        return bl ? this.radius * 1.3 : this.radius * 0.7;
    }

    protected GeneralPath getLinePath(int n2) {
        if (this.getSubType() == 2 && this.getPercent(this.getSeriesSize() - 1, n2) > 0.0) {
            return this.getLinePath4PieSub(n2);
        }
        if (this.getSubType() == 3 && this.getPercent(this.getSeriesSize() - 1, n2) > 0.0) {
            return this.getLinePath4BarSub(n2);
        }
        return null;
    }

    protected Point2D getCenterPoint(int n2, int n3) {
        DataSeries dataSeries = this.getSeries(n2);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n3);
        if (dataPoint4Pie.isValueIsNull()) {
            return null;
        }
        double d2 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        if (this.getSubType() == 2 || this.getSubType() == 3) {
            if (dataPoint4Pie.getPercentValue() < this.smallPercent && n2 != this.getSeriesSize() - 1) {
                double d3 = (double)n3 * d2 + d2 * 0.8;
                return new Point2D.Double(d3, this.getBounds().getHeight() / 2.0);
            }
            double d4 = (double)n3 * d2 + d2 * 0.3;
            return new Point2D.Double(d4, this.getBounds().getHeight() / 2.0);
        }
        return null;
    }

    protected boolean isOutsideLabel(int n2, int n3) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, this.getSeries(n2).getDataPoint(n3), null);
        return (attrContents.getPosition() == 6 || attrContents.isShowGuidLine()) && this.isMainPie(n2, n3);
    }

    protected Shape getArc2D(DataPoint dataPoint) {
        int n2 = dataPoint.getSeriesIndex();
        int n3 = dataPoint.getCategoryIndex();
        double d2 = this.getSeriesStartAngle(n3, n2) % 360.0;
        Point2D point2D = this.getCenterPoint(n2, n3);
        if (!(dataPoint.getPercentValue() < this.smallPercent) || n2 == this.getSeriesSize() - 1) {
            return this.getDataPointShape(point2D, d2, this.radius, n2, n3);
        }
        if (this.getSubType() == 2) {
            return this.getDataPointShape(point2D, d2, this.radius / 2.0, n2, n3);
        }
        if (this.getSubType() == 3) {
            return this.get4PieBar(n2, n3, point2D, this.radius / 2.0);
        }
        return null;
    }

    private Rectangle2D get4PieBar(int n2, int n3, Point2D point2D, double d2) {
        double d3 = 0.0;
        boolean bl = this.isMainPie(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2 = this.isMainPie(i2, n3);
            if (bl != bl2) continue;
            double d4 = this.getPercent(i2, n3);
            d3 += d4;
        }
        double d5 = this.getPercent(n2, n3);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - d2 / 2.0, point2D.getY() - d2 + d3 * 2.0 * d2, d2, d2 * 2.0 * d5);
        return double_;
    }

    private GeneralPath getLinePath4BarSub(int n2) {
        Point2D point2D;
        GeneralPath generalPath = new GeneralPath();
        double d2 = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d3 = (double)n2 * d2 + d2 * 0.8;
        Point2D.Double double_ = new Point2D.Double(d3, this.getBounds().getHeight() / 2.0);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(this.getSeriesSize() - 1).getDataPoint(n2);
        Arc2D arc2D = (Arc2D)dataPoint4Pie.getShape();
        Point2D point2D2 = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getStartPoint() : arc2D.getEndPoint();
        Point2D point2D3 = point2D = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getEndPoint() : arc2D.getStartPoint();
        if (arc2D.getAngleExtent() >= 180.0) {
            Point2D.Double double_2 = new Point2D.Double(arc2D.getCenterX(), arc2D.getCenterY());
            double d4 = this.getAngle4Pie(double_2, new Point2D.Double(((Point2D)double_).getX() - this.radius / 2.0 / 2.0, ((Point2D)double_).getY() - this.radius / 2.0));
            point2D2 = new Point2D.Double(((Point2D)double_2).getX() + Math.cos(d4) * this.radius, ((Point2D)double_2).getY() - Math.sin(d4) * this.radius);
            point2D = new Point2D.Double(((Point2D)double_2).getX() + Math.cos(d4) * this.radius, ((Point2D)double_2).getY() + Math.sin(d4) * this.radius);
        }
        if (double_ != null) {
            generalPath.moveTo((float)(((Point2D)double_).getX() - this.radius / 2.0 / 2.0), (float)(((Point2D)double_).getY() - this.radius / 2.0));
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        }
        if (double_ != null) {
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)(((Point2D)double_).getX() - this.radius / 2.0 / 2.0), (float)(((Point2D)double_).getY() + this.radius / 2.0));
        }
        return generalPath;
    }

    private GeneralPath getLinePath4PieSub(int n2) {
        GeneralPath generalPath = new GeneralPath();
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(this.getSeriesSize() - 1).getDataPoint(n2);
        Arc2D arc2D = (Arc2D)dataPoint4Pie.getShape();
        Point2D point2D = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getStartPoint() : arc2D.getEndPoint();
        Point2D point2D2 = arc2D.getEndPoint().getY() > arc2D.getStartPoint().getY() ? arc2D.getEndPoint() : arc2D.getStartPoint();
        Point2D point2D3 = this.getPoint(n2, true);
        Point2D point2D4 = this.getPoint(n2, false);
        if (arc2D.getAngleExtent() >= 180.0) {
            Point2D.Double double_ = new Point2D.Double(arc2D.getCenterX(), arc2D.getCenterY());
            double d2 = this.getAngle4Pie(double_, point2D3);
            point2D = new Point2D.Double(((Point2D)double_).getX() + Math.cos(d2) * this.radius, ((Point2D)double_).getY() - Math.sin(d2) * this.radius);
            double d3 = this.getAngle4Pie(double_, point2D4);
            point2D2 = new Point2D.Double(((Point2D)double_).getX() + Math.cos(d3) * this.radius, ((Point2D)double_).getY() + Math.sin(d3) * this.radius);
        }
        if (point2D3 != null) {
            generalPath.moveTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        if (point2D4 != null) {
            generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
        }
        return generalPath;
    }

    private double getAngle4Pie(Point2D point2D, Point2D point2D2) {
        double d2 = Math.abs(point2D.getX() - point2D2.getX());
        double d3 = Math.abs(point2D.getY() - point2D2.getY());
        double d4 = Math.atan(d3 / d2);
        double d5 = Math.acos(this.radius * Math.sin(d4) / d3);
        return d4 + d5;
    }

    private Point2D getPoint(int n2, boolean bl) {
        Point2D.Double double_ = null;
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(i2).getDataPoint(n2);
            Arc2D arc2D = (Arc2D)dataPoint4Pie.getShape();
            if (!(dataPoint4Pie.getPercentValue() < this.smallPercent) || i2 == this.getSeriesSize() - 1) continue;
            Rectangle2D rectangle2D = arc2D.getBounds2D();
            double d2 = rectangle2D.getY();
            if (!bl) {
                d2 = rectangle2D.getY() + rectangle2D.getHeight();
            }
            double d3 = arc2D.getWidth() / 2.0;
            double d4 = arc2D.getCenterY();
            double d5 = arc2D.getCenterX();
            double d6 = (d4 - d2) / d3;
            d6 = Math.min(1.0, d6);
            d6 = Math.max(-1.0, d6);
            double d7 = Math.asin(d6) * 180.0 / Math.PI;
            double d8 = d5 + d3 * Math.cos(Math.PI * d7 / 180.0);
            if (!this.isNewPoint(double_, bl, d2)) continue;
            double_ = new Point2D.Double(d8, d2);
        }
        return double_;
    }

    private boolean isNewPoint(Point2D point2D, boolean bl, double d2) {
        return point2D == null || bl && d2 <= point2D.getY() || !bl && d2 >= point2D.getY();
    }

    private boolean isMainPie(int n2, int n3) {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)this.getSeries(n2).getDataPoint(n3);
        return dataPoint4Pie.getPercentValue() >= this.smallPercent || n2 == this.getSeriesSize() - 1;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("subType", this.subType);
        jSONObject.put("smallPercent", this.smallPercent);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "CompositePiePlotGlyph";
    }
}

