/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.NumberAxisGlyph;
import com.fr.chart.chartglyph.RangeAxisGlyph;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ChartAlertValueGlyph
extends SpecialGlyph {
    private static final long serialVersionUID = 5463194639904984544L;
    private static final double ALERT_LABEL_MAX_WIDTH_PERCENT = 0.12;
    private static final int ALERT_LABEL_LINE_GAP = 2;
    private static final int PRE_GAP_ALERT = 20;
    private static final double OFFSET = 4.0;
    private Formula alertValueFormula = new Formula();
    private AttrColor alertLineColor = new AttrColor(Color.red);
    private AttrLineStyle alertLineStyle = new AttrLineStyle(1);
    private float alertLineAlpha = 1.0f;
    private String alertContent = Inter.getLocText("ChartF_Alert");
    private FRFont alertFont = FRFont.getInstance();
    private int alertPosition = 4;
    private String alertNameInPaneSelect = "";
    private int index = 0;
    private NumberAxisGlyph axisGlyph;
    private Line2D[] lines = new Line2D[0];
    private Rectangle2D labelBounds;
    private double indexValue;
    private GeneralPath alertLabelPaths;

    public void setIndexValue(double d2) {
        this.indexValue = d2;
    }

    public void setAlertLabelPaths(GeneralPath generalPath) {
        this.alertLabelPaths = generalPath;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public void setValuAxisGlyph(NumberAxisGlyph numberAxisGlyph) {
        this.axisGlyph = numberAxisGlyph;
    }

    public NumberAxisGlyph getValueAxisGlyph() {
        return this.axisGlyph;
    }

    public void setAlertValueFormula(Formula formula) {
        this.alertValueFormula = formula;
    }

    public Formula getAlertValueFormula() {
        return this.alertValueFormula;
    }

    public void setAlertPosition(int n2) {
        this.alertPosition = n2;
    }

    public int getAlertPosition() {
        return this.alertPosition;
    }

    public void setAlertContent(String string) {
        this.alertContent = string;
    }

    public String getAlertContent() {
        return this.alertContent;
    }

    public void setLineColor(AttrColor attrColor) {
        this.alertLineColor = attrColor;
    }

    public AttrColor getLineColor() {
        return this.alertLineColor;
    }

    public void setLineStyle(AttrLineStyle attrLineStyle) {
        this.alertLineStyle = attrLineStyle;
    }

    public AttrLineStyle getLineStyle() {
        return this.alertLineStyle;
    }

    public void setAlertFont(FRFont fRFont) {
        this.alertFont = fRFont;
    }

    public FRFont getAlertFont() {
        return this.alertFont;
    }

    public void setAlertLineAlpha(float f2) {
        this.alertLineAlpha = f2;
    }

    public float getAlertLineAlpha() {
        return this.alertLineAlpha;
    }

    public void setAlertPaneSelectName(String string) {
        this.alertNameInPaneSelect = string;
    }

    public String getAlertPaneSelectName() {
        return this.alertNameInPaneSelect;
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawAlertLine(graphics2D);
        this.drawAlertValueLabel(graphics2D, n2);
    }

    private void drawAlertLine(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlertLineAlpha()));
        Color color = this.alertLineColor.getSeriesColor();
        if (color == null) {
            return;
        }
        graphics2D.setPaint(color);
        graphics2D.setStroke(GraphHelper.getStroke(this.alertLineStyle.getLineStyle()));
        for (int i2 = 0; i2 < this.lines.length; ++i2) {
            graphics2D.draw(this.lines[i2]);
        }
        graphics2D.setComposite(composite);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public void dealWithAlertLine() {
        Object object = this.getAlertValueFormula().getResult();
        if (object == null) {
            this.drawAlertLineWithNone();
        } else if (object instanceof FArray) {
            this.drawAlertLineWithArray((FArray)object);
        } else {
            this.drawAlertLineWithSingle(object.toString());
        }
    }

    private void drawAlertLineWithNone() {
        double d2 = (this.axisGlyph.getMaxValue() - this.axisGlyph.getMinValue()) * (double)(this.index + 1) / (double)(this.axisGlyph.getAlertValues().length + 2);
        this.lines = this.axisGlyph.getGridLine(d2);
    }

    private void drawAlertLineWithArray(FArray fArray) {
        for (int i2 = 0; i2 < fArray.length(); ++i2) {
            double d2;
            Number number = Utils.string2Number(fArray.elementAt(i2).toString());
            if (number == null || !((d2 = number.doubleValue()) <= this.axisGlyph.getMaxValue()) || !(d2 >= this.axisGlyph.getMinValue())) continue;
            this.lines = this.axisGlyph.getGridLine(d2);
        }
    }

    private void drawAlertLineWithSingle(String string) {
        double d2;
        if (Utils.string2Number(string) != null && (d2 = Utils.string2Number(string).doubleValue()) <= this.axisGlyph.getMaxValue() && d2 >= this.axisGlyph.getMinValue()) {
            this.lines = this.axisGlyph.getGridLine(d2);
        }
    }

    public void drawAlertValueLabel(Graphics graphics, int n2) {
        Point2D point2D = this.axisGlyph.getPoint2D(this.indexValue);
        TextAttr textAttr = new TextAttr();
        Color color = this.alertFont.getForeground();
        if (this.alertLineColor.getSeriesColor() != null) {
            this.alertFont = this.alertFont.applyForeground(this.alertLineColor.getSeriesColor());
        }
        textAttr.setFRFont(this.alertFont);
        String string = this.getAlertContent();
        string = string + "(" + this.axisGlyph.value2String(this.indexValue) + ")";
        ValueAxisGlyph valueAxisGlyph = (ValueAxisGlyph)this.axisGlyph;
        if (valueAxisGlyph.isNeedAutoWrap()) {
            string = ChartBaseUtils.dealLabelStringAutoWrap(string, textAttr, n2, valueAxisGlyph.getPlotZeroBounds().getWidth() * 0.12);
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n2);
        if (this.labelBounds == null) {
            this.labelBounds = this.axisGlyph instanceof RangeAxisGlyph ? this.getAlertLabelBounds4Range(point2D, dimension2D, this.alertLabelPaths, this.getAlertPosition()) : this.getAlertLabelBounds(point2D, dimension2D, this.alertLabelPaths, this.getAlertPosition());
        }
        GlyphUtils.drawStrings(graphics, string, textAttr, this.labelBounds, n2);
        this.alertFont.applyForeground(color);
    }

    protected Rectangle2D getAlertLabelBounds(Point2D point2D, Dimension2D dimension2D, GeneralPath generalPath, int n2) {
        double d2 = 0.0;
        double d3 = 0.0;
        Rectangle2D rectangle2D = this.getAlertBounds(n2);
        if (this.axisGlyph.getPosition() == 2 || this.axisGlyph.getPosition() == 4) {
            d2 = rectangle2D.getX();
            d3 = point2D.getY() - dimension2D.getHeight() / 2.0;
        } else {
            d2 = point2D.getX() - dimension2D.getWidth() / 2.0;
            d3 = rectangle2D.getY();
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
        return this.dealIntersectsBounds(rectangle2D, generalPath, double_);
    }

    protected Rectangle2D getAlertLabelBounds4Range(Point2D point2D, Dimension2D dimension2D, GeneralPath generalPath, int n2) {
        Rectangle2D.Double double_ = null;
        double d2 = this.axisGlyph.getMaxLeftAlert();
        double d3 = this.axisGlyph.getMaxRightAlert();
        Rectangle2D.Double double_2 = null;
        if (n2 == 2) {
            double_2 = new Rectangle2D.Double(0.0, this.axisGlyph.getPlotZeroBounds().getHeight() - this.axisGlyph.getBounds().getY() - d2, this.axisGlyph.getBounds().getWidth(), d2);
            double_ = new Rectangle2D.Double(point2D.getX(), this.axisGlyph.getPlotZeroBounds().getHeight() - this.axisGlyph.getBounds().getY() - d2, dimension2D.getWidth(), dimension2D.getHeight());
        } else {
            double_2 = new Rectangle2D.Double(0.0, 0.0 - this.axisGlyph.getBounds().getY(), this.axisGlyph.getBounds().getWidth(), d3);
            double_ = new Rectangle2D.Double(point2D.getX(), 0.0 - this.axisGlyph.getBounds().getY(), dimension2D.getWidth(), dimension2D.getHeight());
        }
        return this.dealIntersectsBounds(double_2, generalPath, double_);
    }

    public Rectangle2D dealIntersectsBounds(Rectangle2D rectangle2D, GeneralPath generalPath, Rectangle2D rectangle2D2) {
        boolean bl = this.checkPathBoundsFirstAddBounds(generalPath);
        while (this.isNeedMoveResultBounds(rectangle2D, generalPath, rectangle2D2, bl)) {
            this.moveResultBounds(rectangle2D2);
        }
        if (!rectangle2D.contains(rectangle2D2)) {
            return null;
        }
        generalPath.append(rectangle2D2, false);
        return rectangle2D2;
    }

    private boolean checkPathBoundsFirstAddBounds(GeneralPath generalPath) {
        Rectangle rectangle = generalPath != null ? generalPath.getBounds() : null;
        return rectangle != null && ((RectangularShape)rectangle).getWidth() == 0.0 && ((RectangularShape)rectangle).getHeight() == 0.0;
    }

    private boolean isNeedMoveResultBounds(Rectangle2D rectangle2D, GeneralPath generalPath, Rectangle2D rectangle2D2, boolean bl) {
        if (rectangle2D == null || generalPath == null || rectangle2D2 == null) {
            return false;
        }
        return generalPath.intersects(rectangle2D2) || bl && !rectangle2D.contains(rectangle2D2) && rectangle2D.getY() < rectangle2D2.getY();
    }

    private void moveResultBounds(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return;
        }
        if (this.axisGlyph.getPosition() == 2 || this.axisGlyph.getPosition() == 4) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() - 4.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX() - 4.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    protected Rectangle2D getAlertBounds(int n2) {
        Dimension2D dimension2D = this.axisGlyph.getTitleDim();
        double d2 = dimension2D.getWidth() == 0.0 ? 0.0 : dimension2D.getWidth() + 4.0;
        double d3 = dimension2D.getHeight() == 0.0 ? 0.0 : dimension2D.getHeight() + 4.0;
        double d4 = d2 + this.axisGlyph.getAxisLabelWidth();
        double d5 = d3 + this.axisGlyph.getAxisLabelWidth();
        if (this.axisGlyph.getPosition() == 2) {
            return this.getAlertBoundsWhenAtLeft(n2, d4);
        }
        if (this.axisGlyph.getPosition() == 1) {
            return this.getAlertBoundsWhenAtTop(n2, d5);
        }
        if (this.axisGlyph.getPosition() == 4) {
            return this.getAlertBoundsWhenAtRight(n2, d4);
        }
        return this.getAlertBoundsWhenOther(n2, d5);
    }

    private Rectangle2D getAlertBoundsWhenAtLeft(int n2, double d2) {
        double d3 = n2 == 2 ? this.axisGlyph.originPoint.getX() - this.axisGlyph.getMaxLeftAlert() - 2.0 - d2 : this.axisGlyph.getOrigin().getX() + this.axisGlyph.getPlotZeroBounds().getWidth() - (this.axisGlyph.getPlotLastBounds().getX() - this.axisGlyph.getPlotZeroBounds().getX()) - this.axisGlyph.getMaxRightAlert();
        return new Rectangle2D.Double(d3, -20.0, n2 == 2 ? this.axisGlyph.getMaxLeftAlert() : this.axisGlyph.getMaxRightAlert(), this.axisGlyph.getBounds().getHeight() + 20.0);
    }

    private Rectangle2D getAlertBoundsWhenAtTop(int n2, double d2) {
        double d3 = this.axisGlyph.getMaxLeftAlert();
        double d4 = this.axisGlyph.getMaxRightAlert();
        double d5 = n2 == 2 ? this.axisGlyph.getOrigin().getY() : this.axisGlyph.getOrigin().getY() - d4 - 2.0 - d2;
        return new Rectangle2D.Double(-d3, d5, this.axisGlyph.getBounds().getWidth() + d3 + d4, n2 == 2 ? d3 : d4);
    }

    private Rectangle2D getAlertBoundsWhenAtRight(int n2, double d2) {
        double d3 = n2 == 2 ? this.axisGlyph.getPlotZeroBounds().getX() - this.axisGlyph.getPlotLastBounds().getX() - this.axisGlyph.getPlotLastBounds().getWidth() : this.axisGlyph.getOrigin().getX() + d2 + 2.0;
        return new Rectangle2D.Double(d3, -20.0, n2 == 2 ? this.axisGlyph.getMaxLeftAlert() : this.axisGlyph.getMaxRightAlert(), this.axisGlyph.getBounds().getHeight() + 20.0);
    }

    private Rectangle2D getAlertBoundsWhenOther(int n2, double d2) {
        double d3 = this.axisGlyph.getMaxLeftAlert();
        double d4 = this.axisGlyph.getMaxRightAlert();
        double d5 = n2 == 2 ? this.axisGlyph.getOrigin().getY() + d2 + 2.0 : this.axisGlyph.getOrigin().getY() - this.axisGlyph.getAxisGridLength() - d4 - 2.0;
        return new Rectangle2D.Double(-d3, d5, this.axisGlyph.getBounds().getWidth() + d4 + d3, n2 == 2 ? d3 : d4);
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < this.lines.length; ++i2) {
            generalPath.append(this.lines[i2], false);
        }
        if (this.labelBounds != null) {
            generalPath.append(this.labelBounds, false);
        }
        return generalPath;
    }

    public boolean equals(Object object) {
        return object instanceof ChartAlertValueGlyph && ComparatorUtils.equals(((ChartAlertValueGlyph)object).getLineColor(), this.alertLineColor) && ComparatorUtils.equals(((ChartAlertValueGlyph)object).getLineStyle(), this.alertLineStyle) && ComparatorUtils.equals(((ChartAlertValueGlyph)object).getAlertValueFormula(), this.alertValueFormula) && ComparatorUtils.equals(((ChartAlertValueGlyph)object).getAlertPaneSelectName(), this.alertNameInPaneSelect) && ((ChartAlertValueGlyph)object).getAlertPosition() == this.alertPosition && ComparatorUtils.equals(((ChartAlertValueGlyph)object).getAlertContent(), this.alertContent) && ComparatorUtils.equals(((ChartAlertValueGlyph)object).getAlertFont(), this.alertFont) && ((ChartAlertValueGlyph)object).alertLineAlpha == this.alertLineAlpha;
    }

    public Object clone() throws CloneNotSupportedException {
        ChartAlertValueGlyph chartAlertValueGlyph = (ChartAlertValueGlyph)super.clone();
        if (this.alertValueFormula != null) {
            chartAlertValueGlyph.setAlertValueFormula((Formula)this.alertValueFormula.clone());
        }
        if (this.getLineStyle() != null) {
            chartAlertValueGlyph.setLineStyle((AttrLineStyle)this.getLineStyle().clone());
        }
        if (this.getLineColor() != null) {
            chartAlertValueGlyph.setLineColor((AttrColor)this.getLineColor().clone());
        }
        if (this.alertFont != null) {
            chartAlertValueGlyph.setAlertFont((FRFont)this.alertFont.clone());
        }
        return chartAlertValueGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("attrLineColor", this.getLineColor().toJSONObject());
        jSONObject.put("attrLineStyle", this.getLineStyle().toJSONObject());
        if (this.alertValueFormula != null && this.alertValueFormula.getResult() != null) {
            jSONObject.put("formula", this.alertValueFormula.getResult());
        }
        jSONObject.put("alertPosition", this.alertPosition);
        jSONObject.put("alertContent", this.alertContent);
        jSONObject.put("alertLineAlpha", this.alertLineAlpha);
        jSONObject.put("alertFont", this.alertFont.toJSONObject());
        return jSONObject;
    }
}

