/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar3DPlotGlyph;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.Plot3D;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class CategoryPlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 4363652839224475272L;
    private static final int ZP = 100;
    private static final double SCALE = 0.1;
    private boolean isStacked = false;
    protected Cubic threeDBase = null;

    public boolean isStacked() {
        return this.isStacked;
    }

    public void setStacked(boolean bl) {
        this.isStacked = bl;
    }

    public void doLayout(DataSheetGlyph dataSheetGlyph) {
        int n2 = this.getxAxisGlyph().getPosition();
        Rectangle2D rectangle2D = this.getBounds();
        if (n2 == 1 || n2 == 3) {
            dataSheetGlyph.setBeginX(this.getxAxisGlyph().getBounds().getX() + this.getBounds().getX());
            dataSheetGlyph.setUnitLength(this.getxAxisGlyph().getBounds().getWidth() / (double)this.getCategoryCount());
            rectangle2D.setRect(rectangle2D.getX() + 0.0, rectangle2D.getY(), dataSheetGlyph.getBeginX() + this.getxAxisGlyph().getAxisLength() - rectangle2D.getX(), rectangle2D.getHeight());
        } else {
            dataSheetGlyph.setBeginX(this.getyAxisGlyph().getBounds().getX() + this.getBounds().getX());
            dataSheetGlyph.setUnitLength((this.getBounds().getX() + this.getBounds().getWidth() - dataSheetGlyph.getBeginX()) / (double)this.getCategoryCount());
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), dataSheetGlyph.getBeginX() + this.getyAxisGlyph().getAxisLength() - rectangle2D.getX(), rectangle2D.getHeight());
        }
        this.setBounds(rectangle2D);
        dataSheetGlyph.setCrossValue(this.getxAxisGlyph().getCrossValue());
        dataSheetGlyph.setArrowValue(this.getxAxisGlyph().getArrowValue());
    }

    public DataSheetGlyph createDataSheetGlyph(DataSheet dataSheet, LegendItem[] legendItemArray) {
        return this.createSheetGlyphAndNotShowAxisGlyph(dataSheet, legendItemArray);
    }

    protected void resetPlotBoundsWith3DDeepAndProjectionBeforeAxisGlyph() {
        Plot3DGlyph plot3DGlyph = (Plot3DGlyph)((Object)this);
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = 0.1;
        plot3DGlyph.set3DDeepBase((int)(d2 * rectangle2D.getHeight()));
        int n2 = this.get3DDeep(plot3DGlyph);
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d4 - plot3DGlyph.getProjection().projecteeRY(d3, d4, n2);
        double d6 = plot3DGlyph.getProjection().projecteeRX(d3, d4, n2) - d3;
        rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + d5, d3 - d6, d4 - d5);
        this.setBounds(rectangle2D);
        this.threeDBase = new Cubic(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        this.threeDBase.setDeep(n2);
        this.threeDBase.setProjection(plot3DGlyph.getProjection());
        this.threeDBase.setGeneralInfo(this.getGeneralInfo());
        this.threeDBase.setCubicPosition(rectangle2D.getX(), rectangle2D.getY());
        this.getxAxisGlyph().setCubic(this.threeDBase);
        this.getyAxisGlyph().setCubic(this.threeDBase);
    }

    protected void layoutAxisGlyph4ThreeD(AxisGlyph axisGlyph, AxisGlyph axisGlyph2, int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        Rectangle2D rectangle2D2 = this.getBounds();
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph, rectangle2D);
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph2, rectangle2D);
        this.dealPlotBoundsWithAxisGlyph(axisGlyph, rectangle2D2, n2);
        if (axisGlyph2 != null) {
            axisGlyph2.dealPlotBoundsWithAxisTitle(rectangle2D2, n2);
        }
        this.threeDBase.setCubicWidthHeight(rectangle2D2.getWidth(), rectangle2D2.getHeight());
        this.threeDBase.setCubicPosition(rectangle2D2.getX(), rectangle2D2.getY());
        if (axisGlyph2 != null) {
            axisGlyph2.dealPlotBoundsWithLabel(rectangle2D2, n2);
            ((ValueAxisGlyph)axisGlyph2).dealPlotBoundsWithAlert(rectangle2D2, n2);
        }
        boolean bl = this instanceof Bar3DPlotGlyph ? ((Bar3DPlotGlyph)this).isHorizontal : false;
        this.dealPlotBoundsBefore(rectangle2D2, bl);
        this.calculateAxisGlyphAttr(axisGlyph, rectangle2D2);
        this.calculateAxisGlyphAttr(axisGlyph2, rectangle2D2);
        this.dealPlotBoundsAfter(rectangle2D2, bl);
        this.setBounds(rectangle2D2);
    }

    private void dealPlotBoundsBefore(Rectangle2D rectangle2D, boolean bl) {
        double d2 = this.threeDBase.getGapHeight();
        double d3 = this.threeDBase.getGapWidth();
        if (bl) {
            double d4 = rectangle2D.getX();
            double d5 = rectangle2D.getY() + 2.0 * d2;
            double d6 = rectangle2D.getWidth();
            double d7 = rectangle2D.getHeight() - 2.0 * d2;
            rectangle2D.setRect(d4, d5, d6, d7);
        } else {
            double d8 = rectangle2D.getX() + 2.0 * d3;
            double d9 = rectangle2D.getY();
            double d10 = rectangle2D.getWidth() - 2.0 * d3;
            double d11 = rectangle2D.getHeight();
            rectangle2D.setRect(d8, d9, d10, d11);
        }
    }

    private void dealPlotBoundsAfter(Rectangle2D rectangle2D, boolean bl) {
        double d2 = this.threeDBase.getGapHeight();
        double d3 = this.threeDBase.getGapWidth();
        if (bl) {
            double d4 = rectangle2D.getX();
            double d5 = rectangle2D.getY() - d2;
            double d6 = rectangle2D.getWidth();
            double d7 = rectangle2D.getHeight() + 2.0 * d2;
            rectangle2D.setRect(d4, d5, d6, d7);
        } else {
            double d8 = rectangle2D.getX() - d3;
            double d9 = rectangle2D.getY();
            double d10 = rectangle2D.getWidth() + 2.0 * d3;
            double d11 = rectangle2D.getHeight();
            rectangle2D.setRect(d8, d9, d10, d11);
        }
    }

    private int get3DDeep(Plot3DGlyph plot3DGlyph) {
        int n2 = plot3DGlyph.getDeep();
        if (n2 == -1) {
            n2 = plot3DGlyph.getProjection().projecteeDeep(plot3DGlyph.getDeepBase());
        }
        if (this instanceof Bar3DPlotGlyph && ((Bar3DPlotGlyph)this).isHorizontalDrawBar()) {
            n2 = 100;
        }
        return n2;
    }

    protected void drawAxisGlyph4ThreeD(AxisGlyph axisGlyph, Graphics graphics, int n2) {
        if (axisGlyph != null) {
            axisGlyph.draw4ThreeD(graphics, n2);
        }
    }

    public void draw3DInfo(Graphics graphics, int n2) {
        if (this.threeDBase != null) {
            this.paint(graphics);
            this.threeDBase.draw3DBase(graphics, n2);
        }
    }

    public Shape getOutline4Fill() {
        if (this instanceof Plot3D) {
            Point2D point2D = this.threeDBase.getBasePoint();
            double d2 = this.getyAxisGlyph().getBounds().getWidth();
            double d3 = this.threeDBase.getWidth() - d2;
            double d4 = this.threeDBase.getHeight();
            return new Rectangle2D.Double(point2D.getX() + d2, point2D.getY(), d3, d4);
        }
        return super.getOutline4Fill();
    }

    public double getPreSum4Line(int n2, int n3) {
        return this.getPreSum4Area(n2, n3);
    }

    public double getPreSum4Area(int n2, int n3) {
        double d2 = 0.0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            d2 += this.getDataPointPercentValue(this.getSeries(i2), n3);
        }
        return d2;
    }

    public double getPreSum4Bar(int n2, int n3, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            double d4 = this.getDataPointPercentValue(this.getSeries(i2), n3);
            if (d4 > 0.0) {
                d2 += d4;
                continue;
            }
            d3 += d4;
        }
        if (bl) {
            return d3;
        }
        return d2;
    }

    public double getDataPointPercentValue(int n2, int n3) {
        return this.getDataPointPercentValue(this.getSeries(n2), n3);
    }

    private double getDataPointPercentValue(DataSeries dataSeries, int n2) {
        double d2 = dataSeries.getDataPoint(n2).getValue();
        if (!((ValueAxisGlyph)this.getyAxisGlyph()).isPercentage()) {
            return d2;
        }
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries2 = this.getSeries(i2);
            d3 += Math.abs(dataSeries2.getDataPoint(n2).getValue());
        }
        if (d3 == 0.0) {
            return 0.0;
        }
        return d2 / d3;
    }

    public boolean equals(Object object) {
        return object instanceof CategoryPlotGlyph && super.equals(object) && ((CategoryPlotGlyph)object).isStacked() == this.isStacked;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isStacked", this.isStacked);
        return jSONObject;
    }
}

