/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.BaseUtils;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartdata.ScatterChartData;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;

public class ScatterTableDefinition
extends TableDataDefinition {
    private static final long serialVersionUID = -6382943374534442811L;
    public static final String XML_TAG = "ScatterTableDefinition";
    private String seriesName = null;
    private String scatterX = null;
    private String scatterY = null;

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setScatterX(String string) {
        this.scatterX = string;
    }

    public String getScatterX() {
        return this.scatterX;
    }

    public void setScatterY(String string) {
        this.scatterY = string;
    }

    public String getScatterY() {
        return this.scatterY;
    }

    public ChartData createChartData(DataModel dataModel) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            int n2 = DataCoreUtils.getColumnIndexByName(dataModel, this.seriesName);
            if (n2 != -1) {
                arrayList.addAll(Arrays.asList(BaseUtils.getDistinctValues(dataModel, n2)));
            } else {
                arrayList.add(this.seriesName);
            }
            int n3 = DataCoreUtils.getColumnIndexByName(dataModel, this.scatterX);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList2, n2, n3);
            int n4 = DataCoreUtils.getColumnIndexByName(dataModel, this.scatterY);
            this.addValueInColunmWithName(arrayList, dataModel, arrayList3, n2, n4);
            return new ScatterChartData(arrayList.toArray(), BaseUtils.list2Array2D(arrayList2), BaseUtils.list2Array2D(arrayList3));
        }
        catch (TableDataException tableDataException) {
            return new ScatterChartData(new String[]{""}, new String[][]{{""}}, new String[][]{{""}});
        }
    }

    private void addValueInColunmWithName(ArrayList arrayList, DataModel dataModel, ArrayList arrayList2, int n2, int n3) throws TableDataException {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object e2 = arrayList.get(i2);
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (int i3 = 0; i3 < dataModel.getRowCount(); ++i3) {
                if (n2 == -1) {
                    arrayList3.add(dataModel.getValueAt(i3, n3));
                    continue;
                }
                if (!ComparatorUtils.equals(e2, dataModel.getValueAt(i3, n2))) continue;
                arrayList3.add(dataModel.getValueAt(i3, n3));
            }
            arrayList2.add(arrayList3);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("STD201109").attr("seriesName", this.getSeriesName()).attr("scatterX", this.getScatterX()).attr("scatterY", this.getScatterY()).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "STD201109".equals(xMLableReader.getTagName())) {
            this.setSeriesName(xMLableReader.getAttrAsString("seriesName", this.getSeriesName()));
            this.setScatterX(xMLableReader.getAttrAsString("scatterX", this.getScatterX()));
            this.setScatterY(xMLableReader.getAttrAsString("scatterY", this.getScatterY()));
        }
    }

    public boolean equals(Object object) {
        return object instanceof ScatterTableDefinition && ComparatorUtils.equals(((ScatterTableDefinition)object).getSeriesName(), this.getSeriesName()) && ComparatorUtils.equals(((ScatterTableDefinition)object).getScatterX(), this.getScatterX()) && ComparatorUtils.equals(((ScatterTableDefinition)object).getScatterY(), this.getScatterY()) && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        ScatterTableDefinition scatterTableDefinition = (ScatterTableDefinition)super.clone();
        return scatterTableDefinition;
    }
}

