/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Utils;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.XYPlot;
import com.fr.chart.chartdata.ScatterChartData;
import com.fr.chart.chartglyph.DataPoint4XY;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.XYScatterPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class XYScatterPlot
extends XYPlot {
    private static final long serialVersionUID = 5947464168434538499L;
    public static final String XML_TAG = "XYScatterPlot";
    private static final String[] X_ITEM = new String[]{"N", "S"};
    private static final String[][] X_VALUE = new String[][]{{"10", "20", "30", "50", "60", "66", "70", "74", "83", "96", "114", "130"}, {"10", "20", "30", "50", "60", "66", "70", "74", "83", "96", "114", "130"}};
    private static final String[][] Y_VALUE = new String[][]{{"12", "15", "20", "17", "12", "14", "17", "10", "14", "20", "12", "8"}, {"3", "26", "10", "28", "27", "6", "27", "18", "9", "10", "21", "5"}};
    public static final ScatterChartData SCATTER_CHART_DATA = new ScatterChartData(X_ITEM, X_VALUE, Y_VALUE);
    private boolean isCurve = false;

    public ChartData createNullChartData() {
        return new ScatterChartData(new String[]{""}, new String[][]{{""}}, new String[][]{{""}});
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        XYScatterPlotGlyph xYScatterPlotGlyph = new XYScatterPlotGlyph();
        this.install4PlotGlyph(xYScatterPlotGlyph, chartData);
        this.installAxisGlyph(xYScatterPlotGlyph, chartData);
        return xYScatterPlotGlyph;
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        this.addSeriesByIndex(plotGlyph, scatterChartData);
    }

    protected void addSeriesByIndex(PlotGlyph plotGlyph, ScatterChartData scatterChartData) {
        for (int i2 = 0; i2 < scatterChartData.getItemCount(); ++i2) {
            DataSeries dataSeries = this.createDataSeries(i2);
            dataSeries.setSeriesName(Utils.objectToString(scatterChartData.getPresentItem(i2)));
            plotGlyph.addSeries(dataSeries);
            for (int i3 = 0; i3 < scatterChartData.getCategoryLabelCount(); ++i3) {
                DataPoint4XY dataPoint4XY = new DataPoint4XY();
                dataPoint4XY.setCategoryIndex(i3);
                dataPoint4XY.setSeriesIndex(i2);
                if (i2 < scatterChartData.getItemCount() && i3 < scatterChartData.getCategoryLabelCount()) {
                    Number number = scatterChartData.getX(i2, i3);
                    Number number2 = scatterChartData.getY(i2, i3);
                    dataPoint4XY.setX(number == null ? 0.0 : number.doubleValue());
                    dataPoint4XY.setCategoryOriginalName("" + (number == null ? 0.0 : number.doubleValue()));
                    dataPoint4XY.setValue(number2 == null ? 0.0 : number2.doubleValue());
                    if (number == null || number2 == null) {
                        dataPoint4XY.setValueIsNull(true);
                    }
                }
                if (i3 < scatterChartData.getCategoryLabelCount()) {
                    // empty if block
                }
                if (i2 < scatterChartData.getItemCount()) {
                    dataPoint4XY.setSeriesName(Utils.objectToString(scatterChartData.getPresentItem(i2)));
                    dataPoint4XY.setSeriesOriginalName(Utils.objectToString(scatterChartData.getOriginalItem(i2)));
                }
                dataSeries.addDataPoint(dataPoint4XY);
            }
        }
        this.createDataPointLabel(plotGlyph);
    }

    public void install4PlotGlyph(XYScatterPlotGlyph xYScatterPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(xYScatterPlotGlyph, chartData);
        xYScatterPlotGlyph.setCurve(this.isCurve);
    }

    protected double getMaxValue4XValue(ChartData chartData) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d2 = 0.0;
        for (int i2 = 0; i2 < scatterChartData.getItemCount(); ++i2) {
            for (int i3 = 0; i3 < scatterChartData.getCategoryLabelCount(); ++i3) {
                Number number = scatterChartData.getX(i2, i3);
                if (number == null) continue;
                d2 = d2 > number.doubleValue() ? d2 : number.doubleValue();
            }
        }
        return d2;
    }

    public double getMinValue4XValue(ChartData chartData, boolean bl) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d2 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < scatterChartData.getItemCount(); ++i2) {
            for (int i3 = 0; i3 < scatterChartData.getCategoryLabelCount(); ++i3) {
                Number number = scatterChartData.getX(i2, i3);
                if (number == null) continue;
                if (bl) {
                    if (!(number.doubleValue() > 0.0) || !(number.doubleValue() < d2)) continue;
                    d2 = number.doubleValue();
                    continue;
                }
                d2 = d2 < number.doubleValue() ? d2 : number.doubleValue();
            }
        }
        if (bl && d2 == Double.MAX_VALUE) {
            d2 = 1.0;
        }
        return d2;
    }

    public double getMinValueFromData(ChartData chartData, boolean bl, String string) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d2 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < chartData.getCategoryLabelCount(); ++i2) {
            for (int i3 = 0; i3 < scatterChartData.getItemCount(); ++i3) {
                Number number = scatterChartData.getY(i3, i2);
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, i3);
                if (number == null || !ComparatorUtils.equals(attrAxisPosition.getAxisPosition(), string)) continue;
                d2 = bl ? (number.doubleValue() < d2 && number.doubleValue() < 1.0 && number.doubleValue() > 0.0 ? number.doubleValue() : d2) : (number.doubleValue() < d2 ? number.doubleValue() : d2);
            }
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    public double getMaxValueFromData(ChartData chartData, String string) {
        ScatterChartData scatterChartData = ChartXMLUtils.chartData4XY(chartData);
        double d2 = 0.0;
        for (int i2 = 0; i2 < chartData.getCategoryLabelCount(); ++i2) {
            for (int i3 = 0; i3 < scatterChartData.getItemCount(); ++i3) {
                Number number = scatterChartData.getY(i3, i2);
                if (number == null) continue;
                d2 = number.doubleValue() > d2 ? number.doubleValue() : d2;
            }
        }
        if (d2 == this.getMinValueFromData(chartData, false, string)) {
            return d2 + 10.0;
        }
        return d2;
    }

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        return this.getLegendMarkerIcon4Line(dataSeries, colorArray);
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    public ChartData defaultChartData() {
        return SCATTER_CHART_DATA;
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null && !(plot instanceof XYScatterPlot)) {
            return false;
        }
        return super.match4GUI(plot);
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof XYScatterPlot;
    }

    public boolean isSupportTrendLine() {
        return true;
    }

    public boolean isSupportCategoryFilter() {
        return false;
    }

    public boolean isSupportValuePercent() {
        return false;
    }

    public boolean isHighChart() {
        return false;
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public String getPlotName() {
        String string = Inter.getLocText("I-xyScatterStyle_Marker");
        if (this.getConditionCollection().getDefaultAttr().getExisted(AttrLineStyle.class) == null) {
            string = Inter.getLocText("Chart_Line") + string;
        }
        if (this.getConditionCollection() != null && this.getConditionCollection().isDefaultNullMarker()) {
            string = Inter.getLocText(new String[]{"Data", "Marker"}) + string;
        }
        return string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "XYScatterAttr".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttrAsString("showLine", null);
            if (string2 != null && !Boolean.valueOf(string2).booleanValue()) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
            }
            if ((string2 = xMLableReader.getAttrAsString("showMarker", null)) != null && !Boolean.valueOf(string2).booleanValue()) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
            }
            this.isCurve = xMLableReader.getAttrAsBoolean("Curve", false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("XYScatterAttr").attr("Curve", this.isCurve);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof XYScatterPlot && super.equals(object) && ((XYScatterPlot)object).isCurve() == this.isCurve;
    }
}

