/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RangeAxisGlyph;
import com.fr.chart.chartglyph.RangePlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class RangePlot
extends Plot {
    private static final long serialVersionUID = -7011404700170399167L;
    public static final NormalChartData RANGEDATA = new NormalChartData(new String[]{Inter.getLocText("StyleFormat-Category") + 1}, new String[]{Inter.getLocText("DataFunction-Min"), Inter.getLocText("DataFunction-Max"), Inter.getLocText("Chart_Average_Value"), Inter.getLocText("Chart_Current_Value")}, new Object[][]{{"6"}, {"30"}, {"18"}, {"24"}});
    private ValueAxis valueAxis;
    private double seriesWidth = 4.0;

    public RangePlot() {
        this.setValueAxis(new ValueAxis());
        this.getValueAxis().setPosition(3);
        ValueAxis valueAxis = this.getValueAxis();
        valueAxis.setMainGridColor(null);
        valueAxis.setMainGridStyle(0);
        valueAxis.setTickMarkType(3);
        valueAxis.setSecTickMarkType(3);
    }

    public void setValueAxis(ValueAxis valueAxis) {
        this.valueAxis = valueAxis;
    }

    public ValueAxis getValueAxis() {
        return this.valueAxis;
    }

    public void setSeriesWidth(double d2) {
        this.seriesWidth = d2;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        RangePlotGlyph rangePlotGlyph = new RangePlotGlyph();
        this.install4PlotGlyph(rangePlotGlyph, chartData);
        this.createAxisGlyph(rangePlotGlyph, chartData);
        return rangePlotGlyph;
    }

    public void install4PlotGlyph(RangePlotGlyph rangePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(rangePlotGlyph, chartData);
        rangePlotGlyph.setSeriesWidth(this.seriesWidth);
    }

    public void createAxisGlyph(RangePlotGlyph rangePlotGlyph, ChartData chartData) {
        RangePlotGlyph rangePlotGlyph2 = rangePlotGlyph;
        RangeAxisGlyph rangeAxisGlyph = this.valueAxis.createRangeAxisGlyph();
        rangePlotGlyph2.setRangeAxisGlyph(rangeAxisGlyph);
        rangeAxisGlyph.setAxisType("xAxis");
        rangeAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData, this.valueAxis.isLog(), "LEFT"), this.getMaxValueFromData(chartData, "LEFT"));
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof RangePlot;
    }

    public ChartData defaultChartData() {
        return RANGEDATA;
    }

    public String getPlotName() {
        return Inter.getLocText("ChartF-Range_Chart");
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{2};
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("ValueAxis".equals(string2) && (string = xMLableReader.getAttrAsString("class", null)) != null && string.endsWith(".ValueAxis")) {
                this.valueAxis = (ValueAxis)xMLableReader.readXMLObject(new ValueAxis());
            }
            if ("SeriesWidth".equals(string2) && (string = xMLableReader.getAttrAsString("value", null)) != null) {
                this.setSeriesWidth(Double.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("SeriesWidth").attr("value", this.getSeriesWidth()).end();
        if (this.valueAxis != null) {
            this.valueAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        RangePlot rangePlot = (RangePlot)super.clone();
        if (this.valueAxis != null) {
            rangePlot.valueAxis = (ValueAxis)this.valueAxis.clone();
        }
        return rangePlot;
    }

    public boolean equals(Object object) {
        return object instanceof RangePlot && super.equals(object) && ((RangePlot)object).getSeriesWidth() == this.seriesWidth && ComparatorUtils.equals(((RangePlot)object).getValueAxis(), this.valueAxis);
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.valueAxis != null) {
            this.valueAxis.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.valueAxis != null) {
            this.valueAxis.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.valueAxis != null) {
            this.valueAxis.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public Axis getxAxis() {
        return this.valueAxis;
    }

    public void setxAxis(Axis axis) {
        if (axis instanceof ValueAxis) {
            this.valueAxis = (ValueAxis)axis;
        }
    }
}

