/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RadarAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RadarAxisGlyph;
import com.fr.chart.chartglyph.RadarPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class RadarPlot
extends Plot {
    private static final long serialVersionUID = 224372350182474023L;
    private static final String[] CATENAME = new String[]{"1", "2", "3", "4", "5", "6", "7"};
    private static final Object[] SERIESNAME = new Object[]{"NA"};
    private static final Object[][] VALUE = new Object[][]{{"35", "35", "35", "35", "40", "50", "40"}};
    private static final NormalChartData RADARDATA = new NormalChartData(CATENAME, SERIESNAME, VALUE);
    private RadarAxis radarAxis = new RadarAxis();
    private boolean isFilled = false;
    private Color intervalColor = null;

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        return this.getLegendMarkerIcon4Line(dataSeries, colorArray);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        RadarPlotGlyph radarPlotGlyph = new RadarPlotGlyph();
        this.install4PlotGlyph(radarPlotGlyph, chartData);
        this.createAxisGlyph(radarPlotGlyph, chartData);
        return radarPlotGlyph;
    }

    public boolean isOnlyIntervalBackground() {
        return true;
    }

    public void install4PlotGlyph(RadarPlotGlyph radarPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(radarPlotGlyph, chartData);
        radarPlotGlyph.setFilled(this.isFilled);
        radarPlotGlyph.setIntervalColor(this.intervalColor);
    }

    private void createAxisGlyph(RadarPlotGlyph radarPlotGlyph, ChartData chartData) {
        int n2;
        RadarPlotGlyph radarPlotGlyph2 = radarPlotGlyph;
        RadarAxisGlyph radarAxisGlyph = (RadarAxisGlyph)this.radarAxis.createAxisGlyph(chartData);
        radarAxisGlyph.setAxisType("xAxis");
        radarAxisGlyph.setCategoryCount(chartData.getCategoryLabelCount());
        radarAxisGlyph.initMinMaxValue(this.getMinValueFromData(chartData, radarAxisGlyph.isLog(), "LEFT"), this.getMaxValueFromData(chartData, "LEFT"));
        double[] dArray = new double[chartData.getCategoryLabelCount()];
        double[] dArray2 = new double[chartData.getCategoryLabelCount()];
        if (this.radarAxis.isAllMaxMin()) {
            for (n2 = 0; n2 < chartData.getCategoryLabelCount(); ++n2) {
                dArray[n2] = radarAxisGlyph.getMaxValue();
                dArray2[n2] = radarAxisGlyph.getMinValue();
            }
        } else {
            for (n2 = 0; n2 < chartData.getCategoryLabelCount(); ++n2) {
                dArray2[n2] = this.getMinValueFromaCateData(chartData, n2);
                double d2 = this.getMaxValueFromCateData(chartData, n2, "LEFT");
                if (d2 <= dArray2[n2]) {
                    d2 += 10.0;
                }
                dArray[n2] = d2;
            }
        }
        radarAxisGlyph.setRadarMax(dArray);
        radarAxisGlyph.setRadarMin(dArray2);
        int n3 = chartData.getCategoryLabelCount();
        for (n2 = 0; n2 < n3; ++n2) {
            radarAxisGlyph.addCategoryLabel(chartData.getCategoryPresentLabel(n2) == null ? "" : chartData.getCategoryPresentLabel(n2));
        }
        radarPlotGlyph2.setRadarAxisGlyph(radarAxisGlyph);
    }

    public double getMaxValueFromCateData(ChartData chartData, int n2, String string) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getSeriesCount(); ++i2) {
            Number number = normalChartData.getValueAt(i2, n2);
            if (number == null) continue;
            d2 = i2 == 0 ? number.doubleValue() : (number.doubleValue() > d2 ? number.doubleValue() : d2);
        }
        if (d2 == this.getMinValueFromData(normalChartData, false, string)) {
            return d2 + 10.0;
        }
        return d2;
    }

    private double getMinValueFromaCateData(ChartData chartData, int n2) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getSeriesCount(); ++i2) {
            Number number = normalChartData.getValueAt(i2, n2);
            if (number == null) continue;
            d2 = number.doubleValue() < d2 ? number.doubleValue() : d2;
        }
        return d2;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setIsFilled(boolean bl) {
        this.isFilled = bl;
    }

    public void setIntervalColor(Color color) {
        this.intervalColor = color;
    }

    public Color getIntervalColor() {
        return this.intervalColor;
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return plot instanceof RadarPlot && super.match4GUI(plot);
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof RadarPlot;
    }

    public boolean isSupportIntervalBackground() {
        return true;
    }

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        ChartFactory.setDefaultCondition4RadarChart(this);
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{2};
    }

    public ChartData defaultChartData() {
        return RADARDATA;
    }

    public List getList4InteractivePane() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(2));
        return new ArrayList();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("RadarAttr".equals(string2)) {
                this.setIsFilled(xMLableReader.getAttrAsBoolean("isFilled", false));
                this.setIntervalColor(xMLableReader.getAttrAsColor("intervalColor", null));
                if (!xMLableReader.getAttrAsBoolean("showLine", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
                }
                if (!xMLableReader.getAttrAsBoolean("showMarker", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
                }
            } else if ("RadarAxis".equals(string2) && (string = xMLableReader.getAttrAsString("class", null)) != null && string.endsWith(".RadarAxis")) {
                this.radarAxis = (RadarAxis)xMLableReader.readXMLObject(new RadarAxis());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("RadarAttr").attr("isFilled", this.isFilled);
        if (this.intervalColor != null) {
            xMLPrintWriter.attr("intervalColor", this.intervalColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.radarAxis != null) {
            this.radarAxis.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof RadarPlot && super.equals(object) && ComparatorUtils.equals(((RadarPlot)object).radarAxis, this.radarAxis) && ((RadarPlot)object).isFilled() == this.isFilled && ComparatorUtils.equals(((RadarPlot)object).getIntervalColor(), this.intervalColor);
    }

    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.radarAxis != null) {
            this.radarAxis.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.radarAxis != null) {
            this.radarAxis.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.radarAxis != null) {
            this.radarAxis.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RadarPlot radarPlot = (RadarPlot)super.clone();
        if (this.radarAxis != null) {
            radarPlot.radarAxis = (RadarAxis)this.radarAxis.clone();
        }
        return radarPlot;
    }

    public Axis getxAxis() {
        return this.radarAxis;
    }

    public String getPlotName() {
        boolean bl = true;
        DataSeriesCondition dataSeriesCondition = this.getConditionCollection().getDefaultAttr().getExisted(AttrMarkerType.class);
        if (dataSeriesCondition != null) {
            bl = !ComparatorUtils.equals(((AttrMarkerType)dataSeriesCondition).getMarkerType(), "NullMarker");
        }
        String string = Inter.getLocText("ChartF-Radar");
        if (this.isFilled()) {
            string = Inter.getLocText("ChartF-Fill") + string;
        }
        if (bl) {
            string = Inter.getLocText(new String[]{"Data", "Marker"}) + string;
        }
        return string;
    }

    public void setxAxis(Axis axis) {
        if (axis instanceof RadarAxis) {
            this.radarAxis = (RadarAxis)axis;
        }
    }

    public void setyAxis(Axis axis) {
    }
}

