/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.MapXMLHelper;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Map;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

public class MapPlot
extends Plot {
    public static final String XML_TAG = "MapPlot";
    private static final long serialVersionUID = 8037342693603720271L;
    private String mapName = Inter.getLocText("China");
    private MapHotAreaColor hotAreaColor = new MapHotAreaColor();
    private String[] currentShowName = null;
    private HashMap fromMapNames = new HashMap();
    public static final MapChartData MAP_CHART_DATA = new MapChartData();
    private static final HashMap XML_NAMES;

    public MapPlot() {
        XML_NAMES.put("World", Inter.getLocText("World Map"));
        XML_NAMES.put("China", Inter.getLocText("China"));
        XML_NAMES.put("Anhui", Inter.getLocText("Anhui"));
        XML_NAMES.put("Aomen", Inter.getLocText("Aomen"));
        XML_NAMES.put("Beijing", Inter.getLocText("Beijing"));
        XML_NAMES.put("Tianjin", Inter.getLocText("Tianjin"));
        XML_NAMES.put("Hebei", Inter.getLocText("Hebei"));
        XML_NAMES.put("Shanxi", Inter.getLocText("Shanxi"));
        XML_NAMES.put("Nei Mongol", Inter.getLocText("Neimenggu"));
        XML_NAMES.put("Liaoning", Inter.getLocText("Liaoning"));
        XML_NAMES.put("Jilin", Inter.getLocText("Jilin"));
        XML_NAMES.put("Heilongjiang", Inter.getLocText("Heilongjiang"));
        XML_NAMES.put("Shanghai", Inter.getLocText("Shanghai"));
        XML_NAMES.put("Jiangsu", Inter.getLocText("Jiangsu"));
        XML_NAMES.put("Zhejiang", Inter.getLocText("Zhejiang"));
        XML_NAMES.put("Fujian", Inter.getLocText("Fujian"));
        XML_NAMES.put("Jiangxi", Inter.getLocText("Jiangxi"));
        XML_NAMES.put("Shandong", Inter.getLocText("Shandong"));
        XML_NAMES.put("Henan", Inter.getLocText("Henan"));
        XML_NAMES.put("Guangdong", Inter.getLocText("Guangdong"));
        XML_NAMES.put("Guangxi", Inter.getLocText("Guangxi"));
        XML_NAMES.put("Hainan", Inter.getLocText("Hainan"));
        XML_NAMES.put("Chongqing", Inter.getLocText("Chongqing"));
        XML_NAMES.put("Sichuan", Inter.getLocText("Sichuan"));
        XML_NAMES.put("Guizhou", Inter.getLocText("Guizhou"));
        XML_NAMES.put("Yunnan", Inter.getLocText("Yunnan"));
        XML_NAMES.put("Xizang", Inter.getLocText("Xizang"));
        XML_NAMES.put("Shaanxi", Inter.getLocText("Shaanxi"));
        XML_NAMES.put("Gansu", Inter.getLocText("Gansu"));
        XML_NAMES.put("Qinghai", Inter.getLocText("Qinghai"));
        XML_NAMES.put("Ningxia", Inter.getLocText("Ningxia"));
        XML_NAMES.put("Xinjiang", Inter.getLocText("Xinjiang"));
        XML_NAMES.put("Taiwan", Inter.getLocText("Taiwan"));
        XML_NAMES.put("Xianggangdao", Inter.getLocText("Xianggang"));
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        MapPlotGlyph mapPlotGlyph = new MapPlotGlyph();
        this.install4PlotGlyph(mapPlotGlyph, chartData);
        mapPlotGlyph.setMapName(this.mapName);
        this.getAllStartMapName(this.currentShowName, mapPlotGlyph);
        mapPlotGlyph.setAreaColors(this.hotAreaColor);
        return mapPlotGlyph;
    }

    private void getAllStartMapName(String[] stringArray, MapPlotGlyph mapPlotGlyph) {
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        if (stringArray.length == 1 && StringUtils.isNotEmpty(stringArray[0])) {
            mapPlotGlyph.setMapName(stringArray[0]);
            return;
        }
        String[] stringArray2 = stringArray;
        boolean bl = true;
        while (bl) {
            int n2;
            int n3;
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                stringArray2[n3] = Utils.objectToString(this.fromMapNames.get(stringArray2[n3]));
            }
            n3 = 1;
            for (n2 = 0; n2 < stringArray2.length - 1; ++n2) {
                if (ComparatorUtils.equals(stringArray2[n2], stringArray2[n2 + 1])) continue;
                n3 = 0;
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (!StringUtils.isEmpty(stringArray2[n2])) continue;
                n3 = 0;
                bl = false;
                break;
            }
            if (n3 == 0) continue;
            mapPlotGlyph.setMapName(stringArray[0]);
            bl = false;
        }
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        int n2;
        MapChartData mapChartData = (MapChartData)chartData;
        this.fromMapNames.clear();
        int n3 = this.hotAreaColor.getAreaNumber();
        int n4 = 1;
        for (n2 = 0; n2 < n3 + n4; ++n2) {
            plotGlyph.addSeries(new DataSeries(n2));
        }
        n2 = 0;
        this.add4NextSeries(this.mapName, this.mapName, n2, plotGlyph, mapChartData, this.hotAreaColor);
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        for (int i2 = 0; i2 < plotGlyph.getSeriesSize(); ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            int n5 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n5; ++i3) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
                if (mapAreaValue == null) continue;
                double d4 = mapAreaValue.getFirstTitleValue();
                d2 = Math.min(d2, d4);
                d3 = Math.max(d3, d4);
            }
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = 0.0;
        }
        this.hotAreaColor.refreshMinMax(d2, d3);
        this.hotAreaColor.initColor();
        this.makeSurePointIndex(plotGlyph, this.hotAreaColor);
        this.createDataPointLabel(plotGlyph);
    }

    protected void createDataPointLabel(PlotGlyph plotGlyph) {
        this.initTotalValue(plotGlyph);
        this.createDataLabel4EverySeries(plotGlyph);
    }

    private void initTotalValue(PlotGlyph plotGlyph) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                dataPoint.setCategoryIndex(i3);
                if (dataPoint.isValueIsNull()) continue;
                String string = dataPoint.getSeriesName();
                if (hashMap.containsKey(string)) {
                    Object v2 = hashMap.get(string);
                    double d2 = Utils.objectToNumber(v2, false).doubleValue();
                    hashMap.remove(string);
                    hashMap.put(string, new Double(d2 + dataPoint.getValue()));
                    continue;
                }
                hashMap.put(string, new Double(dataPoint.getValue()));
            }
        }
        this.dealDataPointPercent(plotGlyph, hashMap);
    }

    private void dealDataPointPercent(PlotGlyph plotGlyph, HashMap hashMap) {
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                String string;
                Object v2;
                double d2;
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.isValueIsNull() || (d2 = Utils.objectToNumber(v2 = hashMap.get(string = dataPoint.getSeriesName()), false).doubleValue()) == 0.0) continue;
                dataPoint.setPercentValue(dataPoint.getValue() / d2);
            }
        }
    }

    public LegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        if (this.getLegend() == null) {
            return new LegendGlyph();
        }
        Color[] colorArray = this.hotAreaColor.initColor();
        LegendItem[] legendItemArray = new LegendItem[colorArray.length];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            legendItemArray[i2] = new LegendItem("");
            LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
            lineMarkerIcon.setBackground(ColorBackground.getInstance(colorArray[i2]));
            legendItemArray[i2].setLineMarkerIcon(lineMarkerIcon);
            legendItemArray[i2].setLabel(this.hotAreaColor.getLabelWithInt(i2));
        }
        return this.getLegend().createLegendGlyph(legendItemArray);
    }

    private MapAreaValue add4NextSeries(String string, String string2, int n2, PlotGlyph plotGlyph, MapChartData mapChartData, MapHotAreaColor mapHotAreaColor) {
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(string2);
        if (mapAttr == null) {
            return new MapAreaValue();
        }
        MapAttr mapAttr2 = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        MapAreaValue mapAreaValue = new MapAreaValue();
        Iterator iterator = mapAttr.shapeValuesIterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            DataPoint4Map dataPoint4Map = new DataPoint4Map();
            dataPoint4Map.setNameFrom(string);
            dataPoint4Map.setLayerIndex(n2);
            dataPoint4Map.setSeriesName(string2);
            if (!ComparatorUtils.equals(string2, string)) {
                this.fromMapNames.put(string2, string);
            }
            String string4 = mapAttr2.getLayerTo(string3);
            String string5 = this.getDataUseName(mapAttr2, string3, string2);
            if (mapChartData.isHasLayerTo()) {
                dataPoint4Map.setHasNextTo(StringUtils.isNotBlank(string4));
                dataPoint4Map.setNameLayerTo(string4);
            } else {
                dataPoint4Map.setHasNextTo(false);
                dataPoint4Map.setNameLayerTo("");
            }
            dataPoint4Map.setCategoryName(string5);
            dataPoint4Map.setCategoryOriginalName(string3);
            this.initDataPoint4Map(string4, string2, string5, n2, plotGlyph, mapChartData, mapHotAreaColor, dataPoint4Map, mapAreaValue);
        }
        return mapAreaValue;
    }

    private void initDataPoint4Map(String string, String string2, String string3, int n2, PlotGlyph plotGlyph, MapChartData mapChartData, MapHotAreaColor mapHotAreaColor, DataPoint4Map dataPoint4Map, MapAreaValue mapAreaValue) {
        Object object;
        int n3 = 0;
        MapAreaValue mapAreaValue2 = (MapAreaValue)mapChartData.getMapData(string3);
        if (dataPoint4Map.isHasNextTo() && mapChartData.isHasLayerTo() && !ComparatorUtils.equals(string2, string) && StringUtils.isNotBlank(string)) {
            object = this.add4NextSeries(string2, string, n2 + 1, plotGlyph, mapChartData, mapHotAreaColor);
            if (((MapAreaValue)object).isTitleValueNull()) {
                if (!mapAreaValue2.isTitleValueNull()) {
                    double d2 = mapAreaValue2.getFirstTitleValue();
                    dataPoint4Map.setValue(d2);
                    dataPoint4Map.setAreaValue(mapAreaValue2);
                    this.checkMapAreaTitle(mapAreaValue, mapAreaValue2);
                    n3 = mapHotAreaColor.getColorsIndex(d2);
                } else {
                    dataPoint4Map.setValue(0.0);
                    dataPoint4Map.setValueIsNull(true);
                    n3 = plotGlyph.getSeriesSize() - 1;
                }
            } else {
                dataPoint4Map.setValue(((MapAreaValue)object).getFirstTitleValue());
                dataPoint4Map.setAreaValue((MapAreaValue)object);
                n3 = mapHotAreaColor.getColorsIndex(((MapAreaValue)object).getFirstTitleValue());
            }
        } else if (mapAreaValue2.isTitleValueNull()) {
            dataPoint4Map.setValue(0.0);
            dataPoint4Map.setValueIsNull(true);
            n3 = plotGlyph.getSeriesSize() - 1;
        } else {
            double d3 = mapAreaValue2.getFirstTitleValue();
            dataPoint4Map.setValue(d3);
            dataPoint4Map.setAreaValue(mapAreaValue2);
            this.checkMapAreaTitle(mapAreaValue, mapAreaValue2);
            n3 = mapHotAreaColor.getColorsIndex(d3);
        }
        dataPoint4Map.setSeriesIndex(n3);
        object = plotGlyph.getSeries(n3);
        ((DataSeries)object).addDataPoint(dataPoint4Map);
    }

    private void checkMapAreaTitle(MapAreaValue mapAreaValue, MapAreaValue mapAreaValue2) {
        if (mapAreaValue.isTitleValueNull()) {
            int n2 = mapAreaValue2.titleValueSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                MapTitleValue mapTitleValue = mapAreaValue2.getTitleValue(i2);
                mapAreaValue.addTitleValue(new MapTitleValue(mapTitleValue.getTitle(), mapTitleValue.getValue()));
            }
        } else {
            int n3 = mapAreaValue2.titleValueSize();
            for (int i3 = 0; i3 < n3; ++i3) {
                MapTitleValue mapTitleValue = mapAreaValue2.getTitleValue(i3);
                MapTitleValue mapTitleValue2 = mapAreaValue.getTitleValue(i3);
                mapTitleValue2.setValue(mapTitleValue2.getValue() + mapTitleValue.getValue());
            }
        }
    }

    private String getDataUseName(MapAttr mapAttr, String string, String string2) {
        MapAttr mapAttr2;
        String string3 = Utils.objectToString(mapAttr.getNameToValue(string));
        if (!ComparatorUtils.equals(string2, this.mapName) && (mapAttr2 = (MapAttr)MapXMLHelper.getInstance().getMapAttr(string2)) != null) {
            string3 = Utils.objectToString(mapAttr2.getNameToValue(string));
        }
        return string3;
    }

    private void makeSurePointIndex(PlotGlyph plotGlyph, MapHotAreaColor mapHotAreaColor) {
        HashMap hashMap = new HashMap();
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                int n3;
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.isValueIsNull() || (n3 = mapHotAreaColor.getColorsIndex(dataPoint.getValue())) == i2) continue;
                dataSeries.removeDataPoint(dataPoint);
                dataPoint.setSeriesIndex(n3);
                DataSeries dataSeries2 = plotGlyph.getSeries(n3);
                dataSeries2.addDataPoint(dataPoint);
                --i3;
            }
        }
        this.dealDataPointPercent(plotGlyph, hashMap);
    }

    public void setMapAreaColor(MapHotAreaColor mapHotAreaColor) {
        this.hotAreaColor = mapHotAreaColor;
    }

    public MapHotAreaColor getMapAreaColor() {
        return this.hotAreaColor;
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public void setMapName(String string) {
        this.mapName = string;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String[] getCurrentShowName() {
        return this.currentShowName;
    }

    public void setCurrentShowName(String[] stringArray) {
        this.currentShowName = stringArray;
    }

    public String getPlotName() {
        return Inter.getLocText("Chart-Map");
    }

    public boolean isHaveAxis() {
        return false;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof MapPlot;
    }

    public ChartData defaultChartData() {
        return MAP_CHART_DATA;
    }

    public ChartData createNullChartData() {
        return new MapChartData();
    }

    private static final void getFirst() {
        MAP_CHART_DATA.addMapData(Inter.getLocText("China"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1000.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("Xinjiang"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("Guangdong"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FuzhouCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("BeijingInCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("TianjinInCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 600.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("HohhotCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 700.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ShenyangCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 800.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ChangChunCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 900.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("HarbinCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1000.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("HangzhouCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("HefeiCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("NanchangCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("JinanCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1400.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("WuhanCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ChangshaCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 1600.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("GuangzhouCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("NanningCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 600.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("HaikouCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ChengduCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("GuiyangCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("KunmingCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("LasaCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 400.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("XianCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("YinchuanCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("UrumqiCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ShijiazhuangCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("TaiyuanCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ShanghaiInCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ChongqingInCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("LanzhouCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("XiningCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("NanjingCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("ZhengzhouCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("TaipeiCity"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("Zhongxi"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("AomenBandao"), new MapAreaValue(new MapTitleValue(Inter.getLocText("Title"), 500.0)));
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{1, 2};
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("newattr201212", string)) {
                if (xMLableReader.getAttrAsString("mapName", null) != null) {
                    this.mapName = xMLableReader.getAttrAsString("mapName", null);
                }
            } else if (ComparatorUtils.equals("newattr201106", string)) {
                if (xMLableReader.getAttrAsString("mapName", null) != null) {
                    this.mapName = xMLableReader.getAttrAsString("mapName", null);
                    this.mapName = XML_NAMES.containsKey(this.mapName) ? Utils.objectToString(XML_NAMES.get(this.mapName)) : Inter.getLocText("China");
                }
            } else if (ComparatorUtils.equals(string, "MapHotAreaColor")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        MapPlot.this.hotAreaColor = (MapHotAreaColor)xMLableReader.readXMLObject(new MapHotAreaColor());
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("newattr201212").attr("mapName", this.mapName).end();
        if (this.hotAreaColor != null) {
            this.hotAreaColor.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof MapPlot && super.equals(object) && ComparatorUtils.equals(this.hotAreaColor, ((MapPlot)object).getMapAreaColor()) && ComparatorUtils.equals(this.mapName, ((MapPlot)object).getMapName());
    }

    public Object clone() throws CloneNotSupportedException {
        MapPlot mapPlot = (MapPlot)super.clone();
        if (this.hotAreaColor != null) {
            mapPlot.hotAreaColor = (MapHotAreaColor)this.hotAreaColor.clone();
        }
        return mapPlot;
    }

    static {
        MapPlot.getFirst();
        XML_NAMES = new HashMap();
    }
}

