/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.LinePlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class LinePlot
extends CategoryPlot {
    private static final long serialVersionUID = 8277372084403680598L;
    private static final Object[] LINE_SERIES_NAME = new Object[]{"N", "C"};
    private static final Object[][] LINE_VALUE = new Object[][]{{"5", "40", "18", "14", "70", "85"}, {"36", "75", "53", "57", "40", "45"}};
    private boolean isCurve = false;

    public LinePlot() {
        this.setStacked(false);
    }

    public boolean isSupportTrendLine() {
        return !this.isStacked();
    }

    public boolean isSupportMoreCate() {
        return true;
    }

    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    public boolean isSupportAxisReverse() {
        return true;
    }

    public boolean isSupportSeriesDrag() {
        return true;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        LinePlotGlyph linePlotGlyph = new LinePlotGlyph();
        this.install4PlotGlyph(linePlotGlyph, chartData);
        this.installAxisGlyph(linePlotGlyph, chartData);
        linePlotGlyph.getxAxisGlyph().setDrawBetweenTick(true);
        return linePlotGlyph;
    }

    public void install4PlotGlyph(LinePlotGlyph linePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(linePlotGlyph, chartData);
        linePlotGlyph.setCurve(this.isCurve);
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        return this.getLegendMarkerIcon4Line(dataSeries, colorArray);
    }

    public String getPlotName() {
        boolean bl = this.getConditionCollection() == null ? false : this.getConditionCollection().isDefaultNullMarker();
        String string = Inter.getLocText("I-LineStyle_Line");
        if (bl) {
            string = Inter.getLocText(new String[]{"Data", "Marker"}) + string;
        }
        if (this.isStacked()) {
            string = Inter.getLocText("ChartF-Stacked") + string;
        }
        if (this.getyAxis().isPercentage()) {
            string = Inter.getLocText("StyleFormat-Percent") + string;
        }
        return string;
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return plot instanceof LinePlot && super.match4GUI(plot);
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof LinePlot;
    }

    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new NormalChartData(ChartUtils.LONG_CATEGORY_DATE, LINE_SERIES_NAME, LINE_VALUE) : new NormalChartData(ChartUtils.LONG_CATEGORY_STRING, LINE_SERIES_NAME, LINE_VALUE);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Show".equals(string)) {
                this.setCurve(xMLableReader.getAttrAsBoolean("Curve", false));
                if (!xMLableReader.getAttrAsBoolean("showLine", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
                }
                if (!xMLableReader.getAttrAsBoolean("showMarker", true)) {
                    ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
                }
            }
            if (this.getyAxis() != null) {
                this.getyAxis().setPercentage(false);
            }
            this.setStacked(false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Show").attr("Curve", this.isCurve).end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        LinePlot linePlot = (LinePlot)super.clone();
        return linePlot;
    }

    public boolean equals(Object object) {
        return object instanceof LinePlot && super.equals(object) && ((LinePlot)object).isCurve() == this.isCurve;
    }
}

