/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.general.ComparatorUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRFont;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class Legend
extends GeneralInfo {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "Legend";
    private int position = 4;
    private FRFont frFont;
    private boolean legendVisible = true;

    public Legend() {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        this.frFont = defaultValues.getFRFont();
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public FRFont getFRFont() {
        return this.frFont;
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public void setLegendVisible(boolean bl) {
        this.legendVisible = bl;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public LegendGlyph createLegendGlyph(LegendItem[] legendItemArray) {
        if (!this.isLegendVisible()) {
            return null;
        }
        LegendGlyph legendGlyph = new LegendGlyph(legendItemArray);
        legendGlyph.setFont(this.frFont);
        legendGlyph.setGeneralInfo(this);
        legendGlyph.setPosition(this.position);
        legendGlyph.setVisible(this.isLegendVisible());
        return legendGlyph;
    }

    public Object clone() throws CloneNotSupportedException {
        Legend legend = (Legend)super.clone();
        if (this.getFRFont() != null) {
            legend.setFRFont((FRFont)this.getFRFont().clone());
        }
        return legend;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.setPosition(xMLableReader.getAttrAsInt("position", 4));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (BaseXMLUtils.isFRFontTagName(string)) {
                this.setFRFont(BaseXMLUtils.readFRFont(xMLableReader));
            }
            if ("Attr".equals(string)) {
                this.setPosition(xMLableReader.getAttrAsInt("position", 4));
                this.setLegendVisible(xMLableReader.getAttrAsBoolean("visible", true));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr").attr("position", this.getPosition()).attr("visible", this.legendVisible).end();
        if (this.getFRFont() != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.getFRFont());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof Legend && super.equals(object) && ((Legend)object).legendVisible == this.legendVisible && ((Legend)object).position == this.position && ComparatorUtils.equals(((Legend)object).frFont, this.frFont);
    }
}

