/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.Utils;
import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.GisMapChartData;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartglyph.DataPoint4GisMap;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.GisMapPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Map;

public class GisMapPlot
extends Plot {
    private static final long serialVersionUID = -6503508461964417745L;
    private static final double BASE = 60.0;
    private static final String XML_TAG = "GisMapPlot";
    private static final GisMapChartData GIS_MAP_DATA = new GisMapChartData();
    private boolean gisType = true;
    private boolean isAddress = true;
    private String googleKey = "";
    private String baiduKey = "";

    public GisMapPlot() {
        this.resetNullLegendAttr();
    }

    public String getPlotName() {
        return Inter.getLocText("ChartF-Gis");
    }

    public void setAddressType(boolean bl) {
        this.isAddress = bl;
    }

    public boolean isAddress() {
        return this.isAddress;
    }

    public void setGisType(boolean bl) {
        this.gisType = bl;
    }

    public boolean isGisType() {
        return this.gisType;
    }

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        this.resetNullLegendAttr();
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        GisMapPlotGlyph gisMapPlotGlyph = new GisMapPlotGlyph();
        this.install4PlotGlyph(gisMapPlotGlyph, chartData);
        GisMapChartData gisMapChartData = (GisMapChartData)chartData;
        gisMapPlotGlyph.setAddressType(gisMapChartData.isAddress());
        gisMapPlotGlyph.setGisType(this.gisType);
        gisMapPlotGlyph.setBaiduKey(this.baiduKey);
        gisMapPlotGlyph.setGoogleKey(this.googleKey);
        ChartPreStyleServerManager chartPreStyleServerManager = ChartPreStyleServerManager.getInstance();
        chartPreStyleServerManager.setGisType(this.gisType);
        return gisMapPlotGlyph;
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        GisMapChartData gisMapChartData = (GisMapChartData)chartData;
        HashMap hashMap = gisMapChartData.getAddressTittleValue();
        HashMap hashMap2 = gisMapChartData.getAddressName();
        boolean bl = gisMapChartData.isAddress();
        boolean bl2 = gisMapChartData.isLngFirst();
        plotGlyph.addSeries(new DataSeries());
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object;
            String string = Utils.objectToString(entry.getKey());
            DataPoint4GisMap dataPoint4GisMap = new DataPoint4GisMap();
            if (bl) {
                dataPoint4GisMap.setCategoryName(string);
            } else {
                String string2;
                String string3;
                object = string;
                if (this.isDegreeFormat((String)object) && object != null && ((String)object).split(",").length == 2) {
                    string3 = string.split(",")[0];
                    string2 = string.split(",")[1];
                    string3 = this.degree2number(string3);
                    string2 = this.degree2number(string2);
                    object = string3 + "," + string2;
                }
                if (this.gisType != bl2 && object != null && ((String)object).split(",").length == 2) {
                    string3 = string.split(",")[0];
                    string2 = string.split(",")[1];
                    object = string2 + "," + string3;
                }
                dataPoint4GisMap.setCategoryName((String)object);
            }
            object = (MapAreaValue)hashMap.get(string);
            if (((MapAreaValue)object).isTitleValueNull()) {
                dataPoint4GisMap.setValue(0.0);
                dataPoint4GisMap.setValueIsNull(true);
            } else {
                double d2 = ((MapAreaValue)object).getFirstTitleValue();
                dataPoint4GisMap.setValue(d2);
                dataPoint4GisMap.setAreaValue((MapAreaValue)object);
            }
            if (hashMap2 != null && !hashMap2.isEmpty()) {
                String string4 = (String)hashMap2.get(string);
                dataPoint4GisMap.setAddressName(string4);
            }
            plotGlyph.getSeries(0).addDataPoint(dataPoint4GisMap);
        }
    }

    private boolean isDegreeFormat(String string) {
        if (string != null) {
            string = string.trim();
            String string2 = "[+-]?.*\u00b0(.*\u2032)?(.*\u2033)?";
            return string.matches(string2 + "(\\s)*,(\\s)*" + string2);
        }
        return false;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof GisMapPlot;
    }

    public ChartData defaultChartData() {
        return GIS_MAP_DATA;
    }

    public ChartData createNullChartData() {
        return GIS_MAP_DATA;
    }

    private String degree2number(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '\u00b0') {
                string2 = string.substring(n2, i2);
                n2 = i2 + 1;
                continue;
            }
            if (string.charAt(i2) == '\u2032') {
                string3 = string.substring(n2, i2);
                n2 = i2 + 1;
                continue;
            }
            if (string.charAt(i2) != '\u2033') continue;
            string4 = string.substring(n2, i2);
            break;
        }
        double d2 = 0.0;
        if (string4 != null) {
            d2 += Double.parseDouble(string4) / 3600.0;
        }
        if (string3 != null) {
            d2 += Double.parseDouble(string3) / 60.0;
        }
        if (string2 != null) {
            d2 += Double.parseDouble(string2);
        }
        return Double.toString(d2);
    }

    public boolean isHaveAxis() {
        return false;
    }

    public String getBaiduKey() {
        return this.baiduKey;
    }

    public void setBaiduKey(String string) {
        this.baiduKey = string;
    }

    public String getGoogleKey() {
        return this.googleKey;
    }

    public void setGoogleKey(String string) {
        this.googleKey = string;
    }

    public Legend getLegend() {
        return null;
    }

    public boolean isSupportDataSeriesAttr() {
        return false;
    }

    public boolean isSupportAddress4Gis() {
        return true;
    }

    public boolean isSupportDataSeriesCondition() {
        return false;
    }

    public boolean isSupportValuePercent() {
        return false;
    }

    public boolean isSupportAnimate() {
        return false;
    }

    public boolean isSupportDataLabelAttr() {
        return false;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("GISTYPE").attr("gitType", this.gisType).attr("baiduKey", this.baiduKey).attr("googleKey", this.googleKey).end();
    }

    public void readXML(XMLableReader xMLableReader) {
        Object object;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "GISTYPE".equals(object = xMLableReader.getTagName())) {
            boolean bl = xMLableReader.getAttrAsBoolean("gitType", false);
            String string = xMLableReader.getAttrAsString("baiduKey", "");
            String string2 = xMLableReader.getAttrAsString("googleKey", "");
            this.setGisType(bl);
            this.setBaiduKey(xMLableReader.getAttrAsString("baiduKey", ""));
            this.setGoogleKey(xMLableReader.getAttrAsString("googleKey", ""));
        }
        object = ChartPreStyleServerManager.getInstance();
        ((ChartPreStyleServerManager)object).setBaiduKey(this.baiduKey);
        ((ChartPreStyleServerManager)object).setGoogleKey(this.googleKey);
    }

    public boolean equals(Object object) {
        return object instanceof GisMapPlot && super.equals(object) && this.gisType == ((GisMapPlot)object).isGisType() && this.baiduKey == ((GisMapPlot)object).getBaiduKey() && this.googleKey == ((GisMapPlot)object).getGoogleKey();
    }

    static {
        GIS_MAP_DATA.addGisMapData(new HashMap(), new HashMap(), true, true);
    }
}

