/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.chart.ChartRegisterForBI;
import com.fr.base.chart.ChartWebSource;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartattr.ChartPainter;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.core.UUID;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionIDInfor;
import java.awt.Image;

public class EChartPaintUtils {
    static JSONObject createJSon4ChartPainter(ChartPainter chartPainter, Repository repository, int n2, int n3) {
        return EChartPaintUtils.paintTag(chartPainter, repository, n2, n3, new JSONObject());
    }

    private static JSONObject paintTag(ChartPainter chartPainter, Repository repository, int n2, int n3, JSONObject jSONObject) {
        String string = UUID.randomUUID().toString();
        chartPainter.setID(chartPainter.getID() + "__" + string);
        try {
            JSONArray jSONArray = EChartPaintUtils.chartPainter2JSArray(chartPainter, repository, n2, n3);
            jSONObject.put("items", jSONArray);
            jSONObject.put("type", "simplechart");
            jSONObject.put("isNeedRefreshButton", EChartPaintUtils.isNeedRefreshButton(chartPainter));
            jSONObject.put("chartWidth", n2);
            jSONObject.put("chartHeight", n3);
            int n4 = chartPainter.getSelectedIndex();
            if (n4 < 0 || n4 >= chartPainter.getGlyphCount()) {
                n4 = 0;
            }
            jSONObject.put("selectedIndex", n4);
            String string2 = "ChartPainter__" + chartPainter.getID();
            jSONObject.put("chartpainter_id_web_change_selected", string2);
            ChartWebSource.putChartSource(repository.getSessionID(), string2, chartPainter);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    private static boolean isNeedRefreshButton(ChartPainter chartPainter) {
        boolean bl = false;
        int n2 = chartPainter.getGlyphCount();
        for (int i2 = 0; i2 < n2 && !bl; ++i2) {
            ChartGlyph chartGlyph;
            PlotGlyph plotGlyph;
            Object object = chartPainter.getGlyph(i2);
            if (!(object instanceof ChartGlyph) || (plotGlyph = (chartGlyph = (ChartGlyph)object).getPlotGlyph()) == null) continue;
            bl = bl || plotGlyph.isSeriesDragEnable();
        }
        return bl;
    }

    private static void putChartType(JSONObject jSONObject, ChartGlyph chartGlyph) throws JSONException {
        if (chartGlyph != null && chartGlyph.getPlotGlyph() != null) {
            if (chartGlyph.getPlotGlyph() instanceof BarPlotGlyph) {
                BarPlotGlyph barPlotGlyph = (BarPlotGlyph)chartGlyph.getPlotGlyph();
                if (barPlotGlyph.isHorizontal()) {
                    jSONObject.put("chartImageType", "Bar");
                } else {
                    jSONObject.put("chartImageType", chartGlyph.getPlotGlyph().getPlotGlyphType());
                }
            } else {
                jSONObject.put("chartImageType", chartGlyph.getPlotGlyph().getPlotGlyphType());
            }
        }
    }

    private static JSONArray chartPainter2JSArray(ChartPainter chartPainter, Repository repository, int n2, int n3) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n4 = chartPainter.getGlyphCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", chartPainter.getGlyphName(i2));
            if (chartPainter.getGlyph(i2) instanceof ChartGlyph) {
                Object object;
                Object object2;
                ChartGlyph chartGlyph = (ChartGlyph)chartPainter.getGlyph(i2);
                EChartPaintUtils.putChartType(jSONObject, chartGlyph);
                jSONObject.put("chartJSDraw", chartGlyph.isJSDraw());
                if (EChartPaintUtils.isChartSupportCanvas(repository, chartGlyph)) {
                    object2 = chartPainter.getID() + "__index__" + i2;
                    object = chartGlyph.toJSONMap(chartPainter.getWidgetDependenced(), n2, n3, repository, chartPainter.getSheetIndex());
                    ChartWebSource.putChartSource(repository.getSessionID(), (String)object2, object);
                    jSONObject.put("url", EChartPaintUtils.getChartGlyphURL((String)object2, repository));
                    jSONObject.put("isJS", true);
                    jSONObject.put("simpleChartInShowID", object2);
                } else {
                    if (chartGlyph.getPlotGlyph() != null && chartGlyph.getPlotGlyph().getClass().getName().indexOf("3D") != -1 && repository.getBrowser().shouldConsiderVML()) {
                        chartGlyph.is3DIE6(true);
                    }
                    object2 = chartGlyph.toImageWithoutDefaultTitle(n2, n3, repository.getResolution());
                    jSONObject.put("url", repository.checkoutObject(object2, "image"));
                    object2 = null;
                    object = chartGlyph.getPlotGlyph();
                    if (object != null && ((PlotGlyph)object).isNeedDealHotHyperlink()) {
                        String string = "chart_hotmap_" + chartGlyph.getPlotGlyph().hashCode();
                        jSONObject.put("usemap", "#" + string);
                        jSONObject.put("mapHtml", EChartPaintUtils.dealChartHot(chartGlyph, string, repository).toHtml());
                    }
                }
                jSONArray.put(jSONObject);
                continue;
            }
            if (!(chartPainter.getGlyph(i2) instanceof Image)) continue;
            jSONObject.put("url", repository.checkoutObject(chartPainter.getGlyph(i2), "image"));
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private static boolean isChartSupportCanvas(Repository repository, ChartGlyph chartGlyph) {
        return repository.getBrowser().supportCanvas() && chartGlyph.getPlotGlyph() != null && ChartRegisterForBI.isSupportDynamicChart();
    }

    private static String getChartGlyphURL(String string, Repository repository) {
        String string2 = CodeUtils.cjkEncode(string);
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(repository);
        return "?op=chart&cmd=writer_out_html&sessionID=" + sessionIDInfor.getSessionID() + "&chartID=" + string2;
    }

    private static Tag dealChartHot(ChartGlyph chartGlyph, String string, Repository repository) {
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        Tag tag = new Tag("map");
        tag.attr("name", string);
        tag.attr("id", string);
        int n2 = 0;
        int n3 = plotGlyph.getCategoryCount();
        int n4 = plotGlyph.getSeriesSize();
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n5;
            DataPoint[] dataPointArray = new DataPoint[n4];
            for (n5 = 0; n5 < n4; ++n5) {
                if (plotGlyph.getSeries(n5) == null) continue;
                dataPointArray[n5] = plotGlyph.getSeries(n5).getDataPoint(i2);
            }
            for (n5 = 0; n5 < n4; ++n5) {
                for (int i3 = n4 - 1; i3 > n5; --i3) {
                    if (dataPointArray[i3] == null || dataPointArray[i3].isValueIsNull() || !(dataPointArray[i3].getValue() < 0.0)) continue;
                    DataPoint dataPoint = dataPointArray[i3];
                    dataPointArray[i3] = dataPointArray[i3 - 1];
                    dataPointArray[i3 - 1] = dataPoint;
                }
            }
            for (n5 = 0; n5 < n4; ++n5) {
                if (dataPointArray[n5] == null) continue;
                EChartPaintUtils.dealDataPointHot(dataPointArray[n5], chartGlyph, n2, tag, repository);
                ++n2;
            }
        }
        return tag;
    }

    private static void dealDataPointHot(DataPoint dataPoint, ChartGlyph chartGlyph, int n2, Tag tag, Repository repository) {
        PlotGlyph plotGlyph = chartGlyph.getPlotGlyph();
        Tag tag2 = dataPoint.getImageMapAreaTag(chartGlyph);
        if (tag2 != null) {
            tag.sub(tag2);
            tag2.attr("id", n2 + "");
            if (plotGlyph.getHotHyperLink() != null) {
                EChartPaintUtils.dealChartHotHyperLink(plotGlyph.getHotHyperLink(), dataPoint, tag2, repository);
            }
            if (plotGlyph.getHotTooltipStyle() != null) {
                EChartPaintUtils.dealChartHotTooltip(plotGlyph.getHotTooltipStyle(), dataPoint, tag2);
            }
        }
    }

    private static void dealChartHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup, DataPoint dataPoint, Tag tag, Repository repository) {
        String string = dataPoint.createDataPointHotHyperLink(nameJavaScriptGroup, repository);
        if (string != null) {
            tag.attr("cursor", "pointer");
            tag.attr("onclick", "FR.doHyperlink(event||window.event, " + string + ", true)");
            if (repository.getBrowser().isNoBlurInImage()) {
                tag.attr("onfocus", "this.blur()");
            }
            tag.attr("href", "javascript:void(0)");
        }
    }

    private static void dealChartHotTooltip(AttrContents attrContents, DataPoint dataPoint, Tag tag) {
        tag.attr("title", dataPoint.createHotTooltip(attrContents));
    }
}

