/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.chartattr.BarPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.Bar3DPlotGlyph;
import com.fr.chart.chartglyph.Plot3D;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class Bar3DPlot
extends BarPlot
implements Plot3D {
    private static final long serialVersionUID = 3019714978415207642L;
    private double seriesIntervalPercent = 0.0;
    private int deep = -1;
    private Projection projection = new Projection();
    private boolean horizontalDrawBar = false;
    private static final String[] BAR_3D = new String[]{"Cat", "Dog"};
    private static final String[] BAR_SERIES = new String[]{"Food", "Apple"};
    private static final String[][] BAR_VALUE = new String[][]{{"10", "10"}, {"20", "20"}};
    private static final NormalChartData BAR_DATA = new NormalChartData(BAR_3D, BAR_SERIES, BAR_VALUE);

    public void setSeriesIntervalPercent(double d2) {
        this.seriesIntervalPercent = d2;
    }

    public double getSeriesIntervalPercent() {
        return this.seriesIntervalPercent;
    }

    public String getPlotName() {
        String string = super.getPlotName();
        if (this.isHorizontalDrawBar()) {
            string = string + "(" + Inter.getLocText("PageSetup-Landscape") + ")";
        }
        return Inter.getLocText("Chart_3D") + string;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public void setDeep(int n2) {
        this.deep = n2;
    }

    public int getDeep() {
        return this.deep;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Bar3DPlotGlyph bar3DPlotGlyph = new Bar3DPlotGlyph();
        this.install4PlotGlyph(bar3DPlotGlyph, chartData);
        this.installAxisGlyph(bar3DPlotGlyph, chartData);
        bar3DPlotGlyph.getxAxisGlyph().setDrawBetweenTick(true);
        return bar3DPlotGlyph;
    }

    public void install4PlotGlyph(Bar3DPlotGlyph bar3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(bar3DPlotGlyph, chartData);
        bar3DPlotGlyph.setDeep(this.deep);
        bar3DPlotGlyph.setProjection(this.projection);
        bar3DPlotGlyph.setHorizontalDrawBar(this.horizontalDrawBar);
        bar3DPlotGlyph.setSeriesIntervalPercent(this.seriesIntervalPercent);
    }

    public boolean isSupport3D() {
        return true;
    }

    public boolean isSupportBorder() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    public boolean match4GUI(Plot plot) {
        return plot instanceof Bar3DPlot && super.match4GUI(plot) && this.horizontalDrawBar == ((Bar3DPlot)plot).horizontalDrawBar;
    }

    public ChartData defaultChartData() {
        return BAR_DATA;
    }

    public boolean isSupportSeriesDrag() {
        return false;
    }

    public boolean isSupportAxisReverse() {
        return false;
    }

    public boolean needAnalysisLinePane() {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr3D".equals(string)) {
                this.horizontalDrawBar = xMLableReader.getAttrAsBoolean("horizontalDrawBar", false);
                this.setSeriesIntervalPercent(xMLableReader.getAttrAsDouble("seriesIntervalPercent", 0.0));
                this.setDeep(xMLableReader.getAttrAsInt("deep", -1));
            } else if ("Projection".equals(string)) {
                this.setProjection((Projection)xMLableReader.readXMLObject(new Projection()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr3D").attr("horizontalDrawBar", this.horizontalDrawBar).attr("seriesIntervalPercent", this.seriesIntervalPercent);
        if (this.deep != -1) {
            xMLPrintWriter.attr("deep", this.deep);
        }
        xMLPrintWriter.end();
        if (this.getProjection() != null) {
            this.getProjection().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlot bar3DPlot = (Bar3DPlot)super.clone();
        if (this.projection != null) {
            bar3DPlot.projection = (Projection)this.projection.clone();
        }
        return bar3DPlot;
    }

    public boolean equals(Object object) {
        return object instanceof Bar3DPlot && super.equals(object) && ((Bar3DPlot)object).isHorizontalDrawBar() == this.horizontalDrawBar && ((Bar3DPlot)object).getDeep() == this.deep && ((Bar3DPlot)object).getSeriesIntervalPercent() == this.seriesIntervalPercent && ComparatorUtils.equals(((Bar3DPlot)object).getProjection(), this.projection);
    }
}

