/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chartdata.ChartData;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.BarPlot;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class Bar2DPlot
extends BarPlot {
    private static final long serialVersionUID = 7944953095383884004L;
    private static final Object[] BAR_SERIES_NAME = new Object[]{Inter.getLocText("ChartF-Series") + "1", Inter.getLocText("ChartF-Series") + "2", Inter.getLocText("ChartF-Series") + "3"};
    public static final Object[][] BAR_2D_VALUES = new Object[][]{{"40", "50", "30"}, {"35", "25", "15"}, {"25", "45", "55"}};
    private boolean isSimulation3D = false;

    public Bar2DPlot() {
        this.setxAxis(new CategoryAxis());
        this.setyAxis(new ValueAxis());
    }

    public Bar2DPlot(boolean bl) {
        this.isStacked = bl;
        this.setSeriesOverlapPercent(1.0);
    }

    public boolean isSupportTrendLine() {
        return !this.isStacked() && !this.isHorizontal();
    }

    public boolean isSupportZoomCategoryAxis() {
        return !this.isHorizontal();
    }

    public boolean isSupportAxisReverse() {
        return true;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
        this.install4PlotGlyph(bar2DPlotGlyph, chartData);
        this.installAxisGlyph(bar2DPlotGlyph, chartData);
        bar2DPlotGlyph.getxAxisGlyph().setDrawBetweenTick(true);
        return bar2DPlotGlyph;
    }

    public LegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        if (plotGlyph == null) {
            return null;
        }
        return super.createLegendGlyph(plotGlyph);
    }

    public void setSimulation3D(boolean bl) {
        this.isSimulation3D = bl;
    }

    public boolean isSimulation3D() {
        return this.isSimulation3D;
    }

    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new NormalChartData(ChartUtils.CATEGORY_DATE, BAR_SERIES_NAME, BAR_2D_VALUES) : new NormalChartData(ChartUtils.CATEGORY_STRING, BAR_SERIES_NAME, BAR_2D_VALUES);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            this.setSimulation3D(xMLableReader.getAttrAsBoolean("isSimulation3D", true));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Bar2DAttr").attr("isSimulation3D", this.isSimulation3D).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof Bar2DPlot && super.equals(object) && ((Bar2DPlot)object).isSimulation3D() == this.isSimulation3D && ((Bar2DPlot)object).getPlotStyle() == this.getPlotStyle();
    }
}

