/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class AttrColor
extends DataSeriesCondition {
    private static final long serialVersionUID = 4943492805520879958L;
    public static final String XML_TAG = "AttrColor";
    private Color seriesColor = null;

    public AttrColor() {
    }

    public AttrColor(Color color) {
        this.seriesColor = color;
    }

    public void setSeriesColor(Color color) {
        this.seriesColor = color;
    }

    public Color getSeriesColor() {
        return this.seriesColor;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.setSeriesColor(xMLableReader.getAttrAsColor("color", null));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr");
        if (this.seriesColor != null) {
            xMLPrintWriter.attr("color", this.seriesColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrColor && ComparatorUtils.equals(this.seriesColor, ((AttrColor)object).seriesColor);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesColor != null) {
            jSONObject.put("seriesColor", StableUtils.javaColorToCSSColor(this.seriesColor));
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

