/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.concurrentlinkedhashmap;

import com.fr.cache.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.fr.cache.concurrentlinkedhashmap.EvictionListener;
import com.fr.cache.concurrentlinkedhashmap.GuardedBy;
import com.fr.cache.concurrentlinkedhashmap.Immutable;
import com.fr.cache.concurrentlinkedhashmap.Linked;
import com.fr.cache.concurrentlinkedhashmap.LinkedDeque;
import com.fr.cache.concurrentlinkedhashmap.ThreadSafe;
import com.fr.cache.concurrentlinkedhashmap.Weigher;
import com.fr.cache.concurrentlinkedhashmap.Weighers;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAXIMUM_WEIGHT = 0x20000000;
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    static final int BUFFER_THRESHOLD = 16;
    static final int NUMBER_OF_BUFFERS;
    static final int BUFFER_MASK;
    static final int AMORTIZED_DRAIN_THRESHOLD;
    static final Queue<?> DISCARDING_QUEUE;
    final ConcurrentMap<K, ConcurrentLinkedHashMap.Node> data;
    final int concurrencyLevel;
    @GuardedBy(value="evictionLock")
    final LinkedDeque<ConcurrentLinkedHashMap.Node> evictionDeque;
    volatile int capacity;
    @GuardedBy(value="evictionLock")
    volatile int weightedSize;
    volatile int nextOrder;
    @GuardedBy(value="evictionLock")
    int drainedOrder;
    final Lock evictionLock;
    final Queue<Task>[] buffers;
    final ExecutorService executor;
    final BoundedWeigher<V> weigher;
    final AtomicIntegerArray bufferLengths;
    final AtomicReference<DrainStatus> drainStatus;
    final Queue<ConcurrentLinkedHashMap.Node> pendingNotifications;
    final EvictionListener<K, V> listener;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        this.concurrencyLevel = builder.concurrencyLevel;
        this.capacity = Math.min(builder.capacity, 0x40000000);
        this.data = new ConcurrentHashMap<K, ConcurrentLinkedHashMap.Node>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.executor = builder.executor;
        this.nextOrder = Integer.MIN_VALUE;
        this.drainedOrder = Integer.MIN_VALUE;
        this.evictionLock = new ReentrantLock();
        this.evictionDeque = new LinkedDeque();
        this.weigher = new BoundedWeigher(builder.weigher);
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.buffers = new Queue[NUMBER_OF_BUFFERS];
        this.bufferLengths = new AtomicIntegerArray(NUMBER_OF_BUFFERS);
        for (int i2 = 0; i2 < NUMBER_OF_BUFFERS; ++i2) {
            this.buffers[i2] = new ConcurrentLinkedQueue<Task>();
        }
        this.listener = builder.listener;
        this.pendingNotifications = this.listener == DiscardingListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = Math.min(n2, 0x40000000);
        this.evictionLock.lock();
        try {
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    boolean hasOverflowed() {
        return this.weightedSize > this.capacity;
    }

    @GuardedBy(value="evictionLock")
    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.pendingNotifications.add((ConcurrentLinkedHashMap.Node)node);
            }
            node.makeDead();
        }
    }

    void afterCompletion(Task task) {
        boolean bl = this.schedule(task);
        if (this.shouldDrainBuffers(bl)) {
            this.tryToDrainBuffers(AMORTIZED_DRAIN_THRESHOLD);
        }
        this.notifyListener();
    }

    private boolean schedule(Task task) {
        int n2 = ConcurrentLinkedHashMap.bufferIndex();
        int n3 = this.bufferLengths.incrementAndGet(n2);
        if (task.isWrite()) {
            this.buffers[n2].add(task);
            this.drainStatus.set(DrainStatus.REQUIRED);
            return false;
        }
        if (n3 <= 0x100000) {
            this.buffers[n2].add(task);
            return n3 <= 16;
        }
        this.bufferLengths.decrementAndGet(n2);
        return false;
    }

    static int bufferIndex() {
        return (int)Thread.currentThread().getId() & BUFFER_MASK;
    }

    int nextOrdering() {
        return this.nextOrder++;
    }

    boolean shouldDrainBuffers(boolean bl) {
        if (this.executor.isShutdown()) {
            DrainStatus drainStatus = this.drainStatus.get();
            return drainStatus != DrainStatus.PROCESSING && (!bl || drainStatus == DrainStatus.REQUIRED);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToDrainBuffers(int n2) {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.set(DrainStatus.PROCESSING);
                this.drainBuffers(n2);
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainBuffers(int n2) {
        Task[] taskArray = new Task[n2];
        int n3 = this.moveTasksFromBuffers(taskArray);
        this.runTasks(taskArray, n3);
        this.updateDrainedOrder(taskArray, n3);
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffers(Task[] taskArray) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.buffers.length; ++i2) {
            int n3 = this.moveTasksFromBuffer(i2, taskArray);
            n2 = Math.max(n3, n2);
        }
        return n2;
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffer(int n2, Task[] taskArray) {
        Task task;
        Queue<Task> queue = this.buffers[n2];
        int n3 = 0;
        int n4 = -1;
        while ((task = queue.poll()) != null) {
            ++n3;
            int n5 = task.getOrder() - this.drainedOrder;
            if (n5 < 0) {
                task.run();
                continue;
            }
            if (n5 >= taskArray.length) {
                n4 = taskArray.length - 1;
                this.addTaskToChain(taskArray, task, n4);
                break;
            }
            n4 = Math.max(n5, n4);
            this.addTaskToChain(taskArray, task, n5);
        }
        this.bufferLengths.addAndGet(n2, -n3);
        return n4;
    }

    @GuardedBy(value="evictionLock")
    void addTaskToChain(Task[] taskArray, Task task, int n2) {
        task.setNext(taskArray[n2]);
        taskArray[n2] = task;
    }

    @GuardedBy(value="evictionLock")
    void runTasks(Task[] taskArray, int n2) {
        for (int i2 = 0; i2 <= n2; ++i2) {
            this.runTasksInChain(taskArray[i2]);
        }
    }

    @GuardedBy(value="evictionLock")
    void runTasksInChain(Task task) {
        while (task != null) {
            Task task2 = task;
            task = task.getNext();
            task2.setNext(null);
            task2.run();
        }
    }

    @GuardedBy(value="evictionLock")
    void updateDrainedOrder(Task[] taskArray, int n2) {
        if (n2 >= 0) {
            Task task = taskArray[n2];
            this.drainedOrder = task.getOrder() + 1;
        }
    }

    void notifyListener() {
        Node node;
        while ((node = (Node)this.pendingNotifications.poll()) != null) {
            this.listener.onEviction(node.key, node.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public int weightedSize() {
        return Math.max(0, this.weightedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                node.makeDead();
            }
            for (int i2 = 0; i2 < this.buffers.length; ++i2) {
                Task task;
                Queue<Task> queue = this.buffers[i2];
                int n2 = 0;
                while ((task = queue.poll()) != null) {
                    if (task.isWrite()) {
                        task.run();
                    }
                    ++n2;
                }
                this.bufferLengths.addAndGet(i2, -n2);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        ConcurrentLinkedHashMap.checkNotNull(object);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Node node = (Node)this.data.get(object);
        if (node == null) {
            return null;
        }
        this.afterCompletion(new ReadTask(this, node));
        return node.getValue();
    }

    @Override
    public V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    V put(K k2, V v2, boolean bl) {
        WeightedValue weightedValue;
        Node node;
        ConcurrentLinkedHashMap.checkNotNull(v2);
        int n2 = this.weigher.weightOf(v2);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, n2);
        Node node2 = new Node(k2, weightedValue2);
        block0: while (true) {
            if ((node = (Node)this.data.putIfAbsent(node2.key, (ConcurrentLinkedHashMap.Node)node2)) == null) {
                this.afterCompletion(new AddTask(this, node2, n2));
                return null;
            }
            if (bl) {
                this.afterCompletion(new ReadTask(this, node));
                return node.getValue();
            }
            do {
                if (!(weightedValue = (WeightedValue)node.get()).isAlive()) continue block0;
            } while (!node.compareAndSet(weightedValue, weightedValue2));
            break;
        }
        int n3 = n2 - weightedValue.weight;
        ReadTask readTask = n3 == 0 ? new ReadTask(this, node) : new UpdateTask(this, node, n3);
        this.afterCompletion(readTask);
        return weightedValue.value;
    }

    @Override
    public V remove(Object object) {
        Node node = (Node)this.data.remove(object);
        if (node == null) {
            return null;
        }
        node.makeRetired();
        this.afterCompletion(new RemovalTask(this, node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Node node = (Node)this.data.get(object);
        if (node == null || object2 == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        if (weightedValue.hasValue(object2) && node.tryToRetire(weightedValue) && this.data.remove(object, node)) {
            this.afterCompletion(new RemovalTask(this, node));
            return true;
        }
        return false;
    }

    @Override
    public V replace(K k2, V v2) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(v2);
        int n2 = this.weigher.weightOf(v2);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, n2);
        Node node = (Node)this.data.get(k2);
        if (node == null) {
            return null;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n3 = n2 - weightedValue.weight;
        ReadTask readTask = n3 == 0 ? new ReadTask(this, node) : new UpdateTask(this, node, n3);
        this.afterCompletion(readTask);
        return weightedValue.value;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(v2);
        ConcurrentLinkedHashMap.checkNotNull(v3);
        int n2 = this.weigher.weightOf(v3);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v3, n2);
        Node node = (Node)this.data.get(k2);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.hasValue(v2)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n3 = n2 - weightedValue.weight;
        ReadTask readTask = n3 == 0 ? new ReadTask(this, node) : new UpdateTask(this, node, n3);
        this.afterCompletion(readTask);
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet == null ? (this.keySet = new KeySet()) : keySet;
    }

    public Set<K> ascendingKeySet() {
        return this.orderedKeySet(true, Integer.MAX_VALUE);
    }

    public Set<K> ascendingKeySetWithLimit(int n2) {
        return this.orderedKeySet(true, n2);
    }

    public Set<K> descendingKeySet() {
        return this.orderedKeySet(false, Integer.MAX_VALUE);
    }

    public Set<K> descendingKeySetWithLimit(int n2) {
        return this.orderedKeySet(false, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<K> orderedKeySet(boolean bl, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.evictionLock.lock();
        try {
            Iterator<ConcurrentLinkedHashMap.Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int n3 = Math.min(n2, this.evictionDeque.size());
            LinkedHashSet linkedHashSet = new LinkedHashSet(n3);
            Iterator<ConcurrentLinkedHashMap.Node> iterator2 = iterator = bl ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (n3 > linkedHashSet.size()) {
                linkedHashSet.add(((Node)iterator.next()).key);
            }
            Set set = Collections.unmodifiableSet(linkedHashSet);
            return set;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    public Map<K, V> ascendingMap() {
        return this.orderedMap(true, Integer.MAX_VALUE);
    }

    public Map<K, V> ascendingMapWithLimit(int n2) {
        return this.orderedMap(true, n2);
    }

    public Map<K, V> descendingMap() {
        return this.orderedMap(false, Integer.MAX_VALUE);
    }

    public Map<K, V> descendingMapWithLimit(int n2) {
        return this.orderedMap(false, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(boolean bl, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.evictionLock.lock();
        try {
            Object object;
            Iterator<ConcurrentLinkedHashMap.Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int n3 = Math.min(n2, this.evictionDeque.size());
            LinkedHashMap linkedHashMap = new LinkedHashMap(n3);
            Iterator<ConcurrentLinkedHashMap.Node> iterator2 = iterator = bl ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (n3 > linkedHashMap.size()) {
                object = (Node)iterator.next();
                linkedHashMap.put(((Node)object).key, ((Node)object).getValue());
            }
            object = Collections.unmodifiableMap(linkedHashMap);
            return object;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static {
        int n2;
        DISCARDING_QUEUE = new DiscardingQueue();
        int n3 = Runtime.getRuntime().availableProcessors();
        for (n2 = 1; n2 < n3; n2 <<= 1) {
        }
        AMORTIZED_DRAIN_THRESHOLD = (1 + n2) * 16;
        NUMBER_OF_BUFFERS = n2;
        BUFFER_MASK = n2 - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<K, V> {
        static final ExecutorService DEFAULT_EXECUTOR = new DisabledExecutorService();
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        EvictionListener<K, V> listener;
        Weigher<? super V> weigher;
        ExecutorService executor = DEFAULT_EXECUTOR;
        TimeUnit unit;
        long delay;
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        int capacity = -1;

        public Builder() {
            this.weigher = Weighers.singleton();
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            this.initialCapacity = n2;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            this.capacity = n2;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException();
            }
            this.concurrencyLevel = n2;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> evictionListener) {
            ConcurrentLinkedHashMap.checkNotNull(evictionListener);
            this.listener = evictionListener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            ConcurrentLinkedHashMap.checkNotNull(weigher);
            this.weigher = weigher;
            return this;
        }

        public Builder<K, V> catchup(ScheduledExecutorService scheduledExecutorService, long l2, TimeUnit timeUnit) {
            if (l2 <= 0L) {
                throw new IllegalArgumentException();
            }
            ConcurrentLinkedHashMap.checkNotNull(scheduledExecutorService);
            ConcurrentLinkedHashMap.checkNotNull((Object)timeUnit);
            this.executor = scheduledExecutorService;
            this.delay = l2;
            this.unit = timeUnit;
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            if (this.capacity < 0) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap concurrentLinkedHashMap = new ConcurrentLinkedHashMap(this);
            if (this.executor != DEFAULT_EXECUTOR) {
                ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)this.executor;
                scheduledExecutorService.scheduleWithFixedDelay(new CatchUpTask(concurrentLinkedHashMap), this.delay, this.delay, this.unit);
            }
            return concurrentLinkedHashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SerializationProxy<K, V>
    implements Serializable {
        final EvictionListener<K, V> listener;
        final Weigher<? super V> weigher;
        final int concurrencyLevel;
        final Map<K, V> data;
        final int capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap) {
            this.concurrencyLevel = concurrentLinkedHashMap.concurrencyLevel;
            this.weigher = concurrentLinkedHashMap.weigher.delegate;
            this.data = new HashMap<K, V>(concurrentLinkedHashMap);
            this.capacity = concurrentLinkedHashMap.capacity;
            this.listener = concurrentLinkedHashMap.listener;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            concurrentLinkedHashMap.putAll(this.data);
            return concurrentLinkedHashMap;
        }
    }

    abstract class AbstractTask
    implements Task {
        final int order;
        Task task;

        AbstractTask() {
            this.order = ConcurrentLinkedHashMap.this.nextOrdering();
        }

        public int getOrder() {
            return this.order;
        }

        public Task getNext() {
            return this.task;
        }

        public void setNext(Task task) {
            this.task = task;
        }
    }

    static interface Task
    extends Runnable {
        public int getOrder();

        public boolean isWrite();

        public Task getNext();

        public void setNext(Task var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object object, Object object2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DiscardingQueue
    extends AbstractQueue<Object> {
        DiscardingQueue() {
        }

        @Override
        public boolean add(Object object) {
            return true;
        }

        @Override
        public boolean offer(Object object) {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DisabledExecutorService
    extends AbstractExecutorService {
        DisabledExecutorService() {
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean awaitTermination(long l2, TimeUnit timeUnit) {
            return true;
        }

        @Override
        public void execute(Runnable runnable) {
            throw new RejectedExecutionException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CatchUpTask
    implements Runnable {
        final WeakReference<ConcurrentLinkedHashMap<?, ?>> mapRef;

        CatchUpTask(ConcurrentLinkedHashMap<?, ?> concurrentLinkedHashMap) {
            this.mapRef = new WeakReference(concurrentLinkedHashMap);
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap concurrentLinkedHashMap = (ConcurrentLinkedHashMap)this.mapRef.get();
            if (concurrentLinkedHashMap == null) {
                throw new CancellationException();
            }
            int n2 = 0;
            for (int i2 = 0; i2 < concurrentLinkedHashMap.buffers.length; ++i2) {
                n2 += concurrentLinkedHashMap.bufferLengths.get(i2);
            }
            if (n2 != 0) {
                concurrentLinkedHashMap.tryToDrainBuffers(n2 + 16);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BoundedWeigher<V>
    implements Weigher<V> {
        final Weigher<? super V> delegate;

        BoundedWeigher(Weigher<? super V> weigher) {
            this.delegate = weigher;
        }

        @Override
        public int weightOf(V v2) {
            int n2 = this.delegate.weightOf(v2);
            if (n2 < 1 || n2 > 0x20000000) {
                throw new IllegalArgumentException("invalid weight");
            }
            return n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        private final K key;
        private V value;

        public SimpleEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        public SimpleEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;
        final /* synthetic */ ConcurrentLinkedHashMap this$0;

        WriteThroughEntry(ConcurrentLinkedHashMap.Node node) {
            this.this$0 = var1_1;
            super(node.key, node.getValue());
        }

        @Override
        public V setValue(V v2) {
            this.this$0.put(this.getKey(), v2);
            return super.setValue(v2);
        }

        Object writeReplace() {
            return new SimpleEntry(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<ConcurrentLinkedHashMap.Node> iterator;
        ConcurrentLinkedHashMap.Node current;

        EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = (Node)this.iterator.next();
            return new WriteThroughEntry(ConcurrentLinkedHashMap.this, (Node)this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final ConcurrentLinkedHashMap<K, V> map;

        EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.map.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new SimpleEntry(entry));
            }
            return arrayList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new SimpleEntry(entry));
            }
            return arrayList.toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    implements Iterator<V> {
        final Iterator<ConcurrentLinkedHashMap.Node> iterator;
        ConcurrentLinkedHashMap.Node current;
        V value;

        ValueIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = (Node)this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLinkedHashMap.this.containsValue(object);
        }

        @Override
        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Object v2 : this) {
                arrayList.add(v2);
            }
            return arrayList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList(this.size());
            for (Object v2 : this) {
                arrayList.add(v2);
            }
            return arrayList.toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    implements Iterator<K> {
        final Iterator<K> iterator;
        K current;

        KeyIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLinkedHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.map.data.keySet().toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Node
    extends AtomicReference<WeightedValue<V>>
    implements Linked<ConcurrentLinkedHashMap.Node> {
        final K key;
        @GuardedBy(value="evictionLock")
        ConcurrentLinkedHashMap.Node prev;
        @GuardedBy(value="evictionLock")
        ConcurrentLinkedHashMap.Node next;

        Node(K k2, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = k2;
            this.prev = null;
            this.next = null;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public ConcurrentLinkedHashMap.Node getPrevious() {
            return this.prev;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        @Override
        @GuardedBy(value="evictionLock")
        public void setPrevious(Node node) {
            this.prev = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public ConcurrentLinkedHashMap.Node getNext() {
            return this.next;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        @Override
        @GuardedBy(value="evictionLock")
        public void setNext(Node node) {
            this.next = node;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }

        void makeRetired() {
            WeightedValue weightedValue;
            WeightedValue weightedValue2;
            do {
                if ((weightedValue2 = (WeightedValue)this.get()).isAlive()) continue;
                return;
            } while (!this.compareAndSet(weightedValue2, weightedValue = new WeightedValue(weightedValue2.value, -weightedValue2.weight)));
        }

        boolean tryToRetire(WeightedValue<V> weightedValue) {
            if (weightedValue.isAlive()) {
                WeightedValue weightedValue2 = new WeightedValue(weightedValue.value, -weightedValue.weight);
                return this.compareAndSet(weightedValue, weightedValue2);
            }
            return false;
        }

        @GuardedBy(value="evictionLock")
        void makeDead() {
            WeightedValue weightedValue;
            WeightedValue weightedValue2;
            while (!this.compareAndSet(weightedValue2 = (WeightedValue)this.get(), weightedValue = new WeightedValue(weightedValue2.value, 0))) {
            }
            ConcurrentLinkedHashMap.this.weightedSize -= Math.abs(weightedValue2.weight);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static final class WeightedValue<V> {
        final int weight;
        final V value;

        WeightedValue(V v2, int n2) {
            this.weight = n2;
            this.value = v2;
        }

        boolean hasValue(Object object) {
            return object == this.value || this.value.equals(object);
        }

        boolean isAlive() {
            return this.weight > 0;
        }

        boolean isRetired() {
            return this.weight < 0;
        }

        boolean isDead() {
            return this.weight == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class UpdateTask
    extends ReadTask {
        final int weightDifference;
        final /* synthetic */ ConcurrentLinkedHashMap this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public UpdateTask(ConcurrentLinkedHashMap.Node node, int n3) {
            this.this$0 = (ConcurrentLinkedHashMap)n2;
            super((ConcurrentLinkedHashMap)n2, (Node)node);
            this.weightDifference = n3;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            super.run();
            this.this$0.weightedSize += this.weightDifference;
            this.this$0.evict();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RemovalTask
    extends AbstractTask {
        final ConcurrentLinkedHashMap.Node node;
        final /* synthetic */ ConcurrentLinkedHashMap this$0;

        RemovalTask(ConcurrentLinkedHashMap.Node node) {
            this.this$0 = var1_1;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            this.this$0.evictionDeque.remove(this.node);
            this.node.makeDead();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AddTask
    extends AbstractTask {
        final ConcurrentLinkedHashMap.Node node;
        final int weight;
        final /* synthetic */ ConcurrentLinkedHashMap this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        AddTask(ConcurrentLinkedHashMap.Node node, int n3) {
            this.this$0 = (ConcurrentLinkedHashMap)n2;
            this.weight = n3;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            this.this$0.weightedSize += this.weight;
            if (((WeightedValue)this.node.get()).isAlive()) {
                this.this$0.evictionDeque.add(this.node);
                this.this$0.evict();
            }
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReadTask
    extends AbstractTask {
        final ConcurrentLinkedHashMap.Node node;
        final /* synthetic */ ConcurrentLinkedHashMap this$0;

        ReadTask(ConcurrentLinkedHashMap.Node node) {
            this.this$0 = var1_1;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (this.this$0.evictionDeque.contains(this.node)) {
                this.this$0.evictionDeque.moveToBack(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DrainStatus {
        IDLE,
        REQUIRED,
        PROCESSING;

    }
}

