/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.CacheException;
import com.fr.cache.FRCache;
import com.fr.cache.FifoMemoryStore;
import com.fr.cache.LfuMemoryStore;
import com.fr.cache.LruMemoryStore;
import com.fr.cache.MemoryStoreEvictionPolicy;
import com.fr.cache.Status;
import com.fr.cache.Store;
import com.fr.cache.Unity;
import java.util.Map;

public abstract class MemoryStore
implements Store {
    protected FRCache cache;
    protected Map map;
    protected Status status = Status.STATUS_UNINITIALISED;

    protected MemoryStore(FRCache fRCache) {
        this.cache = fRCache;
        this.status = Status.STATUS_ALIVE;
    }

    public static MemoryStore create(FRCache fRCache) {
        MemoryStore memoryStore = null;
        MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = fRCache.getMemoryStoreEvictionPolicy();
        if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.LRU)) {
            memoryStore = new LruMemoryStore(fRCache);
        } else if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.FIFO)) {
            memoryStore = new FifoMemoryStore(fRCache);
        } else if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.LFU)) {
            memoryStore = new LfuMemoryStore(fRCache);
        }
        return memoryStore;
    }

    public final boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.cache = null;
    }

    public final synchronized void flush() {
        this.clear();
    }

    public final synchronized Unity get(Object object) {
        Unity unity = (Unity)this.map.get(object);
        if (unity != null) {
            unity.updateAccessStatistics();
        }
        return unity;
    }

    public final Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public final synchronized Unity getQuiet(Object object) {
        return (Unity)this.map.get(object);
    }

    public final int getSize() {
        return this.map.size();
    }

    public final synchronized void put(Unity unity) throws CacheException {
        if (unity != null) {
            this.map.put(unity.getObjectKey(), unity);
            this.doPut(unity);
        }
    }

    protected void doPut(Unity unity) throws CacheException {
    }

    protected final void evict(Unity unity) throws CacheException {
        this.cache.getCacheEventNotificationService().notifyElementEvicted(unity);
    }

    protected final void notifyExpiry(Unity unity) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(unity);
    }

    protected final boolean isFull() {
        return this.map.size() > this.cache.getMaxElementsInMemory();
    }

    public final synchronized Unity remove(Object object) {
        return (Unity)this.map.remove(object);
    }

    public final void removeAll() throws CacheException {
        this.clear();
    }

    protected final void clear() {
        this.map.clear();
    }
}

