/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import java.util.Random;

public final class LfuPolicyHelper {
    private static final int DEFAULT_SAMPLE_SIZE = 30;
    private static final Random RANDOM = new Random();

    private LfuPolicyHelper() {
    }

    private static int calculateSampleSize(int n2) {
        if (n2 < 30) {
            return n2;
        }
        return 30;
    }

    protected static Metadata leastHit(Metadata[] metadataArray, Metadata metadata) {
        if (metadataArray.length == 1 && metadata != null) {
            return metadata;
        }
        Metadata metadata2 = null;
        for (int i2 = 0; i2 < metadataArray.length; ++i2) {
            Metadata metadata3 = metadataArray[i2];
            if (metadata2 == null) {
                if (metadata3.equals(metadata)) continue;
                metadata2 = metadata3;
                continue;
            }
            if (metadata3.getHitCount() >= metadata2.getHitCount() || metadata3.equals(metadata)) continue;
            metadata2 = metadata3;
        }
        return metadata2;
    }

    protected static int[] generateRandomSample(int n2) {
        int n3 = LfuPolicyHelper.calculateSampleSize(n2);
        int[] nArray = new int[n3];
        int n4 = n2 / n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = RANDOM.nextInt(n4);
        }
        return nArray;
    }

    public static interface Metadata {
        public Object getObjectKey();

        public long getHitCount();
    }
}

