/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.Attachment;
import com.fr.cache.DiskCacheMap;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StableUtils;
import java.util.HashMap;
import java.util.Map;

public class AttachmentSource {
    private static Map attachmentMap = new DiskCacheMap();
    private static Map delegateAttachMap = new HashMap();

    public static void putAttachment(String string, Attachment attachment) {
        attachmentMap.put(string, attachment);
    }

    public static Attachment getAttachment(String string) {
        Attachment attachment = (Attachment)attachmentMap.get(string);
        if (attachment == null) {
            attachment = (Attachment)delegateAttachMap.get(string);
            byte[] byArray = attachment.getBytes();
            String string2 = attachment.getFilename();
            if ((ComparatorUtils.equals(string2, "Download") || string2.indexOf(".") == -1) && byArray != null) {
                string2 = string2 + StableUtils.getFileTypeFromBytes(byArray);
            }
            Attachment attachment2 = new Attachment(attachment.getID(), attachment.getType(), string2, byArray, attachment.getWidth(), attachment.getHeight());
            AttachmentSource.putAttachment(attachment.getID(), attachment2);
            AttachmentSource.removeDelegateAttachment(attachment.getID());
            return attachment2;
        }
        return attachment;
    }

    public static void removeAttachment(String string) {
        attachmentMap.remove(string);
    }

    public static void putDelegateAttachment(String string, Attachment attachment) {
        delegateAttachMap.put(string, attachment);
    }

    public static Attachment getDelegateAttachment(String string) {
        return (Attachment)delegateAttachMap.get(string);
    }

    public static void removeDelegateAttachment(String string) {
        delegateAttachMap.remove(string);
    }
}

