/*
 * Decompiled with CFR 0.152.
 */
package com.fr.bi.fs.output;

import com.fr.bi.fs.BIDesignReport;
import com.fr.bi.fs.BIReportNode;
import com.fr.bi.fs.output.BIFileRepository;
import com.fr.fs.FSConfig;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.general.DateUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import java.io.File;
import java.util.Date;
import java.util.Random;

public class BIReportOutput {
    public static long saveBIReport(BIDesignReport bIDesignReport, long l2, String string, long l3, boolean bl) throws Exception {
        BIReportNode bIReportNode;
        File file;
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return -1L;
        }
        File file2 = BIFileRepository.getInstance().getBIDirFile(l2);
        int n2 = file2.getAbsolutePath().length() + 1;
        if (l3 < 0L) {
            file = BIReportOutput.generateUnExsitFile(l2, bIDesignReport.getSuffix(), string);
            bIReportNode = new BIReportNode(l2, string, file.getAbsolutePath().substring(n2));
        } else {
            bIReportNode = l2 == UserControl.getInstance().getSuperManagerID() ? SystemManagerFavoriteAndADHOC.getInstance().findSysBIReportNodeById(l3) : FSConfig.getInstance().getControl().getBIReportDAO().findByID(l3);
            if (bIReportNode != null) {
                bIReportNode.updateLastModifyTime();
                file = new File(file2, bIReportNode.getPath());
            } else {
                file = BIReportOutput.generateUnExsitFile(l2, bIDesignReport.getSuffix(), string);
                bIReportNode = new BIReportNode(l2, string, file.getAbsolutePath().substring(n2));
            }
        }
        if (bl) {
            bIReportNode.setDescription("isMining");
        }
        bIDesignReport.writeFile(file);
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            SystemManagerFavoriteAndADHOC.getInstance().saveOrUpdateBINode(bIReportNode);
        } else {
            FSConfig.getInstance().getControl().getBIReportDAO().saveOrUpdate(bIReportNode);
        }
        return bIReportNode.getId();
    }

    public static boolean deleteBIReportById(long l2, long l3) throws Exception {
        BIReportNode bIReportNode = null;
        boolean bl = false;
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            bIReportNode = SystemManagerFavoriteAndADHOC.getInstance().findSysBIReportNodeById(l3);
            bl = SystemManagerFavoriteAndADHOC.getInstance().deleteBIReportById(l3);
        } else {
            bIReportNode = FSConfig.getInstance().getControl().getBIReportDAO().findByID(l3);
            bl = FSConfig.getInstance().getControl().getBIReportDAO().deleteByID(l3);
        }
        if (bIReportNode != null && bl) {
            String string = CodeUtils.decodeText(bIReportNode.getPath());
            String string2 = BIFileRepository.getInstance().getBIDirName(l2);
            int n2 = string.lastIndexOf("\\" + string2 + "\\");
            if (n2 > -1) {
                string = string.substring(n2 + ("\\" + string2).length());
            }
            File file = BIFileRepository.getInstance().getBIDirFile(l2);
            new File(file, string).delete();
        }
        return bl;
    }

    private static File generateUnExsitFile(long l2, String string, String string2) throws Exception {
        File file = BIFileRepository.getInstance().getBIDirFile(l2);
        if (!file.exists()) {
            StableUtils.mkdirs(file);
        }
        File file2 = new File(file, DateUtils.getDate2AllIncludeSSS(new Date()) + "_" + new Random().nextInt(1000) + string);
        while (file2.exists()) {
            file2 = new File(file, DateUtils.getDate2AllIncludeSSS(new Date()) + "_" + new Random().nextInt(1000) + string);
        }
        return file2;
    }
}

