/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.chart;

import com.fr.base.BaseUtils;
import com.fr.base.chart.CannyTest;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.image4j.util.ImageUtil;
import ij.IJ;
import ij.ImagePlus;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

public class ColorSelect4Shape {
    private static final int DIR_0 = 0;
    private static final int DIR_1 = 1;
    private static final int DIR_2 = 2;
    private static final int DIR_3 = 3;
    private static final int DIR_4 = 4;
    private static final int DIR_5 = 5;
    private static final int DIR_6 = 6;
    private static final int DIR_7 = 7;
    private static final int DIR_8 = 8;
    private static final int DIR_9 = 9;
    private static final int DIR_10 = 10;
    private static final int DIR_11 = 11;
    private static final int DIR_12 = 12;
    private static final int DIR_13 = 13;
    private static final int DIR_14 = 14;
    private static final int DIR_15 = 15;
    private static final int DIR_NUM = 16;
    private static final int TWO_DIR = 2;
    private static final double OFF_DIR = 0.5;
    private static final int FIVE_MOVE = 5;
    private static final int JION_SIZE = 6;
    private static final int SAFE_NUMBER = 3000;
    private static final int OFFSET = 10;
    private static final int SAFE_POINT = 400;
    private static final int NO_VALUE = -11;
    private static final int ERROR_DIR = -1;
    private static final int LINE_POINT_NUM = 50;
    private static final int SELECT_POINT_SIZE = 100;
    private static final Image QZIMAGE = BaseUtils.readImage("com/fr/chart/base/quanzhoucom.png");
    private static int QWIDTH = QZIMAGE.getWidth(null);
    private static int QHEIGHT = QZIMAGE.getHeight(null);
    private static int[] QZINT = ImageUtil.image2Pixs(QZIMAGE, QWIDTH, QHEIGHT);
    private int selectX;
    private int selectY;
    private int startX;
    private int startY;
    private int imageWidth;
    private int[] ai;
    private Image image;
    private ImagePlus imagePlus;
    private boolean useOldMethod4Com = false;

    public ColorSelect4Shape() {
    }

    public ColorSelect4Shape(int n2, int n3, Image image) {
        this.makesureClickPoint(n2, n3);
        this.makesureImage(image);
    }

    public void makesureImage(Image image) {
        this.check4UseOld(image);
        if (this.useOldMethod4Com) {
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            this.imageWidth = n2;
            CannyTest cannyTest = new CannyTest();
            cannyTest.setSourceImage(image);
            try {
                cannyTest.process();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Error in Image to Edge");
            }
            byte[] byArray = ImageUtil.Thinner2(ImageUtil.toBinary(CannyTest.image2pixels(cannyTest.getEdgeImage()), n2, n3), n2, n3);
            this.ai = ImageUtil.bin2Rgb(byArray, n2, n3);
        } else if (this.imagePlus == null) {
            this.imagePlus = new ImagePlus("In", image);
        } else {
            this.imagePlus.setImage(image);
        }
        this.image = image;
    }

    private void check4UseOld(Image image) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int[] nArray = ImageUtil.image2Pixs(image, n2, n3);
        this.useOldMethod4Com = ComparatorUtils.equals(QZINT, nArray);
    }

    private boolean selectAll(GeneralPath generalPath) {
        if (generalPath.getBounds() != null && this.image != null) {
            double d2 = generalPath.getBounds().getWidth();
            double d3 = generalPath.getBounds().getHeight();
            double d4 = this.image.getWidth(new JPanel());
            double d5 = this.image.getHeight(new JPanel());
            return d2 == d4 && d3 == d5;
        }
        return false;
    }

    public void makesureClickPoint(double d2, double d3) {
        this.selectX = (int)d2;
        this.selectY = (int)d3;
    }

    public boolean hasLoadedImage(Image image) {
        return ComparatorUtils.equals(image, this.image);
    }

    public GeneralPath getSelectedPath() {
        if (this.useOldMethod4Com) {
            return this.getOldPath();
        }
        GeneralPath generalPath = new GeneralPath();
        if (this.imagePlus != null) {
            generalPath = IJ.doWand4Path((ImagePlus)this.imagePlus, (int)this.selectX, (int)this.selectY);
        }
        if (!generalPath.contains(this.selectX, this.selectY) || this.selectAll(generalPath)) {
            return new GeneralPath();
        }
        return generalPath;
    }

    private GeneralPath getOldPath() {
        int n2;
        int n3;
        GeneralPath generalPath = new GeneralPath(0);
        int n4 = this.getXYColorValue(this.selectX, this.selectY);
        if (!this.check4SelectInLine() || this.outOfMap()) {
            return new GeneralPath();
        }
        this.startX = this.selectX;
        this.startY = this.selectY;
        int n5 = 0;
        for (n3 = this.selectX; n3 > 0; --n3) {
            n2 = this.getXYColorValue(n3, this.selectY);
            if (n2 == n4) continue;
            n5 = n2;
            this.startX = n3;
            break;
        }
        if (this.checkIn5(this.selectX, this.selectY, n4)) {
            return this.dealNotSelectPath(n5);
        }
        n3 = this.startX;
        n2 = this.startY;
        generalPath.moveTo(this.startX, this.startY);
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        ArrayList arrayList = new ArrayList();
        int n6 = -1;
        linkedList.add(new Point2D.Double(n3, n2));
        for (int i2 = 0; i2 < 3000; ++i2) {
            int[] nArray = this.getAllLinePoint(new Point2D.Double(n3, n2), n5, n6, linkedList, arrayList);
            if (nArray == null) break;
            n6 = nArray[0];
            n3 = nArray[1];
            n2 = nArray[2];
        }
        for (int i3 = 0; i3 < linkedList.size(); ++i3) {
            Point2D point2D = (Point2D)linkedList.get(i3);
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        if (!generalPath.contains(new Point(this.selectX, this.selectY))) {
            return this.dealNotSelectPath(n5);
        }
        return generalPath;
    }

    private boolean checkIn5(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 6;
        for (n6 = 0; n6 < n11 && (n5 = this.getXYColorValue(n2 + n6, n3)) == n4; ++n6) {
            ++n9;
        }
        for (n6 = 0; n6 < n11 && (n5 = this.getXYColorValue(n2 - n6, n3)) == n4; ++n6) {
            ++n8;
        }
        for (n6 = 0; n6 < n11 && (n5 = this.getXYColorValue(n2, n3 + n6)) == n4; ++n6) {
            ++n10;
        }
        for (n6 = 0; n6 < n11 && (n5 = this.getXYColorValue(n2, n3 - n6)) == n4; ++n6) {
            ++n7;
        }
        return n10 < n11 && n7 < n11 && n8 < n11 && n9 < n11;
    }

    private GeneralPath dealNotSelectPath(int n2) {
        try {
            return this.getScanPath(n2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error In Select Shape");
            return new GeneralPath();
        }
    }

    private boolean check4SelectInLine() {
        int n2 = 1;
        int n3 = this.getXYColorValue(this.selectX, this.selectY);
        for (int i2 = this.selectX - 5; i2 < this.selectX + 5; ++i2) {
            for (int i3 = this.selectY - 5; i3 < this.selectY + 5; ++i3) {
                int n4 = this.getXYColorValue(i2, i3);
                if (n4 != n3) continue;
                ++n2;
            }
        }
        return n2 > 50;
    }

    private boolean outOfMap() {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = this.getXYColorValue(this.selectX, this.selectY);
        for (n4 = this.selectX - 1; n4 > 0 && (n3 = this.getXYColorValue(n4, this.selectY)) == n5; --n4) {
            if (n4 != 1) continue;
            return true;
        }
        for (n4 = this.selectX + 1; n4 < this.imageWidth && (n3 = this.getXYColorValue(n4, this.selectY)) == n5; ++n4) {
            if (n4 != this.imageWidth - 1) continue;
            return true;
        }
        for (n4 = this.selectY - 1; n4 > 0 && (n3 = this.getXYColorValue(this.selectX, n4)) == n5; --n4) {
            if (n4 != 1) continue;
            return true;
        }
        n4 = this.image.getHeight(null);
        for (n3 = this.selectY + 1; n3 < n4 && (n2 = this.getXYColorValue(this.selectX, n3)) == n5; ++n3) {
            if (n3 != n4 - 1) continue;
            return true;
        }
        return bl;
    }

    private boolean isNotJoinOldPath(LinkedList linkedList, Point2D point2D) {
        int n2 = linkedList.size();
        if (n2 > 6) {
            Point2D point2D2 = (Point2D)linkedList.getLast();
            for (int i2 = 1; i2 < 6; ++i2) {
                Point2D point2D3;
                Point2D point2D4 = (Point2D)linkedList.get(n2 - i2);
                if (!this.isJoin(point2D4, point2D3 = (Point2D)linkedList.get(n2 - i2 - 1), point2D2, point2D)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isJoin(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - point2D3.getX(), point2D.getY() - point2D3.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX() - point2D3.getX(), point2D2.getY() - point2D3.getY());
        Point2D.Double double_3 = new Point2D.Double(point2D4.getX() - point2D3.getX(), point2D4.getY() - point2D3.getY());
        double d2 = this.crossMul(double_, double_3) * this.crossMul(double_2, double_3);
        Point2D.Double double_4 = new Point2D.Double(point2D3.getX() - point2D.getX(), point2D3.getY() - point2D.getY());
        Point2D.Double double_5 = new Point2D.Double(point2D4.getX() - point2D.getX(), point2D4.getY() - point2D.getY());
        Point2D.Double double_6 = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        double d3 = this.crossMul(double_4, double_6) * this.crossMul(double_5, double_6);
        return d2 < 0.0 && d3 < 0.0;
    }

    private double crossMul(Point2D point2D, Point2D point2D2) {
        return point2D.getX() * point2D2.getY() - point2D.getY() * point2D2.getX();
    }

    private int[] getAllLinePoint(Point2D point2D, int n2, int n3, LinkedList linkedList, List list) {
        int n4;
        int n5;
        int n6;
        int n7;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        int n8 = (int)point2D.getX();
        int n9 = (int)point2D.getY();
        for (n7 = 0; n7 < 5; ++n7) {
            for (n6 = 0; n6 < 5; ++n6) {
                int n10;
                if (n7 == 0 && n6 == 0 || (n10 = this.getXYColorValue(n5 = n8 + n7 - 2, n4 = n9 + n6 - 2)) != n2) continue;
                Point2D.Double double_ = new Point2D.Double(n5, n4);
                if (linkedList.size() > 100 && ComparatorUtils.equals(new Point2D.Double(this.startX, this.startY), double_)) {
                    return null;
                }
                if (linkedList.contains(double_) || arrayList.contains(double_) || list.contains(double_) || !this.isNotJoinOldPath(linkedList, double_)) continue;
                arrayList.add(double_);
            }
        }
        if (arrayList.isEmpty()) {
            return this.whenListEmpty(point2D, n2, n3, linkedList, list);
        }
        n7 = n3 == -1 ? -1 : (n3 + 8) % 16;
        n6 = 0;
        n5 = 16;
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            int n11;
            Point2D point2D2 = (Point2D)arrayList.get(n4);
            int n12 = this.getDirection(point2D, point2D2);
            if (n7 == -1) {
                n7 = n12 > 0 && n12 < 8 ? n12 : (n12 + 8) % 16;
            }
            if ((n11 = this.nextToDir(n12, n7)) >= n5 || n11 <= 2) continue;
            n5 = n11;
            n6 = n4;
        }
        n4 = (n7 - n5 + 16) % 16;
        Point2D point2D3 = (Point2D)arrayList.get(n6);
        linkedList.add(point2D3);
        return new int[]{n4, (int)point2D3.getX(), (int)point2D3.getY()};
    }

    private int[] whenListEmpty(Point2D point2D, int n2, int n3, LinkedList linkedList, List list) {
        if (linkedList.size() > 3000) {
            return null;
        }
        Point2D point2D2 = (Point2D)linkedList.getLast();
        if (Point2D.distanceSq(this.startX, this.startY, point2D2.getX(), point2D2.getY()) < 5.0) {
            return null;
        }
        list.add(point2D);
        linkedList.remove(point2D);
        Point2D point2D3 = (Point2D)linkedList.get(linkedList.size() - 1);
        Point2D point2D4 = (Point2D)linkedList.get(linkedList.size() - 2);
        n3 = this.getDirection(point2D3, point2D4);
        return this.getAllLinePoint(point2D3, n2, n3, linkedList, list);
    }

    private int nextToDir(int n2, int n3) {
        int n4;
        for (n4 = 1; n4 < 16 && (n3 - n4 + 16) % 16 != n2; ++n4) {
        }
        return n4;
    }

    private int getDirection(Point2D point2D, Point2D point2D2) {
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = point2D2.getY() - point2D.getY();
        if (d2 > 0.0 && d3 == 0.0) {
            return 0;
        }
        if (d2 > 0.0 && d3 > 0.0 && d3 / d2 == 0.5) {
            return 15;
        }
        if (d2 > 0.0 && d3 > 0.0 && d2 == d3) {
            return 14;
        }
        if (d2 > 0.0 && d3 > 0.0 && d3 / d2 == 2.0) {
            return 13;
        }
        if (d2 == 0.0 && d3 > 0.0) {
            return 12;
        }
        if (d2 < 0.0 && d3 > 0.0 && d3 / d2 == -2.0) {
            return 11;
        }
        if (d2 < 0.0 && d3 > 0.0 && d3 == -d2) {
            return 10;
        }
        if (d2 < 0.0 && d3 > 0.0 && d3 / d2 == -0.5) {
            return 9;
        }
        if (d2 < 0.0 && d3 == 0.0) {
            return 8;
        }
        if (d2 < 0.0 && d3 < 0.0 && d3 / d2 == 0.5) {
            return 7;
        }
        if (d2 < 0.0 && d3 < 0.0 && d3 == d2) {
            return 6;
        }
        if (d2 < 0.0 && d3 < 0.0 && d3 / d2 == 2.0) {
            return 5;
        }
        if (d2 == 0.0 && d3 < 0.0) {
            return 4;
        }
        if (d2 > 0.0 && d3 < 0.0 && d3 / d2 == -2.0) {
            return 3;
        }
        if (d2 > 0.0 && d3 < 0.0 && d3 == -d2) {
            return 2;
        }
        if (d2 > 0.0 && d3 < 0.0 && d3 / d2 == -0.5) {
            return 1;
        }
        return -1;
    }

    private int getXYColorValue(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            return -11;
        }
        if (n3 * this.imageWidth + n2 < this.ai.length) {
            return this.ai[n3 * this.imageWidth + n2];
        }
        return -11;
    }

    private GeneralPath getScanPath(int n2) {
        ArrayList arrayList = new ArrayList();
        int n3 = this.selectX;
        int n4 = this.selectY;
        int n5 = this.getLeftLineXInSameY(n3, n4, n2);
        int n6 = this.getRightLineXInSameY(n3, n4, n2);
        this.dealPointInLowWave(n5, n6, n4, arrayList, n2);
        this.dealPointInLowWave(n6, n5, n4, arrayList, n2);
        GeneralPath generalPath = new GeneralPath(0);
        int n7 = arrayList.size();
        for (int i2 = 0; i2 < n7; ++i2) {
            Point2D point2D = (Point2D)arrayList.get(i2);
            if (i2 == 0) {
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                continue;
            }
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    private void dealPointInLowWave(int n2, int n3, int n4, List list, int n5) {
        if (list.size() > 400) {
            return;
        }
        int n6 = (n2 + n3) / 2;
        int n7 = n2;
        list.add(new Point2D.Double(n2, n4));
        int n8 = 10;
        if (n2 < n6) {
            this.dealLowScan(n4, n6, n7, list, n5, n8);
        } else {
            this.dealHighScan(n4, n6, n7, list, n5, n8);
        }
    }

    private void dealLowScan(int n2, int n3, int n4, List list, int n5, int n6) {
        int n7;
        int n8;
        int n9 = this.getScanBottomEndY(n3, n2, n5);
        for (n8 = n2; n8 <= n9; ++n8) {
            n7 = this.getLeftLineXInSameY(n3, n8, n5);
            if (Math.abs(n4 - n7) >= n6) continue;
            n4 = n7;
            list.add(new Point2D.Double(n7 - 1, n8));
        }
        if (n4 != n3) {
            // empty if block
        }
        for (n8 = n9; n8 >= n2; --n8) {
            n7 = this.getRightLineXInSameY(n3, n8, n5);
            if (Math.abs(n4 - n7) >= n6 && n8 != n9) continue;
            n4 = n7;
            list.add(new Point2D.Double(n7 + 1, n8));
        }
    }

    private void dealHighScan(int n2, int n3, int n4, List list, int n5, int n6) {
        int n7;
        int n8;
        int n9 = this.getScanTopEndY(n3, n2, n5);
        for (n8 = n2; n8 >= n9; --n8) {
            n7 = this.getRightLineXInSameY(n3, n8, n5);
            if (Math.abs(n4 - n7) >= n6) continue;
            n4 = n7;
            list.add(new Point2D.Double(n7 + 1, n8));
        }
        if (n3 != n4) {
            // empty if block
        }
        for (n8 = n9; n8 <= n2; ++n8) {
            n7 = this.getLeftLineXInSameY(n3, n8, n5);
            if (Math.abs(n4 - n7) >= n6 && n8 != n9) continue;
            n4 = n7;
            list.add(new Point2D.Double(n7 - 1, n8));
        }
    }

    private int getScanBottomEndY(int n2, int n3, int n4) {
        for (int i2 = n3; i2 > 0; ++i2) {
            int n5 = this.getXYColorValue(n2, i2);
            if (n5 != n4) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    private int getScanTopEndY(int n2, int n3, int n4) {
        for (int i2 = n3; i2 > 0; --i2) {
            int n5 = this.getXYColorValue(n2, i2);
            if (n5 != n4) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    private int getLeftLineXInSameY(int n2, int n3, int n4) {
        int n5 = n2;
        for (int i2 = n2; i2 > 0; --i2) {
            int n6 = this.getXYColorValue(i2, n3);
            if (n6 != n4) continue;
            n5 = i2;
            break;
        }
        return n5;
    }

    private int getRightLineXInSameY(int n2, int n3, int n4) {
        int n5 = n2;
        for (int i2 = n2; i2 > 0; ++i2) {
            int n6 = this.getXYColorValue(i2, n3);
            if (n6 != n4) continue;
            n5 = i2;
            break;
        }
        return n5;
    }
}

