/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CannyTest
extends JComponent
implements MouseListener {
    final float ORIENT_SCALE = 40.0f;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] derivative_mag;
    private int[] magnitude;
    private int[] orientation;
    private Image sourceImage;
    private Image edgeImage;
    private int threshold1 = 50;
    private int threshold2 = 230;
    private int threshold;
    private int widGaussianKernel;
    private int startX = 300;
    private int startY = 200;

    public CannyTest() {
        this.setThreshold(128);
        this.setWidGaussianKernel(15);
        this.addMouseListener(this);
    }

    public void process() throws Exception {
        if (this.threshold < 0 || this.threshold > 255) {
            throw new Exception("The value of the threshold is out of its valid range.");
        }
        if (this.widGaussianKernel < 3 || this.widGaussianKernel > 40) {
            throw new Exception("The value of the widGaussianKernel is out of its valid range.");
        }
        this.width = this.sourceImage.getWidth(this);
        this.height = this.sourceImage.getHeight(this);
        this.picsize = this.width * this.height;
        this.data = new int[this.picsize];
        this.magnitude = new int[this.picsize];
        this.orientation = new int[this.picsize];
        float f2 = 1.0f;
        this.canny_core(f2, this.widGaussianKernel);
        this.thresholding_tracker(this.threshold1, this.threshold2);
        for (int i2 = 0; i2 < this.picsize; ++i2) {
            this.data[i2] = this.data[i2] > this.threshold ? -16777216 : -1;
        }
        this.edgeImage = this.pixels2image(this.data);
        this.data = null;
        this.magnitude = null;
        this.orientation = null;
    }

    private void canny_core(float f2, int n2) {
        int n3;
        int n4;
        int n5;
        float f3;
        int n6;
        int n7;
        float f4;
        int n8;
        boolean bl = false;
        boolean bl2 = false;
        this.derivative_mag = new int[this.picsize];
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        this.data = CannyTest.image2pixels(this.sourceImage);
        for (n8 = 0; !(n8 >= n2 || (f4 = this.gaussian(n8, f2)) <= 0.005f && n8 >= 2); ++n8) {
            float f5 = this.gaussian((float)n8 - 0.5f, f2);
            float f6 = this.gaussian((float)n8 + 0.5f, f2);
            float f7 = this.gaussian(n8, f2 * 0.5f);
            fArray[n8] = (f4 + f5 + f6) / 3.0f / (6.283185f * f2 * f2);
            fArray2[n8] = f6 - f5;
            fArray3[n8] = 1.6f * f7 - f4;
        }
        int n9 = n8;
        float[] fArray4 = new float[this.picsize];
        float[] fArray5 = new float[this.picsize];
        int n10 = this.width - (n9 - 1);
        int n11 = this.width * (n9 - 1);
        int n12 = this.width * (this.height - (n9 - 1));
        for (int i2 = n9 - 1; i2 < n10; ++i2) {
            for (n7 = n11; n7 < n12; n7 += this.width) {
                n6 = i2 + n7;
                float f8 = f3 = (float)this.data[n6] * fArray[0];
                n5 = 1;
                n4 = n6 - this.width;
                n3 = n6 + this.width;
                while (n5 < n9) {
                    f3 += fArray[n5] * (float)(this.data[n4] + this.data[n3]);
                    f8 += fArray[n5] * (float)(this.data[n6 - n5] + this.data[n6 + n5]);
                    ++n5;
                    n4 -= this.width;
                    n3 += this.width;
                }
                fArray4[n6] = f3;
                fArray5[n6] = f8;
            }
        }
        float[] fArray6 = new float[this.picsize];
        for (n7 = n9 - 1; n7 < n10; ++n7) {
            for (n6 = n11; n6 < n12; n6 += this.width) {
                f3 = 0.0f;
                int n13 = n7 + n6;
                for (n5 = 1; n5 < n9; ++n5) {
                    f3 += fArray2[n5] * (fArray4[n13 - n5] - fArray4[n13 + n5]);
                }
                fArray6[n13] = f3;
            }
        }
        fArray4 = null;
        float[] fArray7 = new float[this.picsize];
        for (n6 = n8; n6 < this.width - n8; ++n6) {
            for (int i3 = n11; i3 < n12; i3 += this.width) {
                float f9 = 0.0f;
                n5 = n6 + i3;
                n4 = 1;
                n3 = this.width;
                while (n4 < n9) {
                    f9 += fArray2[n4] * (fArray5[n5 - n3] - fArray5[n5 + n3]);
                    ++n4;
                    n3 += this.width;
                }
                fArray7[n5] = f9;
            }
        }
        fArray5 = null;
        n10 = this.width - n9;
        n11 = this.width * n9;
        n12 = this.width * (this.height - n9);
        for (n6 = n9; n6 < n10; ++n6) {
            for (int i4 = n11; i4 < n12; i4 += this.width) {
                float f10;
                int n14 = n6 + i4;
                n5 = n14 - this.width;
                n4 = n14 + this.width;
                n3 = n14 - 1;
                int n15 = n14 + 1;
                int n16 = n5 - 1;
                int n17 = n5 + 1;
                int n18 = n4 - 1;
                int n19 = n4 + 1;
                float f11 = fArray6[n14];
                float f12 = fArray7[n14];
                float f13 = this.hypotenuse(f11, f12);
                int n20 = (int)((double)f13 * 20.0);
                this.derivative_mag[n14] = n20 >= 256 ? 255 : n20;
                float f14 = this.hypotenuse(fArray6[n5], fArray7[n5]);
                float f15 = this.hypotenuse(fArray6[n4], fArray7[n4]);
                float f16 = this.hypotenuse(fArray6[n3], fArray7[n3]);
                float f17 = this.hypotenuse(fArray6[n15], fArray7[n15]);
                float f18 = this.hypotenuse(fArray6[n17], fArray7[n17]);
                float f19 = this.hypotenuse(fArray6[n19], fArray7[n19]);
                float f20 = this.hypotenuse(fArray6[n18], fArray7[n18]);
                float f21 = this.hypotenuse(fArray6[n16], fArray7[n16]);
                if (f11 * f12 <= 0.0f) {
                    if (Math.abs(f11) >= Math.abs(f12)) {
                        float f22;
                        f10 = Math.abs(f11 * f13);
                        if (!(f22 >= Math.abs(f12 * f18 - (f11 + f12) * f17)) || !(f10 > Math.abs(f12 * f20 - (f11 + f12) * f16))) continue;
                    } else {
                        float f23;
                        f10 = Math.abs(f12 * f13);
                        if (!(f23 >= Math.abs(f11 * f18 - (f12 + f11) * f14)) || !(f10 > Math.abs(f11 * f20 - (f12 + f11) * f15))) continue;
                    }
                } else if (Math.abs(f11) >= Math.abs(f12)) {
                    float f24;
                    f10 = Math.abs(f11 * f13);
                    if (!(f24 >= Math.abs(f12 * f19 + (f11 - f12) * f17)) || !(f10 > Math.abs(f12 * f21 + (f11 - f12) * f16))) continue;
                } else {
                    float f25;
                    f10 = Math.abs(f12 * f13);
                    if (!(f25 >= Math.abs(f11 * f19 + (f12 - f11) * f15)) || !(f10 > Math.abs(f11 * f21 + (f12 - f11) * f14))) continue;
                }
                this.magnitude[n14] = this.derivative_mag[n14];
                this.orientation[n14] = (int)(Math.atan2(f12, f11) * 40.0);
            }
        }
        this.derivative_mag = null;
        fArray6 = null;
        fArray7 = null;
    }

    private float hypotenuse(float f2, float f3) {
        if (f2 == 0.0f && f3 == 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    private float gaussian(float f2, float f3) {
        return (float)Math.exp(-f2 * f2 / (2.0f * f3 * f3));
    }

    private void thresholding_tracker(int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.picsize; ++n4) {
            this.data[n4] = 0;
        }
        for (n4 = 0; n4 < this.width; ++n4) {
            for (int i2 = 0; i2 < this.height; ++i2) {
                if (this.magnitude[n4 + this.width * i2] < n2) continue;
                this.follow(n4, i2, n3);
            }
        }
    }

    private boolean follow(int n2, int n3, int n4) {
        int n5 = n2 + 1;
        int n6 = n2 - 1;
        int n7 = n3 + 1;
        int n8 = n3 - 1;
        int n9 = n2 + n3 * this.width;
        if (n7 >= this.height) {
            n7 = this.height - 1;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n5 >= this.width) {
            n5 = this.width - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (this.data[n9] == 0) {
            this.data[n9] = this.magnitude[n9];
            boolean bl = false;
            for (int i2 = n6; i2 <= n5; ++i2) {
                for (int i3 = n8; i3 <= n7; ++i3) {
                    int n10 = i2 + i3 * this.width;
                    if (i3 == n3 && i2 == n2 || this.magnitude[n10] < n4 || !this.follow(i2, i3, n4)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            return true;
        }
        return false;
    }

    private Image pixels2image(int[] nArray) {
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, ColorModel.getRGBdefault(), nArray, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public static int[] image2pixels(Image image) {
        int n2;
        int n3;
        int n4;
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        int n7 = n5 * n6;
        int[] nArray = new int[n7];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n5, n6, nArray, 0, n5);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        boolean bl = false;
        for (int i2 = 0; i2 < 16; ++i2) {
            n4 = (nArray[i2] & 0xFF0000) >> 16;
            n3 = (nArray[i2] & 0xFF00) >> 8;
            n2 = nArray[i2] & 0xFF;
            if (n4 == n3 && n3 == n2) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n4 = 0; n4 < n7; ++n4) {
                n3 = (nArray[n4] & 0xFF0000) >> 16;
                n2 = (nArray[n4] & 0xFF00) >> 8;
                int n8 = nArray[n4] & 0xFF;
                nArray[n4] = (int)(0.298 * (double)n3 + 0.586 * (double)n2 + 0.113 * (double)n8);
            }
        } else {
            for (n4 = 0; n4 < n7; ++n4) {
                nArray[n4] = nArray[n4] & 0xFF;
            }
        }
        return nArray;
    }

    public void setSourceImage(Image image) {
        this.sourceImage = image;
    }

    public Image getEdgeImage() {
        return this.edgeImage;
    }

    public void setThreshold(int n2) {
        this.threshold = n2;
    }

    public void setWidGaussianKernel(int n2) {
        this.widGaussianKernel = n2;
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.edgeImage, 0, 0, null);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.blue);
        int n2 = this.startX;
        int n3 = this.startY;
    }

    public static void main(String[] stringArray) {
        try {
            CannyTest cannyTest = new CannyTest();
            String string = "/Users/jihua/Desktop/world.png";
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            cannyTest.setSourceImage(bufferedImage);
            try {
                cannyTest.process();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            JFrame jFrame = new JFrame();
            JPanel jPanel = (JPanel)jFrame.getContentPane();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)cannyTest, "Center");
            jFrame.setSize(1400, 900);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setTitle("Canny Test");
            jFrame.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.startX = mouseEvent.getX();
            this.startY = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

