/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.file.FunctionDef;
import com.fr.file.FunctionManager;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.InterpreterError;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Function;
import com.fr.stable.script.NameSpace;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;

public final class DefaultNameSpace
extends AbstractNameSpace {
    private static NameSpace instance = null;
    private Hashtable initedFunctionClasses;

    public static NameSpace getInstance() {
        if (instance == null) {
            instance = new DefaultNameSpace();
        }
        return instance;
    }

    private DefaultNameSpace() {
    }

    public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.equalsIgnoreCase("null")) {
                return Primitive.NULL;
            }
            if (string.equalsIgnoreCase("nofilter")) {
                return Primitive.NOFILTER;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if ("FR_HOME".equalsIgnoreCase(string)) {
                return StableUtils.getInstallHome();
            }
            if ("ENV_HOME".equalsIgnoreCase(string)) {
                return FRContext.getCurrentEnv().getPath();
            }
            if ("lic_PROJECTNAME".equalsIgnoreCase(string)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = StableUtils.getBytes();
                try {
                    StableUtils.decode(byArray, byteArrayOutputStream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                    return jSONObject.get("PROJECTNAME");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        return this.resloveFromThreadContext(object, calculatorProvider);
    }

    private Object resloveFromThreadContext(Object object, CalculatorProvider calculatorProvider) {
        NameSpace nameSpace;
        Object object2;
        Object object3 = null;
        if (object instanceof String && ((String)(object2 = object.toString())).startsWith("$")) {
            object = ((String)object2).substring(1);
        }
        if ((object2 = (Map)Calculator.getSavedVariables()) != null) {
            object3 = object2.get(object);
        }
        if (object3 == null && (nameSpace = (NameSpace)Calculator.getSavedSessionNameSpace()) != null) {
            object3 = nameSpace.getVariable(object, calculatorProvider);
        }
        return object3;
    }

    public Function getMethod(Object object, CalculatorProvider calculatorProvider) {
        String string;
        Class clazz;
        String string2;
        block12: {
            if (!(object instanceof String)) {
                throw new InterpreterError(Inter.getLocText("Function_Name_Should_Not_Be") + object + (object != null ? " " + object.getClass() : ""));
            }
            string2 = ((String)object).toUpperCase();
            if (this.initedFunctionClasses == null) {
                this.initedFunctionClasses = new Hashtable();
            }
            if ((clazz = (Class)this.initedFunctionClasses.get(string2)) == null) {
                string = null;
                FunctionManager functionManager = FunctionManager.getInstance();
                int n2 = functionManager.getFunctionDefCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    FunctionDef functionDef = functionManager.getFunctionDef(i2);
                    if (!functionDef.getName().equalsIgnoreCase(string2)) continue;
                    string = functionDef.getClassName();
                }
                if (string == null) {
                    string = "com.fr.function." + string2;
                }
                try {
                    clazz = GeneralUtils.classForName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (string.equals("com.fr.function." + string2)) break block12;
                    try {
                        clazz = GeneralUtils.classForName("com.fr.function." + string2);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
            }
        }
        if (clazz == null) {
            return null;
        }
        this.initedFunctionClasses.put(string2, clazz);
        try {
            string = (String)clazz.newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return null;
        }
        return (Function)((Object)string);
    }

    public String toString() {
        return "FUNCTION_NAMESPACE";
    }
}

