/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseXMLUtils;
import com.fr.base.ConfigProvider;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.NameStyle;
import com.fr.base.Parameter;
import com.fr.base.Style;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.GeneralContext;
import com.fr.general.LogConfig;
import com.fr.general.ManagerFactory;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListMap;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.ObjectTokenizer;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class ConfigManager
extends XMLFileManager
implements ConfigProvider {
    private static final long DEFAULT_CHECK_TIME = 400000L;
    private static final long DEFAULT_DIGITAL_PRIVILEGE = 90000L;
    private static final long DEFAULT_USERNAME_PRIVILEGE = 1200000L;
    private static final String PRIVILEGE_TIMEOUT_XML = "privilegeTimeout";
    private static final String DIGITAL_PRIVILEGE_XML = "digitalPrivilegeTimeout";
    private static final String USERNAME_PRIVILEGE_XML = "usernamePrivilegeTimeout";
    private static final String EXPORT_FULL_IMAGE = "exportFullImage";
    private static final String EXCEL_ADJUST = "excelAdjust";
    private static ConfigManager configManager = null;
    private String serverCharset = null;
    private Level serverLogLevel = Level.WARNING;
    private FArray mailAddress4log = new FArray();
    private Map globalAttrMap = new HashMap();
    private EmailManager emailManager = new EmailManager();
    private Parameter[] globeParameters = new Parameter[0];
    private EmbeddedTableData embeddedTableData = new EmbeddedTableData();
    private Map styleMap = new ListMap();
    private boolean popupFlashPrintSetting = true;
    private boolean fitPaper = false;
    private boolean printWidget = false;
    private boolean writeShortCuts = true;
    private boolean popupPdfPrintSetting = true;
    private boolean popupAppletPrintSetting = false;
    private String ServletMapping = "ReportServer";
    private boolean supportGzip = false;
    private boolean isLicUseLock = false;
    private boolean isDownChromeFrameInLocal = false;
    private boolean isIncludeString = false;
    private int serverLanguage = 0;
    private String resultSaverClassName = null;
    private String errorTemplate = null;
    private JDBCDatabaseConnection platformConnection;
    private String jbosswebappname = "WebReport";
    private long sessionDeadCheckTime = 400000L;
    private boolean sendHeartBeat = true;
    private String hyperlinkAddress = "";
    private long digitalPrivilegeTimeout = 90000L;
    private long usernamePrivilegeTimeout = 1200000L;
    private boolean exportFullImg4Excel = false;
    private float excelAdjustHeight = 20.1f;
    private double excelAdjustWidth = 34.742;

    public static synchronized ConfigManager getInstance() {
        if (configManager == null) {
            InputStream inputStream;
            configManager = new ConfigManager();
            if (!configManager.readXMLFile() && (inputStream = FRContext.getResourceStream("ReportServerParameter.rxml")) != null) {
                try {
                    XMLTools.readInputStreamXML(configManager, inputStream);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            }
            ManagerFactory.registerConfigProvider(configManager);
        }
        return configManager;
    }

    private static synchronized void envChanged() {
        configManager = null;
    }

    public static synchronized void readInputStream(InputStream inputStream) throws Exception {
        ConfigManager configManager = new ConfigManager();
        XMLTools.readInputStreamXML(configManager, inputStream);
        ConfigManager.configManager = configManager;
        FRContext.getCurrentEnv().writeResource(ConfigManager.configManager);
    }

    public boolean isFitPaper() {
        return this.fitPaper;
    }

    public void setFitPaper(boolean bl) {
        this.fitPaper = bl;
    }

    private ConfigManager() {
    }

    public String fileName() {
        return "config.xml";
    }

    public String getServerCharset() {
        if (this.serverCharset == null) {
            this.serverCharset = this.getDefaultBrowserCharset();
        }
        return this.serverCharset;
    }

    public void setServerCharset(String string) {
        this.serverCharset = string;
    }

    public boolean isPrintWidget() {
        return this.printWidget;
    }

    public void setPrintWidget(boolean bl) {
        this.printWidget = bl;
    }

    private String getDefaultBrowserCharset() {
        if (ComparatorUtils.equals(Locale.SIMPLIFIED_CHINESE, FRContext.getLocale())) {
            return "GBK";
        }
        if (ComparatorUtils.equals(Locale.TRADITIONAL_CHINESE, FRContext.getLocale())) {
            return "BIG5";
        }
        if (ComparatorUtils.equals(Locale.JAPANESE, FRContext.getLocale())) {
            return "EUC_JP";
        }
        if (ComparatorUtils.equals(Locale.KOREAN, FRContext.getLocale())) {
            return "EUC_KR";
        }
        return "UTF-8";
    }

    public Level getServerLogLevel() {
        return this.serverLogLevel;
    }

    public void setServerLogLevel(Level level) {
        this.serverLogLevel = level;
    }

    public FArray getMailAddress4log() {
        return this.mailAddress4log;
    }

    public void setMailAddress4log(FArray fArray) {
        this.mailAddress4log = fArray;
    }

    public void setMailAddress4log(String string) {
        Object[] objectArray = string.split(",");
        this.mailAddress4log = new FArray(objectArray);
    }

    public LogConfig getLogConfig() {
        return LogConfig.getLogConfig();
    }

    public void setLogConfig(LogConfig logConfig) {
        LogConfig.registerLogConfig(logConfig);
    }

    public boolean isWriteShortCuts() {
        return this.writeShortCuts;
    }

    public void setWriteShortCuts(boolean bl) {
        this.writeShortCuts = bl;
    }

    public boolean isPopupFlashPrintSetting() {
        return this.popupFlashPrintSetting;
    }

    public boolean isPopupAppletPrintSetting() {
        return this.popupAppletPrintSetting;
    }

    public boolean isPopupPdfPrintSetting() {
        return this.popupPdfPrintSetting;
    }

    public void setPopupAppletPrintSetting(boolean bl) {
        this.popupAppletPrintSetting = bl;
    }

    public void setPopupFlashPrintSetting(boolean bl) {
        this.popupFlashPrintSetting = bl;
    }

    public void setPopupPdfPrintSetting(boolean bl) {
        this.popupPdfPrintSetting = bl;
    }

    public void setSupportGzip(boolean bl) {
        this.supportGzip = bl;
    }

    public boolean isSupportGzip() {
        return this.supportGzip;
    }

    public void setLicUseLock(boolean bl) {
        this.isLicUseLock = bl;
    }

    public boolean isLicUseLock() {
        return this.isLicUseLock;
    }

    public void setServerLanguage(int n2) {
        this.serverLanguage = n2;
    }

    public int getServerLanguage() {
        return this.serverLanguage;
    }

    public long getUsernamePrivilegeTimeout() {
        return this.usernamePrivilegeTimeout;
    }

    public void setUsernamePrivilegeTimeout(long l2) {
        this.usernamePrivilegeTimeout = l2;
    }

    public long getDigitalPrivilegeTimeout() {
        return this.digitalPrivilegeTimeout;
    }

    public void setDigitalPrivilegeTimeout(long l2) {
        this.digitalPrivilegeTimeout = l2;
    }

    public boolean isExportFullImg4Excel() {
        return this.exportFullImg4Excel;
    }

    public void setExportFullImg4Excel(boolean bl) {
        this.exportFullImg4Excel = bl;
    }

    public float getExcelAdjustHeight() {
        return this.excelAdjustHeight;
    }

    public void setExcelAdjustHeight(float f2) {
        this.excelAdjustHeight = f2;
    }

    public double getExcelAdjustWidth() {
        return this.excelAdjustWidth;
    }

    public void setExcelAdjustWidth(double d2) {
        this.excelAdjustWidth = d2;
    }

    public boolean hasStyle() {
        return !this.styleMap.isEmpty();
    }

    public Iterator getStyleNameIterator() {
        return this.styleMap.keySet().iterator();
    }

    public Style getStyle(String string) {
        Style style = (Style)this.styleMap.get(string);
        if (style == null && string != null && string.indexOf("..") != -1) {
            style = this.getStyle4HalfName(string);
        }
        return style;
    }

    private Style getStyle4HalfName(String string) {
        Iterator iterator = this.getStyleNameIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf(string.replaceAll(".", "")) == -1) continue;
            return this.getStyle(string2);
        }
        return NameStyle.getInstance();
    }

    public void putStyle(String string, Style style) {
        if (style == null) {
            this.styleMap.remove(string);
        }
        if (this.styleMap.get(string) != null) {
            return;
        }
        this.styleMap.put(string, style);
    }

    public void clearAllStyle() {
        this.styleMap.clear();
    }

    public String getResultSaverClassName() {
        return this.resultSaverClassName;
    }

    public EmailManager getEmailManager() {
        return this.emailManager;
    }

    public void setEmailManager(EmailManager emailManager) {
        this.emailManager = emailManager;
    }

    public JDBCDatabaseConnection getPlatformConnection() {
        return this.platformConnection;
    }

    public void putGlobalAttribute(Object object, Object object2) {
        this.globalAttrMap.put(object, object2);
    }

    public Object getGlobalAttribute(Object object) {
        return this.globalAttrMap.get(object);
    }

    public String getJbossWebappName() {
        return this.jbosswebappname;
    }

    private void setJbossWebappName(String string) {
        this.jbosswebappname = string;
    }

    public long getSessionDeadCheckTime() {
        return this.sessionDeadCheckTime;
    }

    public void setSessionDeadCheckTime(long l2) {
        this.sessionDeadCheckTime = l2;
    }

    public boolean isSendHeartBeat() {
        return this.sendHeartBeat;
    }

    public void setSendHeartBeat(boolean bl) {
        this.sendHeartBeat = bl;
    }

    public String getHyperlinkAddress() {
        return this.hyperlinkAddress;
    }

    public void setHyperlinkAddress(String string) {
        this.hyperlinkAddress = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (xMLableReader.isChildNode()) {
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("Write".equals(string)) {
                String string3 = xMLableReader.getAttrAsString("serverCharacterEncoding", null);
                if (string3 != null) {
                    this.setServerCharset(string3);
                }
            } else if ("GZip".equals(string)) {
                this.setSupportGzip(xMLableReader.getAttrAsBoolean("run", false));
            } else if ("Lic".equals(string)) {
                this.setLicUseLock(xMLableReader.getAttrAsBoolean("useLock", false));
            } else if ("ServletMapping".equals(string)) {
                String string4 = xMLableReader.getAttrAsString("pattern", null);
                if (string4 != null) {
                    this.setServletMapping(string4);
                }
            } else if ("ChromeChart".equals(string)) {
                this.setDownChromeFrameInLocal(xMLableReader.getAttrAsBoolean("downLocal", false));
            } else if ("Parameters".equals(string) || "Global_Parameters".equals(string)) {
                this.globeParameters = BaseXMLUtils.readParameters(xMLableReader);
            } else if (string.equals("ReportWebAttr")) {
                this.readReportWebAttr(xMLableReader);
            } else if ("ServerLogLevel".equals(string) || "SetServerLogLevel".equals(string)) {
                this.readServerLog(xMLableReader);
            } else if (string.equals("EmailManager")) {
                this.emailManager = new EmailManager();
                xMLableReader.readXMLObject(this.emailManager);
            } else if (string.equals("Styles")) {
                this.readStyles(xMLableReader);
            } else if (string.equals("SessionInfo")) {
                this.setSessionDeadCheckTime(xMLableReader.getAttrAsLong("checkTime", 400000L));
                this.setSendHeartBeat(xMLableReader.getAttrAsBoolean("heartBeat", true));
            } else if (string.equals("FlashPrint")) {
                this.setPopupFlashPrintSetting(xMLableReader.getAttrAsBoolean("popupFlashPrintSetting", true));
                this.setFitPaper(xMLableReader.getAttrAsBoolean("fitPaper", false));
            } else if (string.equals("PdfPrint")) {
                this.setPopupPdfPrintSetting(xMLableReader.getAttrAsBoolean("popupPdfPrintSetting", true));
            } else if (string.equals("AppletPrint")) {
                this.setPopupAppletPrintSetting(xMLableReader.getAttrAsBoolean("popupAppletPrintSetting", true));
            } else if (string.equals("writeShortCuts")) {
                this.setWriteShortCuts(xMLableReader.getAttrAsBoolean("writeShortCuts", true));
            } else if (string.equals("JbossWebappName")) {
                this.setJbossWebappName(xMLableReader.getAttrAsString("name", null));
            } else if (string.equals("Hyperlink")) {
                this.setHyperlinkAddress(xMLableReader.getAttrAsString("defaultLinkPath", null));
            } else if (string.equals("PrintWidget")) {
                this.setPrintWidget(xMLableReader.getAttrAsBoolean("print", false));
            } else {
                this.readSomeOther(xMLableReader);
            }
        }
    }

    private void readReportWebAttr(XMLableReader xMLableReader) {
        ThreadLocal<ConfigManager> threadLocal = new ThreadLocal<ConfigManager>();
        threadLocal.set(this);
        try {
            Class<?> clazz = Class.forName("com.fr.xml.ReportXMLUtils$ReportObjectTokenizer");
            GeneralXMLTools.Object_Tokenizer = (ObjectTokenizer)clazz.newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        GeneralXMLTools.Object_Tokenizer.tokenizerObject(xMLableReader, false, xMLableReader.getTagName(), threadLocal);
    }

    private void readSomeOther(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (ComparatorUtils.equals("ErrorHandler", string)) {
            this.setErrorTemplate(xMLableReader.getAttrAsString("template", null));
        } else if (ComparatorUtils.equals("PlatformConnection", string)) {
            this.platformConnection = new JDBCDatabaseConnection();
            xMLableReader.readXMLObject(this.platformConnection);
        } else if (ComparatorUtils.equals("CustomLocale", string)) {
            this.embeddedTableData = new EmbeddedTableData();
            xMLableReader.readXMLObject(this.embeddedTableData);
        } else if (ComparatorUtils.equals(LogConfig.XML_TAG, string)) {
            this.setLogConfig((LogConfig)xMLableReader.readXMLObject(new LogConfig()));
        } else if (ComparatorUtils.equals("FARRAY", string)) {
            this.setMailAddress4log((FArray)xMLableReader.readXMLObject(new FArray()));
        } else if (ComparatorUtils.equals(PRIVILEGE_TIMEOUT_XML, string)) {
            this.setDigitalPrivilegeTimeout(xMLableReader.getAttrAsLong(DIGITAL_PRIVILEGE_XML, 90000L));
            this.setUsernamePrivilegeTimeout(xMLableReader.getAttrAsLong(USERNAME_PRIVILEGE_XML, 1200000L));
        } else if (ComparatorUtils.equals(EXPORT_FULL_IMAGE, string)) {
            this.setExportFullImg4Excel(xMLableReader.getAttrAsBoolean("excel", false));
        } else if (ComparatorUtils.equals(EXCEL_ADJUST, string)) {
            this.setExcelAdjustHeight(xMLableReader.getAttrAsFloat("height", 20.1f));
            this.setExcelAdjustWidth(xMLableReader.getAttrAsDouble("width", 34.742));
        }
    }

    private void readServerLog(XMLableReader xMLableReader) {
        String string = "";
        string = xMLableReader.getElementValue();
        if (string != null) {
            try {
                Level level = Level.parse(string);
                this.setServerLogLevel(level);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void readStyles(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isAttr()) {
                    ConfigManager.this.styleMap.clear();
                }
                if (xMLableReader.isChildNode() && "SAttr".equals(string = xMLableReader.getTagName())) {
                    String string2 = "";
                    String string3 = xMLableReader.getAttrAsString("name", null);
                    if (string3 != null) {
                        string2 = string3;
                    }
                    xMLableReader.readXMLObject(new XMLObject(string2){

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode() && "Style".equals(xMLableReader.getTagName())) {
                                Style style = BaseXMLUtils.readFullStyle(xMLableReader);
                                ConfigManager.this.putStyle((String)this.getObject(), style);
                            }
                        }
                    });
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ReportServerParameter");
        if (this.serverLogLevel != null) {
            xMLPrintWriter.startTAG("ServerLogLevel");
            xMLPrintWriter.textNode(String.valueOf(this.getServerLogLevel()));
            xMLPrintWriter.end();
        }
        if (this.getLogConfig() != null) {
            this.getLogConfig().writeXML(xMLPrintWriter);
        }
        if (this.mailAddress4log != null) {
            this.mailAddress4log.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("Write").attr("serverCharacterEncoding", this.getServerCharset());
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("GZip").attr("run", this.isSupportGzip()).end();
        xMLPrintWriter.startTAG("Lic").attr("useLock", this.isLicUseLock()).end();
        xMLPrintWriter.startTAG("ServletMapping").attr("pattern", this.getServletMapping()).end();
        xMLPrintWriter.startTAG("ChromeChart").attr("downLocal", this.isDownChromeFrameInLocal).end();
        xMLPrintWriter.startTAG("JbossWebappName").attr("name", this.getJbossWebappName()).end();
        xMLPrintWriter.startTAG("Hyperlink").attr("defaultLinkPath", this.getHyperlinkAddress()).end();
        for (Object v2 : this.globalAttrMap.values()) {
            if (!(v2 instanceof XMLWriter)) continue;
            ((XMLWriter)v2).writeXML(xMLPrintWriter);
        }
        if (this.emailManager != null) {
            this.emailManager.writeXML(xMLPrintWriter);
        }
        StableXMLUtils.writeParameters(xMLPrintWriter, this.globeParameters);
        this.writeStyles(xMLPrintWriter);
        this.writeSessionManage(xMLPrintWriter);
        this.writePrint(xMLPrintWriter);
        xMLPrintWriter.startTAG("CustomLocale");
        this.embeddedTableData.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
        this.writeSomeOther(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private void writeStyles(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Styles");
        Iterator iterator = this.getStyleNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Style style = this.getStyle(string);
            if (style == null) continue;
            xMLPrintWriter.startTAG("SAttr").attr("name", string);
            BaseXMLUtils.writeStyle(xMLPrintWriter, style);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    private void writeSessionManage(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("SessionInfo").attr("checkTime", this.getSessionDeadCheckTime()).attr("heartBeat", this.isSendHeartBeat()).end();
    }

    private void writePrint(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FlashPrint").attr("popupFlashPrintSetting", this.isPopupFlashPrintSetting()).attr("fitPaper", this.isFitPaper()).end();
        xMLPrintWriter.startTAG("PdfPrint").attr("popupPdfPrintSetting", this.isPopupPdfPrintSetting()).end();
        xMLPrintWriter.startTAG("AppletPrint").attr("popupAppletPrintSetting", this.isPopupAppletPrintSetting()).end();
        xMLPrintWriter.startTAG("writeShortCuts").attr("writeShortCuts", this.isWriteShortCuts()).end();
        if (StringUtils.isNotEmpty(this.errorTemplate)) {
            xMLPrintWriter.startTAG("ErrorHandler").attr("template", this.errorTemplate).end();
        }
        if (this.isPrintWidget()) {
            xMLPrintWriter.startTAG("PrintWidget").attr("print", true).end();
        }
    }

    private void writeSomeOther(XMLPrintWriter xMLPrintWriter) {
        if (this.platformConnection != null) {
            xMLPrintWriter.startTAG("PlatformConnection");
            this.platformConnection.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG(PRIVILEGE_TIMEOUT_XML);
        xMLPrintWriter.attr(DIGITAL_PRIVILEGE_XML, this.getDigitalPrivilegeTimeout());
        xMLPrintWriter.attr(USERNAME_PRIVILEGE_XML, this.getUsernamePrivilegeTimeout());
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG(EXPORT_FULL_IMAGE);
        if (this.exportFullImg4Excel) {
            xMLPrintWriter.attr("excel", this.exportFullImg4Excel);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG(EXCEL_ADJUST);
        if (this.excelAdjustHeight != 20.1f) {
            xMLPrintWriter.attr("height", this.getExcelAdjustHeight());
        }
        if (this.excelAdjustWidth != 34.742) {
            xMLPrintWriter.attr("width", this.getExcelAdjustWidth());
        }
        xMLPrintWriter.end();
    }

    public Parameter[] getGlobal_Parameters() {
        return this.globeParameters;
    }

    public void setGlobal_Parameters(Parameter[] parameterArray) {
        this.globeParameters = parameterArray;
    }

    public String getServletMapping() {
        return this.ServletMapping;
    }

    public void setServletMapping(String string) {
        this.ServletMapping = string;
    }

    public void checkManager() {
        if (configManager == null) {
            configManager = new ConfigManager();
            configManager.readXMLFile();
            ManagerFactory.registerConfigProvider(configManager);
        }
    }

    public void setErrorTemplate(String string) {
        this.errorTemplate = string;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public void setDownChromeFrameInLocal(boolean bl) {
        this.isDownChromeFrameInLocal = bl;
    }

    public boolean isDownChromeFrameInLocal() {
        return this.isDownChromeFrameInLocal;
    }

    public void setIncludeString(boolean bl) {
        this.isIncludeString = bl;
    }

    public boolean isIncludeString() {
        return this.isIncludeString;
    }

    public String getFlashInstallPath(Repository repository) {
        return repository.getBrowser().getFlashPlayerInstallerURL();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ConfigManager.envChanged();
            }
        });
    }
}

