/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.cache.AttachmentSource;
import com.fr.general.DateUtils;
import com.fr.general.Decrypt;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.PageCalObj;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.FormulaProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.ObjectTokenizer;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BaseObjectTokenizer
implements ObjectTokenizer {
    public Object tokenizerObject(XMLableReader xMLableReader, boolean bl, String string, ThreadLocal threadLocal) {
        if ("NULL".equals(string)) {
            return Primitive.NULL;
        }
        if (StringUtils.isBlank(string) || "S".equals(string) || "String".equals(string)) {
            String string2 = "";
            try {
                string2 = StableUtils.readSpecailString(GeneralXMLTools.elementValue(xMLableReader));
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            if (bl && string2 != null && string2.startsWith("=") && !string2.matches("^[\\=]+$")) {
                FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
                formulaProvider.setContent(string2);
                return formulaProvider;
            }
            return string2;
        }
        if ("D".equals(string) || "Double".equals(string)) {
            try {
                return Double.valueOf(GeneralXMLTools.elementValue(xMLableReader));
            }
            catch (NumberFormatException numberFormatException) {
                FRLogger.getLogger().error(numberFormatException.getMessage(), numberFormatException);
                return 0.0;
            }
        }
        if ("B".equals(string) || "Boolean".equals(string)) {
            return Boolean.valueOf(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("I".equals(string) || "Inteter".equals(string)) {
            return Integer.valueOf(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("L".equals(string) || "Long".equals(string)) {
            return Long.valueOf(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("F".equals(string) || "Float".equals(string)) {
            return Float.valueOf(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("BigInteger".equals(string)) {
            return new BigInteger(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("BigDecimal".equals(string)) {
            return new BigDecimal(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("Date".equals(string)) {
            return DateUtils.object2Date(GeneralXMLTools.elementValue(xMLableReader), true);
        }
        if ("FARRAY".equals(string)) {
            return xMLableReader.readXMLObject(new FArray());
        }
        if ("RFormula".equals(string)) {
            String string3 = xMLableReader.getAttrAsString("class", null);
            if (string3 == null || "RFormula".equals(string3)) {
                string3 = "com.fr.base.ResultFormula";
            }
            XMLable xMLable = null;
            try {
                xMLable = (XMLable)GeneralUtils.classForName(string3).newInstance();
                xMLableReader.readXMLObject(xMLable);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            return xMLable;
        }
        if ("Formula".equals(string)) {
            String string4 = xMLableReader.getAttrAsString("class", null);
            if (string4 == null || "Formula".equals(string4)) {
                string4 = "com.fr.base.Formula";
            }
            XMLable xMLable = null;
            try {
                xMLable = (XMLable)GeneralUtils.classForName(string4).newInstance();
                xMLableReader.readXMLObject(xMLable);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            return xMLable;
        }
        if ("WidgetName".equals(string)) {
            String string5 = xMLableReader.getAttrAsString("class", null);
            if (string5 == null || "WidgetName".equals(string5)) {
                string5 = "com.fr.stable.js.WidgetName";
            }
            XMLable xMLable = null;
            try {
                xMLable = (XMLable)GeneralUtils.classForName(string5).newInstance();
                xMLableReader.readXMLObject(xMLable);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            return xMLable;
        }
        if ("Image".equals(string)) {
            XMLObject xMLObject = new XMLObject(null){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        if (xMLableReader.getTagName().equals("IM")) {
                            this.obj = GeneralXMLTools.readImage(xMLableReader);
                        } else if ("Image".equals(xMLableReader.getTagName())) {
                            this.obj = GeneralXMLTools.deprecatedReadImage(xMLableReader);
                        }
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            return xMLObject.getObject();
        }
        if ("Parameter".equals(string)) {
            return StableXMLUtils.readParameter(xMLableReader);
        }
        if ("Attachment".equals(string)) {
            return AttachmentSource.getAttachment(GeneralXMLTools.elementValue(xMLableReader));
        }
        if ("Attachments".equals(string)) {
            String[] stringArray = GeneralXMLTools.elementValue(xMLableReader).split(",");
            FArray fArray = new FArray();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                fArray.add(AttachmentSource.getAttachment(stringArray[i2]));
            }
            return fArray;
        }
        if ("Encrypt".equals(string)) {
            return new Decrypt(GeneralXMLTools.elementValue(xMLableReader), "655");
        }
        if ("PCOBJ".equals(string)) {
            XMLObject xMLObject = new XMLObject(null){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("PCOBJ")) {
                        PageCalObj pageCalObj = new PageCalObj(null);
                        this.obj = xMLableReader.readXMLObject(pageCalObj);
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            return xMLObject.getObject();
        }
        if ("XMLable".equals(string)) {
            XMLable xMLable = null;
            String string6 = xMLableReader.getAttrAsString("class", null);
            if (string6 != null) {
                try {
                    xMLable = (XMLable)GeneralUtils.classForName(string6).newInstance();
                    xMLableReader.readXMLObject(xMLable);
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
            return xMLable;
        }
        return null;
    }
}

