/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report;

import com.fr.adhoc.report.ADHOCReport;
import com.fr.adhoc.report.core.ADHOCAddColumn;
import com.fr.adhoc.report.core.ADHOCChart;
import com.fr.adhoc.report.core.ADHOCGroupColumn;
import com.fr.adhoc.report.core.ADHOCSummaryColumn;
import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.data.condition.ListCondition;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.file.DatasourceManager;
import com.fr.general.GeneralUtils;
import com.fr.general.data.Condition;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.TemplateCellElement;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class NormalADHOCReport
implements ADHOCReport,
XMLable {
    private String viewName;
    private String title;
    private String subtitle;
    private ADHOCSummaryColumn[] summaryColumns;
    private Condition condition;
    protected ADHOCChart chartDefine;
    protected Map cellSettingMap;
    private ADHOCAddColumn[] addedColumns;
    private ADHOCGroupColumn[] groupColumn;
    private List addCells = new ArrayList();
    private List addTitle = new ArrayList();
    private List addBottom = new ArrayList();
    private Map calSupportCellMap = new HashMap();
    protected Map addedCellMap = new HashMap();
    protected static DecimalFormat percentFormat = new DecimalFormat();
    protected static DecimalFormat decimalFormat;

    protected void addCell(String string, int n2) {
        this.addedCellMap.put(string, new Integer(n2));
    }

    protected void addCell(Long l2, String string) {
        this.calSupportCellMap.put(l2, string);
    }

    protected String getCellCal(Long l2) {
        return (String)this.calSupportCellMap.get(l2);
    }

    protected int getAddedColumns() {
        int n2 = 0;
        if (this.addedColumns != null) {
            for (int i2 = 0; i2 < this.addedColumns.length; ++i2) {
                if (this.addedColumns[i2] == null) continue;
                n2 += this.addedColumns[i2].getAddColumns();
            }
        }
        return n2;
    }

    protected ADHOCGroupColumn getGroupColumn(String string) {
        if (string == null) {
            return null;
        }
        if (this.groupColumn == null || this.groupColumn.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.groupColumn.length; ++i2) {
            if (!string.equals(this.groupColumn[i2].getColumnName())) continue;
            return this.groupColumn[i2];
        }
        return null;
    }

    protected ADHOCAddColumn getADHOCAddColumn(String string) {
        for (int i2 = 0; i2 < this.addedColumns.length; ++i2) {
            ADHOCAddColumn aDHOCAddColumn = this.addedColumns[i2].getADHOCAddColumn(string);
            if (aDHOCAddColumn == null) continue;
            return aDHOCAddColumn;
        }
        return null;
    }

    public TableData getADHOCData() {
        if (StringUtils.isEmpty(this.getViewName())) {
            return null;
        }
        return DatasourceManager.getInstance().getADHOC(this.getViewName());
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String string) {
        this.subtitle = string;
    }

    public ADHOCSummaryColumn[] getSummaryColumns() {
        return this.summaryColumns;
    }

    public void setSummaryColumns(ADHOCSummaryColumn[] aDHOCSummaryColumnArray) {
        this.summaryColumns = aDHOCSummaryColumnArray;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    protected void addAddCell(TemplateCellElement templateCellElement) {
        this.addCells.add(templateCellElement);
    }

    protected List getAddedCells() {
        return this.addCells;
    }

    protected void addAddedTitle(TemplateCellElement templateCellElement) {
        this.addTitle.add(templateCellElement);
    }

    protected List getAddedTitleCells() {
        return this.addTitle;
    }

    protected void addAddedBottom(TemplateCellElement templateCellElement) {
        this.addBottom.add(templateCellElement);
    }

    protected List getAddedBottomCells() {
        return this.addBottom;
    }

    protected int titleAppend() {
        int n2 = 2;
        if (this.chartDefine != null) {
            n2 += 14;
        }
        return n2;
    }

    public JSONObject createJSON() throws Exception {
        int n2;
        JSONArray jSONArray;
        JSONObject jSONObject = new JSONObject();
        if (this.viewName != null) {
            jSONObject.put("viewname", this.viewName);
        }
        if (this.title != null) {
            jSONObject.put("title", this.title);
        }
        if (this.subtitle != null) {
            jSONObject.put("subtitle", this.subtitle);
        }
        if (!ArrayUtils.isEmpty(this.summaryColumns)) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < this.summaryColumns.length; ++n2) {
                jSONArray.put(this.summaryColumns[n2].createJSON());
            }
            jSONObject.put("summaryColumn", jSONArray);
        }
        if (this.condition != null) {
            jSONObject.put("condition", this.condition.createJSON());
        }
        if (this.chartDefine != null) {
            jSONObject.put("chart", this.chartDefine.createJSON());
        }
        if (this.cellSettingMap != null) {
            jSONObject.put("cellSettings", BaseUtils.map2JSON(this.cellSettingMap));
        }
        if (this.addedColumns != null) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < this.addedColumns.length; ++n2) {
                jSONArray.put(this.addedColumns[n2].createJSON());
            }
            jSONObject.put("addedCells", jSONArray);
        }
        if (this.groupColumn != null) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < this.groupColumn.length; ++n2) {
                jSONArray.put(this.groupColumn[n2].createJSON());
            }
            jSONObject.put("groupSettings", jSONArray);
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        Object object;
        int n2;
        Object object2;
        if (jSONObject.has("title")) {
            this.setTitle(jSONObject.getString("title"));
        }
        if (jSONObject.has("subtitle")) {
            this.setSubtitle(jSONObject.getString("subtitle"));
        }
        this.setViewName(jSONObject.getString("viewname"));
        if (jSONObject.has("summaryColumn")) {
            object2 = jSONObject.getJSONArray("summaryColumn");
            n2 = ((JSONArray)object2).length();
            object = new ADHOCSummaryColumn[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                ADHOCSummaryColumn aDHOCSummaryColumn = new ADHOCSummaryColumn();
                aDHOCSummaryColumn.parseJSON(((JSONArray)object2).getJSONObject(i2));
                object[i2] = aDHOCSummaryColumn;
            }
            this.setSummaryColumns((ADHOCSummaryColumn[])object);
        }
        if (jSONObject.has("condition")) {
            object2 = new ListCondition();
            ((ListCondition)object2).parseJSON(jSONObject.getJSONObject("condition"));
            this.setCondition((Condition)object2);
        }
        if (jSONObject.has("chart")) {
            this.chartDefine = new ADHOCChart();
            this.chartDefine.parseJSON((JSONObject)jSONObject.get("chart"));
        }
        if (jSONObject.has("cellSettings")) {
            this.cellSettingMap = GeneralUtils.json2Map((JSONObject)jSONObject.get("cellSettings"));
        }
        if (jSONObject.has("addedCells")) {
            object2 = jSONObject.getJSONArray("addedCells");
            this.addedColumns = new ADHOCAddColumn[((JSONArray)object2).length()];
            for (n2 = 0; n2 < ((JSONArray)object2).length(); ++n2) {
                object = new ADHOCAddColumn();
                ((ADHOCAddColumn)object).parseJSON(((JSONArray)object2).getJSONObject(n2));
                this.addedColumns[n2] = object;
            }
        }
        if (jSONObject.has("groupSettings")) {
            object2 = jSONObject.getJSONArray("groupSettings");
            this.groupColumn = new ADHOCGroupColumn[((JSONArray)object2).length()];
            for (n2 = 0; n2 < ((JSONArray)object2).length(); ++n2) {
                object = new ADHOCGroupColumn();
                ((ADHOCGroupColumn)object).parseJSON(((JSONArray)object2).getJSONObject(n2));
                this.groupColumn[n2] = object;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NormalADHOCReport normalADHOCReport = (NormalADHOCReport)super.clone();
        if (!ArrayUtils.isEmpty(this.summaryColumns)) {
            for (int i2 = 0; i2 < this.summaryColumns.length; ++i2) {
                normalADHOCReport.summaryColumns[i2] = (ADHOCSummaryColumn)this.summaryColumns[i2].clone();
            }
        }
        return normalADHOCReport;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("VN".equals(string)) {
                this.viewName = xMLableReader.getElementValue();
            } else if ("Title".equals(string)) {
                this.title = xMLableReader.getElementValue();
            } else if ("SubTitle".equals(string)) {
                this.subtitle = xMLableReader.getElementValue();
            } else if ("SCArray".equals(string)) {
                this.summaryColumns = new ADHOCSummaryColumn[xMLableReader.getAttrAsInt("len", 0)];
                xMLableReader.readXMLObject(new XMLReadable(){
                    private int size = 0;

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "SC".equals(xMLableReader.getTagName())) {
                            ADHOCSummaryColumn aDHOCSummaryColumn = new ADHOCSummaryColumn();
                            xMLableReader.readXMLObject(aDHOCSummaryColumn);
                            ((NormalADHOCReport)NormalADHOCReport.this).summaryColumns[this.size] = aDHOCSummaryColumn;
                            ++this.size;
                        }
                    }
                });
            } else if ("Condition".equals(string)) {
                this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
            } else if ("chart".equals(string)) {
                try {
                    this.chartDefine = new ADHOCChart();
                    this.chartDefine.parseJSON(new JSONObject(xMLableReader.getElementValue()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            } else if ("cellSettingMap".equals(string)) {
                try {
                    this.cellSettingMap = GeneralUtils.jsonString2Map(xMLableReader.getElementValue());
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                }
            } else if ("addedColumns".equals(string)) {
                this.addedColumns = new ADHOCAddColumn[xMLableReader.getAttrAsInt("len", 0)];
                xMLableReader.readXMLObject(new XMLReadable(){
                    private int size = 0;

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "AAC".equals(xMLableReader.getTagName())) {
                            try {
                                ADHOCAddColumn aDHOCAddColumn = new ADHOCAddColumn();
                                aDHOCAddColumn.parseJSON(new JSONObject(xMLableReader.getElementValue()));
                                ((NormalADHOCReport)NormalADHOCReport.this).addedColumns[this.size] = aDHOCAddColumn;
                                ++this.size;
                            }
                            catch (Exception exception) {
                                FRContext.getLogger().error(exception.getMessage(), exception);
                            }
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        if (this.viewName != null) {
            xMLPrintWriter.startTAG("VN").textNode(this.viewName).end();
        }
        if (this.title != null) {
            xMLPrintWriter.startTAG("Title").textNode(this.title).end();
        }
        if (this.subtitle != null) {
            xMLPrintWriter.startTAG("SubTitle").textNode(this.subtitle).end();
        }
        if (!ArrayUtils.isEmpty(this.summaryColumns)) {
            xMLPrintWriter.startTAG("SCArray").attr("len", this.summaryColumns.length);
            for (n2 = 0; n2 < this.summaryColumns.length; ++n2) {
                xMLPrintWriter.startTAG("SC");
                this.summaryColumns[n2].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
        try {
            if (this.chartDefine != null) {
                xMLPrintWriter.startTAG("chart").textNode(this.chartDefine.createJSON().toString()).end();
            }
            if (this.cellSettingMap != null) {
                xMLPrintWriter.startTAG("cellSettingMap").textNode(BaseUtils.map2JSON(this.cellSettingMap).toString()).end();
            }
            if (!ArrayUtils.isEmpty(this.addedColumns)) {
                xMLPrintWriter.startTAG("addedColumns").attr("len", this.addedColumns.length);
                for (n2 = 0; n2 < this.addedColumns.length; ++n2) {
                    xMLPrintWriter.startTAG("AAC").textNode(this.addedColumns[n2].createJSON().toString()).end();
                }
                xMLPrintWriter.end();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    static {
        percentFormat.applyPattern("0.0%");
        decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern("0.00");
    }
}

