/// <reference path="../intellisense/jquery-1.2.6-vsdoc-cn.js" />
/****************************************
author:xuanye.wan@gmail.com
***************************************/
(function($) {
    $.fn.swapClass = function(c1, c2) {
        return this.removeClass(c1).addClass(c2);
    }
    $.fn.treeview = function(settings) {
        var dfop =
            {
                method: "POST",
                datatype: "json",
                url: false,
                onnodeclick: null,
                data: null,
                clicktoggle: true, //ڵչӽڵ
                theme: "fr-tree-lines", //fr-tree-lines ,fr-tree-no-lines,fr-tree-arrows
                nodeSortable : false   // ڵǷ
            }

        $.extend(dfop, settings);
        if (!dfop.data) {
        	dfop.data = [];
        }
        var treenodes = dfop.data;
        var nodeSortable = dfop.nodeSortable;
        var sorthandle = dfop.sorthandle;
        var treenodespath = 0;
        var me = this;
        var id = me.attr("id");
        if (id == null || id == "") {
            id = "bbtree" + new Date().getTime();
            me.attr("id", id);
        }

        var html = [];

        buildtree(dfop.data, html);
        me.addClass("fr-tree").html(html.join(""));
        if (nodeSortable) {
        	sortnode($("ul", me));
        }
        InitEvent(me);
        html = null;
        
        function sortnode($el) {
        	$.each($el, function(idx, ul) {
	        	var $ul = $(ul);
	        	var lis = $ul.children("li");
	        	if (lis.length >= 2) {
	        		$ul.sortable({
	        			items : lis,
						axis : 'y',
						opacity : '0.8',
						helper : 'clone',
						start : function(event, ui) {
							beforeDrag = $ul.children("li").index(ui.item);
						},
						stop : function(event, ui) {
							afterDrag = $ul.children("li").index(ui.item);
							if((beforeDrag != afterDrag) && (beforeDrag >= 0) && (afterDrag >= 0)) {
								var tpath = ui.item.children("div:eq(0)").attr("tpath");
								var lis = $ul.children("li");
								var aindex = (afterDrag < lis.length - 1) ? afterDrag + 1 : lis.length - 2;
								var atpath = $($ul.children("li")[aindex]).children("div:eq(0)").attr("tpath");
								var beforeDragNode = getItem(tpath);
								var afterDragNode = getItem(atpath);
								
								if (sorthandle) {
									sorthandle.call(this, beforeDrag, afterDrag, lis.length, beforeDragNode, afterDragNode);
								}
							}
						}
	        		});
	        	}
	        }).disableSelection();
        }
        
        function modifyTPath4sort(from, to, $ul, aps) {
        	for (var i = from; i < to; i++) {
        		$($ul.children("li")[i]).children("div:eq(0)").attr("tpath", aps + i);
        	}
        }

        function buildtree(data, ht) {
            ht.push("<div class='fr-tree-bwrap'>"); // Wrap ;
            ht.push("<div class='fr-tree-body'>"); // body ;
            ht.push("<ul class='fr-tree-root ", dfop.theme, "'>"); //root
            if (data) {
            	treenodespath = data.length;
			    for (var i = 0; i < data.length; i++) {
			    	if (verifyNeedFolderNode(data[i])) {
			        	buildnode(data[i], ht, 0, i);
			        }
			    } 
            }
            ht.push("</ul>"); // root and;
            ht.push("</div>"); // body end;
            ht.push("</div>"); // Wrap end;
        }
        //endregion
        function buildnode(nd, ht, deep, path) {
            ht.push("<li class='fr-tree-node'>");
            ht.push("<div id='", id, "_", nd.id, "' tpath='", path, "' title='", nd.text, "' unselectable='on'");
            var cs = [];
            cs.push("fr-tree-node-el");
            if (nd.hasChildren) {
                cs.push(nd.isexpand ? "fr-tree-node-expanded" : "fr-tree-node-collapsed");
            }
            else {
                cs.push("fr-tree-node-leaf");
            }
            if (nd.classes) { cs.push(nd.classes); }

            ht.push(" class='", cs.join(" "), "'>");
            //span indent
            ht.push("<span class='fr-tree-node-indent'>");

            for (var i = 0; i <= deep; i++) {
            	if(nd.hasChildren && i == deep) {
            		ht.push("<img class=" + (nd.isexpand ? "'fr-tree-elbow-minus'" : "'fr-tree-elbow-plus'") +  "src=" + FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/schedule/css/s.gif>");		
            	}else {
            		ht.push("<img class='fr-tree-icon' src=" + FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/schedule/css/s.gif>");
            	}
            }
            
            ht.push("</span>");
            //img
            cs.length = 0;

            ht.push("<img class='fr-tree-ec-icon ", cs.join(" "), "' src=" + FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/schedule/css/s.gif>");
            ht.push("<img class='fr-tree-node-icon' src=" + FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/schedule/css/s.gif>");
            //a
            ht.push("<a hideFocus class='fr-tree-node-anchor' tabIndex=1 href='javascript:void(0);'>");
            ht.push("<span unselectable='on'>", nd.text, "</span>");
            ht.push("</a>");
            ht.push("</div>");
            //Child
            if (nd.hasChildren) {
                if (nd.isexpand) {
                	ht.push('<ul>');
                    if (nd.ChildNodes) {
		                deep++;
			            for (var i = 0; i < nd.ChildNodes.length; i++) {
			                	nd.ChildNodes[i].parent = nd;
			                	if (verifyNeedFolderNode(nd.ChildNodes[i])) {
			                		buildnode(nd.ChildNodes[i], ht, deep, path + "." + i);
			               	 	}
			           	}
                    }
                    ht.push("</ul>");
                }
                else {
                    ht.push("<ul style='display:none;'></ul>");
                }
            }
            ht.push("</li>");
            nd.render = true;
        }
        
        function filterData(data) {
        	if (dfop.onlyfolder) {
        		
        	} 
        }
        
        function getFolderNodesLength(data) {
        	 var filter = [];		
            //ֻļ folder.type == 0
            if (dfop.onlyfolder) {
            	$.each(data, function(i) {      
            		if (data[i].type === 0) {
            			filter.push(data[i]);
            		}
            	});           		
            } else {
            	filter = data;
            }
            return filter.length;
        }
        
        function verifyNeedFolderNode(data) {
        	if ((dfop.onlyfolder && data.type === 0) || !dfop.onlyfolder) {
        		return true;
        	} 
        	return false;
        }
        
        function getItem(path) {
            var ap = path.split(".");
            var t = treenodes;
            for (var i = 0; i < ap.length; i++) {
                if (i === 0) {
                    t = t[ap[i]];
                }
                else {
                    t = t.ChildNodes[ap[i]];
                }
            }
            return t;
        }
        
		function setCurrentItem(item) {
			if (dfop.citem) {
		        $("#" + id + "_" + dfop.citem.id).removeClass("fr-tree-selected");
            }
            dfop.citem = item;
            if (item) {
            	$("#" + id + "_" + dfop.citem.id).addClass("fr-tree-selected");
            	if (dfop.onnodeclick) {
	               dfop.onnodeclick.call();
	         	}
            }
		}
		
        function nodeclick(e) {
            var path = $(this).attr("tpath");
            var et = e.target || e.srcElement;
            var item = getItem(path);

            //debugger;
            if (e.type == "dblclick" || et.tagName == "IMG") {
                // +Ҫչ
                if ($(this).hasClass("fr-tree-node-collapsed")) {
                    var ul = $(this).next(); //"fr-tree-node-ct"
                    if (ul.hasClass("fr-tree-node-ct")) {
                        ul.show();
                    }
                    else {
                        var deep = path.split(".").length;
                        if (item.complete) {
                            item.ChildNodes != null && asnybuild(item.ChildNodes, deep, path, ul, item);
                        }
                        else {
                            $(this).addClass("fr-tree-node-loading");
                            asnyloadc(ul, item, function(data) {
                                item.complete = true;
                                item.ChildNodes = data;
                                asnybuild(data, deep, path, ul, item);
                            });
                        }
                    }
                  
                    $(this).swapClass("fr-tree-node-collapsed", "fr-tree-node-expanded");
                    $(".fr-tree-elbow-plus", $(this)).switchClass('fr-tree-elbow-minus');
                    this.title = 'Hide';
                }
                else if ($(this).hasClass("fr-tree-node-expanded")) {                   
                    $(this).next().hide();
                    
                    $(this).swapClass("fr-tree-node-expanded", "fr-tree-node-collapsed");
                    $(".fr-tree-elbow-minus", $(this)).switchClass('fr-tree-elbow-plus');
                    this.title = 'Expand';
                }
            }
            else {
                setCurrentItem(item);
            }
        }
        
        function asnybuild(nodes, deep, path, ul, pnode) {
            var ht = [];
            for (var i = 0; i < nodes.length; i++) {
                nodes[i].parent = pnode;
                if (verifyNeedFolderNode(nodes[i])) {
                	buildnode(nodes[i], ht, deep, path + "." + i);
                }
            }
            ul.html(ht.join(""));
            ht = null;
            if (nodeSortable) {
        		sortnode(ul);
        	}
            InitEvent(ul);
            ul.addClass("fr-tree-node-ct").css({ "z-index": 0, position: "static", visibility: "visible", top: "auto", left: "auto", display: "" });
            ul.prev().removeClass("fr-tree-node-loading");
        }
        
        function addRootNode(rt, ul) {
        	var html = [];
        	buildnode(rt, html, 0, treenodespath);
        	treenodespath++;
        	var root = $(html.join(""));
        	ul.append(root);
        	treenodes.push(rt);
            html = null;
            if (nodeSortable) {
        		sortnode(ul);
        	}
            InitEvent(ul);
        }
        
        function asnyloadc(pul, pnode, callback) {
            if (dfop.url) {
                var param = builparam(pnode);
                FR.ajax({
                    type: dfop.method,
                    url: dfop.url,
                    data: param,
                    dataType: dfop.datatype,
                    success: callback,
                    error: function(e) { alert("error occur!"); }
                });
            }
        }
        
        function builparam(node) {
            var p = [{ name: "id", value: encodeURIComponent(node.id) }
                    , { name: "text", value: encodeURIComponent(node.text) }
                    , { name: "value", value: encodeURIComponent(node.value) }];
            return p;
        }
        
        function InitEvent(parent) {
            var nodes = $("li.fr-tree-node>div", parent);
            nodes.each(function(e) {
                $(this).hover(
					function() {
						$(this).addClass("fr-tree-node-over");
					},
					function() {
						$(this).removeClass("fr-tree-node-over");
					}
				)//hover
                .click(nodeclick)
                .dblclick(nodeclick);
            });
        }
        
       	function delItem(pitem,id) {//ɾһӽڵ
			var items = pitem.ChildNodes;
			for(var i=0;i<items.length;i++){
 		  		if(items[i].id == id){
//  		 			for(var j=i;j+1<items.length;j++){
//  		 				items[j]=items[j+1];
//  		 			}
//   					items.pop();
					items.splice(i, 1);
   					break;
      			}//if
 		  	}
		}
		
		function delRoot(node) {
			var rootDiv = $("div#" + id + "_" + node.id);
			setCurrentItem(undefined);
			treenodespath--;
			$.each(treenodes, function(i) {
				if (treenodes[i] == node) {
					treenodes.splice(i, 1);
					return false;
				}
			});
			if (rootDiv.length === 1) {
				rootDiv.parent("li").remove();
			} else {
				$.each(rootDiv, function(i) {
					if (rootDiv[i].parent().parent() == $(".fr-tree-root")) {
						rootDiv[i].parent().remove();
					}
				});
			}
		}
		
        me[0].t = {
            getCurrentItem: function() {
                return dfop.citem;
            },
            
            addNode : function(pitem,item) {
            	if (!pitem) {
            		var ul = $(".fr-tree-root");
            		addRootNode(item, ul);
            		return;
            	}
            	if(!pitem.ChildNodes){
            		pitem.ChildNodes = [];
            	}
            	pitem.ChildNodes.push(item);
            	var pnode = $("#" + id + "_" + pitem.id);
            	var path = pnode.attr("tpath");
            	var deep = path.split(".").length;
            	var ul = pnode.next();
            	asnybuild(pitem.ChildNodes, deep, path, ul, pitem);
            	pnode.click();
            },
            
            editNode : function(item) {
            	var citem = dfop.citem;
            	if (citem != null && item != null) {
            		citem.description = item.description;
            		citem.text = item.text;
            		$("#" + id + "_" + item.id + ' a span').text(item.text);
            	}
            },
            
            delNodes : function(pitem,ids) {
            	if (!ids) {
            		delRoot(pitem);
            		return;
            	}
            	for(var i=0;i<ids.length;i++){
            		delItem(pitem,ids[i]);
            	}
            	var pnode = $("#" + id + "_" + pitem.id);
            	var path = pnode.attr("tpath");
            	var deep = path.split(".").length;
            	var ul = pnode.next();
            	asnybuild(pitem.ChildNodes, deep, path, ul, pitem);
            	pnode.click();
            },
            getData : function() {
            	return dfop.data;
            },
            getNode : function(cid) {
            	var node = $("#" + id + "_" + cid);
            	return node;
            },
            
            setNode : function(item) {
            	setCurrentItem(item);
            }
        };
        
        //b:Ĭѡеһڵ
        if (treenodes.length > 0) {
        	if (dfop.onlyfolder) {
            	$.each(treenodes, function(i) {      
            		if (treenodes[i].type === 0) {
            			setCurrentItem(treenodes[i]);
            			return false;
            		}
            	});           		
            } else {
            	setCurrentItem(treenodes[0]);
            }
        }
    }
//ȡѡеĽڵItem
    $.fn.getTCT = function() {
        if (this[0].t) {
            return this[0].t.getCurrentItem();
        }
        return null;
    }
	$.fn.addNode = function(pitem,item) {
		if (this[0].t) {
            this[0].t.addNode(pitem,item);
        }
	}
	
	$.fn.editNode = function(item) {
		if (this[0].t) {
			this[0].t.editNode(item);
		}
	},
	
	$.fn.setCurrentItem = function(item) {
		if (this[0].t) {
			this[0].t.setNode(item);
		}
	},
	
	$.fn.delNode = function(item) {
		if (this[0].t) {
			if (item.parent) {
				this[0].t.delNodes(item.parent,[item.id]);
			} else {
				this[0].t.delNodes(item);
			}
		}
	}
	$.fn.delNodes = function(pitem,ids) {
		if (this[0].t) {
			this[0].t.delNodes(pitem,ids);
		}
	}
	$.fn.getData = function() {
		if (this[0].t) {
			return this[0].t.getData();
		}
		return null;
	}
	$.fn.getNode = function(cid) {
		if (this[0].t) {
			return this[0].t.getNode(cid);
		}
		return null;
	}
	$.fn.getPath = function(item) {
		var path = "\/"+item.text;
		if(item.parent){
			path = this.getPath(item.parent) + path;
		}
		return path;
	}

})(jQuery);