/*
 * b/sʵֵJControlPane
 */
(function($){
	$.extend(FR.ListEditor.prototype, {
		jlist : function(opts) {
			this.options = $.extend({
				initaction:false,
				operation : {addaction:false, deleteaction:false, renameaction:false},
				cpPrefix: "_list_",
				iconpath:FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/platform/jlist/user.png",
				addiconpath:FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/platform/jlist/add.png",
				deleteiconpath:FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/platform/jlist/delete.png",
				editiconpath:FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/platform/jlist/user_edit.png"
			}, this.options);
			if(opts){
				this.options.needHead = opts.needHead;
			}
			this.element.addClass("fr-list-bwrap");
			var id = this.id = this.element.attr('id');
			if (id == null || id == '') {
				this.id = "jquery_jlist" + new Date().getTime();
            	this.element.attr("id", id);
			}
			if (this.options.multi) {
				this.selectedLis = [];
			}
			this.isLoading = false;
	        var data = this.options.data;
	        data.resetStatus(this.allPara());
	        var self = this;
	        data.afterRead(function(records) {
	        	var me = self.element;
	        	me.empty();
	        	me.__loadingMoreData__(true);
	        	self.buildControlList(records);
	        	self.fireEvent(FR.Events.DEFAULTINIT);
	        	me.__loadingMoreData__(false);
	        	self.isLoading = false;
	        });
	        data.appendDataEvent(function(records) { 	
		    	self.addData2View(records);    	
		    	self.element.__loadingMoreData__(false);
		    	self.isLoading = false; 
	        });
	        data.loadData();  
			if (this.options.initaction){ 
				this.options.initaction.apply(this, arguments);
			}
	        this.scrollEvent();
		},
		
		checkViewScroll : function(data) {
	    	if (data.length < FR.limitData) {
	    		this.need2Scroll = false;
	    	} else {
	    		this.need2Scroll = true;
	    	}  
    	},
        
        scrollEvent : function() {
        	var self = this;
        	this.element.scroll(function() {
   				if (self.need2Scroll && $(this).scrollTop() + $(this).height() == this.scrollHeight) {
   					self.scrollLoadMoreData();
   				}
   			});
        },
        
        scrollLoadMoreData : function() {
        	if (this.isLoading) {
        		return;
        	}
        	this.isLoading = true;
        	this.element.__loadingMoreData__(true);
        	var data = this.options.data;
	    	data.resetStatus(this.allPara(data.getLength()));
	    	data.loadData();
	    },
	    
	    allPara : function(start, limit) {
	    	var para = this.createDependencePara4Data();
	    	if (this.searchText || this.searchText === 0) {
	    		para.parameter.filter = this.searchText;
	    	}
	
	    	para.parameter.startIndex = start ? start : 0;
	    	para.parameter.limitIndex = limit ? limit : this.options.limitData;
	    	return para;
	    },
	    
	    addData2View : function(data, ul) {
	    	this.checkViewScroll(data);
	    	var ulContent = ul ? ul : $('ul.fr-list-content', this.element);
	    	var frag = document.createDocumentFragment();
	    	var startIndex = $('li', ulContent).length;
	    	var o = this.options;
	    	for (var i = 0, len = data.length; i < len; i++) {
	    		var li = this.createLi(data[i], i + startIndex);
	    		this.initLiEvent(li);
	    		var isEven = i%2 === 0;
	    		if(FR.isArray(o.background)){
	    			if(isEven){
	    				li.css('background', o.background[0]);
	    			} else {
	    				li.css('background', o.background[1]);
	    			}
	    		} else {
	    			if(isEven){
	    				li.css('background', o.background);
	    			}
	    		}
	    		frag.appendChild(li[0]);
	    	}
			ulContent[0].appendChild(frag);
	    },
	    
	    clearSelected : function () {
	    	$('.fr-list-node', this.element).removeClass('fr-list-node-selected');
	    	this.fireEvent(FR.Events.NOSELECT);
	    },
	    
	    getSortedAll : function () {
	    	var self = this;
	    	var items = $('.fr-list-node', this.element);
	    	var all = [];
	    	var textlength = (this.id + this.options.cpPrefix).length
	    	$.each(items, function(idx, item){
	    		var id = $(item).attr('id');
	    		id = id.substr(textlength);
	    		all.push(self.getValueByIndex(id));
	    	});
	    	return all;
	    },
	    
	    getValueByIndex : function(index) {
	    	 var nd = this.options.data.getRecord(index);
		     return {text: nd.getShowValue(), value : nd.getValue() != null ? nd.getValue() : nd.getShowValue()};
	    },
	  
	    reBuildBackground : function(){
	    	var li = $('.fr-list-node', this.element);
	    	$.each(li, function(idx, item){
	    		if (idx % 2 === 0) {
	    			$(this).removeClass('fr-list-node-odd');
	    			$(this).addClass('fr-list-node-even');
	    		} else {
	    			$(this).removeClass('fr-list-node-even');
	    			$(this).addClass('fr-list-node-odd');
	    		}
	    	});
	    	var o = this.options;
	    	if(FR.isArray(o.background)){
	    		$('.fr-list-node-even', this.element).css('background', o.background[0]);
	    		$('.fr-list-node-odd', this.element).css('background', o.background[1]);
	    	} else {
	    		$('.fr-list-node-even', this.element).css('background', o.background);
	    	}
	    },
	    
	    createLi : function(record, index) {
	    	var li = $('<li/>').addClass('fr-list-node').attr('id', this.id + this.options.cpPrefix + index);
	    	var dc = $('<div/>').addClass('fr-list-node-el');
	    	/*b:objectʱԱȵiconӰ*/
	    	var self = this;
	    	if (this.options.multi) {   			    		
	    		var checkbox = new FR.CheckBox();
	    		checkbox.on(FR.Events.STATECHANGE, function() {
	    			if (this.isSelected()) {
	    				self.selectedLis.push(this);
	    			} else {
	    				self.selectedLis.remove(this);
	    			}
	    		});
	    		li.data('checkbox', checkbox);	    		
	    		dc.append(checkbox.element.children());
	    	}
	    	if (this.options.expand && record.getContent().childMenu) {
		    	var config = {
			        destroyOnClose : false,
			        minWidth : 120,
			        items : []
			    };
			    li.menu = new FR.frMenu(config);
			    li.menu.close();
	    		$('<span>&nbsp;</span>').addClass(this.options.expand).css({'float' : 'right'})
	    			.appendTo(dc).mouseover(function() {
	    				li.menu.$menuRoot.empty()
	    				li.menu.addItems(record.getContent().childMenu());
	    				li.menu.show();
	    				var p = $(this).offset();
	    				li.menu.position(p.left + 10, p.top - 5);
	    			}).mouseout(function(e) {
	    				if (e.pageX < parseInt(li.menu.$menuRoot.css('left'))) {
	    					li.menu.close();
	    				}
	    			});
	    	}

	    	if (this.options.removeSelf) {
	    		$('<span>&nbsp;</span>').addClass(this.options.removeSelf).css({'padding-left' : '16px', 'float' : 'right'})
	    			.appendTo(dc).click(function(e) {
	    				var li = $(this).parent().parent();
	    				if (self.options.removeConfirm) {
	    					self.options.removeConfirm(function() {
	    						self.removeItem(li);
	    					});
	    				} else {
	    					self.removeItem(li);
	    				}	    				
	    			}).mouseover(function() {
	    				$(this).addClass('fr_hover');
	    			}).mouseout(function() {
	    				$(this).removeClass('fr_hover');
	    			});
	    	}
	    	var icon = record.getContent().icon || this.options.icon;
	    	if (icon) {
	    		$('<span>&nbsp;</span>').addClass(icon).css('padding-left', '16px').appendTo(dc);
	    	}
	    	return li.append(dc.append($("<a hideFocus class='fr-list-node-anchor' tabIndex=1></a>")
	    		.append(this.options.showAsHtml
                    ? $("<span unselectable='on'/>").html(record.getShowValue())
                    : $("<span unselectable='on'/>").text(record.getShowValue())
                    .attr("title",record.getShowValue()))));
	    },
	    
        buildControlList : function(data) {
        	var cd = $('<div class="fr-list-body"/>');
        	if (this.options.needHead) {
        		cd.append(this.createHeader());
        	}
        	var ul = $('<ul class="available fr-list-content"/>');
        	cd.append(ul);
        	this.addData2View(data, ul);
        	this.element.append(cd);
        	if (this.options.draggable) {
				FR.$defaultImport('/com/fr/web/core/js/ui/jquery.ui.sortable.js', 'js');
				ul.sortable({items:'li',opacity:0.8, helper:'clone', axis:this.options.axis}).disableSelection();
				if (this.options.outside) {
					//ϵбҪǿøߺͿ,б߶Զ᲻ȷ
					ul.height(this.options.height).width(this.options.width);
					ul.css('position', 'inherit');
					cd.css('position', 'inherit');
				}
			}
        },
        
        /*b:roleListùto improve or remove*/
        createHeader : function(){
            var ops = [$('<span class="fr-list-operation">').append($('<img class="fr-list-operation-add"/>').attr('src', this.options.addiconpath)),
        		$('<span class="fr-list-operation">').append($('<img class="fr-list-operation-delete"/>').attr('src', this.options.deleteiconpath)),
        		$('<span class="fr-list-operation">').append($('<img class="fr-list-operation-edit"/>').attr('src', this.options.editiconpath))];
        	var self = this;
        	$.each(ops, function(i, sp) {
        		$(sp).bind('click.operation', function(event) {
        			self.operation(event);
        		});
        	});
        	return $('<div class="fr-list-header"/>').append(ops[0]).append(ops[1]).append(ops[2]);        
        },
		initLiEvent : function(li) {
			var self = this;
			li.hover(function(){
                if (!self.options.disabled) {
                    $(this).addClass("fr-list-node-over");
                }
			}, function(){
				$(this).removeClass("fr-list-node-over");
			}).click(function(e) {
                if (!self.options.disabled) {
				    self.doSelected(e, $(this));
                }
			});
			if (this.options.draggable) {
				li.css('cursor', 'move');
			}
		},
		
		doSelected : function(e, li){
			if (this.options.multi) {
				this.fireEvent(FR.Events.CLICK);
				return;
			}
			var id = li.attr("id"); 
			var op = this.options;     
            var index = this.getItemIndex(id);

            if (op.cindex != null && op.cindex != index && !this.fireEvent(FR.Events.BEFORESTATECHANGE)) {
				return;
			}
			if (op.cindex){
            	$("#"+ this.id + op.cpPrefix + op.cindex).removeClass("fr-list-node-selected");
            }
            var oldItem = op.cindex ? op.data.getRecords()[op.cindex] : null; 
			var newItem = op.data.getRecords()[index];
            op.cindex = index;
            li.addClass("fr-list-node-selected");
            this.fireEvent(FR.Events.CLICK, index, newItem, oldItem);
//            this.fireEvent(FR.Events.AFTEREDIT); 
			if(e)  {
				e.stopEvent();  
			}          
		},
		
		getItemIndex : function(id){			
			return id != undefined ? id.split(this.options.cpPrefix)[1] : -1;
		},
		
		operation : function(e){
			var et = e.target || e.srcElement;
			if (et.tagName == "IMG") {
				if ($(et).hasClass("fr-list-operation-add")){
					var name = prompt(FR.i18nText("FS-Process-Input_A_Name"));
			        if (!name){
			        	FR.Msg.toast(FR.i18nText("FS-Process-Name_Cannot_Be_Null"));
			        } else {
			           var item = {text : name, value : name};
			           this.doAddItem(FR.DataFactory.createItemRecord(item));
			        }
				} else if ($(et).hasClass("fr-list-operation-delete")){
					this.doDeleteItem();
				} else {
					this.doEditItem();
				}
			}
		},
		
		checkStringOrNumber : function(ob) {
			return /Number|String/.test(Object.prototype.toString.apply(ob));
		},
		
		addSimpleData : function(data) {
			/*b:readsource should suport the data, like readobject(string)*/
			//b:new FR.ob false	
			if (this.checkStringOrNumber(data)) {
				data = {text : data, value : data};
			}		
			if (this.fireEvent(FR.Events.APPENDDATA, data)) {
				if (!$.isArray(data)) {
					data = [data];
				}
				this.options.data.updateData(data);
			};
		},

		doAddItem : function(record, isSetAll){
			if(this.options.needHead && !isSetAll){
				this.options.data.addRecord(record);
			}
			this.addData2View([record]);
			var op = this.options;
			if (op.needHead && op.addaction){
				op.operation.addaction.call(this, record);
			}	
		},
		/*b:ѡģʽݲɾ,ɾԶѡto add*/
		removeSelectedItem : function() {
			if (this.options.multi) {
				return;
			}			
			return this.removeItem($("li.fr-list-node-selected", this.element));
		},
		
		removeItem : function(li) {		
			if (!li[0]) {
				FR.Msg.toast(FR.i18nText("FS-Process-Selected_None_Of_Any_Items") + "!");
				return false;
			}	
			var currentIndex = li.attr('id').split(this.options.cpPrefix)[1];
			var op = this.options;
			var record = op.data.getRecord(currentIndex);
			var orgLen = op.data.getLength();
			// richer:ɾԪ
			op.data.getRecords().splice(currentIndex, 1);
			// richer:idҪӦı仯
			$("#" + this.id + op.cpPrefix + currentIndex, this.element).remove();
			for (var i = currentIndex; i < orgLen; i ++){
				var cid = this.id + op.cpPrefix + i;
				var nid = this.id + op.cpPrefix + (i - 1);
				$("#" + cid, this.element).attr("id", nid);
			}
			this.fireEvent(FR.Events.REMOVEDATA, record);
			//this.reBuildBackground();
			if (this.getSelectedIndex() < 0) {
 				this.fireEvent(FR.Events.NOSELECT);
 			}
			return 	record;		
		},
		
		doDeleteItem : function(){
			var op = this.options;
			//if (op.operation.deleteaction && op.needhead){
				op.operation.deleteaction.call(this.element, this.removeSelectedItem());
			//}
		},
		
		editItem : function(data) {
			var record = this.getSelectedItem();
			$.extend(record.data, data);
			if (this.fireEvent(FR.Events.EDITDATA, record.data)) {
				var li = $("#" + this.id + this.options.cpPrefix + this.getSelectedIndex());
				this.options.showAsHtml?$("a > span", li).html(record.getShowValue()):$("a > span", li).text(record.getShowValue());
			}
		},
		
		doEditItem : function(){
			var record = this.getSelectedItem();
			if (!record){
				FR.Msg.toast(FR.i18nText("FS-Process-Selected_None_Of_Any_Items") + "!");
				return false;
			}
			var oldname = record.getShowValue();
			var newname = prompt("Rename", oldname);
			newname = newname == null ? oldname : newname;
			record.setShowValue(newname);
			var op = this.options;
			// richer:Ҫıʾֵ
			var li = $("#" + this.id + op.cpPrefix + this.getSelectedIndex());
			$("span", li).text(newname);
			if (op.operation.renameaction && oldname != newname && op.needhead){
				op.operation.renameaction.call(this, newname, oldname);
			}
		},
		
		doClear : function(){
			this.options.data.clearData();
			$(".fr-list-node", this.element).remove();
			if (this.options.multi) {
				this.selectedLis = [];
			}
		},
		
		getSelectedData : function() {
			return this.getSelectedItem() != null ?  this.getSelectedItem().getContent() : null;	
		},
		
		getSelectedItem : function(){
			var index = this.getSelectedIndex();
			return index != -1 ? this.options.data.getRecord(index) : null;
		},
		
		/*b:indexôƵɾʱ岻󣬷Ӱ*/
		getSelectedIndex : function(){
			var currentLi = $("li.fr-list-node-selected", this.element);
			var index = currentLi.length !== 0 ? currentLi.attr("id").split(this.options.cpPrefix)[1] : -1;
			return parseInt(index);
		},
		
		getSelectedIndexs : function() {
			if (this.options.multi) {
				var si = [];
				for (var i = 0, len = this.selectedLis.length; i < len; i++) {
					si.push(this.selectedLis[i].$btn.parent().parent().attr('id').split(this.options.cpPrefix)[1]);
				}
				return si;
			} else {
				return [this.getSelectedIndex()];
			}
		},
		
		getSelectedItems : function() {
			var si = this.getSelectedIndexs(),rs = [], data = this.options.data;
			for (var i = 0, len = si.length; i < len; i++) {
				rs.push(data.getRecord(si[i]));
			}
			return rs;
		}
	})})(jQuery);