/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: sean
 * Date: 13-10-19
 * Time: 1:38
 */
FS.SYSMGR = {
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_sysmgr.css', 'css');
        var self = this;
        this.initData();
        var items = [
            {
                ui: this.basicSetModule,
                pop: this.popData
            },
            {
                ui: this.printSetModule,
                pop: this.popData
            },
            {
                ui: this.mailSetModule,
                pop: this.popData
            },
            {
                ui: this.cacheSetModule,
                pop: this.popData
            },
            {
                ui: this.connSetModule,
                pop: this.popData
            }
        ];
        $.each(FS.SystemItems, function(i, it) {
            items.push(it);
        });


        var tabItems = this._createTabItems(items);
        this.serverConfig = new FS.LTabPane({
            width: '100%',
            height: '100%',
            items: tabItems,
            style: 'blue',
            renderEl: renderer,
            marginLeft: 40,
            initAfterAction : function(idx) {
                var pop = items[idx].pop;
                if ($.isFunction(pop) && !isNaN(idx)) {
                    self.tabPane = this;
                    pop.apply(self, [parseInt(idx), this]);
                }
            }
        });
    },

    _createTabItems : function(items) {
        var uiItems = [];
        for (var i = 0, len = items.length; i < len; i ++) {
            var ui = items[i].ui;
            if ($.isFunction(ui)) {
                uiItems.push(ui.apply(this));
            }
        }
        return uiItems;
    },

    setWidgetValue: function (widgetName, value) {
        if (this.tabPane.getWidgetByName(widgetName)) {
            this.tabPane.getWidgetByName(widgetName).setValue(value);
        }
    },

    getWidgetValue: function (widgetName) {
        if (this.tabPane.getWidgetByName(widgetName)) {
            return this.tabPane.getWidgetByName(widgetName).getValue();
        }
    },

    sendTestMail: function () {
        var self = this;
        var testEmailTablelayout = {
            widgetName: 'testEmailTablelayout',
            type: 'tablelayout',
            items: [
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: $('<div/>')},
                    {el: {type: 'llabel', value: FR.i18nText("FS-System-Email_Receiver") + ":", textalign: 'right'}},
                    {el: $('<div/>')},
                    {el: {type: 'text', widgetName: 'emailReceiver'}}
                ]
            ],
            columnSize: [20, 100, 10, 230],
            rowSize: [30, 21],
            vgap: 20
        };

        var testEmailDialog = new FR.Dialog({
            title: FR.i18nText("FS-System-Send_Test_Mail"),
            onOK: function () {
                var toAddress = this.getWidgetByName('emailReceiver').getValue();
                var serverName = self.serverConfig.getWidgetByName('host').getValue();
                var serverPort = self.serverConfig.getWidgetByName('port').getValue();
                var encryptionMethod = self.serverConfig.getWidgetByName('encryption').getValue();
                var userName = self.serverConfig.getWidgetByName('username').getValue();
                var passWord = self.serverConfig.getWidgetByName('password').getValue();
                var fromAddress = self.serverConfig.getWidgetByName('address').getValue();
                var emailToAttr = {
                    serverName: serverName,
                    serverPort: serverPort,
                    encryptionMethod: encryptionMethod,
                    fromAddress: fromAddress,
                    userName: userName,
                    passWord: passWord,
                    toAddress: toAddress
                };
                FR.showLoadingDialog({
                    width: 310,
                    height: 80,
                    title: FR.i18nText("FS-Generic-Simple_Email"),
                    text: FR.i18nText("FS-System-Simple_Sending")
                });
                FR.ajax({
                    url: '${servletURL}?op=fr_server&cmd=sc_test_mail',
                    type: 'POST',
                    data: {
                        type: 'POST',
                        __parameters__: emailToAttr
                    },
                    complete: function (res, status) {
                        FR.hideLoadingDialog();
                        var result = FR.jsonDecode(res.responseText);
                        if (result.status == "success") {
                            FR.Msg.alert(FR.i18nText("FS-Generic-HJS_Send_Successfully"), FR.i18nText("FS-System-Email_Has_Send_To") + toAddress);
                        } else {
                            FR.Msg.alert(FR.i18nText("FS-Generic-HJS_Send_Failed"), FR.i18nText("FS-System-Email_Send_Failed") + "!\n" + FR.i18nText("FS-System-Please_Check_Email_Attr"));
                        }
                    }
                });
            },
            destroyOnClose: true,
            width: 400,
            height: 200,
            doSize: true,
            confirm: true,
            contentWidget: testEmailTablelayout
        });
        testEmailDialog.setVisible(true);
    },

    /**************************/
    basicSetModule: function () {
        var self = this;
        var charsetitems = [];
        for (var i = 0, len = this.data.encodingArray.length; i < len; i++) {
            charsetitems.push({
                value: this.data.encodingArray[i],
                text: this.data.encodingArray[i]
            })
        }
        var items = [
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-System-Reportlets_root_directory_name")}},
                {el: {type: 'text', widgetName: 'reportlets', disabled: true}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-System-Resources_root_directory_name")}},
                {el: {type: 'text', widgetName: 'resources', disabled: true}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-System-Server_character_encoding")}},
                {el: {type: 'combo', widgetName: 'charset', items: charsetitems}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-System-ServletMapping_name")}},
                {el: {type: 'text', widgetName: 'servlet'}}
            ]
        ];
        var rowSize = [21, 21, 21, 21];
        var height = 300;
        items.push([
                {el: {type: 'llabel', value: FR.i18nText("FS-System-Unlock_Gzip")}},
                {el: {type: 'switch', widgetName: 'gzip'}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("FS-System-Sign_Dongle")}},
                {el: {type: 'switch', widgetName: 'dongle'}}
            ]);
        rowSize.push(25, 25);
        var basicTablelayout = {
            widgetName: 'basicTablelayout',
            type: 'tablelayout',
            items: items,
            columnSize: [131, 122],
            rowSize: rowSize,
            vgap: 20
        };
        var basicSetPanel = {
            title: FR.i18nText("FS-System-Basic_Description"),
            content: {
                widgetName: 'basicSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                text4OK: FR.i18nText("FS-Frame-Simple_Save"),
                text4Cancel: null,
                width: 500,
                height: height,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK: function () {
                    self.saveBasicData();
                },
                contentWidget: basicTablelayout
            }
        };
        return basicSetPanel;
    },

    /*************ӡ*************/
    printSetModule: function () {
        var self = this;
        var pintlistitems = [];
        for (var i = 0, len = this.data.serverPrinterList.length; i < len; i++) {
            pintlistitems.push({
                value: this.data.serverPrinterList[i],
                text: this.data.serverPrinterList[i]
            })
        }
        //wei : ΪӦtablelayout֣ҪһdivŽȥȻ졣tabpaneȡ
        //ؼˣԵһ
        this.printerCombo = FR.createWidget({
            type: 'combocheckbox',
            supportTag: false,
            widgetName: 'printer',
            width: 122,
            height: 21,
            items: pintlistitems
        });
        var printTablelayout = {
            widgetName: 'printTablelayout',
            type: 'tablelayout',
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-Generic-Activated_Printer")}},
                    {el: $('<div/>').append(this.printerCombo.element)}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-Generic-Flash_Print")}},
                    {
                        el: {
                            type: 'checkbox',
                            marginleft: 0,
                            widgetName: 'flash_page',
                            text: FR.i18nText("FS-System-FlashP_Need_Page_Selection")
                        }
                    }
                ],
                [
                    {el: $('<div/>')},
                    {
                        el: {
                            type: 'checkbox',
                            marginleft: 0,
                            widgetName: 'flash_setting',
                            text: FR.i18nText("FS-System-FlashP_Need_Settings"),
                            selected: true,
                            disabled: true
                        }
                    }
                ],
                [
                    {el: $('<div/>')},
                    {
                        el: {
                            type: 'checkbox',
                            marginleft: 0,
                            widgetName: 'flash_size',
                            text: FR.i18nText("FS-System-FlashP_Default_Size")
                        }
                    }
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-Generic-PDF_Print")}},
                    {
                        el: {
                            type: 'checkbox',
                            marginleft: 0,
                            widgetName: 'pdf_page',
                            text: FR.i18nText("FS-System-PDFP_Need_Settings")
                        }
                    }
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-Generic-Applet_Print")}},
                    {
                        el: {
                            type: 'checkbox',
                            marginleft: 0,
                            widgetName: 'applet_page',
                            text: FR.i18nText("FS-System-Applet_Need_Settings")
                        }
                    }
                ]
            ],
            columnSize: [131, 'fill'],
            rowSize: [21, 0, 16, 16, 16, 0, 16, 0, 16],
            vgap: 10
        };
        var printSetPanel = {
            title: FR.i18nText("FS-Generic-Simple_Print"),
            content: {
                widgetName: 'printSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                text4OK: FR.i18nText("FS-Frame-Simple_Save"),
                text4Cancel: null,
                width: 500,
                height: 256,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK: function () {
                    self.savePrintData();
                },
                contentWidget: printTablelayout
            }
        };
        return printSetPanel;
    },

    /*************ʼ*************/
    mailSetModule: function () {
        var self = this;
        self.isEmailExpand = false;
        var senderLLabel = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("FS-System-Mail_Sender_Account")
        };
        var host_items = [{value: "SMTP.gmail.com", text: "SMTP.gmail.com"}, {
            value: "SMTP.sina.com",
            text: "SMTP.sina.com"
        },
            {value: "SMTP.163.com", text: "SMTP.163.com"}, {value: "SMTP.qq.com", text: "SMTP.qq.com"},
            {value: "SMTP.sohu.com", text: "SMTP.sohu.com"}, {value: "SMTP.live.com", text: "SMTP.live.com"},
            {value: "SMTP.mail.yahoo.com", text: "SMTP.mail.yahoo.com"}, {
                value: "SMTP.netease.com",
                text: "SMTP.netease.com"
            },
            {value: "SMTP.sina.com.cn", text: "SMTP.sina.com.cn"}, {value: "SMTP.263.net", text: "SMTP.263.net"},
            {value: "SMTP.126.com", text: "SMTP.126.com"}];
        var encryption_items = [
            {value: "SSL", text: FR.i18nText("FS-System-Email_Encrypt_SSL")},
            {value: "TLS", text: FR.i18nText("FS-System-Email_Encrypt_TLS")},
            {value: "None", text: FR.i18nText("FS-System-Email_Encrypt_None")}
        ];
        var senderTablePane = {
            widgetName: 'senderTablePane',
            type: 'tablepane',
            colSize: [131, 350, 120],
            rowSize: [21, 21, 21, 21, 21, 21],
            vgap: 20,
            items: [
                [
                    {type: 'llabel', value: FR.i18nText("FS-System-Mail_Host(SMTP)")},
                    {type: 'combo', widgetName: 'host', directEdit: true, items: host_items},
                    {
                        type: 'iconbutton',
                        text: FR.i18nText("FS-System-Email_Ports_and_Encryption"),
                        baseClass: 'fs-servercfg-test',
                        handler: function () {
                            self.isEmailExpand = !self.isEmailExpand;
                            self.serverConfig.getWidgetByName("senderTablePane").setRowVisible([1, 2], self.isEmailExpand);
                        }
                    }
                ],
                [
                    {type: 'llabel', value: FR.i18nText("FS-System-Email_Port")},
                    {type: 'text', widgetName: 'port'}, null
                ],
                [
                    {type: 'llabel', value: FR.i18nText("FS-System-Email_Encryption_Method")},
                    {
                        type: 'combo',
                        widgetName: 'encryption',
                        directEdit: false,
                        allowBlank: false,
                        items: encryption_items
                    }, null
                ],
                [
                    {type: 'llabel', value: FR.i18nText("FS-System-Sender_Address")},
                    {
                        type: 'text', widgetName: 'address', listeners: [{
                        eventName: 'afteredit',
                        action: function () {
                            var showFullName = this.getWidgetByName('username');
                            var mail_address = this.getValue();
                            if (mail_address) {
                                var namePosition = mail_address.indexOf("@");
                                var mail_fullname = namePosition === -1 ? mail_address : mail_address.substring(0, namePosition);
                                showFullName.setValue(mail_fullname);
                            }
                        }
                    }]
                    }, null
                ],
                [
                    {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Password")},
                    {type: 'password', widgetName: 'password'}, null
                ],
                [
                    {type: 'llabel', value: FR.i18nText("FS-System-Email_Show_Full_Name")},
                    {type: 'text', widgetName: 'username'},
                    {
                        type: 'iconbutton',
                        text: FR.i18nText("FS-System-Send_Test_Mail"),
                        baseClass: 'fs-servercfg-test',
                        handler: function () {
                            self.sendTestMail();
                        }
                    }
                ]
            ]
        };
        var mailSetPanel = {
            title: FR.i18nText("FS-Generic-Simple_Email"),
            content: {
                widgetName: 'mailSetPanel',
                type: 'tablepane',
                colSize: [80, 750],
                rowSize: [25, 'auto', 30],
                vgap: 25,
                items: [
                    [null, senderLLabel],
                    [null, senderTablePane],
                    [{
                        type: 'quickbutton',
                        style: 'blue',
                        text: FR.i18nText("FS-Frame-Simple_Save"),
                        handler: function () {
                            self.saveEmailData();
                        }
                    }, null]
                ]

            }
        };
        return mailSetPanel;
    },

    /**************************/
    cacheSetModule: function () {
        var self = this;
        var datasetShare = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("FS-System-Cache_Dataset_Share")
        };
        var cptCache = {
            type: 'llabel',
            levelStyle: 1,
            value: FR.i18nText("FS-System-Cache_Template_Settings")
        };
        var dsShareTablelayout = {
            type: 'tablelayout',
            columnSize: [131, 122, 8, 'fill'],
            rowSize: [21, 15, 82, 15, 21, 20, 21],
            vgap: 0,
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-System-Max_Shared_Datasets")}},
                    {el: {type: 'text', widgetName: 'maximum'}}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {
                        el: {
                            type: 'llabel',
                            verticalcenter: false,
                            lineheight: 26,
                            value: FR.i18nText("FS-System-Cache_Principle")
                        }
                    },
                    {
                        el: {
                            type: 'radiogroup',
                            assureSelect: true,
                            items: [
                                {text: FR.i18nText("FS-System-Simple_LRU"), value: 'LRU'},
                                {text: FR.i18nText("FS-System-Simple_LFU"), value: 'LFU'},
                                {text: FR.i18nText("FS-System-Simple_FIFO"), value: 'FIFO'}
                            ],
                            columnsInRow: 1,
                            adaptive: true,
                            widgetName: 'principle'
                        }
                    }
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-System-Time_To_Idle_Seconds")}},
                    {el: {type: 'text', widgetName: 'idle'}},
                    {el: $('<div/>')},
                    {el: {type: 'llabel', value: FR.i18nText("FS-Generic-Sche_Second")}}
                ],
                [
                    {el: $('<div/>')}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-System-Time_To_Live_Seconds")}},
                    {el: {type: 'text', widgetName: 'live'}},
                    {el: $('<div/>')},
                    {el: {type: 'llabel', value: FR.i18nText("FS-Generic-Sche_Second")}}
                ]
            ]
        };
        var cptCacheTablelayout = {
            type: 'tablelayout',
            columnSize: [131, 122],
            rowSize: [25],
            vgap: 20,
            items: [
                [
                    {el: {type: 'llabel', value: FR.i18nText("FS-System-Cache_Reload_Template_Policy")}},
                    {el: {type: 'switch', widgetName: 'reload'}}
                ]
            ]
        };
        var cacheSetPanel = {
            title: FR.i18nText("FS-System-Memory_Cache"),
            content: {
                widgetName: 'cacheSetPanel',
                type: 'confirm',
                firstBtnMargin: 0,
                width: 750,
                height: 393,
                text4OK: FR.i18nText("FS-Frame-Simple_Save"),
                text4Cancel: null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                doSize: true,
                onOK: function () {
                    self.saveCacheData();
                },
                contentWidget: {
                    type: 'tablelayout',
                    columnSize: ['fill'],
                    rowSize: [25, 213, 25, 25],
                    vgap: 10,
                    items: [
                        [
                            {el: datasetShare}
                        ],
                        [
                            {el: dsShareTablelayout}
                        ],
                        [
                            {el: cptCache}
                        ],
                        [
                            {el: cptCacheTablelayout}
                        ]
                    ]
                }
            }
        };
        return cacheSetPanel;
    },
    /**************************/
    connSetModule: function () {
        var self = this, items = [];
        var connParas = {};
        var connNames = [];
        var connSize = 0;
        FR.ajax({
            url: FR.servletURL + "?op=fs_set&cmd=sc_getconnectioninfo",
            type: 'POST',
            async: false,
            complete: function (res, status) {
                if (status == 'success' && !FR.isEmpty(res.responseText)) {
                    var result = FR.jsonDecode(res.responseText);
                    connSize = result.length;
                    for (var i = 0; i < connSize; i++) {
                        var conn = result[i];
                        connNames.push(conn.name);
                        items.push({
                            menu: FR.i18nText("FS-System-Connection_List") + (i + 1) + ": " + conn.name,
                            content: {
                                type: 'tablepane',
                                colSize: [130, 380],
                                rowSize: [21, 21, 21, 21],
                                vgap: 8,
                                hgap: 0,
                                items: [
                                    [
                                        {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Driver")},
                                        {type: 'text', widgetName: 'DRIVER' + i, value: conn.driver}
                                    ], [
                                        {type: 'llabel', value: 'url'},
                                        {type: 'text', widgetName: 'URL' + i, value: conn.url}
                                    ], [
                                        {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Username")},
                                        {type: 'text', widgetName: 'USERNAME' + i, value: conn.user, width: 190}
                                    ], [
                                        {type: 'llabel', value: FR.i18nText("FS-Generic-Simple_Password")},
                                        {type: 'password', widgetName: 'PASSWORD' + i, value: conn.password, width: 190}
                                    ]
                                ]
                            }
                        });
                    }
                }
            }
        });
        var connSetPanel = {
            title: FR.i18nText("FS-System-Connection_Description"),
            content: {
                widgetName: 'CONNSETPANE',
                type: 'tablepane',
                colSize: [80, 750],
                rowSize: ['auto', 30],
                vgap: 25,
                items: [
                    [
                        null,
                        {
                            type: 'accordion',
                            items: items
                        }
                    ], [
                        {
                            type: 'quickbutton',
                            style: 'blue',
                            text: FR.i18nText("FS-Frame-Simple_Save"),
                            handler: function () {
                                for (var i = 0; i < connSize; i++) {
                                    connParas[connNames[i]] = {
                                        driver: this.getWidgetByName('DRIVER' + i).getValue(),
                                        url: this.getWidgetByName('URL' + i).getValue(),
                                        user: this.getWidgetByName('USERNAME' + i).getValue(),
                                        password: this.getWidgetByName('PASSWORD' + i).getValue()
                                    }
                                }
                                FR.ajax({
                                    url: '${servletURL}?op=fs_set&cmd=sc_connection_attrset',
                                    type: 'POST',
                                    data: {
                                        __parameters__: connParas,
                                        changedConName: connNames
                                    },
                                    complete: function (res, status) {
                                        var conAttrStatus = res.responseText;
                                        if (conAttrStatus == -1) {
                                            FR.Msg.toast(FR.i18nText("FS-System-Event_Submitfailure"));
                                        } else if (conAttrStatus == "success") {
                                            FR.Msg.toast(FR.i18nText("FS-System-Event_Submitsuccess"));
                                        } else {
                                            FR.Msg.toast(FR.i18nText("FS-System-Event_Submitfailure"));
                                        }
                                    }
                                });
                            }
                        },
                        null
                    ]
                ]
            }
        };
        return connSetPanel;
    },
    /****************** ݲ *******************/
    initData: function () {
        var self = this;
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_get_configinfo',
            type: 'POST',
            async: false,
            complete: function (res, status) {
                self.data = FR.jsonDecode(res.responseText);
            }
        });
    },

    popData: function (index) {
        if (index === 0) {
            this._popBasicSetData();
        } else if (index === 1) {
            this._popPrintSetData();
        } else if (index === 2) {
            this._popEmailData();
        } else if (index === 3) {
            this._popCacheData();
        }
    },

    _popBasicSetData: function () {
        var basicAttr = this.data;
        this.setWidgetValue("reportlets", basicAttr.reportletsName);
        this.setWidgetValue("resources", basicAttr.resourcesName);
        this.setWidgetValue("charset", basicAttr.serverCharSet);
        this.setWidgetValue("servlet", basicAttr.serverletMapping);
        this.setWidgetValue("gzip", basicAttr.isSupportGzip);
        this.setWidgetValue("dongle", basicAttr.isLicUseLock);
    },

    _popPrintSetData: function () {
        var basicAttr = this.data;
        this.printerCombo.setValue(basicAttr.serverActivePrinterList);

        this.setWidgetValue("flash_page", basicAttr.isPopupFlashPrintSetting);
        this.setWidgetValue("flash_size", basicAttr.isFitPaper);
        this.setWidgetValue("pdf_page", basicAttr.isPopupPdfPrintSetting);
        this.setWidgetValue("applet_page", basicAttr.isPopupAppletPrintSetting);
    },

    _popEmailData: function () {
        var basicAttr = this.data;
        this.setWidgetValue("host", basicAttr.serverName);
        this.setWidgetValue("port", basicAttr.serverPort);
        this.setWidgetValue("encryption", basicAttr.encryptionMethod);
        this.setWidgetValue("username", basicAttr.userName);
        this.setWidgetValue("password", basicAttr.passWord);
        this.setWidgetValue("address", basicAttr.fromAddress);
        this.serverConfig.getWidgetByName("senderTablePane").setRowVisible([1, 2], this.isEmailExpand);
    },

    _popCacheData: function () {
        var basicAttr = this.data;
        this.setWidgetValue("maximum", basicAttr.maxElementsInMemory);
        this.setWidgetValue("principle", basicAttr.memoryStoreEvictionPolicy);
        this.setWidgetValue("idle", basicAttr.timeToIdleSeconds);
        this.setWidgetValue("live", basicAttr.timeToLiveSeconds);
        this.setWidgetValue("reload", basicAttr.alwaysReloadTpl);
    },

    /*************  ***********/
    saveBasicData: function () {
        var basicData = {
            serverCharSet: this.getWidgetValue("charset"),
            serverletMapping: this.getWidgetValue("servlet"),
            isSupportGzip: this.getWidgetValue("gzip"),
            isLicUseLock: this.getWidgetValue("dongle")
        };
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_basic_set',
            type: 'POST',
            data: basicData,
            complete: function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                }
            }
        });
    },

    savePrintData: function () {
        var printData = {
            serverActivePrinterList: this.printerCombo.getValue(),
            isPopupFlashPrintSetting: this.getWidgetValue("flash_page"),
            isFitPaper: this.getWidgetValue("flash_size"),
            isPopupPdfPrintSetting: this.getWidgetValue("pdf_page"),
            isPopupAppletPrintSetting: this.getWidgetValue("applet_page")
        };
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_print_set',
            type: 'POST',
            data: printData,
            complete: function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                }
            }
        });
    },

    saveEmailData: function () {
        var emailData = {
            host: this.getWidgetValue("host"),
            port: this.getWidgetValue("port"),
            encryption: this.getWidgetValue("encryption"),
            username: this.getWidgetValue("username"),
            password: this.getWidgetValue("password"),
            address: this.getWidgetValue("address")
        };
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_email_set',
            type: 'POST',
            data: emailData,
            complete: function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                }
            }
        });
    },

    saveCacheData: function () {
        var cacheData = {
            maximum: this.getWidgetValue("maximum"),
            principle: this.getWidgetValue("principle"),
            idle: this.getWidgetValue("idle"),
            live: this.getWidgetValue("live"),
            reload: this.getWidgetValue("reload")
        };
        FR.ajax({
            url: FR.servletURL + '?op=fr_server&cmd=sc_cache_set',
            type: 'POST',
            data: cacheData,
            complete: function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                }
            }
        });
    },

    /*************¼*************/
    /**
     * ¼ҳñǩҳ
     * ͬ fs ƽ̨ʽ
     */
    loginMgrModule: function () {
        var self = this;
        var colSize = [80, 131, 'fill'];
        var rowSize = [21, 52, 25, 150, 30];
        return {
            title: FR.i18nText("FS-Setting-Login_Page"),
            content: {
                widgetName: 'LOGINSETPANE',
                type: 'tablepane',
                colSize: colSize,
                rowSize: rowSize,
                vgap: 20,
                items: [
                    self._createLoginPageTypeConfig(),
                    self._createLoginPageUrlConfig(),
                    self._createLoginImgUploadConfig(),
                    [null, {}, $('<img/>').addClass('fs_csview_loginimg')],
                    [{
                        type: 'quickbutton',
                        style: 'blue',
                        text: FR.i18nText("FS-Frame-Simple_Save"),
                        handler: function () {
                            self.saveLoginPageData();
                        }
                    }, null, null]
                ]
            }
        };
    },

    /**
     * ¼ҳѡѡ
     * @private
     */
    _createLoginPageTypeConfig: function () {
        var self = this;
        return [
            null,
            {
                type: 'llabel',
                value: FR.i18nText("FS-Setting-Customize_Login")
            },
            {
                widgetName: "mgrLoginPageTypeRadioGroup",
                type: 'radiogroup',
                assureSelect: true,
                width: 270,
                height: 21,
                items: [
                    {
                        text: FR.i18nText("FS-Setting-Login_Background"),
                        value: 1,
                        width: 135
                    },
                    {
                        text: FR.i18nText("FS-Setting-Login_URL"),
                        value: 2,
                        width: 135
                    }
                ],
                listeners: [{
                    eventName: "afteredit",
                    action: function () {
                        var widget = this.getWidgetByName("mgrLoginPageTypeRadioGroup");
                        if (widget && widget.getValue() === 1) {
                            self._showLoginPageImg();
                        } else {
                            self._showLoginPageURL();
                        }
                    }
                }],
                columnsInRow: 2
            }
        ]
    },

    /**
     * ¼ҳǩ Url ò
     * @private
     */
    _createLoginPageUrlConfig: function () {
        return [
            null,
            {},
            {
                widgetName: "mgrLoginPageUrlPane",
                type: 'tablepane',
                colSize: [122, 322],
                rowSize: [21, 21],
                vgap: 10,
                items: [
                    [{type: 'llabel', value: FR.i18nText("FS-Setting-Login_URL_Detail")}, null],
                    [null, {widgetName: "mgrLoginPageUrlText", type: 'text'}]
                ]
            }
        ]
    },

    /**
     * ¼ҳǩԶͼƬϴò
     * @private
     */
    _createLoginImgUploadConfig: function () {
        var self = this;
        return [
            null,
            {
                el: $('<div/>')
            },
            {
                type: 'multifile',
                widgetName: "mgrLoginPageImgUpload",
                maxlength: 1,
                accept: '.png.jpg.gif',
                hideFileList: true,
                height: 32,
                width: 32,
                tooltipText: FR.i18nText("FS-Setting-BG_Upload_ToolTip"),
                listeners: [
                    {
                        eventName: "afteredit",
                        action: function () {
                            var widget = this.getWidgetByName("mgrLoginPageImgUpload");
                            if (widget) {
                                var attachid = widget.getValue().attach_id;
                                var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
                                self.loginImgView.attr('src', url);
                                $('td', widget.element).remove();
                            }
                        }
                    }
                ]
            }
        ]
    },

    /**
     * ʾ¼ҳԶͼƬò
     * @private
     */
    _showLoginPageImg: function () {
        var sc = this.serverConfig;
        var attr = this.data;
        sc.getWidgetByName('LOGINSETPANE').setRowVisible([1], false);
        sc.getWidgetByName('LOGINSETPANE').setRowVisible([2, 3], true);
        var url = FR.servletURL + (
                attr.loginimg ? ('?op=fr_attach&cmd=ah_image&id=' + attr.loginimg + '&isAdjust=false') :
                    '?op=resource&resource=/com/fr/fs/resources/images/oem/signin.jpg'
            );
        //¼ҳͼƬԤ
        this.loginImgView = $('.fs_csview_loginimg');
        this.loginImgView.attr('src', url);
    },

    /**
     * ʾ¼ҳ Url ò
     * @private
     */
    _showLoginPageURL: function () {
        var sc = this.serverConfig;
        sc.getWidgetByName('LOGINSETPANE').setRowVisible([1], true);
        sc.getWidgetByName('LOGINSETPANE').setRowVisible([2, 3], false);
    },

    /**
     * ¼ҳ
     */
    saveLoginPageData: function () {
        var sc = this.serverConfig;
        var jo = {};
        var isLoginImg = (sc.getWidgetByName("mgrLoginPageTypeRadioGroup").getValue() === 1);
        jo.isLoginImg = isLoginImg;
        if (isLoginImg) {
            var loginPageAttach = sc.getWidgetByName("mgrLoginPageImgUpload").getValue();
            if (loginPageAttach && loginPageAttach.attach_id) {
                jo.loginImgId = loginPageAttach.attach_id;
            }
        } else {
            var loginUrl = sc.getWidgetByName("mgrLoginPageUrlText").getValue();
            if (loginUrl) {
                jo.loginUrl = loginUrl;
            }
        }
        FR.ajax({
            url: FR.servletURL + '?op=fs_manager&cmd=fs_set_login_page',
            type: 'POST',
            data: jo,
            complete: function (res, status) {
                if (status === 'success') {
                    FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                }
            }
        });
    }
};
