/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-7-10
 * Time: 1:08
 */
$(function() {
    var imgOffsetX, imgOffsetY, loginImgWidth, loginImgHeight, scale;
    //ɰ
    var $mask = $('<div class="fs-login-errmask"/>');
    //û
    var $username = $('input.fs-login-username').attr("placeholder", FR.i18nText("FS-Generic-Simple_Username")).attr('title',FR.i18nText("FS-Generic-Simple_Username"));
    //
    var $password = $('input.fs-login-password').attr("placeholder", FR.i18nText("FS-Generic-Simple_Password")).attr('title',FR.i18nText("FS-Generic-Simple_Password"));
    $('input').focus(function(){
        $(this).parent().addClass('fs-login-input-focus');
        $mask.hide();
    }).blur(function(){
            $(this).parent().removeClass('fs-login-input-focus');
        });
    //Ƿ񱣳ֵ¼״̬
    var $keep = $('span.fs-login-remember').text(FR.i18nText("FS-Generic-Privilege_Keep_Login_State")).click(
        function(){
            $(this).toggleClass('fs-login-remember-selected');
        }
    );
    //¼ť
    $('a').text(FR.i18nText("FS-Generic-Sign_In")).click(
        function(){
            signIN();
        }
    );
    //󶨻س
    $(document).keydown(function(e){
        if(e.keyCode===13){
            signIN();
        }
    });
    /**
     * ʼFSĵ¼ͼƬ
     */
    var initBackgroundImage = function () {
        var self = this;
        var ran = new Date().getTime() + "" + (Math.random() * 1000);
        FR.ajax({
            url: FR.servletURL + "?op=fs_load&cmd=getLoginImageInfo&_ran=" + ran,
            complete: function (res, status) {
                if (status == 'success') {
                    var loginInfo = FR.jsonDecode(res.responseText);
                    var loginImgID = loginInfo.id;
                    loginImgWidth = parseInt(loginInfo.width);
                    loginImgHeight = parseInt(loginInfo.height);
                    calcBackgroundScale();

                    var url = FR.servletURL + ((loginImgID && loginImgID != 'null') ?
                            ('?op=fr_attach&cmd=ah_image&id=' + loginImgID + '&isAdjust=false')
                            : '?op=resource&resource=/com/fr/fs/resources/images/oem/signin.jpg');
                    if ($('body').length > 0) {
                        var loginImg = $('img.fs-login-img');
                        loginImg.attr("src", url);
                        loginImg.css({
                            "margin-left": "-" + imgOffsetX + "px",
                            "margin-top": "-" + imgOffsetY + "px",
                            width: loginImgWidth * scale + "px",
                            height: loginImgHeight * scale + "px"
                        });

                        var offset = $('#fs-login-scalebg').offset();
                        var loginScaleBgImg = $('img.fs-login-scalebg-img');
                        loginScaleBgImg.attr("src", url);
                        loginScaleBgImg.css({
                            "margin-left": "-" + (imgOffsetX + offset.left) + "px",
                            "margin-top": "-" + (imgOffsetY + offset.top) + "px",
                            width: loginImgWidth * scale + "px",
                            height: loginImgHeight * scale + "px"
                        });
                    }
                }
            }
        })
    };

    var calcBackgroundScale = function () {
        var windowWidth = document.body.clientWidth;
        var windowHeight = document.body.clientHeight;

        if (windowWidth / windowHeight >= loginImgWidth / loginImgHeight) {
            scale = windowWidth / loginImgWidth;
            imgOffsetX = 0;
            imgOffsetY = (loginImgHeight * scale - windowHeight) / 2;
        } else {
            scale = windowHeight / loginImgHeight;
            imgOffsetX = (loginImgWidth * scale - windowWidth) / 2;
            imgOffsetY = 0;
        }
    };

    var showErrorMsg = function($pos, msg){
        $mask.hide().insertAfter($pos).text(msg);
        $mask.click(function(){
            $(this).fadeOut();
            $pos.select();
        }).fadeIn();
    };

    var signIN = function(){
        $mask.hide();
        var user = $username.val();
        var pw = $password.val();
        //ûΪ
        if(FR.isEmpty(user)){
            showErrorMsg($username,FR.i18nText('FS-User-User_Can_Not_Be_Null'));
            return;
        }
        //Ϊ
        if(FR.isEmpty(pw)){
            showErrorMsg($password,FR.i18nText('FS-Admin-Password_Can_Not_Be_Null'));
            return;
        }
        FR.ajax({
            url : FR.servletURL + '?op=fs_load&cmd=login',
            data : FR.cjkEncodeDO({
                fr_username : encodeURIComponent(user),
                fr_password : encodeURIComponent(pw),
                fr_remember : $keep.hasClass('fs-login-remember-selected')
            }),
            type : 'POST',
            async : false,
            error : function() {
                FR.Msg.toast("Error!");
            },
            complete : function(res, status) {
                if (res.responseText == "") {
                    showErrorMsg($username,FR.i18nText('FS-Admin-Authentication_failed'));
                    return;
                }
                var signResult = FR.jsonDecode(res.responseText);
                if (signResult.fail) {
                    //û벻ƥ
                    showErrorMsg($username,FR.i18nText("FS-Generic-Privilege_Name_Not_Match_Password"));
                } else if (signResult.url) {
                    window.location.href = signResult.url;
                }
            }
        });
    };
    initBackgroundImage();
    $username.focus();
    $(window).resize(function(){
        calcBackgroundScale();
        $('img.fs-login-img').css({
            "margin-left": "-" + imgOffsetX +"px",
            "margin-top": "-" + imgOffsetY +"px",
            width: loginImgWidth * scale + "px",
            height: loginImgHeight * scale + "px"
        });
        var offset = $('#fs-login-scalebg').offset();
        $('img.fs-login-scalebg-img').css({
            "margin-left": "-" + (imgOffsetX + offset.left) + "px",
            "margin-top": "-" + (imgOffsetY + offset.top) + "px",
            width: loginImgWidth * scale + "px",
            height: loginImgHeight * scale + "px"
        });
    });
});
