/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.task;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.dao.ReportletEntryDAO;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.web.ShowType;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ItriggerTask;
import com.fr.schedule.util.ExecuteType;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.TaskConfig;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.Trigger;
import java.util.List;

public class ScheduleTask
extends ItriggerTask {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "fr_schedule_task";
    public static final String FIELD_NAME_REPORTLET_FOREIGN_KEY = "groupId";
    private static FRLogger log = FRLogger.getLogger();
    private String reportletPath;
    private ShowType showType;
    private ScheduledOutput scheduledOutput;
    private ExecuteType executeType;
    private String executeFormula;
    private String executeClass;
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(ScheduleTask.class, new Table("fr_schedule_task"), new FieldColumnMapper[]{ID, NAME, DES, new CommonFieldColumnMapper("reportletPath", 12, new ColumnSize(255)), new CommonFieldColumnMapper("showType", 4, "showType", new ColumnSize(5), true, new FCValueMapper(){

        public Object field2Value(Object object) {
            if (object == null) {
                return ShowType.NONE.toInt();
            }
            return ((ShowType)((Object)object)).toInt();
        }

        public Object value2Field(Object object) {
            return ShowType.parse((Integer)object);
        }
    }), new CommonFieldColumnMapper("executeType", 4, "executeType", new ColumnSize(5), true, new FCValueMapper(){

        public Object field2Value(Object object) {
            if (object == null) {
                return ExecuteType.NOLIMIT.toInt();
            }
            return ((ExecuteType)((Object)object)).toInt();
        }

        public Object value2Field(Object object) {
            return ExecuteType.parse((Integer)object);
        }
    }), REPEATTIME, REPEATTIMES, new CommonFieldColumnMapper("executeFormula", 12, new ColumnSize(255)), new CommonFieldColumnMapper("executeClass", 12, new ColumnSize(255)), COUNTS, ITRIGGER, TASKPARAMETERS, new CompatiableIDFCMapper(ScheduledOutput.class, "scheduledOutput", 4, "scheduledOupputId", new ColumnSize(20), true)}, 0);

    public ScheduleTask() {
    }

    public ScheduleTask(String string) {
        super(string);
    }

    public ScheduleTask(String string, String string2) {
        super(string, string2);
    }

    public ScheduleTask(TaskConfig taskConfig) {
        super(taskConfig);
        this.scheduledOutput = taskConfig.getScheduledOutput();
        this.reportletPath = taskConfig.getReportletPath();
        this.showType = taskConfig.getShowType();
        this.executeType = taskConfig.getExecuteType();
        this.executeFormula = taskConfig.getExecuteFormula();
        this.executeClass = taskConfig.getExecuteClass();
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        super.createJSONConfig(jSONObject);
        jSONObject.put("reportletPath", (Object)this.reportletPath);
        jSONObject.put("showType", (Object)this.showType);
        jSONObject.put("executeType", this.executeType.toInt());
        jSONObject.put("executeFormula", (Object)this.executeFormula);
        jSONObject.put("executeClass", (Object)this.executeClass);
        if (this.getScheduledOutput() != null) {
            JSONObject jSONObject2 = this.getScheduledOutput().createJSONConfig();
            jSONObject.put("scheduledOutput", (Object)jSONObject2);
        }
        return jSONObject;
    }

    protected void setTriggerState(JSONObject jSONObject) {
        try {
            List list;
            Scheduler scheduler = ScheduleContext.getScheduler();
            Trigger[] triggerArray = scheduler.getTriggersOfJob(this.getName(), this.reportletPath);
            if (triggerArray.length == 0 && (list = ReportletEntryDAO.getInstance().findByPath(this.reportletPath)) != null && !list.isEmpty()) {
                ReportletEntry reportletEntry = (ReportletEntry)list.get(0);
                triggerArray = scheduler.getTriggersOfJob(this.getName(), reportletEntry.getDisplayName());
            }
            if (triggerArray.length > 0) {
                list = triggerArray[0];
                int n = scheduler.getTriggerState(list.getName(), list.getGroup());
                jSONObject.put("state", n);
            }
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
        }
    }

    public void setScheduledOutput(ScheduledOutput scheduledOutput) {
        if (this.getId() != 0L && this.scheduledOutput != null && (scheduledOutput == null || scheduledOutput.getId() != this.scheduledOutput.getId())) {
            ScheduleContext.createDAOSession().deleteByPrimaryKey(ScheduledOutput.class, this.scheduledOutput.getId());
        }
        this.scheduledOutput = scheduledOutput;
    }

    public ScheduledOutput getScheduledOutput() {
        return this.scheduledOutput;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduleTask)) {
            return false;
        }
        ScheduleTask scheduleTask = (ScheduleTask)object;
        return super.equals(object) && ComparatorUtils.equals((Object)this.scheduledOutput, (Object)scheduleTask.scheduledOutput);
    }

    public String getReportletPath() {
        return this.reportletPath;
    }

    public void setReportletPath(String string) {
        this.reportletPath = string;
    }

    public ShowType getShowType() {
        return this.showType;
    }

    public void setShowType(ShowType showType) {
        this.showType = showType;
    }

    public ScheduleTask clone4Exe() throws CloneNotSupportedException {
        return (ScheduleTask)super.clone();
    }

    public ExecuteType getExecuteType() {
        return this.executeType;
    }

    public void setExecuteType(ExecuteType executeType) {
        this.executeType = executeType;
    }

    public String getExecuteFormula() {
        return this.executeFormula;
    }

    public void setExecuteFormula(String string) {
        this.executeFormula = string;
    }

    public String getExecuteClass() {
        return this.executeClass;
    }

    public void setExecuteClass(String string) {
        this.executeClass = string;
    }
}

