/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.task;

import com.fr.base.Parameter;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.trigger.CalendarITrigger;
import com.fr.fs.schedule.trigger.CronExpressionITrigger;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.fs.schedule.trigger.SimpleITrigger;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.util.TaskConfig;
import com.fr.stable.StableUtils;
import com.fr.web.platform.TransmitParameters;
import java.io.Serializable;

public abstract class ItriggerTask
implements Cloneable,
Serializable {
    private long id = -1L;
    private String name;
    private String description;
    private int counts;
    private String repeatTime = "0";
    private String repeatTimes = "0";
    private ITrigger iTrigger;
    private TransmitParameters taskParameters;
    protected static final FieldColumnMapper ID = new PrimaryKeyFCMapper("id", 4, "id", new ColumnSize(20), false, true);
    protected static final FieldColumnMapper NAME = new CommonFieldColumnMapper("name", 12, new ColumnSize(255));
    protected static final FieldColumnMapper DES = new CommonFieldColumnMapper("description", 12, new ColumnSize(255));
    protected static final FieldColumnMapper REPEATTIME = new CommonFieldColumnMapper("repeatTime", 12, new ColumnSize(20));
    protected static final FieldColumnMapper REPEATTIMES = new CommonFieldColumnMapper("repeatTimes", 12, new ColumnSize(20));
    protected static final FieldColumnMapper COUNTS = new CommonFieldColumnMapper("counts", 4, new ColumnSize(5));
    protected static final FieldColumnMapper ITRIGGER = new CompatiableIDFCMapper(ITrigger.class, "iTrigger", 4, "itriggerId", new ColumnSize(20), true, new FCValueMapper(){

        public Object value2Field(Object object) {
            long l = ((Number)object).longValue();
            String string = String.valueOf(l);
            if (string.length() > 0 && string.charAt(0) == '1') {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.createDAOSession().load(OnceITrigger.class, l);
            }
            if (string.length() > 0 && string.charAt(0) == '2') {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.createDAOSession().load(SimpleITrigger.class, l);
            }
            if (string.length() > 0 && string.charAt(0) == '3') {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.createDAOSession().load(CalendarITrigger.class, l);
            }
            if (string.length() > 0 && string.charAt(0) == '4') {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.createDAOSession().load(CronExpressionITrigger.class, l);
            }
            return null;
        }

        public Object field2Value(Object object) {
            long l;
            if (object == null) {
                return new Long(-1L);
            }
            ScheduleContext.createDAOSession().saveOrUpdate(object);
            try {
                l = ((Number)StableUtils.getPrivateFieldValue((Object)object, (String)"id")).longValue();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            String string = ((ITrigger)object).getITriggerIdPrefix() + String.valueOf(l);
            return new Long(Long.parseLong(string));
        }
    });
    protected static final FieldColumnMapper TASKPARAMETERS = new CommonFieldColumnMapper("taskParameters", 12, "task_parameters", new ColumnSize(255), true, TransmitParameters.TRANPARAM_VALUE_MAPPER);

    public ItriggerTask() {
    }

    public ItriggerTask(String string) {
        this.name = string;
    }

    public ItriggerTask(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public ItriggerTask(TaskConfig taskConfig) {
        this.name = taskConfig.getName();
        this.description = taskConfig.getDescription();
        this.repeatTime = taskConfig.getRepeatTime();
        this.repeatTimes = taskConfig.getRepeatTimes();
        this.iTrigger = taskConfig.getiTrigger();
        this.taskParameters = taskConfig.getTaskParameters();
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setITrigger(ITrigger iTrigger) {
        this.iTrigger = iTrigger;
    }

    public ITrigger getITrigger() {
        return this.iTrigger;
    }

    public void setTaskParameters(TransmitParameters transmitParameters) {
        this.taskParameters = transmitParameters;
    }

    public TransmitParameters getTaskParameters() {
        return this.taskParameters;
    }

    public Parameter[] getParametersToArray() {
        return this.getTaskParameters() == null ? new Parameter[]{} : this.getTaskParameters().toArray();
    }

    public String getRepeatTime() {
        return this.repeatTime;
    }

    public void setRepeatTime(String string) {
        this.repeatTime = string;
    }

    public String getRepeatTimes() {
        return this.repeatTimes;
    }

    public void setRepeatTimes(String string) {
        this.repeatTimes = string;
    }

    public int getCounts() {
        return this.counts;
    }

    public void setCounts(int n) {
        this.counts = n;
    }

    public JSONObject createJSONConfig(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        this.setTriggerState(jSONObject);
        jSONObject.put("id", this.getId());
        jSONObject.put("name", (Object)this.getName());
        jSONObject.put("description", (Object)this.getDescription());
        jSONObject.put("repeatTime", (Object)this.repeatTime);
        jSONObject.put("repeatTimes", (Object)this.repeatTimes);
        if (this.getITrigger() != null) {
            jSONObject2 = this.getITrigger().createJSONConfig();
            jSONObject.put("iTrigger", (Object)jSONObject2);
        }
        jSONObject2 = this.getTaskParameters().createJSON();
        jSONObject.put("taskParameters", (Object)jSONObject2);
        return jSONObject;
    }

    private boolean triggerExist() {
        return this.getITrigger() != null && this.getITrigger().getStartTime() != null && this.getITrigger().getStartTime().getTime() > System.currentTimeMillis();
    }

    protected abstract void setTriggerState(JSONObject var1) throws JSONException;

    public boolean equals(Object object) {
        if (!(object instanceof ItriggerTask)) {
            return false;
        }
        ItriggerTask itriggerTask = (ItriggerTask)object;
        return this.id == itriggerTask.id && ComparatorUtils.equals((Object)this.name, (Object)itriggerTask.name) && ComparatorUtils.equals((Object)this.description, (Object)itriggerTask.description) && ComparatorUtils.equals((Object)this.iTrigger, (Object)itriggerTask.iTrigger) && ComparatorUtils.equals((Object)itriggerTask.getTaskParameters(), (Object)this.getTaskParameters());
    }
}

