/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.ExcelUtils;
import com.fr.base.TemplateUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.cache.EntryCache;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.fs.web.platform.entry.FileEntry;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.ImageExporter;
import com.fr.io.exporter.PDFExporter;
import com.fr.io.exporter.WordExporter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.workbook.AnalyRWorkBook;
import com.fr.main.workbook.AnalyWorkBook;
import com.fr.main.workbook.PageRWorkBook;
import com.fr.main.workbook.PageWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.schedule.output.AbstractOutputFileAction;
import com.fr.schedule.output.ClassOutputFileAction;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FTPTransmission;
import com.fr.schedule.output.FileActionList;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.output.OutputFileFormat;
import com.fr.schedule.output.PrintRWorkbookAction;
import com.fr.schedule.output.PushOutputFileAction;
import com.fr.schedule.util.ScheduleConstants;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledOutput
implements XMLable {
    public static final String XML_TAG = "ScheduleOutput";
    public static final String TABLE_NAME = "fr_schedule_output";
    public static final long HIDE_FILEENTRY_PARENTID = -1L;
    private static FRLogger log = FRLogger.getLogger();
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(ScheduledOutput.class, new Table("fr_schedule_output"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, "id", new ColumnSize(20), false, true), new CommonFieldColumnMapper("baseFileName", 12, "base_name", new ColumnSize(255), true), new CommonFieldColumnMapper("description", 12, "description", new ColumnSize(255), true), new CommonFieldColumnMapper("folderEntryId", 4, "folderEntryId", new ColumnSize(20), true), new CommonFieldColumnMapper("isCreateCPRByUsername", 16, "isCreateCPRByUsername", new ColumnSize(20), true), new CommonFieldColumnMapper("isSendEmailByUsername", 16, "isSendEmailByUsername", new ColumnSize(20), true), new CommonFieldColumnMapper("usernames", 12, "usernames", new ColumnSize(1023), true), new CommonFieldColumnMapper("outputFileFormat", 4, "format", new ColumnSize(10), true, new FCValueMapper(){

        public Object value2Field(Object object) {
            if (object == null) {
                return new OutputFileFormat();
            }
            OutputFileFormat outputFileFormat = new OutputFileFormat();
            outputFileFormat.setFormat(((Number)object).intValue());
            return outputFileFormat;
        }

        public Object field2Value(Object object) {
            if (object == null) {
                return new Integer(new OutputFileFormat().getFormat());
            }
            try {
                return StableUtils.getPrivateFieldValue((Object)object, (String)"format");
            }
            catch (Exception exception) {
                ScheduleLogUtils.error(exception);
                return null;
            }
        }
    }), new CompatiableIDFCMapper(FileActionList.class, "outputFileActionList", -5, "listId", new ColumnSize(20), true)}, 0);
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String baseFileName;
    private String description;
    private long folderEntryId = -1L;
    private OutputFileFormat outputFileFormat;
    private FileActionList outputFileActionList = null;
    private boolean isCreateCPRByUsername;
    private boolean isSendEmailByUsername;
    private String usernames = "";
    private FileRepository fileRepository = new FileRepository();

    public ScheduledOutput() {
    }

    public ScheduledOutput(String string, String string2, FileRepository fileRepository, OutputFileFormat outputFileFormat, FileActionList fileActionList) {
        this.baseFileName = string;
        this.description = string2;
        this.fileRepository = fileRepository;
        this.outputFileFormat = outputFileFormat;
        this.outputFileActionList = fileActionList;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("baseFileName", (Object)this.getBaseFileName());
        jSONObject.put("description", (Object)this.getDescription());
        jSONObject.put("isCreateCPRByUsername", this.isCreateCPRByUsername);
        jSONObject.put("isSendEmailByUsername", this.isSendEmailByUsername);
        jSONObject.put("usernames", (Object)this.usernames);
        if (this.getFolderEntryId() > -1L) {
            jSONObject.put("folderEntryId", (Object)("0" + this.getFolderEntryId()));
        }
        JSONObject jSONObject2 = this.getOutputFileFormat().createJSONConfig();
        jSONObject.put("outputFileFormat", (Object)jSONObject2);
        if (this.getOutputFileActionList() != null) {
            this.synFileActionList();
            JSONObject jSONObject3 = new JSONObject();
            int n = this.getOutputFileActionList().size();
            for (int i = 0; i < n; ++i) {
                OutputFileAction outputFileAction = (OutputFileAction)this.getOutputFileActionList().get(i);
                String string = outputFileAction.getJsonTag();
                JSONObject jSONObject4 = outputFileAction.createJSONConfig();
                jSONObject3.put(string, (Object)jSONObject4);
            }
            jSONObject.put("outputFileActionList", (Object)jSONObject3);
        }
        return jSONObject;
    }

    public static ScheduledOutput analyzeJSON(JSONObject jSONObject) {
        try {
            ScheduledOutput scheduledOutput = null;
            if (jSONObject.length() == 0) {
                return null;
            }
            scheduledOutput = jSONObject.has("id") ? (ScheduledOutput)ScheduleContext.createDAOSession().load(ScheduledOutput.class, jSONObject.getLong("id")) : new ScheduledOutput();
            String string = jSONObject.getString("baseFileName");
            String string2 = jSONObject.getString("description");
            boolean bl = jSONObject.getBoolean("isCreateCPRByUsername");
            String string3 = jSONObject.getString("usernames");
            boolean bl2 = jSONObject.getBoolean("isSendEmailByUsername");
            long l = -1L;
            if (jSONObject.has("folderEntryId")) {
                l = jSONObject.getLong("folderEntryId");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("outputFileFormat");
            OutputFileFormat outputFileFormat = OutputFileFormat.analyzeJSON(jSONObject2);
            FileActionList fileActionList = new FileActionList();
            if (jSONObject.has("outputFileActionList")) {
                ScheduledOutput.analysisOutputFileList(jSONObject, fileActionList);
            }
            scheduledOutput.setBaseFileName(string);
            scheduledOutput.setDescription(string2);
            scheduledOutput.setFolderEntryId(l);
            scheduledOutput.setOutputFileFormat(outputFileFormat);
            scheduledOutput.setOutputFileActionList(fileActionList);
            scheduledOutput.setCreateCPRByUsername(bl);
            scheduledOutput.setSendEmailByUsername(bl2);
            scheduledOutput.setUsernames(string3);
            return scheduledOutput;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    private static void analysisOutputFileList(JSONObject jSONObject, FileActionList fileActionList) throws JSONException {
        EmailNotification emailNotification = new EmailNotification();
        FTPTransmission fTPTransmission = new FTPTransmission();
        PrintRWorkbookAction printRWorkbookAction = new PrintRWorkbookAction();
        ClassOutputFileAction classOutputFileAction = new ClassOutputFileAction();
        PushOutputFileAction pushOutputFileAction = new PushOutputFileAction();
        JSONObject jSONObject2 = jSONObject.getJSONObject("outputFileActionList");
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, emailNotification, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, fTPTransmission, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, printRWorkbookAction, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, classOutputFileAction, fileActionList);
        ScheduledOutput.dealWithOutputFileAction(jSONObject2, pushOutputFileAction, fileActionList);
    }

    private static void dealWithOutputFileAction(JSONObject jSONObject, OutputFileAction outputFileAction, FileActionList fileActionList) throws JSONException {
        String string = outputFileAction.getJsonTag();
        if (jSONObject.has(string)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            fileActionList.addFileAction(outputFileAction.analyzeJSON(jSONObject2));
        }
    }

    public File[] exportReportFiles(PageWorkBook pageWorkBook, String string, File file) throws Exception {
        if (this.outputFileFormat == null) {
            return new File[0];
        }
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        File file2 = ScheduledOutput.generateUnExsitFile(file, string, ".cpr", string3);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ((PageRWorkBook)pageWorkBook).export((OutputStream)fileOutputStream);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        arrayList.add(file2);
        FileEntry fileEntry = new FileEntry(string2 + ".cpr", this.description, file2.getAbsolutePath());
        fileEntry.setParentId(this.folderEntryId);
        this.checkCPRExsists(fileEntry);
        if (this.folderEntryId != -1L && ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
            ScheduleLinkOutput scheduleLinkOutput = new ScheduleLinkOutput(this.id, fileEntry.getId());
            ScheduleContext.createDAOSession().saveOrUpdate((Object)scheduleLinkOutput);
            EntryCache.cache(fileEntry);
        }
        this.dealWithOutputFiles(pageWorkBook, string, file, arrayList);
        this.dealWithEmailPreviewFile(pageWorkBook, string, file, arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private void checkCPRExsists(FileEntry fileEntry) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("displayName", fileEntry.getDisplayName());
        hashMap.put("parentId", fileEntry.getParentId());
        List list = ScheduleContext.createDAOSession().listByFieldValues(FileEntry.class, hashMap);
        if (!list.isEmpty()) {
            FileEntry fileEntry2 = (FileEntry)list.get(list.size() - 1);
            fileEntry.setId(fileEntry2.getId());
        }
    }

    private void dealWithOutputFiles(PageWorkBook pageWorkBook, String string, File file, List<File> list) throws Exception {
        FileEntry fileEntry;
        Object object;
        Object object2;
        Object object3;
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        if (this.outputFileFormat.isConvertToExcel()) {
            object3 = ExcelUtils.checkPOIJarExist() ? ".xlsx" : ".xls";
            object2 = ScheduledOutput.generateUnExsitFile(file, string, (String)object3, string3);
            object = new FileOutputStream((File)object2);
            new ExcelExporter().export((OutputStream)object, (ResultWorkBook)pageWorkBook);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            list.add((File)object2);
            fileEntry = new FileEntry(string2 + (String)object3, this.description, ((File)object2).getAbsolutePath());
            fileEntry.setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
                EntryCache.cache(fileEntry);
            }
        }
        if (this.outputFileFormat.isConvertToPdf()) {
            object3 = ScheduledOutput.generateUnExsitFile(file, string, ".pdf", string3);
            object2 = new FileOutputStream((File)object3);
            new PDFExporter().export((OutputStream)object2, (ResultWorkBook)pageWorkBook);
            ((OutputStream)object2).flush();
            ((OutputStream)object2).close();
            list.add((File)object3);
            object = new FileEntry(string2 + ".pdf", this.description, ((File)object3).getAbsolutePath());
            ((BaseEntry)object).setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate(object)) {
                EntryCache.cache((Entry)object);
            }
        }
        if (this.outputFileFormat.isConvertToWord()) {
            object3 = ".doc";
            object2 = ScheduledOutput.generateUnExsitFile(file, string, (String)object3, string3);
            object = new FileOutputStream((File)object2);
            new WordExporter().export((OutputStream)object, (ResultWorkBook)pageWorkBook);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            list.add((File)object2);
            fileEntry = new FileEntry(string2 + (String)object3, this.description, ((File)object2).getAbsolutePath());
            fileEntry.setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
                EntryCache.cache(fileEntry);
            }
        }
    }

    private void dealWithEmailPreviewFile(PageWorkBook pageWorkBook, String string, File file, List<File> list) throws Exception {
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        EmailNotification emailNotification = null;
        if (this.outputFileActionList != null) {
            emailNotification = this.outputFileActionList.getEmailNotification();
        }
        if (emailNotification != null && emailNotification.getCanPreviewAttach().booleanValue()) {
            File file2 = ScheduledOutput.generateUnExsitFile(file, string, ".png", string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            new ImageExporter("png").export((OutputStream)fileOutputStream, (ResultWorkBook)pageWorkBook);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            list.add(file2);
            FileEntry fileEntry = new FileEntry(string2 + ".png", this.description, file2.getAbsolutePath());
            fileEntry.setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
                EntryCache.cache(fileEntry);
            }
        }
    }

    public File[] exportAnalyReportFiles(AnalyWorkBook analyWorkBook, String string, File file) throws Exception {
        if (this.outputFileFormat == null) {
            return new File[0];
        }
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        File file2 = ScheduledOutput.generateUnExsitFile(file, string, ".cpr", string3);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ((AnalyRWorkBook)analyWorkBook).export((OutputStream)fileOutputStream);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        arrayList.add(file2);
        FileEntry fileEntry = new FileEntry(string2 + ".cpr", this.description, file2.getAbsolutePath());
        fileEntry.setParentId(this.folderEntryId);
        if (this.folderEntryId != -1L && ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
            ScheduleLinkOutput scheduleLinkOutput = new ScheduleLinkOutput(this.id, fileEntry.getId());
            ScheduleContext.createDAOSession().saveOrUpdate((Object)scheduleLinkOutput);
            EntryCache.cache(fileEntry);
        }
        this.dealWithAnalyOutputFiles(analyWorkBook, string, file, arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private void dealWithAnalyOutputFiles(AnalyWorkBook analyWorkBook, String string, File file, List list) throws Exception {
        FileEntry fileEntry;
        Object object;
        Object object2;
        Object object3;
        String string2 = TemplateUtils.render((String)this.baseFileName, (Calculator)Calculator.createCalculator());
        String string3 = this.fileNameForWindows(TemplateUtils.renderTpl((CalculatorProvider)Calculator.createCalculator(), (String)this.getBaseFileName()));
        if (this.outputFileFormat.isConvertToExcel()) {
            object3 = ExcelUtils.checkPOIJarExist() ? ".xlsx" : ".xls";
            object2 = ScheduledOutput.generateUnExsitFile(file, string, (String)object3, string3);
            object = new FileOutputStream((File)object2);
            new ExcelExporter().export((OutputStream)object, (ResultWorkBook)analyWorkBook);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            list.add(object2);
            fileEntry = new FileEntry(string2 + (String)object3, this.description, ((File)object2).getAbsolutePath());
            fileEntry.setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
                EntryCache.cache(fileEntry);
            }
        }
        if (this.outputFileFormat.isConvertToPdf()) {
            object3 = ScheduledOutput.generateUnExsitFile(file, string, ".pdf", string3);
            object2 = new FileOutputStream((File)object3);
            new PDFExporter().export((OutputStream)object2, (ResultWorkBook)analyWorkBook);
            ((OutputStream)object2).flush();
            ((OutputStream)object2).close();
            list.add(object3);
            object = new FileEntry(string2 + ".pdf", this.description, ((File)object3).getAbsolutePath());
            ((BaseEntry)object).setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate(object)) {
                EntryCache.cache((Entry)object);
            }
        }
        if (this.outputFileFormat.isConvertToWord()) {
            object3 = ".doc";
            object2 = ScheduledOutput.generateUnExsitFile(file, string, (String)object3, string3);
            object = new FileOutputStream((File)object2);
            new WordExporter().export((OutputStream)object, (ResultWorkBook)analyWorkBook);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            list.add(object2);
            fileEntry = new FileEntry(string2 + (String)object3, this.description, ((File)object2).getAbsolutePath());
            fileEntry.setParentId(-1L);
            if (ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) {
                EntryCache.cache(fileEntry);
            }
        }
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setBaseFileName(String string) {
        this.baseFileName = string;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFolderEntryId(long l) {
        this.folderEntryId = l;
    }

    public long getFolderEntryId() {
        return this.folderEntryId;
    }

    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public FileRepository getFileRepository() {
        return this.fileRepository;
    }

    public void setOutputFileFormat(OutputFileFormat outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public OutputFileFormat getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setOutputFileActionList(FileActionList fileActionList) {
        if (this.id != 0L && this.outputFileActionList != null) {
            int n = this.outputFileActionList.size();
            for (int i = 0; i < n; ++i) {
                AbstractOutputFileAction abstractOutputFileAction;
                if (this.outputFileActionList.get(i) instanceof EmailNotification) {
                    abstractOutputFileAction = (EmailNotification)this.outputFileActionList.get(i);
                    ScheduleContext.createDAOSession().deleteByPrimaryKey(EmailNotification.class, ((EmailNotification)abstractOutputFileAction).getId());
                    continue;
                }
                if (this.outputFileActionList.get(i) instanceof FTPTransmission) {
                    abstractOutputFileAction = (FTPTransmission)this.outputFileActionList.get(i);
                    ScheduleContext.createDAOSession().deleteByPrimaryKey(FTPTransmission.class, ((FTPTransmission)abstractOutputFileAction).getId());
                    continue;
                }
                if (this.outputFileActionList.get(i) instanceof PrintRWorkbookAction) {
                    abstractOutputFileAction = (PrintRWorkbookAction)this.outputFileActionList.get(i);
                    ScheduleContext.createDAOSession().deleteByPrimaryKey(PrintRWorkbookAction.class, ((PrintRWorkbookAction)abstractOutputFileAction).getId());
                    continue;
                }
                if (!(this.outputFileActionList.get(i) instanceof ClassOutputFileAction)) continue;
                abstractOutputFileAction = (ClassOutputFileAction)this.outputFileActionList.get(i);
                ScheduleContext.createDAOSession().deleteByPrimaryKey(ClassOutputFileAction.class, ((ClassOutputFileAction)abstractOutputFileAction).getId());
            }
        }
        this.outputFileActionList = fileActionList;
    }

    public FileActionList getOutputFileActionList() {
        return this.outputFileActionList;
    }

    public void synFileActionList() {
        if (this.outputFileActionList != null) {
            if (this.outputFileActionList.getEmailNotification() != null) {
                this.outputFileActionList.add(this.outputFileActionList.getEmailNotification());
            }
            if (this.outputFileActionList.getFtpTransmission() != null) {
                this.outputFileActionList.add(this.outputFileActionList.getFtpTransmission());
            }
            if (this.outputFileActionList.getClassOutputFileAction() != null) {
                this.outputFileActionList.add(this.outputFileActionList.getClassOutputFileAction());
            }
            if (this.outputFileActionList.getPrintRWorkbookAction() != null) {
                this.outputFileActionList.add(this.outputFileActionList.getPrintRWorkbookAction());
            }
            if (this.outputFileActionList.getPushOutputFileAction() != null) {
                this.outputFileActionList.add(this.outputFileActionList.getPushOutputFileAction());
            }
        }
    }

    private static File generateUnExsitFile(File file, String string, String string2, String string3) {
        File file2 = new File(file, string3 + string2);
        while (file2.exists()) {
            file2 = new File(file, string + "_" + DateUtils.getDate2AllIncludeSSS((Date)new Date()) + "_" + ScheduleConstants.RANDOM.nextInt(1000) + string2);
        }
        return file2;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("baseFileName", null);
            if (string != null) {
                this.setBaseFileName(string);
            }
            if ((string = xMLableReader.getAttrAsString("description", null)) != null) {
                this.setDescription(string);
            }
        } else if (xMLableReader.isChildNode()) {
            if ("FileRepository".equals(xMLableReader.getTagName())) {
                this.fileRepository = (FileRepository)xMLableReader.readXMLObject((XMLReadable)new FileRepository());
            } else if ("OutputFileFormat".equals(xMLableReader.getTagName())) {
                this.outputFileFormat = (OutputFileFormat)xMLableReader.readXMLObject((XMLReadable)new OutputFileFormat());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("baseFileName", this.baseFileName).attr("description", this.description);
        if (this.fileRepository != null) {
            this.fileRepository.writeXML(xMLPrintWriter);
        }
        if (this.outputFileFormat != null) {
            this.outputFileFormat.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduledOutput)) {
            return false;
        }
        ScheduledOutput scheduledOutput = (ScheduledOutput)object;
        return ComparatorUtils.equals((Object)this.baseFileName, (Object)scheduledOutput.baseFileName) && ComparatorUtils.equals((Object)this.description, (Object)scheduledOutput.description) && ComparatorUtils.equals((Object)this.fileRepository, (Object)scheduledOutput.fileRepository) && ComparatorUtils.equals((Object)this.outputFileFormat, (Object)scheduledOutput.outputFileFormat) && ComparatorUtils.equals((Object)this.outputFileActionList, (Object)scheduledOutput.outputFileActionList);
    }

    public Object clone() throws CloneNotSupportedException {
        ScheduledOutput scheduledOutput = (ScheduledOutput)super.clone();
        if (this.fileRepository != null) {
            scheduledOutput.setFileRepository((FileRepository)this.fileRepository.clone());
        }
        if (this.outputFileFormat != null) {
            scheduledOutput.setOutputFileFormat((OutputFileFormat)this.outputFileFormat.clone());
        }
        if (this.outputFileActionList != null) {
            scheduledOutput.setOutputFileActionList((FileActionList)this.outputFileActionList.clone());
        }
        return scheduledOutput;
    }

    private String fileNameForWindows(String string) {
        string = string.replaceAll(":", "\uff1a");
        string = string.replaceAll("\\*", "");
        string = string.replaceAll("\"", "");
        string = string.replaceAll("/", "");
        string = string.replaceAll("\\\\", "");
        string = string.replaceAll(">", "");
        string = string.replaceAll("<", "");
        string = string.replaceAll("\\?", "");
        string = string.replaceAll("|", "");
        return string;
    }

    public String getUsernames() {
        return this.usernames;
    }

    public void setUsernames(String string) {
        this.usernames = string;
    }

    public boolean isSendEmailByUsername() {
        return this.isSendEmailByUsername;
    }

    public void setSendEmailByUsername(boolean bl) {
        this.isSendEmailByUsername = bl;
    }

    public boolean isCreateCPRByUsername() {
        return this.isCreateCPRByUsername;
    }

    public void setCreateCPRByUsername(boolean bl) {
        this.isCreateCPRByUsername = bl;
    }
}

