/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class OutputFileFormat
implements XMLable {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "OutputFileFormat";
    private static final int CONVERT_TO_EXCEL = 1;
    private static final int CONVERT_TO_PDF = 2;
    private static final int CONVERT_TO_WORD = 4;
    private static FRLogger log = FRLogger.getLogger();
    private int format = 1;

    public OutputFileFormat() {
    }

    public OutputFileFormat(boolean bl, boolean bl2, boolean bl3) {
        this.setConvertToExcel(bl);
        this.setConvertToPdf(bl2);
        this.setConvertToWord(bl3);
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isConvertToExcel", this.isConvertToExcel());
        jSONObject.put("isConvertToPdf", this.isConvertToPdf());
        jSONObject.put("isConvertToWord", this.isConvertToWord());
        return jSONObject;
    }

    public static OutputFileFormat analyzeJSON(JSONObject jSONObject) {
        try {
            boolean bl = jSONObject.getBoolean("isConvertToExcel");
            boolean bl2 = jSONObject.getBoolean("isConvertToPdf");
            boolean bl3 = jSONObject.getBoolean("isConvertToWord");
            return new OutputFileFormat(bl, bl2, bl3);
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean isConvertToExcel() {
        return (this.getFormat() & 1) != 0;
    }

    public void setConvertToExcel(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 1);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFFE);
        }
    }

    public boolean isConvertToPdf() {
        return (this.getFormat() & 2) != 0;
    }

    public void setConvertToPdf(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 2);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFFD);
        }
    }

    public boolean isConvertToWord() {
        return (this.getFormat() & 4) != 0;
    }

    public void setConvertToWord(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 4);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFFB);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setFormat(xMLableReader.getAttrAsInt("format", 1));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("format", this.getFormat()).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OutputFileFormat)) {
            return false;
        }
        OutputFileFormat outputFileFormat = (OutputFileFormat)object;
        return outputFileFormat.getFormat() == this.getFormat();
    }

    public Object clone() throws CloneNotSupportedException {
        OutputFileFormat outputFileFormat = (OutputFileFormat)super.clone();
        return outputFileFormat;
    }
}

