/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.output.AbstractOutputFileAction;
import com.fr.schedule.output.FTPException;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;

public class FTPTransmission
extends AbstractOutputFileAction {
    public static final String TABLE_NAME = "fr_schedule_ftp";
    private static FRLogger log = FRLogger.getLogger();
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(FTPTransmission.class, new Table("fr_schedule_ftp"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(20), false, true), new CommonFieldColumnMapper("serverAddress", 12, "serverAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("port", 4, "port", new ColumnSize(255), true), new CommonFieldColumnMapper("savePath", 12, "savePath", new ColumnSize(255), true), new CommonFieldColumnMapper("username", 12, "username", new ColumnSize(255), true), new CommonFieldColumnMapper("password", 12, "password", new ColumnSize(255), true)});
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String serverAddress = null;
    private int port = -1;
    private String savePath = null;
    private String username = null;
    private String password = null;
    private int arraySizeForFileBytes = 1024;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String string) {
        this.serverAddress = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String string) {
        this.savePath = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public File[] getFilesToDealWith(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.getPdfFromOutputFile(fileArray) != null) {
            arrayList.add(this.getPdfFromOutputFile(fileArray));
        }
        if (this.getWordFromOutputFile(fileArray) != null) {
            arrayList.add(this.getWordFromOutputFile(fileArray));
        }
        if (this.getExcelFromOutputFile(fileArray) != null) {
            arrayList.add(this.getExcelFromOutputFile(fileArray));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public void doFTP(File[] fileArray) throws Exception {
        Object object;
        Object object2;
        Class<FtpClient> clazz = FtpClient.class;
        Boolean bl = true;
        try {
            object2 = clazz.getMethod("create", new Class[0]);
            object = ((Method)object2).invoke(clazz, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = clazz.newInstance();
            bl = false;
        }
        object2 = null;
        FileInputStream fileInputStream = null;
        try {
            Method method;
            Method method2;
            Method method3;
            Method method4;
            File[] fileArray2;
            if (bl.booleanValue()) {
                fileArray2 = clazz.getMethod("connect", SocketAddress.class);
                fileArray2.invoke(object, new InetSocketAddress(this.getServerAddress(), this.getPort()));
                method4 = clazz.getMethod("login", String.class, char[].class);
                method4.invoke(object, this.getUsername(), this.getPassword().toCharArray());
                method3 = clazz.getMethod("changeDirectory", String.class);
                method2 = clazz.getMethod("setBinaryType", new Class[0]);
                method = clazz.getMethod("putFileStream", String.class);
            } else {
                fileArray2 = clazz.getMethod("openServer", String.class, Integer.TYPE);
                fileArray2.invoke(object, this.getServerAddress(), this.getPort());
                method4 = clazz.getMethod("login", String.class, String.class);
                method4.invoke(object, this.getUsername(), this.getPassword());
                method3 = clazz.getMethod("cd", String.class);
                method2 = clazz.getMethod("binary", new Class[0]);
                method = clazz.getMethod("put", String.class);
            }
            if (StringUtils.isNotBlank((String)this.getSavePath())) {
                method3.invoke(object, this.getSavePath());
            }
            method2.invoke(object, new Object[0]);
            for (File file : fileArray) {
                int n;
                if (file == null || !file.exists()) {
                    throw new IOException("File does not exit!");
                }
                object2 = (TelnetOutputStream)method.invoke(object, file.getName());
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[this.arraySizeForFileBytes];
                while ((n = fileInputStream.read(byArray)) != -1) {
                    ((TelnetOutputStream)object2).write(byArray, 0, n);
                }
                ((BufferedOutputStream)object2).flush();
                ((FilterOutputStream)object2).close();
            }
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            throw new FTPException(exception);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (object2 != null) {
                ((FilterOutputStream)object2).close();
            }
        }
    }

    public void doFileAction(File[] fileArray) throws Exception {
        try {
            this.doFTP(fileArray);
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            throw exception;
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("serverAddress", (Object)this.getServerAddress());
        jSONObject.put("port", this.getPort());
        jSONObject.put("savePath", (Object)this.getSavePath());
        jSONObject.put("username", (Object)this.getUsername());
        jSONObject.put("password", (Object)this.getPassword());
        return jSONObject;
    }

    public OutputFileAction analyzeJSON(JSONObject jSONObject) {
        try {
            FTPTransmission fTPTransmission = null;
            fTPTransmission = jSONObject.has("id") ? (FTPTransmission)ScheduleContext.createDAOSession().load(FTPTransmission.class, jSONObject.getLong("id")) : new FTPTransmission();
            String string = jSONObject.getString("serverAddress");
            int n = jSONObject.getInt("port");
            String string2 = jSONObject.getString("savePath");
            String string3 = jSONObject.getString("username");
            String string4 = jSONObject.getString("password");
            fTPTransmission.setServerAddress(string);
            fTPTransmission.setPort(n);
            fTPTransmission.setSavePath(string2);
            fTPTransmission.setUsername(string3);
            fTPTransmission.setPassword(string4);
            return fTPTransmission;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getJsonTag() {
        return "ftpTransmission";
    }

    public boolean isEmailNotification() {
        return false;
    }
}

