/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.cache.MemoryStoreEvictionPolicy;
import com.fr.file.CacheManager;
import com.fr.file.DatasourceManager;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServerConfigService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.web.Printer;
import com.fr.stable.EncodeConstants;
import com.fr.web.attr.ReportWebAttr;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigGetInfoAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 5L)) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        this.addBasciInfo(jSONObject);
        this.addCacheInfo(jSONObject);
        this.addEmailInfo(jSONObject);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private void addBasciInfo(JSONObject jSONObject) throws JSONException {
        if (ServerConfigService.PLATFORM_VERSIONID == -1L) {
            ServerConfigService.PLATFORM_VERSIONID = new Date().getTime();
        }
        jSONObject.put("fr_platform_version", ServerConfigService.PLATFORM_VERSIONID);
        String string = "reportlets";
        String string2 = "resources";
        String string3 = ConfigManager.getInstance().getServerCharset();
        String[] stringArray = EncodeConstants.ENCODING_ARRAY;
        String string4 = ConfigManager.getInstance().getServletMapping();
        boolean bl = ConfigManager.getInstance().isSupportGzip();
        boolean bl2 = ConfigManager.getInstance().isDownChromeFrameInLocal();
        boolean bl3 = ConfigManager.getInstance().isLicUseLock();
        boolean bl4 = ConfigManager.getInstance().isPopupFlashPrintSetting();
        boolean bl5 = ConfigManager.getInstance().isFitPaper();
        boolean bl6 = ConfigManager.getInstance().isPopupPdfPrintSetting();
        boolean bl7 = ConfigManager.getInstance().isPopupAppletPrintSetting();
        Level[] levelArray = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO};
        Level level = ConfigManager.getInstance().getServerLogLevel();
        String[] stringArray2 = GeneralUtils.getSystemPrinterNameArray();
        ReportWebAttr reportWebAttr = (ReportWebAttr)ConfigManager.getInstance().getGlobalAttribute(ReportWebAttr.class);
        Printer printer = reportWebAttr == null ? null : reportWebAttr.getPrinter();
        String[] stringArray3 = printer != null ? printer.getPrinters() : new String[]{};
        jSONObject.put("reportletsName", (Object)string);
        jSONObject.put("resourcesName", (Object)string2);
        jSONObject.put("serverCharSet", (Object)string3);
        jSONObject.put("encodingArray", (Object)stringArray);
        jSONObject.put("serverletMapping", (Object)string4);
        jSONObject.put("isSupportGzip", bl);
        jSONObject.put("isDownChromeFrameInLocal", bl2);
        jSONObject.put("isLicUseLock", bl3);
        jSONObject.put("isPopupFlashPrintSetting", bl4);
        jSONObject.put("isFitPaper", bl5);
        jSONObject.put("isPopupPdfPrintSetting", bl6);
        jSONObject.put("isPopupAppletPrintSetting", bl7);
        jSONObject.put("LOG_LEVELS", (Object)levelArray);
        jSONObject.put("serverLogLevel", (Object)level);
        jSONObject.put("serverPrinterList", (Object)stringArray2);
        jSONObject.put("serverActivePrinterList", (Object)stringArray3);
    }

    private void addCacheInfo(JSONObject jSONObject) throws JSONException {
        if (ServerConfigService.PLATFORM_VERSIONID == -1L) {
            ServerConfigService.PLATFORM_VERSIONID = new Date().getTime();
        }
        jSONObject.put("fr_platform_version", ServerConfigService.PLATFORM_VERSIONID);
        int n = CacheManager.getInstance().getDbConfig().getMaxElementsInMemory();
        MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = CacheManager.getInstance().getDbConfig().getMemoryStoreEvictionPolicy();
        long l = CacheManager.getInstance().getDbConfig().getTimeToIdleSeconds();
        long l2 = CacheManager.getInstance().getDbConfig().getTimeToLiveSeconds();
        boolean bl = CacheManager.getInstance().isAlwaysReloadTpl();
        jSONObject.put("maxElementsInMemory", n);
        jSONObject.put("memoryStoreEvictionPolicy", (Object)memoryStoreEvictionPolicy);
        jSONObject.put("timeToIdleSeconds", l);
        jSONObject.put("timeToLiveSeconds", l2);
        jSONObject.put("alwaysReloadTpl", bl);
    }

    private void addEmailInfo(JSONObject jSONObject) throws JSONException {
        if (ServerConfigService.PLATFORM_VERSIONID == -1L) {
            ServerConfigService.PLATFORM_VERSIONID = new Date().getTime();
        }
        jSONObject.put("fr_platform_version", ServerConfigService.PLATFORM_VERSIONID);
        EmailManager emailManager = ConfigManager.getInstance().getEmailManager();
        String string = emailManager.getMailHost();
        String string2 = emailManager.getPort();
        String string3 = emailManager.getEncryptionMethod();
        String string4 = emailManager.getUser();
        String string5 = emailManager.getPassword();
        String string6 = emailManager.getFromEmailAddress();
        HashSet<String> hashSet = new HashSet<String>();
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        Iterator iterator = datasourceManager.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string7 = (String)iterator.next();
            hashSet.add(string7);
        }
        jSONObject.put("tableDataNameSet", hashSet);
        jSONObject.put("serverName", (Object)string);
        jSONObject.put("serverPort", (Object)string2);
        jSONObject.put("encryptionMethod", (Object)string3);
        jSONObject.put("userName", (Object)string4);
        jSONObject.put("passWord", (Object)string5);
        jSONObject.put("fromAddress", (Object)string6);
    }

    public String getCMD() {
        return "sc_get_configinfo";
    }
}

