/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.BaseUtils;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSSystemGlobalAttrExamineAction
extends ActionNoSessionCMD {
    private static List nameStyleList;
    private static JSONArray globalAttrResult;

    public String getCMD() {
        return "globalattr";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 9L)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        nameStyleList = this.getAllNameStyle();
        globalAttrResult = new JSONArray();
        this.examCptsForGlobalAttrs("reportlets");
        printWriter.print(BaseUtils.jsonEncode((Object)globalAttrResult));
        printWriter.flush();
        printWriter.close();
    }

    private List getAllNameStyle() {
        ArrayList arrayList = new ArrayList();
        if (ConfigManager.getInstance().hasStyle()) {
            Iterator iterator = ConfigManager.getInstance().getStyleNameIterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    private void examCptsForGlobalAttrs(String string) throws Exception {
        FileNode[] fileNodeArray = FRContext.getCurrentEnv().listCpt(string);
        for (int i = 0; i < fileNodeArray.length; ++i) {
            if (!fileNodeArray[i].isDirectory()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    StableUtils.pathJoin((String[])new String[]{string, fileNodeArray[i].getName()});
                    String string2 = StableUtils.pathJoin((String[])new String[]{StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), string}), fileNodeArray[i].getName()});
                    File file = new File(string2);
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(file);
                    Element element = document.getDocumentElement();
                    for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (!"StyleList".equals(node.getNodeName())) continue;
                        NodeList nodeList = node.getChildNodes();
                        for (int j = 0; j < nodeList.getLength(); ++j) {
                            String string3;
                            Node node2;
                            Node node3 = nodeList.item(j);
                            if (!"Style".equals(node3.getNodeName()) || (node2 = node3.getAttributes().getNamedItem("style_name")) == null || nameStyleList.contains(string3 = node2.getNodeValue())) continue;
                            jSONObject.put("cpt_name", (Object)(string + '/' + fileNodeArray[i].getName()));
                            jSONObject.put("style_name", (Object)string3);
                            globalAttrResult.put((Object)jSONObject);
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    jSONObject.put("cpt_name", (Object)(string + '/' + fileNodeArray[i].getName()));
                    jSONObject.put("style_name", false);
                    globalAttrResult.put((Object)jSONObject);
                    continue;
                }
            }
            this.examCptsForGlobalAttrs(StableUtils.pathJoin((String[])new String[]{string, fileNodeArray[i].getName()}));
        }
    }

    static {
        globalAttrResult = new JSONArray();
    }
}

