/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.BaseUtils;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthSaveAction
extends ActionNoSessionCMD {
    public static String modules = "modules";
    public static String reports = "reports";
    public static String add = "add";
    public static String remove = "remove";
    private final Object lock = new Object();
    private static String customRoleRootID = "-99";

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        JSONArray jSONArray = (JSONArray)BaseUtils.jsonDecode((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"companyRole"));
        JSONArray jSONArray2 = (JSONArray)BaseUtils.jsonDecode((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"customRole"));
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        try {
            this.addCompanyRolePrivilege(jSONArray);
            this.addCustomRolePrivilege(jSONArray2);
        }
        catch (Exception exception) {
            printWriter.print("error");
            printWriter.flush();
            printWriter.close();
            return;
        }
        printWriter.print("success");
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_save";
    }

    private void addCompanyRolePrivilege(JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            long l = jSONObject.getLong("departmentId");
            long l2 = CompanyRoleControl.getInstance().getPostAllID();
            if (jSONObject.has("postId")) {
                l2 = jSONObject.getLong("postId");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("modules");
            Set set = FSSetAuthSaveAction.string2ModuleSet(jSONObject2.getString("add"));
            Set set2 = FSSetAuthSaveAction.string2ModuleSet(jSONObject2.getString("remove"));
            JSONObject jSONObject3 = jSONObject.getJSONObject("entries");
            Set set3 = FSSetAuthSaveAction.string2EntrySet(jSONObject3.getString("add"));
            Set set4 = FSSetAuthSaveAction.string2EntrySet(jSONObject3.getString("remove"));
            JSONObject jSONObject4 = jSONObject.getJSONObject("templates");
            Set set5 = FSSetAuthSaveAction.string2TemplateSet(jSONObject4.getString("add"));
            Set set6 = FSSetAuthSaveAction.string2TemplateSet(jSONObject4.getString("remove"));
            JSONObject jSONObject5 = jSONObject.getJSONObject("depandcroles");
            Set<String> set7 = FSSetAuthSaveAction.string2Set(jSONObject5.getString("add"));
            Set<String> set8 = FSSetAuthSaveAction.string2Set(jSONObject5.getString("remove"));
            JSONObject jSONObject6 = jSONObject.getJSONObject("dataconnections");
            Set<String> set9 = FSSetAuthSaveAction.string2Set(jSONObject6.getString("add"));
            Set<String> set10 = FSSetAuthSaveAction.string2Set(jSONObject6.getString("remove"));
            CompanyRole companyRole = CompanyRoleControl.getInstance().getOrCreateAllRole(l, l2);
            if (companyRole == null) {
                return;
            }
            CompanyRoleControl.getInstance().updateEntryPrivileges(companyRole.getId(), set3, set4);
            CompanyRoleControl.getInstance().updateModulePrivileges(companyRole.getId(), set, set2);
            CompanyRoleControl.getInstance().updateTemplatePrivileges(companyRole.getId(), set5, set6);
            CompanyRoleControl.getInstance().updateDepAndCRolePrivileges(companyRole.getId(), set7, set8);
            CompanyRoleControl.getInstance().updateDataConnectionPrivileges(companyRole.getId(), set9, set10);
        }
    }

    private void addCustomRolePrivilege(JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            CustomRole customRole;
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONObject jSONObject2 = jSONObject.getJSONObject("modules");
            Set set = FSSetAuthSaveAction.string2ModuleSet(jSONObject2.getString("add"));
            Set set2 = FSSetAuthSaveAction.string2ModuleSet(jSONObject2.getString("remove"));
            JSONObject jSONObject3 = jSONObject.getJSONObject("entries");
            Set set3 = FSSetAuthSaveAction.string2EntrySet(jSONObject3.getString("add"));
            Set set4 = FSSetAuthSaveAction.string2EntrySet(jSONObject3.getString("remove"));
            JSONObject jSONObject4 = jSONObject.getJSONObject("templates");
            Set set5 = FSSetAuthSaveAction.string2TemplateSet(jSONObject4.getString("add"));
            Set set6 = FSSetAuthSaveAction.string2TemplateSet(jSONObject4.getString("remove"));
            JSONObject jSONObject5 = jSONObject.getJSONObject("depandcroles");
            Set<String> set7 = FSSetAuthSaveAction.string2Set(jSONObject5.getString("add"));
            Set<String> set8 = FSSetAuthSaveAction.string2Set(jSONObject5.getString("remove"));
            JSONObject jSONObject6 = jSONObject.getJSONObject("dataconnections");
            Set<String> set9 = FSSetAuthSaveAction.string2Set(jSONObject6.getString("add"));
            Set<String> set10 = FSSetAuthSaveAction.string2Set(jSONObject6.getString("remove"));
            long l = jSONObject.getLong("roleId");
            if (l <= -1000L) {
                customRole = CustomRoleControl.getInstance().getCustomRole(l);
                this.addSyncCustomeRoleEntryPrivilege(customRole, set3, set4);
                this.addSyncCustomRoleModulePrivilege(customRole, set, set2);
                this.addSyncCustomRoleTemplatePrivilege(customRole, set5, set6);
                this.addSyncCustomRoleDepAndCRolePrivilge(customRole, set7, set8);
                this.addSyncCustomRoleDataConnectionPrivilege(customRole, set9, set10);
                continue;
            }
            customRole = CustomRoleControl.getInstance().getCustomRole(l);
            CustomRoleControl.getInstance().updateEntryPrivileges(customRole.getId(), set3, set4);
            CustomRoleControl.getInstance().updateModulePrivileges(customRole.getId(), set, set2);
            CustomRoleControl.getInstance().updateTemplatePrivileges(customRole.getId(), set5, set6);
            CustomRoleControl.getInstance().updateDepAndCRolePrivileges(customRole.getId(), set7, set8);
            CustomRoleControl.getInstance().updateDataConnectionPrivileges(customRole.getId(), set9, set10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSyncCustomRoleTemplatePrivilege(CustomRole customRole, Set<RoleTemplatePrivilege> set, Set<RoleTemplatePrivilege> set2) throws Exception {
        String string = customRole.getRolename();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
            if (set != null) {
                arrayList.addAll(set);
            }
            ArrayList<RoleTemplatePrivilege> arrayList2 = new ArrayList<RoleTemplatePrivilege>();
            if (set2 != null) {
                arrayList2.addAll(set2);
            }
            TableDataCustomRoleDAO.getInstance().updateTemplatePrivileges(string, arrayList, arrayList2);
        }
        try {
            CustomRoleCache.refreshTemplatePrivileges(customRole.getId(), TableDataCustomRoleDAO.getInstance().getTemplatePrivileges(string));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSyncCustomRoleDepAndCRolePrivilge(CustomRole customRole, Set<String> set, Set<String> set2) throws Exception {
        String string = customRole.getRolename();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (set != null) {
                arrayList.addAll(set);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (set2 != null) {
                arrayList2.addAll(set2);
            }
            TableDataCustomRoleDAO.getInstance().updateDepAndCrolePrivilege(string, arrayList, arrayList2);
        }
        try {
            CustomRoleCache.refreshDepAndCRolePrivileges(customRole.getId(), TableDataCustomRoleDAO.getInstance().getDepAndCrolePrivileges(string));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSyncCustomRoleDataConnectionPrivilege(CustomRole customRole, Set<String> set, Set<String> set2) throws Exception {
        String string = customRole.getRolename();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (set != null) {
                arrayList.addAll(set);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (set2 != null) {
                arrayList2.addAll(set2);
            }
            TableDataCustomRoleDAO.getInstance().updateDataConnectionPrivileges(string, arrayList, arrayList2);
        }
        try {
            CustomRoleCache.refreshDataConnectionPrivileges(customRole.getId(), TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges(string));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSyncCustomRoleModulePrivilege(CustomRole customRole, Set set, Set set2) throws Exception {
        String string = customRole.getRolename();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            if (set != null) {
                arrayList.addAll(set);
            }
            ArrayList arrayList2 = new ArrayList();
            if (set2 != null) {
                arrayList2.addAll(set2);
            }
            TableDataCustomRoleDAO.getInstance().updateModulePrivileges(string, arrayList, arrayList2);
        }
        try {
            CustomRoleCache.refreshModulePrivileges(customRole.getId(), TableDataCustomRoleDAO.getInstance().getModulePrivileges(string));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSyncCustomeRoleEntryPrivilege(CustomRole customRole, Set set, Set set2) throws Exception {
        String string = customRole.getRolename();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            if (set != null) {
                arrayList.addAll(set);
            }
            ArrayList arrayList2 = new ArrayList();
            if (set2 != null) {
                arrayList2.addAll(set2);
            }
            TableDataCustomRoleDAO.getInstance().updateEntryPrivileges(string, arrayList, arrayList2);
        }
        try {
            CustomRoleCache.refreshEntryPrivileges(customRole.getId(), TableDataCustomRoleDAO.getInstance().getEntryPrivileges(string));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    private static String[] dealWithStringArray(String string) {
        if (string == null) {
            return new String[0];
        }
        if ((string = string.replaceAll("\"", "")).trim().length() <= 2) {
            return new String[0];
        }
        return string.substring(1, string.length() - 1).split(",");
    }

    private static Set string2EntrySet(String string) throws JSONException {
        HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
        try {
            JSONArray jSONArray = (JSONArray)BaseUtils.jsonDecode((String)string);
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                int n2 = jSONObject.getInt("type");
                long l = jSONObject.getLong("id");
                long l2 = 1L;
                if (jSONObject.has("view")) {
                    l2 = jSONObject.getLong("view");
                }
                long l3 = 0L;
                if (jSONObject.has("design")) {
                    l3 = jSONObject.getLong("design");
                }
                long l4 = 0L;
                if (jSONObject.has("edit")) {
                    l4 = jSONObject.getLong("edit");
                }
                hashSet.add(EntryTypeAndID.getInstance(n2, l, l2, l3, l4));
            }
            return hashSet;
        }
        catch (Exception exception) {
            if (string.length() == 2) {
                return new HashSet();
            }
            String[] stringArray = FSSetAuthSaveAction.dealWithStringArray(string);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!Pattern.compile("^\".+\"$").matcher(string2).find()) continue;
                stringArray[i] = string2.substring(1, string2.length() - 1);
            }
            return FSSetAuthSaveAction.dealWithEntryInfo(stringArray);
        }
    }

    private static Set string2ModuleSet(String string) throws JSONException {
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        JSONArray jSONArray = (JSONArray)BaseUtils.jsonDecode((String)string);
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            long l = jSONObject.getLong("id");
            long l2 = jSONObject.has("view") ? jSONObject.getLong("view") : 0L;
            long l3 = jSONObject.has("design") ? jSONObject.getLong("design") : 0L;
            RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(l, l2, l3);
            hashSet.add(roleModulePrivilege);
        }
        return hashSet;
    }

    private static Set string2TemplateSet(String string) throws JSONException {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        JSONArray jSONArray = (JSONArray)BaseUtils.jsonDecode((String)string);
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            String string2 = jSONObject.getString("path");
            long l = jSONObject.has("page") ? jSONObject.getLong("page") : 0L;
            long l2 = jSONObject.has("write") ? jSONObject.getLong("write") : 0L;
            long l3 = jSONObject.has("design") ? jSONObject.getLong("design") : 0L;
            RoleTemplatePrivilege roleTemplatePrivilege = new RoleTemplatePrivilege(string2, l, l2, l3);
            hashSet.add(roleTemplatePrivilege);
        }
        return hashSet;
    }

    private static Set<String> string2Set(String string) {
        if (string == null || string.length() == 2) {
            return new HashSet<String>();
        }
        String[] stringArray = FSSetAuthSaveAction.dealWithStringArray(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            if (ComparatorUtils.equals((Object)string2, (Object)customRoleRootID)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    private static Set dealWithEntryInfo(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.parseInt(stringArray[i].substring(0, 1));
            long l = Long.parseLong(stringArray[i].substring(1));
            hashSet.add(EntryTypeAndID.getInstance(n, l));
        }
        return hashSet;
    }
}

