/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetModuleUsersAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"moduleId");
        JSONArray jSONArray = new JSONArray();
        this.addUserFromCompanyRole(jSONArray, string);
        this.addUserFromCustomRole(jSONArray, string);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getModuleUsers";
    }

    private void addUserFromCompanyRole(JSONArray jSONArray, String string) throws Exception {
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            List<RoleModulePrivilege> list2 = CompanyRoleControl.getInstance().getAllModulePrivileges(companyRole.getId());
            for (RoleModulePrivilege roleModulePrivilege : list2) {
                if (!ComparatorUtils.equals((Object)string, (Object)(roleModulePrivilege.getModuleid() + ""))) continue;
                this.addCompanyUser(companyRole, roleModulePrivilege, jSONArray);
            }
        }
    }

    private void addUserFromCustomRole(JSONArray jSONArray, String string) throws Exception {
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            List<RoleModulePrivilege> list2 = CustomRoleControl.getInstance().getAllModulePrivileges(customRole.getId());
            for (RoleModulePrivilege roleModulePrivilege : list2) {
                if (!ComparatorUtils.equals((Object)string, (Object)(roleModulePrivilege.getModuleid() + ""))) continue;
                this.addCustomUser(customRole, roleModulePrivilege, jSONArray);
            }
        }
    }

    private void addCompanyUser(CompanyRole companyRole, RoleModulePrivilege roleModulePrivilege, JSONArray jSONArray) throws Exception {
        Set set = CompanyRoleControl.getInstance().getUsersID(companyRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l);
            this.addUser(user, jSONArray, roleModulePrivilege);
        }
    }

    private void addCustomUser(CustomRole customRole, RoleModulePrivilege roleModulePrivilege, JSONArray jSONArray) throws Exception {
        Set set = CustomRoleControl.getInstance().getUsersID(customRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l);
            this.addUser(user, jSONArray, roleModulePrivilege);
        }
    }

    private void addUser(User user, JSONArray jSONArray, RoleModulePrivilege roleModulePrivilege) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.getLong("id") != user.getId()) continue;
            long l = jSONObject.getLong("view");
            long l2 = roleModulePrivilege.getView();
            if (l == 0L && l2 == 1L) {
                jSONObject.put("view", 1);
            }
            long l3 = jSONObject.getLong("design");
            long l4 = roleModulePrivilege.getAuthorized();
            if (l3 == 0L && l4 == 1L) {
                jSONObject.put("design", 1);
            }
            return;
        }
        JSONObject jSONObject = user.createUnEditInfoJSONConfig();
        jSONObject.put("view", roleModulePrivilege.getView());
        jSONObject.put("design", roleModulePrivilege.getAuthorized());
        jSONObject.put("id", user.getId());
        jSONArray.put((Object)jSONObject);
    }
}

