/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.base.entity.User;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetAllUserAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "auth_getallusers";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 3L) || !UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"dataFilter");
        if (string == null) {
            string = "";
        } else {
            int n = Math.max(string.lastIndexOf(","), string.lastIndexOf("\uff0c"));
            string = string.substring(n + 1);
        }
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"exclude");
        List list = UserControl.getInstance().findAllAuthUser(l);
        JSONArray jSONArray = new JSONArray();
        for (User user : list) {
            JSONObject jSONObject = user.createUnEditInfoJSONConfig();
            if (!this.isKeywordInUserInfo(user, string) || this.isUserExcluded(user, string2)) continue;
            jSONArray.put((Object)jSONObject);
        }
        String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"includeroot");
        if (ComparatorUtils.equals((Object)string3, (Object)"true")) {
            User user;
            user = new JSONObject();
            user.put("username", PrivilegeManager.getInstance().getRootManagerName());
            user.put("realname", PrivilegeManager.getInstance().getRootManagerRealname());
            jSONArray.put((Object)user);
        }
        printWriter.print(jSONArray.toString());
        printWriter.flush();
        printWriter.close();
    }

    private boolean isKeywordInUserInfo(User user, String string) {
        return this.containsNoCase(user.getUsername(), string) || this.containsNoCase(user.getRealname(), string);
    }

    private boolean containsNoCase(String string, String string2) {
        return string.toUpperCase().contains(string2.toUpperCase());
    }

    private boolean isUserExcluded(User user, String string) {
        if (ComparatorUtils.equalsIgnoreCase((String)string, (String)"fs_login")) {
            return LoginUserControl.hasFSLoginUser(user.getUsername());
        }
        if (ComparatorUtils.equalsIgnoreCase((String)string, (String)"mobile_login")) {
            return LoginUserControl.hasMobileLoginUser(user.getUsername());
        }
        return false;
    }
}

