/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetAllModuleAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        JSONArray jSONArray = ModuleControl.getInstance().getAuthorizedModuleItems(l);
        this.createI18NModuleName(jSONArray, WebUtils.getLocale((HttpServletRequest)httpServletRequest));
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getallmodules";
    }

    private void createI18NModuleName(JSONArray jSONArray, Locale locale) throws JSONException {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            String string = Inter.getLocText((String)jSONObject.optString("key"), (Locale)locale);
            if (string == null) continue;
            jSONObject.put("text", (Object)string);
        }
    }
}

