/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.Utils;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeVote;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.web.FSReportlet;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.OutputFileProcessor;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.fs.web.platform.entry.FileEntry;
import com.fr.fs.web.platform.entry.ReportProcessEntry;
import com.fr.fs.web.platform.entry.URLEntry;
import com.fr.fs.web.service.FSEntryService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.general.privilege.NoCheckHyperLinkSessionAttribute;
import com.fr.report.stable.fun.Actor;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.web.Weblet;
import com.fr.web.core.A.QC;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSMainEntryReportAction
extends ActionNoSessionCMD {
    public static final String CMD = "entry_report";
    private static int Expires = -10;
    protected static final long TIMEOUT = 1200000L;
    private int fivehundred = 500;

    public String getCMD() {
        return CMD;
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (l == ServiceUtils.noAuthenticatedUser) {
            FSPrivilegeVote.FS_AUTH_ERROR.action(httpServletRequest, httpServletResponse);
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"id");
        EntryTypeAndID entryTypeAndID = FSEntryService.dealWithEntryInfo(string);
        String string2 = this.dealWithEntryResourceRequest(httpServletRequest, httpServletResponse, ServiceUtils.getCurrentUserID(httpServletRequest), entryTypeAndID.getType(), entryTypeAndID.getId());
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        if (StringUtils.isNotEmpty((String)string2)) {
            printWriter.write(string2);
        }
        printWriter.flush();
        printWriter.close();
    }

    private String dealWithEntryResourceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l, int n, long l2) throws Exception {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return "";
        }
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", (long)Expires);
        Entry entry = EntryControl.getInstance().getEntry(n, l2);
        if (!UserControl.getInstance().hasEntryPrivilege(l, n, l2)) {
            boolean bl = false;
            if (entry.getEntryType() == 2) {
                String string;
                long l3;
                String string2 = "/" + ((ReportletEntry)entry).getWebletPath();
                HttpSession httpSession = httpServletRequest.getSession(false);
                NoCheckHyperLinkSessionAttribute noCheckHyperLinkSessionAttribute = (NoCheckHyperLinkSessionAttribute)httpSession.getAttribute("fr_nocheck_hyperlinkinfo");
                if (noCheckHyperLinkSessionAttribute != null && noCheckHyperLinkSessionAttribute.isOneOfTheHyperlinks(string2) && (l3 = noCheckHyperLinkSessionAttribute.checkAlive(string = (String)httpSession.getAttribute("fr_username"), null, string2)) > 0L && System.currentTimeMillis() - l3 <= 1200000L) {
                    bl = true;
                }
            }
            if (!bl) {
                throw new NoPrivilegeException();
            }
        }
        if (entry == null) {
            throw new Exception("The entry or node doesn't exsit!");
        }
        UserCache.addToHistory(l, new UserCache.IDText(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"id"), WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"ftext"), entry.getShowType()));
        if (entry.getEntryType() == 2) {
            return this.dealWithReportlet((ReportletEntry)entry, httpServletRequest, httpServletResponse);
        }
        if (entry.getEntryType() == 3) {
            return this.dealWithUrl((URLEntry)entry, httpServletRequest, httpServletResponse);
        }
        if (entry.getEntryType() == 1) {
            return this.dealWithFile((FileEntry)entry, httpServletRequest, httpServletResponse);
        }
        if (entry.getEntryType() == 8) {
            return this.dealWithReportProcess((ReportProcessEntry)entry, httpServletRequest, httpServletResponse);
        }
        return "";
    }

    private String dealWithReportlet(ReportletEntry reportletEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object v;
        Weblet weblet;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        if (reportletEntry.getTransmitParameters() != null && (weblet = reportletEntry.getTransmitParameters().toArray()) != null) {
            for (int i = 0; i < ((Weblet)weblet).length; ++i) {
                hashMap.put(weblet[i].getName(), weblet[i].getValue());
            }
        }
        if (reportletEntry.isForm()) {
            weblet = StableFactory.createWeblet((String)"FSFormlet", (String)reportletEntry.getWebletPath(), hashMap);
            if (weblet != null) {
                weblet.dealWeblet(httpServletRequest, httpServletResponse);
            }
            return "";
        }
        weblet = reportletEntry.isReportletPage() ? ActorFactory.getActor((String)"view") : (reportletEntry.isReportletWrite() ? ActorFactory.getActor((String)"write") : ((v = hashMap.get("__bypagesize__")) != null && "false".equals(v.toString()) ? ActorFactory.getActor((String)"nopage") : ActorFactory.getActor((String)"page")));
        hashMap.put("reportName", reportletEntry.getWebletPath());
        FSReportlet fSReportlet = new FSReportlet(reportletEntry.getWebletPath(), reportletEntry.getDisplayName(), hashMap, (Actor)weblet);
        QC.A((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Weblet)fSReportlet, (boolean)false);
        return "";
    }

    private String dealWithUrl(URLEntry uRLEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = uRLEntry.getUrl();
        if (StringUtils.isEmpty((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"isTree"))) {
            return string;
        }
        if (StringUtils.isNotEmpty((String)string) && Utils.isEmbeddedParameter((String)string)) {
            String string2 = Calendar.getInstance().getTime().toString().replaceAll(" ", "");
            httpServletRequest.getSession().setAttribute(string2, (Object)string);
            return string2;
        }
        return "";
    }

    private String dealWithFile(FileEntry fileEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (StringUtils.isNotBlank((String)fileEntry.getPath())) {
            boolean bl = false;
            OutputFileProcessor outputFileProcessor = (OutputFileProcessor)StableFactory.getMarkedInstanceObjectFromClass((String)"OutputFileProcessor", OutputFileProcessor.class);
            if (outputFileProcessor != null) {
                bl = outputFileProcessor.flush(fileEntry, httpServletRequest, httpServletResponse);
            }
            if (!bl) {
                this.dealWithFSDownload(httpServletResponse, fileEntry.getPath(), fileEntry.getDisplayName());
            }
        }
        return "";
    }

    private String dealWithReportProcess(ReportProcessEntry reportProcessEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!VT4FR.isLicAvailable((byte[])StableUtils.getBytes()) || !VT4FR.MULTI_DATA_REPORT.support()) {
            throw new RegistEditionException(VT4FR.MULTI_DATA_REPORT);
        }
        int n = reportProcessEntry.getProcessType();
        String string = "/com/fr/web/core/process/reportprocess/web/";
        if (n == 1) {
            string = string + "rp_taskmgr.html";
        } else if (n == 2) {
            string = string + "rp_processmgr.html";
        } else if (n == 3) {
            string = string + "rp_mytask.html";
        }
        WebUtils.writeOutTemplate((String)string, (HttpServletResponse)httpServletResponse, (Map)Collections.EMPTY_MAP);
        return "";
    }

    private void dealWithFSDownload(HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byte[] byArray = new byte[this.fivehundred];
        File file = new File(string);
        httpServletResponse.reset();
        string2 = string2 == null ? "file" : string2;
        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string2 + "\"");
        httpServletResponse.setContentType("application/x-download");
        long l = file.length();
        String string3 = String.valueOf(l);
        httpServletResponse.setHeader("Content_Length", string3);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            servletOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        servletOutputStream.flush();
        if (servletOutputStream != null) {
            servletOutputStream.close();
        }
    }
}

