/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.IdGenerator;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryGetClassesAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "getClasses";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!(UserControl.getInstance().hasModulePrivilege(l, 3L) || UserControl.getInstance().hasModulePrivilege(l, 2L) || UserControl.getInstance().hasModulePrivilege(l, 16L))) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        IdGenerator idGenerator = new IdGenerator();
        printWriter.print(this.getClasses("classes", idGenerator).toString());
        printWriter.flush();
        printWriter.close();
    }

    private JSONArray getClasses(String string, IdGenerator idGenerator) {
        JSONArray jSONArray = new JSONArray();
        FileNode[] fileNodeArray = null;
        String string2 = ".class";
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return jSONArray;
        }
        for (FileNode fileNode : fileNodeArray) {
            String string3 = fileNode.getEnvPath().substring("classes".length() + 1);
            if (StringUtils.isNotEmpty((String)string3) && !fileNode.isDirectory() && !string3.endsWith(string2)) continue;
            JSONObject jSONObject = new JSONObject();
            jSONArray.put((Object)jSONObject);
            try {
                jSONObject.put("id", idGenerator.generateId());
                jSONObject.put("text", (Object)fileNode.getName());
                jSONObject.put("value", (Object)fileNode.getName());
                jSONObject.put("path", (Object)string3);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("hasChildren", true);
                jSONObject.put("ChildNodes", (Object)this.getClasses(fileNode.getEnvPath(), idGenerator));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            }
        }
        return jSONArray;
    }
}

