/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.file.CacheManager;
import com.fr.fs.web.service.AbstractEmailActionTools;
import com.fr.general.ComparatorUtils;
import com.fr.general.DeclareRecordType;
import com.fr.general.Inter;
import com.fr.io.exporter.AppExporter;
import com.fr.log.LogUtils;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.web.core.ActionCMD;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionDealWith;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EmailDealWithAction
extends AbstractEmailActionTools
implements ActionCMD {
    public String getCMD() {
        return "deal_email";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        this.sessionIDInfor = (ReportSessionIDInfor)SessionDealWith.getSessionIDInfor((String)string);
        if (this.sessionIDInfor == null) {
            return;
        }
        this.writer = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        this.fileName = this.getAttachFileName(httpServletRequest);
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"FORMAT");
        if (StringUtils.isNotEmpty((String)string2) && !this.isExportAttachFileSuccess(httpServletRequest, string2, this.writer)) {
            return;
        }
        try {
            Calculator calculator = this.sessionIDInfor.createSessionCalculator(httpServletRequest, httpServletResponse);
            this.sendMail(httpServletRequest, calculator);
            this.getPrintWriterSuccessful();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            this.getPrintWriterWhileSendFailed();
        }
        this.closePrintWriter();
    }

    private void sendMail(HttpServletRequest httpServletRequest, Calculator calculator) throws Exception {
        EmailManager emailManager = ConfigManager.getInstance().getEmailManager();
        if (emailManager == null) {
            throw new Exception("Email Config needed.");
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"FROM");
        String string2 = TemplateUtils.renderTpl((CalculatorProvider)calculator, (String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"TO"));
        if (StringUtils.isEmpty((String)string) || StringUtils.isEmpty((String)string2)) {
            throw new Exception(Inter.getLocText((String)"FR-Basic_NS_mail_config"));
        }
        String string3 = TemplateUtils.renderTpl((CalculatorProvider)calculator, (String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"SUBJECT"));
        String string4 = TemplateUtils.renderTpl((CalculatorProvider)calculator, (String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"MESSAGE"));
        String string5 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"CC");
        String string6 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"BCC");
        String string7 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"ISSHOWTPL");
        File file = ComparatorUtils.equals((Object)string7, (Object)"true") ? this.exportTemplateAsImage(httpServletRequest) : null;
        emailManager.send(string2, string5, string6, string, string3, string4, (Object)this.attachFile, (Object)file);
    }

    private boolean isExportAttachFileSuccess(HttpServletRequest httpServletRequest, String string, PrintWriter printWriter) throws Exception {
        String string2 = this.getAttachFileFormat(string);
        File file = CacheManager.getInstance().getCacheDirectory();
        String string3 = "_" + System.currentTimeMillis() + File.separator + this.fileName;
        this.attachFile = new File(file, string3 + "." + string2);
        int n = 0;
        while (this.attachFile.exists()) {
            this.attachFile = new File(file, string3 + "_" + n + "." + string2);
            ++n;
        }
        StableUtils.mkdirs((File)this.attachFile.getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream(this.attachFile);
        AppExporter appExporter = this.getExporterFormat(string);
        DeclareRecordType declareRecordType = this.getExporterType(string);
        try {
            if (appExporter != null) {
                LogUtils.exportAndLogRecord((AppExporter)appExporter, (OutputStream)fileOutputStream, (ReportRepositoryDeal)new ReportRepositoryDeal(httpServletRequest, this.sessionIDInfor), (DeclareRecordType)declareRecordType);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            this.closePrintWriter();
            return false;
        }
        this.attachFile.deleteOnExit();
        this.attachFile.getParentFile().deleteOnExit();
        return true;
    }
}

