/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.FSConfig;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.fs.base.FSManager;
import com.fr.fs.base.entity.User;
import com.fr.fs.base.entity.UserInfo;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.AuthenticateResult;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.privilege.auth.FailResult;
import com.fr.fs.privilege.auth.SuccessResult;
import com.fr.fs.privilege.auth.UserNamePassWordFSAuthenticationProvider;
import com.fr.fs.privilege.base.FServicePrivilegeLoader;
import com.fr.fs.privilege.entity.DaoFSAuthentication;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.privilege.Authentication;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.authentication.CommonAuthentication;
import com.fr.privilege.authentication.UsernamePasswordAuthentication;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.session.PrivilegeInfoSessionMananger;
import com.fr.privilege.session.PrivilegeLoader;
import com.fr.stable.StringUtils;
import com.fr.web.core.reserve.NoSessionIDService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractFSAuthService
extends NoSessionIDService {
    protected PrivilegeVote getFSVote(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        if (fSAuthentication == null) {
            AbstractFSAuthService.dealCookie(httpServletRequest, httpServletResponse);
            fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        }
        return FSManager.getFSKeeper().access(fSAuthentication);
    }

    public static void dealCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UserInfo userInfo = new UserInfo(httpServletRequest);
        AbstractFSAuthService.dealLoginInfo(httpServletRequest, httpServletResponse, userInfo.getUsername(), userInfo.getPassword(), false);
    }

    public static boolean dealLoginInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, boolean bl) throws Exception {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            return false;
        }
        UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication(string, string2);
        UserNamePassWordFSAuthenticationProvider userNamePassWordFSAuthenticationProvider = UserNamePassWordFSAuthenticationProvider.getInstance();
        AuthenticateResult authenticateResult = AbstractFSAuthService.doAuthenticate((CommonAuthentication)usernamePasswordAuthentication, userNamePassWordFSAuthenticationProvider, bl);
        if (authenticateResult.success()) {
            FSAuthentication fSAuthentication = authenticateResult.getFSAuthentication();
            if (bl) {
                AbstractFSAuthService.doTemplateUserLogin(httpServletRequest, httpServletResponse, fSAuthentication, string);
            } else {
                AbstractFSAuthService.doUserLogin(httpServletRequest, httpServletResponse, fSAuthentication, string);
            }
            return true;
        }
        return false;
    }

    private static void doUserLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthentication fSAuthentication, String string) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(true);
        UserControl userControl = UserControl.getInstance();
        long l = fSAuthentication.getUserInfo().getId();
        PrivilegeInfoSessionMananger.login((PrivilegeLoader)new FServicePrivilegeLoader(string, userControl.getAllSRoleNames(l), userControl.getUserDP(l)), (HttpSession)httpSession, (HttpServletResponse)httpServletResponse);
        httpSession.setAttribute("fr_fs_auth_key", (Object)fSAuthentication);
        userControl.login(l);
    }

    private static void doTemplateUserLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthentication fSAuthentication, String string) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(true);
        PrivilegeInfoSessionMananger.login((PrivilegeLoader)new FServicePrivilegeLoader(string, null, null), (HttpSession)httpSession, (HttpServletResponse)httpServletResponse);
        httpSession.setAttribute("fr_fs_auth_key", (Object)fSAuthentication);
    }

    public static boolean dealMobileLoginInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            return false;
        }
        UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication(string, string2);
        UserNamePassWordFSAuthenticationProvider userNamePassWordFSAuthenticationProvider = UserNamePassWordFSAuthenticationProvider.getInstance();
        userNamePassWordFSAuthenticationProvider.setIsMobileAuth(true);
        AuthenticateResult authenticateResult = AbstractFSAuthService.doAuthenticate((CommonAuthentication)usernamePasswordAuthentication, userNamePassWordFSAuthenticationProvider, false);
        if (authenticateResult.success()) {
            FSAuthentication fSAuthentication = authenticateResult.getFSAuthentication();
            AbstractFSAuthService.doUserLogin(httpServletRequest, httpServletResponse, fSAuthentication, string);
            return true;
        }
        return false;
    }

    public static AuthenticateResult doAuthenticate(CommonAuthentication commonAuthentication, UserNamePassWordFSAuthenticationProvider userNamePassWordFSAuthenticationProvider, boolean bl) throws Exception {
        boolean bl2 = true;
        if (!AbstractFSAuthService.isRootUser(commonAuthentication.getUserName(), commonAuthentication.getPassWord())) {
            if (!FSRegisterForBI.isSupportFS() && !bl) {
                return new FailResult("No User & Password Exist!");
            }
            AuthenticateObjectType authenticateObjectType = FSConfig.getInstance().getAuthenticateObjectType();
            if (authenticateObjectType != null) {
                if (!authenticateObjectType.authentication((Authentication)commonAuthentication)) {
                    return new FailResult("No User & Password Exist!");
                }
                bl2 = !authenticateObjectType.authenticationWithoutPassword();
            }
        }
        userNamePassWordFSAuthenticationProvider.setNeedPassword(bl2);
        return AbstractFSAuthService.doUsernamePasswordAuth((Authentication)commonAuthentication, userNamePassWordFSAuthenticationProvider);
    }

    private static AuthenticateResult doUsernamePasswordAuth(Authentication authentication, UserNamePassWordFSAuthenticationProvider userNamePassWordFSAuthenticationProvider) throws Exception {
        AuthenticateResult authenticateResult;
        boolean bl = userNamePassWordFSAuthenticationProvider.authenticate(authentication);
        if (!bl) {
            authenticateResult = new FailResult("No User & Password Exist!");
        } else {
            User user = UserControl.getInstance().getByUserName(GeneralUtils.objectToString((Object)authentication.getPrincipal()));
            if (user != null) {
                DaoFSAuthentication daoFSAuthentication = new DaoFSAuthentication(new UserInfo(user.getId(), user.getUsername(), user.getPassword()));
                daoFSAuthentication.setRoot(authentication.isRoot());
                daoFSAuthentication.setAuthenticated(true);
                daoFSAuthentication.setAuthorities(authentication.getAuthorities());
                authenticateResult = new SuccessResult(daoFSAuthentication);
            } else {
                authenticateResult = new FailResult("No User & Password Exist!");
            }
        }
        return authenticateResult;
    }

    private static boolean isRootUser(String string, String string2) {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        return ComparatorUtils.equals((Object)string, (Object)privilegeManager.getRootManagerName()) && ComparatorUtils.equals((Object)string2, (Object)privilegeManager.getRootManagerPassword());
    }

    public static boolean isSupportFS() {
        return FSRegisterForBI.isSupportFS();
    }

    protected void syncUserID(HttpServletRequest httpServletRequest) throws Exception {
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        if (fSAuthentication == null) {
            return;
        }
        UserInfo userInfo = fSAuthentication.getUserInfo();
        String string = userInfo.getUsername();
        Long l = UserControl.getInstance().getUser(string);
        User user = UserControl.getInstance().getUser(l);
        if (user == null) {
            return;
        }
        if (user.getId() != userInfo.getId()) {
            FSAuthenticationManager.refreshAuth4FineServer(httpServletRequest, user.getId());
        }
    }

    public static String getUserShowName(HttpServletRequest httpServletRequest) throws Exception {
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        String string = fSAuthentication.getUserInfo().getUsername();
        User user = UserControl.getInstance().getByUserName(string);
        if (StringUtils.isNotEmpty((String)user.getRealname())) {
            return user.getRealname();
        }
        return string;
    }
}

