/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.fs.schedule.ViewScheduleSavedInfo;
import com.fr.fs.schedule.job.DoFileActionJob;
import com.fr.fs.schedule.job.ReportletJob;
import com.fr.fs.web.ShowType;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.AnalyWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.ReportHelper;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.script.Calculator;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLWriter;
import com.fr.web.WebletException;
import com.fr.web.request.ReportletRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AnalyReportletJob
extends ReportletJob {
    private ViewScheduleSavedInfo viewScheduleSavedInfo;
    private File saveDirectory;
    private static final ShowType SHOWTYPE = ShowType.VIEW;
    private List attachFileList;

    protected void executeReport() {
        this.attachFileList = new ArrayList();
        this.record_list = new ArrayList();
        this.arrayParaList = new ArrayList();
        String string = this.reportPath.substring(this.reportPath.lastIndexOf("/") + 1, this.reportPath.lastIndexOf("."));
        FileRepository fileRepository = this.scheduleTask.getScheduledOutput().getFileRepository();
        this.saveDirectory = ScheduleUtils.getTaskTimeDirFile(fileRepository, this.scheduleTask.getName(), this.scheduledFireTime);
        if (!this.saveDirectory.exists()) {
            StableUtils.mkdirs((File)this.saveDirectory);
        }
        try {
            this.reportlet = ReportHelper.generateReportlet((String)this.reportPath);
            File file = new File(StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", this.reportPath}));
            if (!file.exists()) {
                this.log.error("[Schedule] Not found reportlet: " + this.reportPath);
                return;
            }
            ScheduleUtils.calculatorParameters(this.getExecuteParameter(), this.record_list, this.arrayParaList);
            this.viewScheduleSavedInfo = new ViewScheduleSavedInfo();
            this.viewScheduleSavedInfo.setShowType(SHOWTYPE);
            if (!this.arrayParaList.isEmpty()) {
                this.viewScheduleSavedInfo.setFArrayParameters(this.arrayParaList.toArray(new Parameter[this.arrayParaList.size()]));
            }
            String[] stringArray = new String[this.arrayParaList.size()];
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Parameter)this.arrayParaList.get(i)).getName();
            }
            File[] fileArray = new File[]{};
            int n2 = this.record_list.size();
            for (n = 0; n < n2; ++n) {
                Map map = (Map)this.record_list.get(n);
                AnalyWorkBook analyWorkBook = this.checkReport(map);
                if (ComparatorUtils.equals((Object)analyWorkBook, null)) {
                    return;
                }
                String string2 = ScheduleUtils.createOutputReportName(string, n, stringArray);
                fileArray = this.scheduleTask.getScheduledOutput().exportAnalyReportFiles(analyWorkBook, string2, this.saveDirectory);
                this.dealWithInfo(fileArray, map);
            }
            this.exportViewScheduleSavedInfo();
            DoFileActionJob.doFileAction(this.scheduleTask, Arrays.asList(fileArray));
            this.log.info("[Schedule] The Task '" + this.scheduleTask.getName() + "' of " + this.reportPath + " has finished!");
        }
        catch (Exception exception) {
            this.dealWithException(exception);
        }
    }

    private AnalyWorkBook checkReport(Map map) {
        TemplateWorkBook templateWorkBook = null;
        try {
            templateWorkBook = this.reportlet.createReport((ReportletRequest)new ScheduleReportletRequestImpl(map));
        }
        catch (WebletException webletException) {
            this.log.error(ScheduleLogUtils.combineByColon("Not_Found_Reportlet", this.reportPath));
        }
        if (templateWorkBook == null) {
            this.log.error(ScheduleLogUtils.combineByColon("Not_Found_Reportlet", this.reportPath));
            return null;
        }
        Calculator.putThreadSavedNameSpace((NameSpace)ParameterMapNameSpace.create((Map)map));
        AnalyWorkBook analyWorkBook = (AnalyWorkBook)templateWorkBook.execute(map, ActorFactory.getActor((String)"view"));
        if (!this.checkExecuteFormula(map, (ResultWorkBook)analyWorkBook)) {
            return null;
        }
        return analyWorkBook;
    }

    private void dealWithInfo(File[] fileArray, Map map) {
        String string = Inter.getLocText((String)"FS-Schedule-CPR_SUCCESS");
        if (this.scheduleTask.getCounts() > 0) {
            string = string + ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts());
        }
        this.log.scheduleInfo(this.scheduleTask.getName(), string);
        this.scheduleTask.setCounts(0);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            this.viewScheduleSavedInfo.addMapTemplateFileName(map, fileArray[i].getName());
            if (fileArray[i].getName().endsWith(".cpr")) continue;
            this.attachFileList.add(fileArray[i]);
        }
    }

    private void exportViewScheduleSavedInfo() throws FileNotFoundException {
        BaseXMLUtils.writeXMLFile((OutputStream)new FileOutputStream(new File(this.saveDirectory, "info.xml")), (XMLWriter)this.viewScheduleSavedInfo);
    }

    private static class ScheduleReportletRequestImpl
    implements ReportletRequest {
        private Map map = null;

        public ScheduleReportletRequestImpl(Map map) {
            this.map = map;
        }

        public Object getParameter(String string) {
            return this.map.get(string);
        }
    }
}

